/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.olingo.commons.api.ODataRuntimeException;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataHttpHandler;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.processor.Processor;
import org.apache.olingo.server.api.serializer.CustomContentTypeSupport;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.core.ODataExceptionHelper;
import org.apache.olingo.server.core.ODataHandler;
import org.apache.olingo.server.core.ODataHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataHttpHandlerImpl
implements ODataHttpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ODataHttpHandlerImpl.class);
    private ODataHandler handler;
    private int split = 0;

    public ODataHttpHandlerImpl(OData odata, ServiceMetadata serviceMetadata) {
        this.handler = new ODataHandler(odata, serviceMetadata);
    }

    public void process(HttpServletRequest request, HttpServletResponse response) {
        ODataResponse odResponse;
        ODataRequest odRequest = null;
        try {
            odRequest = this.createODataRequest(request, this.split);
            odResponse = this.handler.process(odRequest);
        }
        catch (Exception e) {
            odResponse = this.handleException(odRequest, e);
        }
        ODataHttpHandlerImpl.convertToHttp(response, odResponse);
    }

    public void setSplit(int split) {
        this.split = split;
    }

    private ODataResponse handleException(ODataRequest odRequest, Exception e) {
        ODataResponse resp = new ODataResponse();
        ODataServerError serverError = e instanceof ODataHandlerException ? ODataExceptionHelper.createServerErrorObject((ODataHandlerException)((Object)e), null) : (e instanceof ODataTranslatedException ? ODataExceptionHelper.createServerErrorObject((ODataTranslatedException)e, null) : ODataExceptionHelper.createServerErrorObject(e));
        this.handler.handleException(odRequest, resp, serverError);
        return resp;
    }

    static void convertToHttp(HttpServletResponse response, ODataResponse odResponse) {
        response.setStatus(odResponse.getStatusCode());
        for (Map.Entry entry : odResponse.getHeaders().entrySet()) {
            response.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
        InputStream input = odResponse.getContent();
        if (input != null) {
            ServletOutputStream output = null;
            try {
                int n;
                output = response.getOutputStream();
                byte[] buffer = new byte[1024];
                while (-1 != (n = input.read(buffer))) {
                    output.write(buffer, 0, n);
                }
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new ODataRuntimeException((Exception)e);
            }
            finally {
                ODataHttpHandlerImpl.closeStream((Closeable)output);
                ODataHttpHandlerImpl.closeStream(input);
            }
        }
    }

    private static void closeStream(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private ODataRequest createODataRequest(HttpServletRequest httpRequest, int split) throws ODataTranslatedException {
        try {
            ODataRequest odRequest = new ODataRequest();
            odRequest.setBody((InputStream)httpRequest.getInputStream());
            ODataHttpHandlerImpl.extractHeaders(odRequest, httpRequest);
            ODataHttpHandlerImpl.extractMethod(odRequest, httpRequest);
            ODataHttpHandlerImpl.extractUri(odRequest, httpRequest, split);
            return odRequest;
        }
        catch (IOException e) {
            throw new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
    }

    static void extractMethod(ODataRequest odRequest, HttpServletRequest httpRequest) throws ODataTranslatedException {
        try {
            HttpMethod httpRequestMethod = HttpMethod.valueOf((String)httpRequest.getMethod());
            if (httpRequestMethod == HttpMethod.POST) {
                String xHttpMethod = httpRequest.getHeader("X-HTTP-Method");
                String xHttpMethodOverride = httpRequest.getHeader("X-HTTP-Method-Override");
                if (xHttpMethod == null && xHttpMethodOverride == null) {
                    odRequest.setMethod(httpRequestMethod);
                } else if (xHttpMethod == null) {
                    odRequest.setMethod(HttpMethod.valueOf((String)xHttpMethodOverride));
                } else if (xHttpMethodOverride == null) {
                    odRequest.setMethod(HttpMethod.valueOf((String)xHttpMethod));
                } else {
                    if (!xHttpMethod.equalsIgnoreCase(xHttpMethodOverride)) {
                        throw new ODataHandlerException("Ambiguous X-HTTP-Methods", ODataHandlerException.MessageKeys.AMBIGUOUS_XHTTP_METHOD, xHttpMethod, xHttpMethodOverride);
                    }
                    odRequest.setMethod(HttpMethod.valueOf((String)xHttpMethod));
                }
            } else {
                odRequest.setMethod(httpRequestMethod);
            }
        }
        catch (IllegalArgumentException e) {
            throw new ODataHandlerException("Invalid HTTP method" + httpRequest.getMethod(), ODataHandlerException.MessageKeys.INVALID_HTTP_METHOD, httpRequest.getMethod());
        }
    }

    static void extractUri(ODataRequest odRequest, HttpServletRequest httpRequest, int split) {
        String rawServiceResolutionUri;
        String rawODataPath;
        int beginIndex;
        String rawRequestUri = httpRequest.getRequestURL().toString();
        if (!"".equals(httpRequest.getServletPath())) {
            beginIndex = rawRequestUri.indexOf(httpRequest.getServletPath());
            rawODataPath = rawRequestUri.substring(beginIndex += httpRequest.getServletPath().length());
        } else if (!"".equals(httpRequest.getContextPath())) {
            beginIndex = rawRequestUri.indexOf(httpRequest.getContextPath());
            rawODataPath = rawRequestUri.substring(beginIndex += httpRequest.getContextPath().length());
        } else {
            rawODataPath = httpRequest.getRequestURI();
        }
        if (split > 0) {
            rawServiceResolutionUri = rawODataPath;
            for (int i = 0; i < split; ++i) {
                int e = rawODataPath.indexOf("/", 1);
                rawODataPath = -1 == e ? "" : rawODataPath.substring(e);
            }
            int end = rawServiceResolutionUri.length() - rawODataPath.length();
            rawServiceResolutionUri = rawServiceResolutionUri.substring(0, end);
        } else {
            rawServiceResolutionUri = null;
        }
        String rawBaseUri = rawRequestUri.substring(0, rawRequestUri.length() - rawODataPath.length());
        odRequest.setRawQueryPath(httpRequest.getQueryString());
        odRequest.setRawRequestUri(rawRequestUri + (httpRequest.getQueryString() == null ? "" : "?" + httpRequest.getQueryString()));
        odRequest.setRawODataPath(rawODataPath);
        odRequest.setRawBaseUri(rawBaseUri);
        odRequest.setRawServiceResolutionUri(rawServiceResolutionUri);
    }

    static void extractHeaders(ODataRequest odRequest, HttpServletRequest req) {
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            ArrayList<String> headerValues = new ArrayList<String>();
            Enumeration headers = req.getHeaders(headerName);
            while (headers.hasMoreElements()) {
                String value = (String)headers.nextElement();
                headerValues.add(value);
            }
            odRequest.addHeader(headerName, headerValues);
        }
    }

    public void register(Processor processor) {
        this.handler.register(processor);
    }

    public void register(CustomContentTypeSupport customContentTypeSupport) {
        this.handler.register(customContentTypeSupport);
    }
}

