/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.util.List;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataHttpHandler;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.deserializer.FixedFormatDeserializer;
import org.apache.olingo.server.api.deserializer.ODataDeserializer;
import org.apache.olingo.server.api.edm.provider.EdmProvider;
import org.apache.olingo.server.api.edmx.EdmxReference;
import org.apache.olingo.server.api.serializer.FixedFormatSerializer;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriHelper;
import org.apache.olingo.server.core.ODataHttpHandlerImpl;
import org.apache.olingo.server.core.ServiceMetadataImpl;
import org.apache.olingo.server.core.deserializer.FixedFormatDeserializerImpl;
import org.apache.olingo.server.core.deserializer.json.ODataJsonDeserializer;
import org.apache.olingo.server.core.serializer.FixedFormatSerializerImpl;
import org.apache.olingo.server.core.serializer.json.ODataJsonSerializer;
import org.apache.olingo.server.core.serializer.xml.ODataXmlSerializerImpl;
import org.apache.olingo.server.core.uri.UriHelperImpl;

public class ODataImpl
extends OData {
    public ODataSerializer createSerializer(ODataFormat format) throws SerializerException {
        Object serializer;
        switch (format) {
            case JSON: 
            case JSON_NO_METADATA: 
            case JSON_FULL_METADATA: {
                serializer = new ODataJsonSerializer(format);
                break;
            }
            case XML: {
                serializer = new ODataXmlSerializerImpl();
                break;
            }
            default: {
                throw new SerializerException("Unsupported format: " + format, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_FORMAT, new String[]{format.toString()});
            }
        }
        return serializer;
    }

    public FixedFormatSerializer createFixedFormatSerializer() {
        return new FixedFormatSerializerImpl();
    }

    public ODataHttpHandler createHandler(ServiceMetadata edm) {
        return new ODataHttpHandlerImpl(this, edm);
    }

    public ServiceMetadata createServiceMetadata(EdmProvider edmProvider, List<EdmxReference> references) {
        return new ServiceMetadataImpl(ODataServiceVersion.V40, edmProvider, references);
    }

    public FixedFormatDeserializer createFixedFormatDeserializer() {
        return new FixedFormatDeserializerImpl();
    }

    public UriHelper createUriHelper() {
        return new UriHelperImpl();
    }

    public ODataDeserializer createDeserializer(ODataFormat format) throws DeserializerException {
        ODataJsonDeserializer serializer;
        switch (format) {
            case JSON: 
            case JSON_NO_METADATA: 
            case JSON_FULL_METADATA: {
                serializer = new ODataJsonDeserializer();
                break;
            }
            default: {
                throw new DeserializerException("Unsupported format: " + format, (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_FORMAT, new String[]{format.toString()});
            }
        }
        return serializer;
    }
}

