/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.batchhandler;

import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.batch.BatchFacade;
import org.apache.olingo.server.api.batch.exception.BatchDeserializerException;
import org.apache.olingo.server.api.deserializer.batch.BatchRequestPart;
import org.apache.olingo.server.api.deserializer.batch.ODataResponsePart;
import org.apache.olingo.server.api.processor.BatchProcessor;
import org.apache.olingo.server.core.ODataHandler;
import org.apache.olingo.server.core.batchhandler.referenceRewriting.BatchReferenceRewriter;

public class BatchPartHandler {
    private final ODataHandler oDataHandler;
    private final BatchProcessor batchProcessor;
    private final BatchFacade batchFascade;
    private final BatchReferenceRewriter rewriter;

    public BatchPartHandler(ODataHandler oDataHandler, BatchProcessor processor, BatchFacade batchFascade) {
        this.oDataHandler = oDataHandler;
        this.batchProcessor = processor;
        this.batchFascade = batchFascade;
        this.rewriter = new BatchReferenceRewriter();
    }

    public ODataResponse handleODataRequest(ODataRequest request) throws BatchDeserializerException {
        return this.handle(request, true);
    }

    public ODataResponsePart handleBatchRequest(BatchRequestPart request) throws BatchDeserializerException {
        if (request.isChangeSet()) {
            return this.handleChangeSet(request);
        }
        ODataResponse response = this.handle((ODataRequest)request.getRequests().get(0), false);
        return new ODataResponsePart(response, false);
    }

    public ODataResponse handle(ODataRequest request, boolean isChangeSet) throws BatchDeserializerException {
        ODataResponse response;
        if (isChangeSet) {
            this.rewriter.replaceReference(request);
            response = this.oDataHandler.process(request);
            this.rewriter.addMapping(request, response);
        } else {
            response = this.oDataHandler.process(request);
        }
        String contentId = request.getHeader("Content-Id");
        if (contentId != null) {
            response.setHeader("Content-Id", contentId);
        }
        return response;
    }

    private ODataResponsePart handleChangeSet(BatchRequestPart request) throws BatchDeserializerException {
        return this.batchProcessor.processChangeSet(this.batchFascade, request.getRequests());
    }
}

