/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer.batch;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.batch.exception.BatchDeserializerException;
import org.apache.olingo.server.core.deserializer.batch.Header;
import org.apache.olingo.server.core.deserializer.batch.Line;

public class BatchParserCommon {
    private static final String REG_EX_BOUNDARY = "([a-zA-Z0-9_\\-\\.'\\+]{1,70})|\"([a-zA-Z0-9_\\-\\.'\\+\\s\\(\\),/:=\\?]{1,69}[a-zA-Z0-9_\\-\\.'\\+\\(\\),/:=\\?])\"";
    private static final Pattern PATTERN_LAST_CRLF = Pattern.compile("(.*)(\r\n){1}( *)", 32);
    private static final Pattern PATTERN_HEADER_LINE = Pattern.compile("([a-zA-Z\\-]+):\\s?(.*)\\s*");
    private static final String REG_EX_APPLICATION_HTTP = "application/http";
    public static final Pattern PATTERN_MULTIPART_BOUNDARY = Pattern.compile("multipart/mixed(.*)", 2);
    public static final Pattern PATTERN_CONTENT_TYPE_APPLICATION_HTTP = Pattern.compile("application/http", 2);
    public static final String BINARY_ENCODING = "binary";
    public static final String HTTP_CONTENT_ID = "Content-Id";
    public static final String HTTP_CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static final String HTTP_EXPECT = "Expect";
    public static final String HTTP_FROM = "From";
    public static final String HTTP_MAX_FORWARDS = "Max-Forwards";
    public static final String HTTP_RANGE = "Range";
    public static final String HTTP_TE = "TE";

    public static String getBoundary(String contentType, int line) throws BatchDeserializerException {
        if (contentType == null) {
            throw new BatchDeserializerException("Missing content type", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.MISSING_CONTENT_TYPE, line);
        }
        if (contentType.toLowerCase(Locale.ENGLISH).startsWith("multipart/mixed")) {
            String[] parameter;
            for (String pair : parameter = contentType.split(";")) {
                String[] attrValue = pair.split("=");
                if (attrValue.length != 2 || !"boundary".equals(attrValue[0].trim().toLowerCase(Locale.ENGLISH))) continue;
                if (attrValue[1].matches(REG_EX_BOUNDARY)) {
                    return BatchParserCommon.trimQuota(attrValue[1].trim());
                }
                throw new BatchDeserializerException("Invalid boundary format", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_BOUNDARY, new String[]{"" + line});
            }
        }
        throw new BatchDeserializerException("Content type is not multipart mixed", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_CONTENT_TYPE, new String[]{"multipart/mixed"});
    }

    public static String removeEndingSlash(String content) {
        int lastSlashIndex = (content = content.trim()).lastIndexOf(47);
        return lastSlashIndex == content.length() - 1 ? content.substring(0, content.length() - 1) : content;
    }

    private static String trimQuota(String boundary) {
        if (boundary.matches("\".*\"")) {
            boundary = boundary.replace("\"", "");
        }
        return boundary;
    }

    public static List<List<Line>> splitMessageByBoundary(List<Line> message, String boundary) throws BatchDeserializerException {
        int lineNumer;
        LinkedList<List<Line>> messageParts = new LinkedList<List<Line>>();
        AbstractList currentPart = new ArrayList<Line>();
        boolean isEndReached = false;
        String quotedBoundary = Pattern.quote(boundary);
        Pattern boundaryDelimiterPattern = Pattern.compile("--" + quotedBoundary + "--[\\s ]*");
        Pattern boundaryPattern = Pattern.compile("--" + quotedBoundary + "[\\s ]*");
        for (Line currentLine : message) {
            if (boundaryDelimiterPattern.matcher(currentLine.toString()).matches()) {
                BatchParserCommon.removeEndingCRLFFromList(currentPart);
                messageParts.add(currentPart);
                isEndReached = true;
            } else if (boundaryPattern.matcher(currentLine.toString()).matches()) {
                BatchParserCommon.removeEndingCRLFFromList(currentPart);
                messageParts.add(currentPart);
                currentPart = new LinkedList();
            } else {
                currentPart.add(currentLine);
            }
            if (!isEndReached) continue;
            break;
        }
        int n = lineNumer = message.size() > 0 ? message.get(0).getLineNumber() : 0;
        if (messageParts.size() > 0) {
            messageParts.remove(0);
        }
        if (!isEndReached) {
            throw new BatchDeserializerException("Missing close boundary delimiter", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.MISSING_CLOSE_DELIMITER, new String[]{"" + lineNumer});
        }
        return messageParts;
    }

    private static void removeEndingCRLFFromList(List<Line> list) {
        if (list.size() > 0) {
            Line lastLine = list.remove(list.size() - 1);
            list.add(BatchParserCommon.removeEndingCRLF(lastLine));
        }
    }

    public static Line removeEndingCRLF(Line line) {
        Pattern pattern = PATTERN_LAST_CRLF;
        Matcher matcher = pattern.matcher(line.toString());
        if (matcher.matches()) {
            return new Line(matcher.group(1), line.getLineNumber());
        }
        return line;
    }

    public static Header consumeHeaders(List<Line> remainingMessage) {
        int headerLineNumber = remainingMessage.size() != 0 ? remainingMessage.get(0).getLineNumber() : 0;
        Header headers = new Header(headerLineNumber);
        Iterator<Line> iter = remainingMessage.iterator();
        boolean isHeader = true;
        while (iter.hasNext() && isHeader) {
            Line currentLine = iter.next();
            Matcher headerMatcher = PATTERN_HEADER_LINE.matcher(currentLine.toString());
            if (headerMatcher.matches() && headerMatcher.groupCount() == 2) {
                iter.remove();
                String headerName = headerMatcher.group(1).trim();
                String headerValue = headerMatcher.group(2).trim();
                headers.addHeader(headerName, Header.splitValuesByComma(headerValue), currentLine.getLineNumber());
                continue;
            }
            isHeader = false;
        }
        return headers;
    }

    public static void consumeBlankLine(List<Line> remainingMessage, boolean isStrict) throws BatchDeserializerException {
        if (remainingMessage.size() > 0 && remainingMessage.get(0).toString().matches("\\s*(\r\n|\n)\\s*")) {
            remainingMessage.remove(0);
        } else if (isStrict) {
            int lineNumber = remainingMessage.size() > 0 ? remainingMessage.get(0).getLineNumber() : 0;
            throw new BatchDeserializerException("Missing blank line", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.MISSING_BLANK_LINE, new String[]{"[None]", "" + lineNumber});
        }
    }

    public static InputStream convertLineListToInputStream(List<Line> messageList) {
        String message = BatchParserCommon.lineListToString(messageList);
        return new ByteArrayInputStream(message.getBytes());
    }

    private static String lineListToString(List<Line> messageList) {
        StringBuilder builder = new StringBuilder();
        for (Line currentLine : messageList) {
            builder.append(currentLine.toString());
        }
        return builder.toString();
    }

    public static String trimLineListToLength(List<Line> list, int length) {
        String message = BatchParserCommon.lineListToString(list);
        int lastIndex = Math.min(length, message.length());
        return lastIndex > 0 ? message.substring(0, lastIndex) : "";
    }

    public static InputStream convertLineListToInputStream(List<Line> list, int length) {
        String message = BatchParserCommon.trimLineListToLength(list, length);
        return new ByteArrayInputStream(message.getBytes());
    }
}

