/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer.batch;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.server.core.deserializer.batch.Line;

public class BufferedReaderIncludingLineEndings
extends Reader {
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final int EOF = -1;
    private static final int BUFFER_SIZE = 8192;
    private Reader reader;
    private char[] buffer;
    private int offset = 0;
    private int limit = 0;

    public BufferedReaderIncludingLineEndings(Reader reader) {
        this(reader, 8192);
    }

    public BufferedReaderIncludingLineEndings(Reader reader, int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than zero.");
        }
        this.reader = reader;
        this.buffer = new char[bufferSize];
    }

    @Override
    public int read(char[] charBuffer, int bufferOffset, int length) throws IOException {
        if (bufferOffset + length > charBuffer.length) {
            throw new IndexOutOfBoundsException("Buffer is too small");
        }
        if (length < 0 || bufferOffset < 0) {
            throw new IndexOutOfBoundsException("Offset and length must be grater than zero");
        }
        if (this.limit == this.offset || this.isEOF()) {
            this.fillBuffer();
            if (this.isEOF()) {
                return -1;
            }
        }
        int bytesRead = 0;
        int bytesToRead = length;
        int currentOutputOffset = bufferOffset;
        while (bytesToRead != 0) {
            if (this.limit == this.offset) {
                this.fillBuffer();
                if (this.isEOF()) {
                    bytesToRead = 0;
                }
            }
            if (bytesToRead <= 0) continue;
            int readByte = Math.min(this.limit - this.offset, bytesToRead);
            bytesRead += readByte;
            bytesToRead -= readByte;
            for (int i = 0; i < readByte; ++i) {
                charBuffer[currentOutputOffset++] = this.buffer[this.offset++];
            }
        }
        return bytesRead;
    }

    public List<String> toList() throws IOException {
        String currentLine;
        ArrayList<String> result = new ArrayList<String>();
        while ((currentLine = this.readLine()) != null) {
            result.add(currentLine);
        }
        return result;
    }

    public List<Line> toLineList() throws IOException {
        String currentLine;
        ArrayList<Line> result = new ArrayList<Line>();
        int counter = 1;
        while ((currentLine = this.readLine()) != null) {
            result.add(new Line(currentLine, counter++));
        }
        return result;
    }

    public String readLine() throws IOException {
        if (this.limit == -1) {
            return null;
        }
        StringBuilder stringBuffer = new StringBuilder();
        boolean foundLineEnd = false;
        while (!foundLineEnd) {
            if (this.limit == this.offset && this.fillBuffer() == -1) {
                foundLineEnd = true;
            }
            if (foundLineEnd) continue;
            char currentChar = this.buffer[this.offset++];
            stringBuffer.append(currentChar);
            if (currentChar == '\n') {
                foundLineEnd = true;
                continue;
            }
            if (currentChar != '\r') continue;
            foundLineEnd = true;
            if (this.limit == this.offset) {
                this.fillBuffer();
            }
            if (this.limit == -1 || this.buffer[this.offset] != '\n') continue;
            stringBuffer.append('\n');
            ++this.offset;
        }
        return stringBuffer.length() == 0 ? null : stringBuffer.toString();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public boolean ready() throws IOException {
        return !this.isEOF() && this.limit != this.offset;
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("Reset is not supported");
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("Mark is not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n == 0L) {
            return 0L;
        }
        if (n < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        long charactersToSkip = n;
        long charactersSkiped = 0L;
        while (charactersToSkip != 0L) {
            if (this.limit == this.offset) {
                this.fillBuffer();
                if (this.isEOF()) {
                    charactersToSkip = 0L;
                }
            }
            if (this.isEOF()) continue;
            int skipChars = (int)Math.min((long)(this.limit - this.offset), charactersToSkip);
            charactersSkiped += (long)skipChars;
            charactersToSkip -= (long)skipChars;
            this.offset += skipChars;
        }
        return charactersSkiped;
    }

    private boolean isEOF() {
        return this.limit == -1;
    }

    private int fillBuffer() throws IOException {
        this.limit = this.reader.read(this.buffer, 0, this.buffer.length);
        this.offset = 0;
        return this.limit;
    }
}

