/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer.batch;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.batch.exception.BatchDeserializerException;
import org.apache.olingo.server.core.deserializer.batch.Line;

public class HttpRequestStatusLine {
    private static final Pattern PATTERN_RELATIVE_URI = Pattern.compile("([^/][^?]*)(?:\\?(.*))?");
    private static final Set<String> HTTP_BATCH_METHODS = new HashSet<String>(Arrays.asList("GET"));
    private static final Set<String> HTTP_CHANGE_SET_METHODS = new HashSet<String>(Arrays.asList("POST", "PUT", "DELETE", "PATCH"));
    private static final String HTTP_VERSION = "HTTP/1.1";
    private final Line statusLine;
    final String requestBaseUri;
    private HttpMethod method;
    private String httpVersion;
    private String rawServiceResolutionUri;
    private String rawQueryPath;
    private String rawODataPath;
    private String rawBaseUri;
    private String rawRequestUri;

    public HttpRequestStatusLine(Line httpStatusLine, String baseUri, String serviceResolutionUri) throws BatchDeserializerException {
        this.statusLine = httpStatusLine;
        this.requestBaseUri = baseUri;
        this.rawServiceResolutionUri = serviceResolutionUri;
        this.parse();
    }

    private void parse() throws BatchDeserializerException {
        String[] parts = this.statusLine.toString().split(" ");
        if (parts.length != 3) {
            throw new BatchDeserializerException("Invalid status line", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_STATUS_LINE, this.statusLine.getLineNumber());
        }
        this.method = this.parseMethod(parts[0]);
        this.parseUri(parts[1], this.requestBaseUri);
        this.httpVersion = this.parseHttpVersion(parts[2]);
    }

    private void parseUri(String rawUri, String baseUri) throws BatchDeserializerException {
        try {
            URI uri = new URI(rawUri);
            if (uri.isAbsolute()) {
                this.parseAbsoluteUri(rawUri, baseUri);
            } else {
                this.parseRelativeUri(rawUri);
            }
        }
        catch (URISyntaxException e) {
            throw new BatchDeserializerException("Malformed uri", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_URI, this.statusLine.getLineNumber());
        }
    }

    private void parseAbsoluteUri(String rawUri, String baseUri) throws BatchDeserializerException {
        if (!rawUri.startsWith(baseUri)) {
            throw new BatchDeserializerException("Base uri do not match", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_BASE_URI, this.statusLine.getLineNumber());
        }
        String relativeUri = this.removeLeadingSlash(rawUri.substring(baseUri.length()));
        this.parseRelativeUri(relativeUri);
    }

    private String removeLeadingSlash(String value) {
        return value.length() > 0 && value.charAt(0) == '/' ? value.substring(1) : value;
    }

    private void parseRelativeUri(String rawUri) throws BatchDeserializerException {
        Matcher relativeUriMatcher = PATTERN_RELATIVE_URI.matcher(rawUri);
        if (!relativeUriMatcher.matches()) {
            throw new BatchDeserializerException("Malformed uri", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_URI, this.statusLine.getLineNumber());
        }
        this.buildUri(relativeUriMatcher.group(1), relativeUriMatcher.group(2));
    }

    private void buildUri(String oDataPath, String queryOptions) throws BatchDeserializerException {
        this.rawBaseUri = this.requestBaseUri;
        this.rawODataPath = "/" + oDataPath;
        this.rawRequestUri = this.requestBaseUri + this.rawODataPath;
        if (queryOptions != null) {
            this.rawRequestUri = this.rawRequestUri + "?" + queryOptions;
            this.rawQueryPath = queryOptions;
        } else {
            this.rawQueryPath = "";
        }
    }

    private HttpMethod parseMethod(String method) throws BatchDeserializerException {
        try {
            return HttpMethod.valueOf((String)method.trim());
        }
        catch (IllegalArgumentException e) {
            throw new BatchDeserializerException("Illegal http method", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_METHOD, this.statusLine.getLineNumber());
        }
    }

    private String parseHttpVersion(String httpVersion) throws BatchDeserializerException {
        if (!HTTP_VERSION.equals(httpVersion.trim())) {
            throw new BatchDeserializerException("Invalid http version", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_HTTP_VERSION, this.statusLine.getLineNumber());
        }
        return HTTP_VERSION;
    }

    public void validateHttpMethod(boolean isChangeSet) throws BatchDeserializerException {
        Set<String> validMethods;
        Set<String> set = validMethods = isChangeSet ? HTTP_CHANGE_SET_METHODS : HTTP_BATCH_METHODS;
        if (!validMethods.contains(this.getMethod().toString())) {
            if (isChangeSet) {
                throw new BatchDeserializerException("Invalid change set method", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_CHANGESET_METHOD, this.statusLine.getLineNumber());
            }
            throw new BatchDeserializerException("Invalid query operation method", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_QUERY_OPERATION_METHOD, this.statusLine.getLineNumber());
        }
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public int getLineNumber() {
        return this.statusLine.getLineNumber();
    }

    public String getRequestBaseUri() {
        return this.requestBaseUri;
    }

    public String getRawServiceResolutionUri() {
        return this.rawServiceResolutionUri;
    }

    public String getRawQueryPath() {
        return this.rawQueryPath;
    }

    public String getRawODataPath() {
        return this.rawODataPath;
    }

    public String getRawBaseUri() {
        return this.rawBaseUri;
    }

    public String getRawRequestUri() {
        return this.rawRequestUri;
    }
}

