/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntitySet;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.domain.ODataLinkType;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.core.data.EntityImpl;
import org.apache.olingo.commons.core.data.EntitySetImpl;
import org.apache.olingo.commons.core.data.LinkImpl;
import org.apache.olingo.commons.core.data.PropertyImpl;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.deserializer.ODataDeserializer;

public class ODataJsonDeserializer
implements ODataDeserializer {
    private static final String ODATA_ANNOTATION_MARKER = "@";
    private static final String ODATA_CONTROL_INFORMATION_PREFIX = "@odata.";

    public EntitySet entityCollection(InputStream stream, EdmEntityType edmEntityType) throws DeserializerException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY, true);
            JsonParser parser = new JsonFactory((ObjectCodec)objectMapper).createParser(stream);
            ObjectNode tree = (ObjectNode)parser.getCodec().readTree(parser);
            return this.consumeEntitySetNode(edmEntityType, tree);
        }
        catch (JsonParseException e) {
            throw new DeserializerException("An JsonParseException occurred", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.JSON_SYNTAX_EXCEPTION, new String[0]);
        }
        catch (JsonMappingException e) {
            throw new DeserializerException("Duplicate json property detected", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.DUPLICATE_JSON_PROPERTY, new String[0]);
        }
        catch (IOException e) {
            throw new DeserializerException("An IOException occurred", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
    }

    private EntitySet consumeEntitySetNode(EdmEntityType edmEntityType, ObjectNode tree) throws DeserializerException {
        EntitySetImpl entitySet = new EntitySetImpl();
        JsonNode jsonNode = tree.get("value");
        if (jsonNode != null) {
            if (!jsonNode.isArray()) {
                throw new DeserializerException("The content of the value tag must be an Array but is not. ", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.VALUE_TAG_MUST_BE_AN_ARRAY, new String[0]);
            }
        } else {
            throw new DeserializerException("Could not find value array.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.VALUE_ARRAY_NOT_PRESENT, new String[0]);
        }
        entitySet.getEntities().addAll(this.consumeEntitySetArray(edmEntityType, jsonNode));
        tree.remove("value");
        ArrayList toRemove = new ArrayList();
        Iterator fieldsIterator = tree.fields();
        while (fieldsIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldsIterator.next();
            if (((String)field.getKey()).contains(ODATA_CONTROL_INFORMATION_PREFIX)) {
                toRemove.add(field.getKey());
                continue;
            }
            if (!((String)field.getKey()).contains(ODATA_ANNOTATION_MARKER)) continue;
            throw new DeserializerException("Custom annotation with field name: " + (String)field.getKey() + " not supported", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
        }
        tree.remove(toRemove);
        this.assertJsonNodeIsEmpty((JsonNode)tree);
        return entitySet;
    }

    private List<Entity> consumeEntitySetArray(EdmEntityType edmEntityType, JsonNode jsonNode) throws DeserializerException {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (JsonNode arrayElement : jsonNode) {
            if (arrayElement.isArray() || arrayElement.isValueNode()) {
                throw new DeserializerException("Nested Arrays and primitive values are not allowed for an entity value.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_ENTITY, new String[0]);
            }
            entities.add(this.consumeEntityNode(edmEntityType, (ObjectNode)arrayElement));
        }
        return entities;
    }

    public Entity entity(InputStream stream, EdmEntityType edmEntityType) throws DeserializerException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY, true);
            JsonParser parser = new JsonFactory((ObjectCodec)objectMapper).createParser(stream);
            ObjectNode tree = (ObjectNode)parser.getCodec().readTree(parser);
            return this.consumeEntityNode(edmEntityType, tree);
        }
        catch (JsonParseException e) {
            throw new DeserializerException("An JsonParseException occurred", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.JSON_SYNTAX_EXCEPTION, new String[0]);
        }
        catch (JsonMappingException e) {
            throw new DeserializerException("Duplicate property detected", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.DUPLICATE_PROPERTY, new String[0]);
        }
        catch (IOException e) {
            throw new DeserializerException("An IOException occurred", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
    }

    private Entity consumeEntityNode(EdmEntityType edmEntityType, ObjectNode tree) throws DeserializerException {
        EntityImpl entity = new EntityImpl();
        entity.setType(edmEntityType.getFullQualifiedName().getFullQualifiedNameAsString());
        this.consumeEntityProperties(edmEntityType, tree, entity);
        this.consumeExpandedNavigationProperties(edmEntityType, tree, entity);
        this.consumeRemainingJsonNodeFields(edmEntityType, tree, entity);
        this.assertJsonNodeIsEmpty((JsonNode)tree);
        return entity;
    }

    private void consumeRemainingJsonNodeFields(EdmEntityType edmEntityType, ObjectNode node, EntityImpl entity) throws DeserializerException {
        ArrayList toRemove = new ArrayList();
        Iterator fieldsIterator = node.fields();
        while (fieldsIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldsIterator.next();
            if (((String)field.getKey()).contains("@odata.bind")) {
                Link bindingLink = this.consumeBindingLink((String)field.getKey(), (JsonNode)field.getValue(), edmEntityType);
                entity.getNavigationBindings().add(bindingLink);
                toRemove.add(field.getKey());
                continue;
            }
            if (((String)field.getKey()).contains(ODATA_CONTROL_INFORMATION_PREFIX)) {
                toRemove.add(field.getKey());
                continue;
            }
            if (!((String)field.getKey()).contains(ODATA_ANNOTATION_MARKER)) continue;
            throw new DeserializerException("Custom annotation with field name: " + (String)field.getKey() + " not supported", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
        }
        node.remove(toRemove);
    }

    private void consumeEntityProperties(EdmEntityType edmEntityType, ObjectNode node, EntityImpl entity) throws DeserializerException {
        List propertyNames = edmEntityType.getPropertyNames();
        for (String propertyName : propertyNames) {
            JsonNode jsonNode = node.get(propertyName);
            if (jsonNode == null) continue;
            EdmProperty edmProperty = (EdmProperty)edmEntityType.getProperty(propertyName);
            if (jsonNode.isNull() && !this.isNullable(edmProperty)) {
                throw new DeserializerException("Property: " + propertyName + " must not be null.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PROPERTY, new String[]{propertyName});
            }
            Property property = this.consumePropertyNode(edmProperty, jsonNode);
            entity.addProperty(property);
            node.remove(propertyName);
        }
    }

    private void consumeExpandedNavigationProperties(EdmEntityType edmEntityType, ObjectNode node, EntityImpl entity) throws DeserializerException {
        List navigationPropertyNames = edmEntityType.getNavigationPropertyNames();
        for (String navigationPropertyName : navigationPropertyNames) {
            boolean isNullable;
            JsonNode jsonNode = node.get(navigationPropertyName);
            if (jsonNode == null) continue;
            EdmNavigationProperty edmNavigationProperty = edmEntityType.getNavigationProperty(navigationPropertyName);
            boolean bl = isNullable = edmNavigationProperty.isNullable() == null ? true : edmNavigationProperty.isNullable();
            if (jsonNode.isNull() && !isNullable) {
                throw new DeserializerException("Property: " + navigationPropertyName + " must not be null.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PROPERTY, new String[]{navigationPropertyName});
            }
            LinkImpl link = new LinkImpl();
            link.setTitle(navigationPropertyName);
            if (jsonNode.isArray() && edmNavigationProperty.isCollection()) {
                link.setType(ODataLinkType.ENTITY_SET_NAVIGATION.toString());
                EntitySetImpl inlineEntitySet = new EntitySetImpl();
                inlineEntitySet.getEntities().addAll(this.consumeEntitySetArray(edmNavigationProperty.getType(), jsonNode));
                link.setInlineEntitySet((EntitySet)inlineEntitySet);
            } else if (!(jsonNode.isArray() || jsonNode.isValueNode() || edmNavigationProperty.isCollection())) {
                link.setType(ODataLinkType.ENTITY_NAVIGATION.toString());
                if (!jsonNode.isNull()) {
                    Entity inlineEntity = this.consumeEntityNode(edmNavigationProperty.getType(), (ObjectNode)jsonNode);
                    link.setInlineEntity(inlineEntity);
                }
            } else {
                throw new DeserializerException("Invalid value: " + jsonNode.getNodeType() + " for expanded navigation property: " + navigationPropertyName, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_NAVIGATION_PROPERTY, new String[]{navigationPropertyName});
            }
            entity.getNavigationLinks().add(link);
            node.remove(navigationPropertyName);
        }
    }

    private Link consumeBindingLink(String key, JsonNode jsonNode, EdmEntityType edmEntityType) throws DeserializerException {
        String[] splitKey = key.split(ODATA_ANNOTATION_MARKER);
        String navigationPropertyName = splitKey[0];
        EdmNavigationProperty edmNavigationProperty = edmEntityType.getNavigationProperty(navigationPropertyName);
        if (edmNavigationProperty == null) {
            throw new DeserializerException("Invalid navigationPropertyName: " + navigationPropertyName, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.NAVIGATION_PROPERTY_NOT_FOUND, new String[]{navigationPropertyName});
        }
        LinkImpl bindingLink = new LinkImpl();
        bindingLink.setTitle(navigationPropertyName);
        if (edmNavigationProperty.isCollection()) {
            this.assertIsNullNode(key, jsonNode);
            if (!jsonNode.isArray()) {
                throw new DeserializerException("Binding annotation: " + key + " must be an array.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_ANNOTATION_TYPE, new String[]{key});
            }
            ArrayList<String> bindingLinkStrings = new ArrayList<String>();
            for (JsonNode arrayValue : jsonNode) {
                this.assertIsNullNode(key, arrayValue);
                if (!arrayValue.isTextual()) {
                    throw new DeserializerException("Binding annotation: " + key + " must have string valued array.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_ANNOTATION_TYPE, new String[]{key});
                }
                bindingLinkStrings.add(arrayValue.asText());
            }
            bindingLink.setType(ODataLinkType.ENTITY_COLLECTION_BINDING.toString());
            bindingLink.setBindingLinks(bindingLinkStrings);
        } else {
            this.assertIsNullNode(key, jsonNode);
            if (!jsonNode.isValueNode()) {
                throw new DeserializerException("Binding annotation: " + key + " must be a string value.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_ANNOTATION_TYPE, new String[]{key});
            }
            bindingLink.setBindingLink(jsonNode.asText());
            bindingLink.setType(ODataLinkType.ENTITY_BINDING.toString());
        }
        return bindingLink;
    }

    private void assertIsNullNode(String key, JsonNode jsonNode) throws DeserializerException {
        if (jsonNode.isNull()) {
            throw new DeserializerException("Annotation: " + key + "must not have a null value.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_ANNOTATION, new String[]{key});
        }
    }

    private Property consumePropertyNode(EdmProperty edmProperty, JsonNode jsonNode) throws DeserializerException {
        PropertyImpl property = new PropertyImpl();
        property.setName(edmProperty.getName());
        property.setType(edmProperty.getType().getFullQualifiedName().getFullQualifiedNameAsString());
        if (edmProperty.isCollection()) {
            this.consumePropertyCollectionNode(edmProperty, jsonNode, (Property)property);
        } else {
            this.consumePropertySingleNode(edmProperty, jsonNode, (Property)property);
        }
        return property;
    }

    private void consumePropertySingleNode(EdmProperty edmProperty, JsonNode jsonNode, Property property) throws DeserializerException {
        switch (edmProperty.getType().getKind()) {
            case PRIMITIVE: {
                Object value = this.readPrimitiveValue(edmProperty, jsonNode);
                property.setValue(ValueType.PRIMITIVE, value);
                break;
            }
            case DEFINITION: {
                Object value = this.readTypeDefinitionValue(edmProperty, jsonNode);
                property.setValue(ValueType.PRIMITIVE, value);
                break;
            }
            case ENUM: {
                Object value = this.readEnumValue(edmProperty, jsonNode);
                property.setValue(ValueType.PRIMITIVE, value);
                break;
            }
            case COMPLEX: {
                Object value = this.readComplexNode(edmProperty, jsonNode);
                property.setValue(ValueType.COMPLEX, value);
                break;
            }
            default: {
                throw new DeserializerException("Invalid Type Kind for a property found: " + edmProperty.getType().getKind(), (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_JSON_TYPE_FOR_PROPERTY, new String[]{edmProperty.getName()});
            }
        }
    }

    private Object readComplexNode(EdmProperty edmProperty, JsonNode jsonNode) throws DeserializerException {
        Object value = this.readComplexValue(edmProperty, jsonNode);
        ArrayList toRemove = new ArrayList();
        Iterator fieldsIterator = jsonNode.fields();
        while (fieldsIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldsIterator.next();
            if (((String)field.getKey()).contains(ODATA_CONTROL_INFORMATION_PREFIX)) {
                toRemove.add(field.getKey());
                continue;
            }
            if (!((String)field.getKey()).contains(ODATA_ANNOTATION_MARKER)) continue;
            throw new DeserializerException("Custom annotation with field name: " + (String)field.getKey() + " not supported", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
        }
        if (!jsonNode.isNull()) {
            ((ObjectNode)jsonNode).remove(toRemove);
        }
        this.assertJsonNodeIsEmpty(jsonNode);
        return value;
    }

    private void consumePropertyCollectionNode(EdmProperty edmProperty, JsonNode jsonNode, Property property) throws DeserializerException {
        if (!jsonNode.isArray()) {
            throw new DeserializerException("Value for property: " + edmProperty.getName() + " must be an array but is not.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_JSON_TYPE_FOR_PROPERTY, new String[]{edmProperty.getName()});
        }
        ArrayList<Object> valueArray = new ArrayList<Object>();
        Iterator iterator = jsonNode.iterator();
        switch (edmProperty.getType().getKind()) {
            case PRIMITIVE: {
                while (iterator.hasNext()) {
                    JsonNode arrayElement = (JsonNode)iterator.next();
                    Object value = this.readPrimitiveValue(edmProperty, arrayElement);
                    valueArray.add(value);
                }
                property.setValue(ValueType.COLLECTION_PRIMITIVE, valueArray);
                break;
            }
            case DEFINITION: {
                while (iterator.hasNext()) {
                    JsonNode arrayElement = (JsonNode)iterator.next();
                    Object value = this.readTypeDefinitionValue(edmProperty, arrayElement);
                    valueArray.add(value);
                }
                property.setValue(ValueType.COLLECTION_PRIMITIVE, valueArray);
                break;
            }
            case ENUM: {
                while (iterator.hasNext()) {
                    JsonNode arrayElement = (JsonNode)iterator.next();
                    Object value = this.readEnumValue(edmProperty, arrayElement);
                    valueArray.add(value);
                }
                property.setValue(ValueType.COLLECTION_ENUM, valueArray);
                break;
            }
            case COMPLEX: {
                while (iterator.hasNext()) {
                    Object value = this.readComplexNode(edmProperty, (JsonNode)iterator.next());
                    valueArray.add(value);
                }
                property.setValue(ValueType.COLLECTION_COMPLEX, valueArray);
                break;
            }
            default: {
                throw new DeserializerException("Invalid Type Kind for a property found: " + edmProperty.getType().getKind(), (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_JSON_TYPE_FOR_PROPERTY, new String[]{edmProperty.getName()});
            }
        }
    }

    private Object readComplexValue(EdmProperty edmComplexProperty, JsonNode jsonNode) throws DeserializerException {
        if (this.isValidNull(edmComplexProperty, jsonNode)) {
            return null;
        }
        if (jsonNode.isArray() || !jsonNode.isContainerNode()) {
            throw new DeserializerException("Invalid value for property: " + edmComplexProperty.getName() + " must not be an array or primitive value.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_JSON_TYPE_FOR_PROPERTY, new String[]{edmComplexProperty.getName()});
        }
        ArrayList<Property> propertyList = new ArrayList<Property>();
        EdmComplexType edmType = (EdmComplexType)edmComplexProperty.getType();
        for (String propertyName : edmType.getPropertyNames()) {
            JsonNode subNode = jsonNode.get(propertyName);
            if (subNode == null) continue;
            EdmProperty edmProperty = (EdmProperty)edmType.getProperty(propertyName);
            if (subNode.isNull() && !this.isNullable(edmProperty)) {
                throw new DeserializerException("Property: " + propertyName + " must not be null.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PROPERTY, new String[]{propertyName});
            }
            Property property = this.consumePropertyNode(edmProperty, subNode);
            propertyList.add(property);
            ((ObjectNode)jsonNode).remove(propertyName);
        }
        return propertyList;
    }

    private boolean isNullable(EdmProperty edmProperty) {
        return edmProperty.isNullable() == null ? true : edmProperty.isNullable();
    }

    private Object readTypeDefinitionValue(EdmProperty edmProperty, JsonNode jsonNode) throws DeserializerException {
        this.checkForValueNode(edmProperty, jsonNode);
        if (this.isValidNull(edmProperty, jsonNode)) {
            return null;
        }
        try {
            EdmTypeDefinition edmTypeDefinition = (EdmTypeDefinition)edmProperty.getType();
            this.checkJsonTypeBasedOnPrimitiveType(edmProperty.getName(), edmTypeDefinition.getUnderlyingType().getName(), jsonNode);
            return edmTypeDefinition.valueOfString(jsonNode.asText(), edmProperty.isNullable(), edmTypeDefinition.getMaxLength(), edmTypeDefinition.getPrecision(), edmTypeDefinition.getScale(), edmTypeDefinition.isUnicode(), edmTypeDefinition.getDefaultType());
        }
        catch (EdmPrimitiveTypeException e) {
            throw new DeserializerException("Invalid value: " + jsonNode.asText() + " for property: " + edmProperty.getName(), (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{edmProperty.getName()});
        }
    }

    private boolean isValidNull(EdmProperty edmProperty, JsonNode jsonNode) throws DeserializerException {
        if (jsonNode.isNull()) {
            if (this.isNullable(edmProperty)) {
                return true;
            }
            throw new DeserializerException("Property: " + edmProperty.getName() + " must not be null.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PROPERTY, new String[]{edmProperty.getName()});
        }
        return false;
    }

    private Object readEnumValue(EdmProperty edmProperty, JsonNode jsonNode) throws DeserializerException {
        this.checkForValueNode(edmProperty, jsonNode);
        if (this.isValidNull(edmProperty, jsonNode)) {
            return null;
        }
        try {
            EdmEnumType edmEnumType = (EdmEnumType)edmProperty.getType();
            this.checkJsonTypeBasedOnPrimitiveType(edmProperty.getName(), edmEnumType.getUnderlyingType().getName(), jsonNode);
            return edmEnumType.valueOfString(jsonNode.asText(), edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), edmEnumType.getDefaultType());
        }
        catch (EdmPrimitiveTypeException e) {
            throw new DeserializerException("Invalid value: " + jsonNode.asText() + " for property: " + edmProperty.getName(), (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{edmProperty.getName()});
        }
    }

    private Object readPrimitiveValue(EdmProperty edmProperty, JsonNode jsonNode) throws DeserializerException {
        this.checkForValueNode(edmProperty, jsonNode);
        if (this.isValidNull(edmProperty, jsonNode)) {
            return null;
        }
        try {
            EdmPrimitiveType edmPrimitiveType = (EdmPrimitiveType)edmProperty.getType();
            this.checkJsonTypeBasedOnPrimitiveType(edmProperty.getName(), edmPrimitiveType.getName(), jsonNode);
            return edmPrimitiveType.valueOfString(jsonNode.asText(), edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), edmPrimitiveType.getDefaultType());
        }
        catch (EdmPrimitiveTypeException e) {
            throw new DeserializerException("Invalid value: " + jsonNode.asText() + " for property: " + edmProperty.getName(), (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{edmProperty.getName()});
        }
    }

    private void checkForValueNode(EdmProperty edmProperty, JsonNode jsonNode) throws DeserializerException {
        if (!jsonNode.isValueNode()) {
            throw new DeserializerException("Invalid value for property: " + edmProperty.getName() + " must not be an object or array.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_JSON_TYPE_FOR_PROPERTY, new String[]{edmProperty.getName()});
        }
    }

    private void assertJsonNodeIsEmpty(JsonNode node) throws DeserializerException {
        if (node.size() != 0) {
            String unknownField = (String)node.fieldNames().next();
            throw new DeserializerException("Tree should be empty but still has content left: " + unknownField, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.UNKOWN_CONTENT, new String[]{unknownField});
        }
    }

    private void checkJsonTypeBasedOnPrimitiveType(String propertyName, String edmPrimitiveTypeName, JsonNode jsonNode) throws DeserializerException {
        EdmPrimitiveTypeKind primKind;
        try {
            primKind = EdmPrimitiveTypeKind.valueOf((ODataServiceVersion)ODataServiceVersion.V40, (String)edmPrimitiveTypeName);
        }
        catch (IllegalArgumentException e) {
            throw new DeserializerException("Unknown Primitive Type: " + edmPrimitiveTypeName, (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_PRIMITIVE_TYPE, new String[]{edmPrimitiveTypeName, propertyName});
        }
        switch (primKind) {
            case Boolean: {
                if (jsonNode.isBoolean()) break;
                throw new DeserializerException("Invalid json type: " + jsonNode.getNodeType() + " for edm " + primKind + " property: " + propertyName, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{propertyName});
            }
            case Int16: 
            case Int32: 
            case Int64: 
            case Byte: 
            case SByte: 
            case Single: 
            case Double: 
            case Decimal: {
                if (jsonNode.isNumber()) break;
                throw new DeserializerException("Invalid json type: " + jsonNode.getNodeType() + " for edm " + primKind + " property: " + propertyName, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{propertyName});
            }
            case String: 
            case Binary: 
            case Date: 
            case DateTimeOffset: 
            case Duration: 
            case Guid: 
            case TimeOfDay: {
                if (jsonNode.isTextual()) break;
                throw new DeserializerException("Invalid json type: " + jsonNode.getNodeType() + " for edm " + primKind + " property: " + propertyName, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{propertyName});
            }
            default: {
                throw new DeserializerException("Unsupported Edm Primitive Type: " + primKind, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
            }
        }
    }
}

