/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.edm.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmAnnotations;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.AbstractEdmSchema;
import org.apache.olingo.server.api.edm.provider.Action;
import org.apache.olingo.server.api.edm.provider.ComplexType;
import org.apache.olingo.server.api.edm.provider.EdmProvider;
import org.apache.olingo.server.api.edm.provider.EntityType;
import org.apache.olingo.server.api.edm.provider.EnumType;
import org.apache.olingo.server.api.edm.provider.Function;
import org.apache.olingo.server.api.edm.provider.Schema;
import org.apache.olingo.server.api.edm.provider.TypeDefinition;
import org.apache.olingo.server.core.edm.provider.EdmActionImpl;
import org.apache.olingo.server.core.edm.provider.EdmComplexTypeImpl;
import org.apache.olingo.server.core.edm.provider.EdmEntityContainerImpl;
import org.apache.olingo.server.core.edm.provider.EdmEntityTypeImpl;
import org.apache.olingo.server.core.edm.provider.EdmEnumTypeImpl;
import org.apache.olingo.server.core.edm.provider.EdmFunctionImpl;
import org.apache.olingo.server.core.edm.provider.EdmTypeDefinitionImpl;

public class EdmSchemaImpl
extends AbstractEdmSchema {
    private final Schema schema;
    private final Edm edm;
    private final EdmProvider provider;

    public EdmSchemaImpl(Edm edm, EdmProvider provider, Schema schema) {
        super(schema.getNamespace(), schema.getAlias());
        this.edm = edm;
        this.provider = provider;
        this.schema = schema;
    }

    protected EdmEntityContainer createEntityContainer() {
        if (this.schema.getEntityContainer() != null) {
            FullQualifiedName containerFQN = new FullQualifiedName(this.namespace, this.schema.getEntityContainer().getName());
            return new EdmEntityContainerImpl(this.edm, this.provider, containerFQN, this.schema.getEntityContainer());
        }
        return null;
    }

    protected List<EdmTypeDefinition> createTypeDefinitions() {
        ArrayList<EdmTypeDefinition> typeDefinitions = new ArrayList<EdmTypeDefinition>();
        List providerTypeDefinitions = this.schema.getTypeDefinitions();
        if (providerTypeDefinitions != null) {
            for (TypeDefinition def : providerTypeDefinitions) {
                typeDefinitions.add((EdmTypeDefinition)new EdmTypeDefinitionImpl(this.edm, new FullQualifiedName(this.namespace, def.getName()), def));
            }
        }
        return typeDefinitions;
    }

    protected List<EdmEnumType> createEnumTypes() {
        ArrayList<EdmEnumType> enumTypes = new ArrayList<EdmEnumType>();
        List providerEnumTypes = this.schema.getEnumTypes();
        if (providerEnumTypes != null) {
            for (EnumType enumType : providerEnumTypes) {
                enumTypes.add((EdmEnumType)new EdmEnumTypeImpl(this.edm, new FullQualifiedName(this.namespace, enumType.getName()), enumType));
            }
        }
        return enumTypes;
    }

    protected List<EdmEntityType> createEntityTypes() {
        ArrayList<EdmEntityType> entityTypes = new ArrayList<EdmEntityType>();
        List providerEntityTypes = this.schema.getEntityTypes();
        if (providerEntityTypes != null) {
            for (EntityType entityType : providerEntityTypes) {
                entityTypes.add((EdmEntityType)EdmEntityTypeImpl.getInstance(this.edm, new FullQualifiedName(this.namespace, entityType.getName()), entityType));
            }
        }
        return entityTypes;
    }

    protected List<EdmComplexType> createComplexTypes() {
        ArrayList<EdmComplexType> complexTypes = new ArrayList<EdmComplexType>();
        List providerComplexTypes = this.schema.getComplexTypes();
        if (providerComplexTypes != null) {
            for (ComplexType complexType : providerComplexTypes) {
                complexTypes.add((EdmComplexType)EdmComplexTypeImpl.getInstance(this.edm, new FullQualifiedName(this.namespace, complexType.getName()), complexType));
            }
        }
        return complexTypes;
    }

    protected List<EdmAction> createActions() {
        ArrayList<EdmAction> actions = new ArrayList<EdmAction>();
        List providerActions = this.schema.getActions();
        if (providerActions != null) {
            for (Action action : providerActions) {
                actions.add(EdmActionImpl.getInstance(this.edm, new FullQualifiedName(this.namespace, action.getName()), action));
            }
        }
        return actions;
    }

    protected List<EdmFunction> createFunctions() {
        ArrayList<EdmFunction> functions = new ArrayList<EdmFunction>();
        List providerFunctions = this.schema.getFunctions();
        if (providerFunctions != null) {
            for (Function function : providerFunctions) {
                functions.add(EdmFunctionImpl.getInstance(this.edm, new FullQualifiedName(this.namespace, function.getName()), function));
            }
        }
        return functions;
    }

    protected List<EdmTerm> createTerms() {
        return Collections.emptyList();
    }

    protected List<EdmAnnotations> createAnnotationGroups() {
        return Collections.emptyList();
    }

    protected List<EdmAnnotation> createAnnotations() {
        return Collections.emptyList();
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<EdmAnnotation> getAnnotations() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

