/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.olingo.commons.api.ODataRuntimeException;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.batch.exception.BatchSerializerException;
import org.apache.olingo.server.api.deserializer.batch.ODataResponsePart;

public class BatchResponseSerializer {
    private static final int BUFFER_SIZE = 4096;
    private static final String DOUBLE_DASH = "--";
    private static final String COLON = ":";
    private static final String SP = " ";
    private static final String CRLF = "\r\n";

    public InputStream serialize(List<ODataResponsePart> responses, String boundary) throws BatchSerializerException {
        StringBuilder builder = this.createBody(responses, boundary);
        return new ByteArrayInputStream(builder.toString().getBytes());
    }

    private StringBuilder createBody(List<ODataResponsePart> batchResponses, String boundary) throws BatchSerializerException {
        StringBuilder builder = new StringBuilder();
        for (ODataResponsePart part : batchResponses) {
            builder.append(this.getDashBoundary(boundary));
            if (part.isChangeSet()) {
                this.appendChangeSet(part, builder);
                continue;
            }
            this.appendBodyPart((ODataResponse)part.getResponses().get(0), builder, false);
        }
        builder.append(this.getCloseDelimiter(boundary));
        return builder;
    }

    private void appendChangeSet(ODataResponsePart part, StringBuilder builder) throws BatchSerializerException {
        String changeSetBoundary = this.generateBoundary("changeset");
        this.appendChangeSetHeader(builder, changeSetBoundary);
        builder.append(CRLF);
        for (ODataResponse response : part.getResponses()) {
            builder.append(this.getDashBoundary(changeSetBoundary));
            this.appendBodyPart(response, builder, true);
        }
        builder.append(this.getCloseDelimiter(changeSetBoundary));
    }

    private void appendBodyPart(ODataResponse response, StringBuilder builder, boolean isChangeSet) throws BatchSerializerException {
        byte[] body = this.getBody(response);
        this.appendBodyPartHeader(response, builder, isChangeSet);
        builder.append(CRLF);
        this.appendStatusLine(response, builder);
        this.appendResponseHeader(response, body.length, builder);
        builder.append(CRLF);
        builder.append(new String(body));
        builder.append(CRLF);
    }

    private byte[] getBody(ODataResponse response) {
        InputStream content = response.getContent();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (content != null) {
            byte[] buffer = new byte[4096];
            try {
                int n;
                while ((n = content.read(buffer, 0, buffer.length)) != -1) {
                    out.write(buffer, 0, n);
                }
                out.flush();
            }
            catch (IOException e) {
                throw new ODataRuntimeException((Exception)e);
            }
            return out.toByteArray();
        }
        return new byte[0];
    }

    private void appendChangeSetHeader(StringBuilder builder, String changeSetBoundary) {
        this.appendHeader("Content-Type", "multipart/mixed".toString() + "; boundary=" + changeSetBoundary, builder);
    }

    private void appendHeader(String name, String value, StringBuilder builder) {
        builder.append(name).append(COLON).append(SP).append(value).append(CRLF);
    }

    private void appendStatusLine(ODataResponse response, StringBuilder builder) {
        builder.append("HTTP/1.1").append(SP).append("" + response.getStatusCode()).append(SP).append(HttpStatusCode.fromStatusCode((int)response.getStatusCode()).toString()).append(CRLF);
    }

    private void appendResponseHeader(ODataResponse response, int contentLength, StringBuilder builder) {
        Map header = response.getHeaders();
        for (String key : header.keySet()) {
            if (key.equalsIgnoreCase("Content-Id")) continue;
            this.appendHeader(key, (String)header.get(key), builder);
        }
        this.appendHeader("Content-Length", "" + contentLength, builder);
    }

    private void appendBodyPartHeader(ODataResponse response, StringBuilder builder, boolean isChangeSet) throws BatchSerializerException {
        this.appendHeader("Content-Type", "application/http", builder);
        this.appendHeader("Content-Transfer-Encoding", "binary", builder);
        if (isChangeSet) {
            if (response.getHeaders().get("Content-Id") != null) {
                this.appendHeader("Content-Id", (String)response.getHeaders().get("Content-Id"), builder);
            } else {
                throw new BatchSerializerException("Missing content id", (ODataTranslatedException.MessageKey)BatchSerializerException.MessageKeys.MISSING_CONTENT_ID, new String[0]);
            }
        }
    }

    private String getDashBoundary(String boundary) {
        return DOUBLE_DASH + boundary + CRLF;
    }

    private String getCloseDelimiter(String boundary) {
        return DOUBLE_DASH + boundary + DOUBLE_DASH + CRLF;
    }

    private String generateBoundary(String value) {
        return value + "_" + UUID.randomUUID().toString();
    }
}

