/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.json;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmSingleton;

public class ServiceDocumentJsonSerializer {
    public static final String KIND = "kind";
    public static final String FUNCTION_IMPORT = "FunctionImport";
    public static final String SINGLETON = "Singleton";
    public static final String SERVICE_DOCUMENT = "ServiceDocument";
    private final Edm edm;
    private final String serviceRoot;

    public ServiceDocumentJsonSerializer(Edm edm, String serviceRoot) {
        this.edm = edm;
        this.serviceRoot = serviceRoot;
    }

    public void writeServiceDocument(JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        String metadataUri = this.serviceRoot == null ? "$metadata" : (this.serviceRoot.endsWith("/") ? this.serviceRoot + "$metadata" : this.serviceRoot + "/" + "$metadata");
        gen.writeObjectField("@odata.context", (Object)metadataUri);
        gen.writeArrayFieldStart("value");
        this.writeEntitySets(gen, this.edm);
        this.writeFunctionImports(gen, this.edm);
        this.writeSingletons(gen, this.edm);
    }

    private void writeEntitySets(JsonGenerator gen, Edm edm) throws IOException {
        EdmEntityContainer container = edm.getEntityContainer(null);
        for (EdmEntitySet edmEntitySet : container.getEntitySets()) {
            if (!edmEntitySet.isIncludeInServiceDocument()) continue;
            gen.writeStartObject();
            gen.writeObjectField("name", (Object)edmEntitySet.getName());
            gen.writeObjectField("url", (Object)edmEntitySet.getName());
            gen.writeEndObject();
        }
    }

    private void writeFunctionImports(JsonGenerator gen, Edm edm) throws IOException {
        EdmEntityContainer container = edm.getEntityContainer(null);
        for (EdmFunctionImport edmFunctionImport : container.getFunctionImports()) {
            if (!edmFunctionImport.isIncludeInServiceDocument()) continue;
            gen.writeStartObject();
            gen.writeObjectField("name", (Object)edmFunctionImport.getName());
            gen.writeObjectField("url", (Object)edmFunctionImport.getName());
            gen.writeObjectField(KIND, (Object)FUNCTION_IMPORT);
            gen.writeEndObject();
        }
    }

    private void writeSingletons(JsonGenerator gen, Edm edm) throws IOException {
        EdmEntityContainer container = edm.getEntityContainer(null);
        for (EdmSingleton edmSingleton : container.getSingletons()) {
            gen.writeStartObject();
            gen.writeObjectField("name", (Object)edmSingleton.getName());
            gen.writeObjectField("url", (Object)edmSingleton.getName());
            gen.writeObjectField(KIND, (Object)SINGLETON);
            gen.writeEndObject();
        }
    }
}

