/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.utils;

import java.net.URI;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.core.Encoder;

public final class ContextURLBuilder {
    public static URI create(ContextURL contextURL) {
        StringBuilder result = new StringBuilder();
        if (contextURL.getServiceRoot() != null) {
            result.append(contextURL.getServiceRoot());
        }
        result.append("$metadata");
        if (contextURL.getEntitySetOrSingletonOrType() != null) {
            result.append('#');
            if (contextURL.isCollection()) {
                result.append("Collection(").append(Encoder.encode((String)contextURL.getEntitySetOrSingletonOrType())).append(")");
            } else {
                result.append(Encoder.encode((String)contextURL.getEntitySetOrSingletonOrType()));
            }
        }
        if (contextURL.getDerivedEntity() != null) {
            if (contextURL.getEntitySetOrSingletonOrType() == null) {
                throw new IllegalArgumentException("ContextURL: Derived Type without anything to derive from!");
            }
            result.append('/').append(Encoder.encode((String)contextURL.getDerivedEntity()));
        }
        if (contextURL.getKeyPath() != null) {
            result.append('(').append(contextURL.getKeyPath()).append(')');
        }
        if (contextURL.getNavOrPropertyPath() != null) {
            result.append('/').append(contextURL.getNavOrPropertyPath());
        }
        if (contextURL.getSelectList() != null) {
            result.append('(').append(contextURL.getSelectList()).append(')');
        }
        if (contextURL.isReference()) {
            if (contextURL.getEntitySetOrSingletonOrType() != null) {
                throw new IllegalArgumentException("ContextURL: $ref with Entity Set");
            }
            result.append('#').append(ContextURL.Suffix.REFERENCE.getRepresentation());
        } else if (contextURL.getSuffix() != null) {
            if (contextURL.getEntitySetOrSingletonOrType() == null) {
                throw new IllegalArgumentException("ContextURL: Suffix without preceding Entity Set!");
            }
            result.append('/').append(contextURL.getSuffix().getRepresentation());
        }
        return URI.create(result.toString());
    }
}

