/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri;

import java.util.List;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.core.Encoder;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriHelper;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.core.serializer.utils.ContextURLHelper;

public class UriHelperImpl
implements UriHelper {
    public String buildContextURLSelectList(EdmStructuredType type, ExpandOption expand, SelectOption select) throws SerializerException {
        return ContextURLHelper.buildSelectList(type, expand, select);
    }

    public String buildContextURLKeyPredicate(List<UriParameter> keys) throws SerializerException {
        return ContextURLHelper.buildKeyPredicate(keys);
    }

    public String buildCanonicalURL(EdmEntitySet edmEntitySet, Entity entity) throws SerializerException {
        StringBuilder result = new StringBuilder(edmEntitySet.getName());
        result.append('(');
        EdmEntityType entityType = edmEntitySet.getEntityType();
        List keyNames = entityType.getKeyPredicateNames();
        boolean first = true;
        for (String keyName : keyNames) {
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            if (keyNames.size() > 1) {
                result.append(Encoder.encode((String)keyName)).append('=');
            }
            EdmProperty edmProperty = entityType.getStructuralProperty(keyName);
            EdmPrimitiveType type = (EdmPrimitiveType)edmProperty.getType();
            Object propertyValue = entity.getProperty(keyName).getValue();
            try {
                String value = type.toUriLiteral(type.valueToString(propertyValue, edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode()));
                result.append(Encoder.encode((String)value));
            }
            catch (EdmPrimitiveTypeException e) {
                throw new SerializerException("Wrong key value!", (ODataTranslatedException.MessageKey)SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, new String[]{edmProperty.getName(), propertyValue.toString()});
            }
        }
        result.append(')');
        return result.toString();
    }
}

