/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.validator;

import java.util.HashMap;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmActionImport;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmKeyPropertyRef;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.api.uri.UriResourceSingleton;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOptionKind;
import org.apache.olingo.server.core.uri.validator.UriValidationException;

public class UriValidator {
    private boolean[][] decisionMatrix = new boolean[][]{{true, true, true, false, true, true, true, true, true, true, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false}, {true, true, true, false, true, true, true, true, true, true, true, true}, {false, true, true, true, false, false, false, true, false, false, true, false}, {false, true, false, false, false, false, false, false, false, false, false, false}, {false, true, false, false, false, false, false, false, false, false, false, false}, {false, true, false, false, false, false, false, false, false, false, false, false}, {true, true, true, false, true, true, true, true, true, true, true, true}, {true, false, false, false, false, false, true, false, false, false, false, false}, {false, true, true, false, false, false, false, true, false, false, true, false}, {false, true, false, false, false, false, false, false, false, false, false, false}, {true, true, false, false, false, true, true, false, true, true, false, true}, {false, true, false, false, false, false, false, false, false, false, false, false}, {false, true, true, false, false, false, false, true, false, false, true, false}, {true, true, true, false, true, true, false, false, true, true, true, true}, {true, false, false, false, false, false, true, false, false, false, false, false}, {false, true, false, false, false, false, false, false, false, false, false, false}, {true, true, false, false, false, true, false, false, true, true, false, true}, {true, false, false, false, false, false, true, false, false, false, false, false}, {false, true, false, false, false, false, false, false, false, false, false, false}};
    private boolean[][] decisionMatrixForHttpMethod = new boolean[][]{{true, true, true, true, true, true, true, true, true, true, true, true}, {true, false, true, false, false, true, false, true, false, false, true, false}, {false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false}};

    public void validate(UriInfo uriInfo, HttpMethod httpMethod) throws UriValidationException {
        this.validateForHttpMethod(uriInfo, httpMethod);
        this.validateQueryOptions(uriInfo);
        this.validateKeyPredicates(uriInfo);
        this.validatePropertyOperations(uriInfo, httpMethod);
    }

    private ColumnIndex colIndex(SystemQueryOptionKind queryOptionKind) throws UriValidationException {
        ColumnIndex idx;
        switch (queryOptionKind) {
            case FILTER: {
                idx = ColumnIndex.filter;
                break;
            }
            case FORMAT: {
                idx = ColumnIndex.format;
                break;
            }
            case EXPAND: {
                idx = ColumnIndex.expand;
                break;
            }
            case ID: {
                idx = ColumnIndex.id;
                break;
            }
            case COUNT: {
                idx = ColumnIndex.count;
                break;
            }
            case ORDERBY: {
                idx = ColumnIndex.orderby;
                break;
            }
            case SEARCH: {
                idx = ColumnIndex.search;
                break;
            }
            case SELECT: {
                idx = ColumnIndex.select;
                break;
            }
            case SKIP: {
                idx = ColumnIndex.skip;
                break;
            }
            case SKIPTOKEN: {
                idx = ColumnIndex.skiptoken;
                break;
            }
            case LEVELS: {
                idx = ColumnIndex.levels;
                break;
            }
            case TOP: {
                idx = ColumnIndex.top;
                break;
            }
            default: {
                throw new UriValidationException("Unsupported option: " + queryOptionKind.toString(), UriValidationException.MessageKeys.UNSUPPORTED_QUERY_OPTION, queryOptionKind.toString());
            }
        }
        return idx;
    }

    private RowIndexForUriType rowIndexForUriType(UriInfo uriInfo) throws UriValidationException {
        RowIndexForUriType idx;
        switch (uriInfo.getKind()) {
            case all: {
                idx = RowIndexForUriType.all;
                break;
            }
            case batch: {
                idx = RowIndexForUriType.batch;
                break;
            }
            case crossjoin: {
                idx = RowIndexForUriType.crossjoin;
                break;
            }
            case entityId: {
                idx = RowIndexForUriType.entityId;
                break;
            }
            case metadata: {
                idx = RowIndexForUriType.metadata;
                break;
            }
            case resource: {
                idx = this.rowIndexForResourceKind(uriInfo);
                break;
            }
            case service: {
                idx = RowIndexForUriType.service;
                break;
            }
            default: {
                throw new UriValidationException("Unsupported uriInfo kind: " + uriInfo.getKind(), UriValidationException.MessageKeys.UNSUPPORTED_URI_KIND, uriInfo.getKind().toString());
            }
        }
        return idx;
    }

    private RowIndexForUriType rowIndexForResourceKind(UriInfo uriInfo) throws UriValidationException {
        RowIndexForUriType idx;
        int lastPathSegmentIndex = uriInfo.getUriResourceParts().size() - 1;
        UriResource lastPathSegment = (UriResource)uriInfo.getUriResourceParts().get(lastPathSegmentIndex);
        switch (lastPathSegment.getKind()) {
            case count: {
                idx = this.rowIndexForCount(uriInfo);
                break;
            }
            case action: {
                idx = this.rowIndexForAction(lastPathSegment);
                break;
            }
            case complexProperty: {
                idx = this.rowIndexForComplexProperty(lastPathSegment);
                break;
            }
            case entitySet: {
                idx = this.rowIndexForEntitySet(lastPathSegment);
                break;
            }
            case function: {
                idx = this.rowIndexForFunction(lastPathSegment);
                break;
            }
            case navigationProperty: {
                idx = ((UriResourceNavigation)lastPathSegment).isCollection() ? RowIndexForUriType.entitySet : RowIndexForUriType.entity;
                break;
            }
            case primitiveProperty: {
                idx = this.rowIndexForPrimitiveProperty(lastPathSegment);
                break;
            }
            case ref: {
                idx = this.rowIndexForRef(uriInfo, lastPathSegment);
                break;
            }
            case root: {
                idx = RowIndexForUriType.service;
                break;
            }
            case singleton: {
                idx = RowIndexForUriType.entity;
                break;
            }
            case value: {
                idx = this.rowIndexForValue(uriInfo);
                break;
            }
            default: {
                throw new UriValidationException("Unsupported uriResource kind: " + lastPathSegment.getKind(), UriValidationException.MessageKeys.UNSUPPORTED_URI_RESOURCE_KIND, lastPathSegment.getKind().toString());
            }
        }
        return idx;
    }

    private RowIndexForUriType rowIndexForValue(UriInfo uriInfo) throws UriValidationException {
        RowIndexForUriType idx;
        int secondLastPathSegmentIndex = uriInfo.getUriResourceParts().size() - 2;
        UriResource secondLastPathSegment = (UriResource)uriInfo.getUriResourceParts().get(secondLastPathSegmentIndex);
        switch (secondLastPathSegment.getKind()) {
            case primitiveProperty: {
                idx = RowIndexForUriType.propertyPrimitiveValue;
                break;
            }
            case entitySet: {
                idx = RowIndexForUriType.mediaStream;
                break;
            }
            case function: {
                EdmFunction function;
                UriResourceFunction uriFunction = (UriResourceFunction)secondLastPathSegment;
                EdmFunctionImport functionImport = uriFunction.getFunctionImport();
                if (functionImport != null) {
                    List functions = functionImport.getUnboundFunctions();
                    function = (EdmFunction)functions.get(0);
                } else {
                    function = uriFunction.getFunction();
                }
                EdmTypeKind functionReturnTypeKind = function.getReturnType().getType().getKind();
                boolean isFunctionCollection = function.getReturnType().isCollection();
                idx = this.determineReturnType(functionReturnTypeKind, isFunctionCollection);
                break;
            }
            case action: {
                UriResourceAction uriAction = (UriResourceAction)secondLastPathSegment;
                EdmActionImport actionImport = uriAction.getActionImport();
                EdmAction action = actionImport != null ? actionImport.getUnboundAction() : uriAction.getAction();
                EdmTypeKind actionReturnTypeKind = action.getReturnType().getType().getKind();
                boolean isActionCollection = action.getReturnType().isCollection();
                idx = this.determineReturnType(actionReturnTypeKind, isActionCollection);
                break;
            }
            case navigationProperty: {
                UriResourceNavigation uriNavigation = (UriResourceNavigation)secondLastPathSegment;
                if (uriNavigation.isCollection()) {
                    idx = RowIndexForUriType.entitySet;
                    break;
                }
                idx = RowIndexForUriType.entity;
                break;
            }
            case singleton: {
                UriResourceSingleton uriSingleton = (UriResourceSingleton)secondLastPathSegment;
                EdmSingleton singleton = uriSingleton.getSingleton();
                EdmTypeKind singletonReturnTypeKind = singleton.getEntityType().getKind();
                idx = this.determineReturnType(singletonReturnTypeKind, false);
                break;
            }
            default: {
                throw new UriValidationException("Unexpected kind in path segment before $value: " + secondLastPathSegment.getKind(), UriValidationException.MessageKeys.UNALLOWED_KIND_BEFORE_VALUE, secondLastPathSegment.toString());
            }
        }
        return idx;
    }

    private RowIndexForUriType determineReturnType(EdmTypeKind functionReturnTypeKind, boolean isCollection) throws UriValidationException {
        RowIndexForUriType idx;
        switch (functionReturnTypeKind) {
            case COMPLEX: {
                idx = isCollection ? RowIndexForUriType.propertyComplexCollection : RowIndexForUriType.propertyComplex;
                break;
            }
            case ENTITY: {
                idx = isCollection ? RowIndexForUriType.entitySet : RowIndexForUriType.entity;
                break;
            }
            case PRIMITIVE: 
            case ENUM: 
            case DEFINITION: {
                idx = isCollection ? RowIndexForUriType.propertyPrimitiveCollection : RowIndexForUriType.propertyPrimitive;
                break;
            }
            default: {
                throw new UriValidationException("Unsupported function return type: " + functionReturnTypeKind, UriValidationException.MessageKeys.UNSUPPORTED_FUNCTION_RETURN_TYPE, functionReturnTypeKind.toString());
            }
        }
        return idx;
    }

    private RowIndexForUriType rowIndexForRef(UriInfo uriInfo, UriResource lastPathSegment) throws UriValidationException {
        int secondLastPathSegmentIndex = uriInfo.getUriResourceParts().size() - 2;
        UriResource secondLastPathSegment = (UriResource)uriInfo.getUriResourceParts().get(secondLastPathSegmentIndex);
        if (!(secondLastPathSegment instanceof UriResourcePartTyped)) {
            throw new UriValidationException("secondLastPathSegment not a class of UriResourcePartTyped: " + lastPathSegment.getClass(), UriValidationException.MessageKeys.LAST_SEGMENT_NOT_TYPED, lastPathSegment.toString());
        }
        RowIndexForUriType idx = ((UriResourcePartTyped)secondLastPathSegment).isCollection() ? RowIndexForUriType.references : RowIndexForUriType.reference;
        return idx;
    }

    private RowIndexForUriType rowIndexForPrimitiveProperty(UriResource lastPathSegment) throws UriValidationException {
        if (!(lastPathSegment instanceof UriResourcePartTyped)) {
            throw new UriValidationException("lastPathSegment not a class of UriResourcePartTyped: " + lastPathSegment.getClass(), UriValidationException.MessageKeys.LAST_SEGMENT_NOT_TYPED, lastPathSegment.toString());
        }
        RowIndexForUriType idx = ((UriResourcePartTyped)lastPathSegment).isCollection() ? RowIndexForUriType.propertyPrimitiveCollection : RowIndexForUriType.propertyPrimitive;
        return idx;
    }

    private RowIndexForUriType rowIndexForFunction(UriResource lastPathSegment) throws UriValidationException {
        RowIndexForUriType idx;
        UriResourceFunction urf = (UriResourceFunction)lastPathSegment;
        EdmReturnType rt = urf.getFunction().getReturnType();
        switch (rt.getType().getKind()) {
            case ENTITY: {
                if (((EdmEntityType)rt.getType()).hasStream()) {
                    idx = RowIndexForUriType.mediaStream;
                    break;
                }
                idx = rt.isCollection() ? RowIndexForUriType.entitySet : RowIndexForUriType.entity;
                break;
            }
            case PRIMITIVE: {
                idx = rt.isCollection() ? RowIndexForUriType.propertyPrimitiveCollection : RowIndexForUriType.propertyPrimitive;
                break;
            }
            case COMPLEX: {
                idx = rt.isCollection() ? RowIndexForUriType.propertyComplexCollection : RowIndexForUriType.propertyComplex;
                break;
            }
            default: {
                throw new UriValidationException("Unsupported function return type: " + rt.getType().getKind(), UriValidationException.MessageKeys.UNSUPPORTED_FUNCTION_RETURN_TYPE, rt.getType().getKind().toString());
            }
        }
        return idx;
    }

    private RowIndexForUriType rowIndexForEntitySet(UriResource lastPathSegment) throws UriValidationException {
        if (!(lastPathSegment instanceof UriResourcePartTyped)) {
            throw new UriValidationException("lastPathSegment not a class of UriResourcePartTyped: " + lastPathSegment.getClass(), UriValidationException.MessageKeys.LAST_SEGMENT_NOT_TYPED, lastPathSegment.toString());
        }
        RowIndexForUriType idx = ((UriResourcePartTyped)lastPathSegment).isCollection() ? RowIndexForUriType.entitySet : RowIndexForUriType.entity;
        return idx;
    }

    private RowIndexForUriType rowIndexForComplexProperty(UriResource lastPathSegment) throws UriValidationException {
        if (!(lastPathSegment instanceof UriResourcePartTyped)) {
            throw new UriValidationException("lastPathSegment not a class of UriResourcePartTyped: " + lastPathSegment.getClass(), UriValidationException.MessageKeys.LAST_SEGMENT_NOT_TYPED, lastPathSegment.toString());
        }
        RowIndexForUriType idx = ((UriResourcePartTyped)lastPathSegment).isCollection() ? RowIndexForUriType.propertyComplexCollection : RowIndexForUriType.propertyComplex;
        return idx;
    }

    private RowIndexForUriType rowIndexForAction(UriResource lastPathSegment) throws UriValidationException {
        RowIndexForUriType idx;
        UriResourceAction ura = (UriResourceAction)lastPathSegment;
        EdmReturnType rt = ura.getAction().getReturnType();
        switch (rt.getType().getKind()) {
            case ENTITY: {
                if (((EdmEntityType)rt.getType()).hasStream()) {
                    idx = RowIndexForUriType.mediaStream;
                    break;
                }
                idx = rt.isCollection() ? RowIndexForUriType.entitySet : RowIndexForUriType.entity;
                break;
            }
            case PRIMITIVE: {
                idx = rt.isCollection() ? RowIndexForUriType.propertyPrimitiveCollection : RowIndexForUriType.propertyPrimitive;
                break;
            }
            case COMPLEX: {
                idx = rt.isCollection() ? RowIndexForUriType.propertyComplexCollection : RowIndexForUriType.propertyComplex;
                break;
            }
            default: {
                throw new UriValidationException("Unsupported action return type: " + rt.getType().getKind(), UriValidationException.MessageKeys.UNSUPPORTED_ACTION_RETURN_TYPE, rt.getType().getKind().toString());
            }
        }
        return idx;
    }

    private RowIndexForUriType rowIndexForCount(UriInfo uriInfo) throws UriValidationException {
        RowIndexForUriType idx;
        int secondLastPathSegmentIndex = uriInfo.getUriResourceParts().size() - 2;
        UriResource secondLastPathSegment = (UriResource)uriInfo.getUriResourceParts().get(secondLastPathSegmentIndex);
        switch (secondLastPathSegment.getKind()) {
            case entitySet: 
            case navigationProperty: {
                idx = RowIndexForUriType.entitySetCount;
                break;
            }
            case complexProperty: {
                idx = RowIndexForUriType.propertyComplexCollectionCount;
                break;
            }
            case primitiveProperty: {
                idx = RowIndexForUriType.propertyPrimitiveCollectionCount;
                break;
            }
            case function: {
                EdmFunction function;
                UriResourceFunction uriFunction = (UriResourceFunction)secondLastPathSegment;
                EdmFunctionImport functionImport = uriFunction.getFunctionImport();
                if (functionImport != null) {
                    List functions = functionImport.getUnboundFunctions();
                    function = (EdmFunction)functions.get(0);
                } else {
                    function = uriFunction.getFunction();
                }
                EdmTypeKind functionReturnTypeKind = function.getReturnType().getType().getKind();
                boolean isCollection = function.getReturnType().isCollection();
                idx = this.determineReturnType(functionReturnTypeKind, isCollection);
                break;
            }
            default: {
                throw new UriValidationException("Illegal path part kind before $count: " + secondLastPathSegment.getKind(), UriValidationException.MessageKeys.UNALLOWED_KIND_BEFORE_COUNT, secondLastPathSegment.toString());
            }
        }
        return idx;
    }

    private void validateQueryOptions(UriInfo uriInfo) throws UriValidationException {
        RowIndexForUriType row = this.rowIndexForUriType(uriInfo);
        for (SystemQueryOption option : uriInfo.getSystemQueryOptions()) {
            ColumnIndex col = this.colIndex(option.getKind());
            if (this.decisionMatrix[row.getIndex()][col.getIndex()]) continue;
            throw new UriValidationException("System query option not allowed: " + option.getName(), UriValidationException.MessageKeys.SYSTEM_QUERY_OPTION_NOT_ALLOWED, option.getName());
        }
    }

    private void validateForHttpMethod(UriInfo uriInfo, HttpMethod httpMethod) throws UriValidationException {
        RowIndexForHttpMethod row = this.rowIndexForHttpMethod(httpMethod);
        for (SystemQueryOption option : uriInfo.getSystemQueryOptions()) {
            ColumnIndex col = this.colIndex(option.getKind());
            if (this.decisionMatrixForHttpMethod[row.getIndex()][col.getIndex()]) continue;
            throw new UriValidationException("System query option " + option.getName() + " not allowed for method " + httpMethod, UriValidationException.MessageKeys.SYSTEM_QUERY_OPTION_NOT_ALLOWED_FOR_HTTP_METHOD, option.getName(), httpMethod.toString());
        }
    }

    private RowIndexForHttpMethod rowIndexForHttpMethod(HttpMethod httpMethod) throws UriValidationException {
        RowIndexForHttpMethod idx;
        switch (httpMethod) {
            case GET: {
                idx = RowIndexForHttpMethod.GET;
                break;
            }
            case POST: {
                idx = RowIndexForHttpMethod.POST;
                break;
            }
            case PUT: {
                idx = RowIndexForHttpMethod.PUT;
                break;
            }
            case DELETE: {
                idx = RowIndexForHttpMethod.DELETE;
                break;
            }
            case PATCH: {
                idx = RowIndexForHttpMethod.PATCH;
                break;
            }
            default: {
                throw new UriValidationException("HTTP method not supported: " + httpMethod, UriValidationException.MessageKeys.UNSUPPORTED_HTTP_METHOD, httpMethod.toString());
            }
        }
        return idx;
    }

    private void validateKeyPredicates(UriInfo uriInfo) throws UriValidationException {
        for (UriResource pathSegment : uriInfo.getUriResourceParts()) {
            UriResourceEntitySet pathEntitySet;
            List keyPredicates;
            if (pathSegment.getKind() != UriResourceKind.entitySet || (keyPredicates = (pathEntitySet = (UriResourceEntitySet)pathSegment).getKeyPredicates()) == null) continue;
            List keyPredicateNames = pathEntitySet.getEntityType().getKeyPredicateNames();
            HashMap<String, EdmKeyPropertyRef> edmKeys = new HashMap<String, EdmKeyPropertyRef>();
            for (EdmKeyPropertyRef key : pathEntitySet.getEntityType().getKeyPropertyRefs()) {
                edmKeys.put(key.getKeyPropertyName(), key);
                String alias = key.getAlias();
                if (alias == null) continue;
                edmKeys.put(alias, key);
            }
            for (UriParameter keyPredicate : keyPredicates) {
                String name = keyPredicate.getName();
                String alias = keyPredicate.getAlias();
                String value = alias == null ? keyPredicate.getText() : uriInfo.getValueForAlias(alias);
                EdmKeyPropertyRef edmKey = (EdmKeyPropertyRef)edmKeys.get(name);
                if (edmKey == null) {
                    if (keyPredicateNames.contains(name)) {
                        throw new UriValidationException("Double key property: " + name, UriValidationException.MessageKeys.DOUBLE_KEY_PROPERTY, name);
                    }
                    throw new UriValidationException("Unknown key property: " + name, UriValidationException.MessageKeys.INVALID_KEY_PROPERTY, name);
                }
                EdmProperty property = edmKey.getProperty();
                EdmPrimitiveType edmPrimitiveType = (EdmPrimitiveType)property.getType();
                try {
                    if (!edmPrimitiveType.validate(edmPrimitiveType.fromUriLiteral(value), property.isNullable(), property.getMaxLength(), property.getPrecision(), property.getScale(), property.isUnicode())) {
                        throw new UriValidationException("PrimitiveTypeException", UriValidationException.MessageKeys.INVALID_KEY_PROPERTY, name);
                    }
                }
                catch (EdmPrimitiveTypeException e) {
                    throw new UriValidationException("PrimitiveTypeException", e, UriValidationException.MessageKeys.INVALID_KEY_PROPERTY, name);
                }
                edmKeys.remove(name);
                edmKeys.remove(alias);
            }
        }
    }

    private void validatePropertyOperations(UriInfo uriInfo, HttpMethod method) throws UriValidationException {
        UriResource previous;
        List parts = uriInfo.getUriResourceParts();
        UriResource last = parts.size() > 0 ? (UriResource)parts.get(parts.size() - 1) : null;
        UriResource uriResource = previous = parts.size() > 1 ? (UriResource)parts.get(parts.size() - 2) : null;
        if (last != null && (last.getKind() == UriResourceKind.primitiveProperty || last.getKind() == UriResourceKind.complexProperty || last.getKind() == UriResourceKind.value && previous.getKind() == UriResourceKind.primitiveProperty)) {
            EdmProperty property = ((UriResourceProperty)(last.getKind() == UriResourceKind.value ? previous : last)).getProperty();
            if (method == HttpMethod.PATCH && property.isCollection()) {
                throw new UriValidationException("Attempt to patch collection property.", UriValidationException.MessageKeys.UNSUPPORTED_HTTP_METHOD, method.toString());
            }
            if (method == HttpMethod.DELETE && property.isNullable() != null && !property.isNullable().booleanValue()) {
                throw new UriValidationException("Attempt to delete non-nullable property.", UriValidationException.MessageKeys.UNSUPPORTED_HTTP_METHOD, method.toString());
            }
        }
    }

    private static enum RowIndexForHttpMethod {
        GET(0),
        POST(1),
        PUT(2),
        DELETE(3),
        PATCH(4);

        private int idx;

        private RowIndexForHttpMethod(int i) {
            this.idx = i;
        }

        public int getIndex() {
            return this.idx;
        }
    }

    private static enum ColumnIndex {
        filter(0),
        format(1),
        expand(2),
        id(3),
        count(4),
        orderby(5),
        search(6),
        select(7),
        skip(8),
        skiptoken(9),
        levels(10),
        top(11);

        private int idx;

        private ColumnIndex(int i) {
            this.idx = i;
        }

        public int getIndex() {
            return this.idx;
        }
    }

    private static enum RowIndexForUriType {
        all(0),
        batch(1),
        crossjoin(2),
        entityId(3),
        metadata(4),
        resource(5),
        service(6),
        entitySet(7),
        entitySetCount(8),
        entity(9),
        mediaStream(10),
        references(11),
        reference(12),
        propertyComplex(13),
        propertyComplexCollection(14),
        propertyComplexCollectionCount(15),
        propertyPrimitive(16),
        propertyPrimitiveCollection(17),
        propertyPrimitiveCollectionCount(18),
        propertyPrimitiveValue(19);

        private int idx;

        private RowIndexForUriType(int i) {
            this.idx = i;
        }

        public int getIndex() {
            return this.idx;
        }
    }
}

