/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.util.Locale;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ClientServerError;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.ODataHandlerException;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.parser.UriParserSemanticException;
import org.apache.olingo.server.core.uri.parser.UriParserSyntaxException;
import org.apache.olingo.server.core.uri.validator.UriValidationException;

public class ODataExceptionHelper {
    public static ClientServerError createServerErrorObject(UriValidationException e, Locale requestedLocale) {
        ClientServerError serverError = ODataExceptionHelper.basicTranslatedError(e, requestedLocale);
        serverError.setStatusCode(HttpStatusCode.BAD_REQUEST.getStatusCode());
        return serverError;
    }

    public static ClientServerError createServerErrorObject(UriParserSemanticException e, Locale requestedLocale) {
        ClientServerError serverError = ODataExceptionHelper.basicTranslatedError(e, requestedLocale);
        if (UriParserSemanticException.MessageKeys.RESOURCE_NOT_FOUND.equals(e.getMessageKey()) || UriParserSemanticException.MessageKeys.PROPERTY_NOT_IN_TYPE.equals(e.getMessageKey())) {
            serverError.setStatusCode(HttpStatusCode.NOT_FOUND.getStatusCode());
        } else {
            serverError.setStatusCode(HttpStatusCode.BAD_REQUEST.getStatusCode());
        }
        return serverError;
    }

    public static ClientServerError createServerErrorObject(UriParserSyntaxException e, Locale requestedLocale) {
        ClientServerError serverError = ODataExceptionHelper.basicTranslatedError(e, requestedLocale);
        serverError.setStatusCode(UriParserSyntaxException.MessageKeys.WRONG_VALUE_FOR_SYSTEM_QUERY_OPTION_FORMAT.equals(e.getMessageKey()) ? HttpStatusCode.NOT_ACCEPTABLE.getStatusCode() : HttpStatusCode.BAD_REQUEST.getStatusCode());
        return serverError;
    }

    public static ClientServerError createServerErrorObject(UriParserException e, Locale requestedLocale) {
        ClientServerError serverError = ODataExceptionHelper.basicTranslatedError(e, requestedLocale);
        serverError.setStatusCode(HttpStatusCode.BAD_REQUEST.getStatusCode());
        return serverError;
    }

    public static ClientServerError createServerErrorObject(ContentNegotiatorException e, Locale requestedLocale) {
        ClientServerError serverError = ODataExceptionHelper.basicTranslatedError(e, requestedLocale);
        serverError.setStatusCode(HttpStatusCode.NOT_ACCEPTABLE.getStatusCode());
        return serverError;
    }

    public static ClientServerError createServerErrorObject(ODataHandlerException e, Locale requestedLocale) {
        ClientServerError serverError = ODataExceptionHelper.basicTranslatedError(e, requestedLocale);
        if (ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED.equals(e.getMessageKey()) || ODataHandlerException.MessageKeys.PROCESSOR_NOT_IMPLEMENTED.equals(e.getMessageKey())) {
            serverError.setStatusCode(HttpStatusCode.NOT_IMPLEMENTED.getStatusCode());
        } else if (ODataHandlerException.MessageKeys.ODATA_VERSION_NOT_SUPPORTED.equals(e.getMessageKey()) || ODataHandlerException.MessageKeys.INVALID_HTTP_METHOD.equals(e.getMessageKey()) || ODataHandlerException.MessageKeys.AMBIGUOUS_XHTTP_METHOD.equals(e.getMessageKey())) {
            serverError.setStatusCode(HttpStatusCode.BAD_REQUEST.getStatusCode());
        } else if (ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED.equals(e.getMessageKey())) {
            serverError.setStatusCode(HttpStatusCode.METHOD_NOT_ALLOWED.getStatusCode());
        }
        return serverError;
    }

    public static ClientServerError createServerErrorObject(SerializerException e, Locale requestedLocale) {
        ClientServerError serverError = ODataExceptionHelper.basicTranslatedError((ODataTranslatedException)e, requestedLocale);
        serverError.setStatusCode(HttpStatusCode.BAD_REQUEST.getStatusCode());
        return serverError;
    }

    public static ClientServerError createServerErrorObject(DeserializerException e, Locale requestedLocale) {
        return ODataExceptionHelper.basicTranslatedError((ODataTranslatedException)e, requestedLocale).setStatusCode(HttpStatusCode.BAD_REQUEST.getStatusCode());
    }

    public static ClientServerError createServerErrorObject(ODataTranslatedException e, Locale requestedLocale) {
        return ODataExceptionHelper.basicTranslatedError(e, requestedLocale);
    }

    public static ClientServerError createServerErrorObject(ODataApplicationException e) {
        ClientServerError serverError = ODataExceptionHelper.basicServerError((Exception)e);
        serverError.setStatusCode(e.getStatusCode());
        serverError.setLocale(e.getLocale());
        serverError.setCode(e.getODataErrorCode());
        return serverError;
    }

    public static ClientServerError createServerErrorObject(Exception e) {
        ClientServerError serverError = ODataExceptionHelper.basicServerError(e);
        serverError.setStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        serverError.setLocale(Locale.ENGLISH);
        return serverError;
    }

    private static ClientServerError basicServerError(Exception e) {
        return new ClientServerError().setException(e).setMessage(e.getMessage());
    }

    private static ClientServerError basicTranslatedError(ODataTranslatedException e, Locale requestedLocale) {
        ClientServerError serverError = ODataExceptionHelper.basicServerError((Exception)e);
        ODataTranslatedException.ODataErrorMessage translatedMessage = e.getTranslatedMessage(requestedLocale);
        serverError.setMessage(translatedMessage.getMessage());
        serverError.setLocale(translatedMessage.getLocale());
        serverError.setStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        return serverError;
    }
}

