/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.batch.exception.BatchDeserializerException;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.deserializer.FixedFormatDeserializer;
import org.apache.olingo.server.api.deserializer.batch.BatchOptions;
import org.apache.olingo.server.api.deserializer.batch.BatchRequestPart;
import org.apache.olingo.server.core.deserializer.batch.BatchParser;

public class FixedFormatDeserializerImpl
implements FixedFormatDeserializer {
    public byte[] binary(InputStream content) throws DeserializerException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[128];
        try {
            int count;
            while ((count = content.read(buffer)) > -1) {
                result.write(buffer, 0, count);
            }
            result.flush();
        }
        catch (IOException e) {
            throw new DeserializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        return result.toByteArray();
    }

    public List<BatchRequestPart> parseBatchRequest(InputStream content, String boundary, BatchOptions options) throws BatchDeserializerException {
        BatchParser parser = new BatchParser();
        return parser.parseBatchRequest(content, boundary, options);
    }
}

