/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer.batch;

import java.util.List;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.batch.exception.BatchDeserializerException;
import org.apache.olingo.server.core.deserializer.batch.BatchParserCommon;
import org.apache.olingo.server.core.deserializer.batch.BatchPart;
import org.apache.olingo.server.core.deserializer.batch.Header;
import org.apache.olingo.server.core.deserializer.batch.Line;

public class BatchQueryOperation
implements BatchPart {
    protected final boolean isStrict;
    protected Line httpStatusLine;
    protected Header headers;
    protected List<Line> body;
    protected int bodySize;
    protected List<Line> message;

    public BatchQueryOperation(List<Line> message, boolean isStrict) {
        this.isStrict = isStrict;
        this.message = message;
    }

    public BatchQueryOperation parse() throws BatchDeserializerException {
        this.httpStatusLine = this.consumeHttpStatusLine(this.message);
        this.headers = BatchParserCommon.consumeHeaders(this.message);
        BatchParserCommon.consumeBlankLine(this.message, this.isStrict);
        this.body = this.message;
        return this;
    }

    protected Line consumeHttpStatusLine(List<Line> message) throws BatchDeserializerException {
        if (message.size() > 0 && !message.get(0).toString().trim().equals("")) {
            Line method = message.get(0);
            message.remove(0);
            return method;
        }
        int line = message.size() > 0 ? message.get(0).getLineNumber() : 0;
        throw new BatchDeserializerException("Missing http request line", (ODataTranslatedException.MessageKey)BatchDeserializerException.MessageKeys.INVALID_STATUS_LINE, new String[]{"" + line});
    }

    public Line getHttpStatusLine() {
        return this.httpStatusLine;
    }

    public List<Line> getBody() {
        return this.body;
    }

    public int getBodySize() {
        return this.bodySize;
    }

    @Override
    public Header getHeaders() {
        return this.headers;
    }

    @Override
    public boolean isStrict() {
        return this.isStrict;
    }
}

