/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer.batch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.olingo.server.core.deserializer.batch.HeaderField;

public class Header
implements Iterable<HeaderField> {
    private final Map<String, HeaderField> headers = new HashMap<String, HeaderField>();
    private int lineNumber;

    public Header(int lineNumer) {
        this.lineNumber = lineNumer;
    }

    public void addHeader(String name, String value, int lineNumber) {
        HeaderField headerField = this.getHeaderFieldOrDefault(name, lineNumber);
        List<String> headerValues = headerField.getValues();
        if (!headerValues.contains(value)) {
            headerValues.add(value);
        }
    }

    public void addHeader(String name, List<String> values, int lineNumber) {
        HeaderField headerField = this.getHeaderFieldOrDefault(name, lineNumber);
        List<String> headerValues = headerField.getValues();
        for (String value : values) {
            if (headerValues.contains(value)) continue;
            headerValues.add(value);
        }
    }

    public void replaceHeaderField(HeaderField headerField) {
        this.headers.put(headerField.getFieldName().toLowerCase(Locale.ENGLISH), headerField);
    }

    public boolean exists(String name) {
        HeaderField field = this.headers.get(name.toLowerCase(Locale.ENGLISH));
        return field != null && field.getValues().size() != 0;
    }

    public boolean isHeaderMatching(String name, Pattern pattern) {
        if (this.getHeaders(name).size() != 1) {
            return false;
        }
        return pattern.matcher(this.getHeaders(name).get(0)).matches();
    }

    public void removeHeader(String name) {
        this.headers.remove(name.toLowerCase(Locale.ENGLISH));
    }

    public String getHeader(String name) {
        HeaderField headerField = this.getHeaderField(name);
        return headerField == null ? null : headerField.getValue();
    }

    public String getHeaderNotNull(String name) {
        HeaderField headerField = this.getHeaderField(name);
        return headerField == null ? "" : headerField.getValueNotNull();
    }

    public List<String> getHeaders(String name) {
        HeaderField headerField = this.getHeaderField(name);
        return headerField == null ? new ArrayList() : headerField.getValues();
    }

    public HeaderField getHeaderField(String name) {
        return this.headers.get(name.toLowerCase(Locale.ENGLISH));
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Map<String, String> toSingleMap() {
        HashMap<String, String> singleMap = new HashMap<String, String>();
        for (String key : this.headers.keySet()) {
            HeaderField field = this.headers.get(key);
            singleMap.put(field.getFieldName(), this.getHeader(key));
        }
        return singleMap;
    }

    public Map<String, List<String>> toMultiMap() {
        HashMap<String, List<String>> singleMap = new HashMap<String, List<String>>();
        for (String key : this.headers.keySet()) {
            HeaderField field = this.headers.get(key);
            singleMap.put(field.getFieldName(), field.getValues());
        }
        return singleMap;
    }

    private HeaderField getHeaderFieldOrDefault(String name, int lineNumber) {
        HeaderField headerField = this.headers.get(name.toLowerCase(Locale.ENGLISH));
        if (headerField == null) {
            headerField = new HeaderField(name, lineNumber);
            this.headers.put(name.toLowerCase(Locale.ENGLISH), headerField);
        }
        return headerField;
    }

    public Header clone() {
        Header newInstance = new Header(this.lineNumber);
        for (String key : this.headers.keySet()) {
            newInstance.headers.put(key, this.headers.get(key).clone());
        }
        return newInstance;
    }

    @Override
    public Iterator<HeaderField> iterator() {
        return new Iterator<HeaderField>(){
            Iterator<String> keyIterator;
            {
                this.keyIterator = Header.this.headers.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.keyIterator.hasNext();
            }

            @Override
            public HeaderField next() {
                return (HeaderField)Header.this.headers.get(this.keyIterator.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static List<String> splitValuesByComma(String headerValue) {
        String[] parts;
        ArrayList<String> singleValues = new ArrayList<String>();
        for (String value : parts = headerValue.split(",")) {
            singleValues.add(value.trim());
        }
        return singleValues;
    }
}

