/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Parameter;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmMapping;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.deserializer.DeserializerResult;
import org.apache.olingo.server.api.deserializer.ODataDeserializer;
import org.apache.olingo.server.core.deserializer.DeserializerResultImpl;
import org.apache.olingo.server.core.deserializer.helper.ExpandTreeBuilder;
import org.apache.olingo.server.core.deserializer.helper.ExpandTreeBuilderImpl;

public class ODataJsonDeserializer
implements ODataDeserializer {
    private static final String ODATA_ANNOTATION_MARKER = "@";
    private static final String ODATA_CONTROL_INFORMATION_PREFIX = "@odata.";

    public DeserializerResult entityCollection(InputStream stream, EdmEntityType edmEntityType) throws DeserializerException {
        try {
            ObjectNode tree = this.parseJsonTree(stream);
            return DeserializerResultImpl.with().entityCollection(this.consumeEntitySetNode(edmEntityType, tree, null)).build();
        }
        catch (JsonParseException e) {
            throw new DeserializerException("An JsonParseException occurred", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.JSON_SYNTAX_EXCEPTION, new String[0]);
        }
        catch (JsonMappingException e) {
            throw new DeserializerException("Duplicate json property detected", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.DUPLICATE_JSON_PROPERTY, new String[0]);
        }
        catch (IOException e) {
            throw new DeserializerException("An IOException occurred", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
    }

    private EntityCollection consumeEntitySetNode(EdmEntityType edmEntityType, ObjectNode tree, ExpandTreeBuilder expandBuilder) throws DeserializerException {
        EntityCollection entitySet = new EntityCollection();
        JsonNode jsonNode = tree.get("value");
        if (jsonNode != null) {
            if (!jsonNode.isArray()) {
                throw new DeserializerException("The content of the value tag must be an Array but is not. ", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.VALUE_TAG_MUST_BE_AN_ARRAY, new String[0]);
            }
        } else {
            throw new DeserializerException("Could not find value array.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.VALUE_ARRAY_NOT_PRESENT, new String[0]);
        }
        entitySet.getEntities().addAll(this.consumeEntitySetArray(edmEntityType, jsonNode, expandBuilder));
        tree.remove("value");
        ArrayList toRemove = new ArrayList();
        Iterator fieldsIterator = tree.fields();
        while (fieldsIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldsIterator.next();
            if (((String)field.getKey()).contains(ODATA_CONTROL_INFORMATION_PREFIX)) {
                toRemove.add(field.getKey());
                continue;
            }
            if (!((String)field.getKey()).contains(ODATA_ANNOTATION_MARKER)) continue;
            throw new DeserializerException("Custom annotation with field name: " + (String)field.getKey() + " not supported", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
        }
        tree.remove(toRemove);
        this.assertJsonNodeIsEmpty((JsonNode)tree);
        return entitySet;
    }

    private List<Entity> consumeEntitySetArray(EdmEntityType edmEntityType, JsonNode jsonNode, ExpandTreeBuilder expandBuilder) throws DeserializerException {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (JsonNode arrayElement : jsonNode) {
            if (arrayElement.isArray() || arrayElement.isValueNode()) {
                throw new DeserializerException("Nested Arrays and primitive values are not allowed for an entity value.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_ENTITY, new String[0]);
            }
            entities.add(this.consumeEntityNode(edmEntityType, (ObjectNode)arrayElement, expandBuilder));
        }
        return entities;
    }

    public DeserializerResult entity(InputStream stream, EdmEntityType edmEntityType) throws DeserializerException {
        try {
            ObjectNode tree = this.parseJsonTree(stream);
            ExpandTreeBuilderImpl expandBuilder = new ExpandTreeBuilderImpl();
            return DeserializerResultImpl.with().entity(this.consumeEntityNode(edmEntityType, tree, expandBuilder)).expandOption(expandBuilder.build()).build();
        }
        catch (JsonParseException e) {
            throw new DeserializerException("An JsonParseException occurred", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.JSON_SYNTAX_EXCEPTION, new String[0]);
        }
        catch (JsonMappingException e) {
            throw new DeserializerException("Duplicate property detected", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.DUPLICATE_PROPERTY, new String[0]);
        }
        catch (IOException e) {
            throw new DeserializerException("An IOException occurred", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
    }

    private Entity consumeEntityNode(EdmEntityType edmEntityType, ObjectNode tree, ExpandTreeBuilder expandBuilder) throws DeserializerException {
        Entity entity = new Entity();
        entity.setType(edmEntityType.getFullQualifiedName().getFullQualifiedNameAsString());
        this.consumeEntityProperties(edmEntityType, tree, entity);
        this.consumeExpandedNavigationProperties(edmEntityType, tree, entity, expandBuilder);
        this.consumeRemainingJsonNodeFields(edmEntityType, tree, entity);
        this.assertJsonNodeIsEmpty((JsonNode)tree);
        return entity;
    }

    public DeserializerResult actionParameters(InputStream stream, EdmAction edmAction) throws DeserializerException {
        try {
            ObjectNode tree = this.parseJsonTree(stream);
            LinkedHashMap<String, Parameter> parameters = new LinkedHashMap<String, Parameter>();
            if (tree != null) {
                this.consumeParameters(edmAction, tree, parameters);
                ArrayList toRemove = new ArrayList();
                Iterator fieldsIterator = tree.fields();
                while (fieldsIterator.hasNext()) {
                    Map.Entry field = (Map.Entry)fieldsIterator.next();
                    if (((String)field.getKey()).contains(ODATA_CONTROL_INFORMATION_PREFIX)) {
                        toRemove.add(field.getKey());
                        continue;
                    }
                    if (!((String)field.getKey()).contains(ODATA_ANNOTATION_MARKER)) continue;
                    throw new DeserializerException("Custom annotation with field name: " + (String)field.getKey() + " not supported", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
                }
                tree.remove(toRemove);
                this.assertJsonNodeIsEmpty((JsonNode)tree);
            }
            return DeserializerResultImpl.with().actionParameters(parameters).build();
        }
        catch (JsonParseException e) {
            throw new DeserializerException("An JsonParseException occurred", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.JSON_SYNTAX_EXCEPTION, new String[0]);
        }
        catch (JsonMappingException e) {
            throw new DeserializerException("Duplicate property detected", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.DUPLICATE_PROPERTY, new String[0]);
        }
        catch (IOException e) {
            throw new DeserializerException("An IOException occurred", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
    }

    private ObjectNode parseJsonTree(InputStream stream) throws IOException, JsonParseException, JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY, true);
        JsonParser parser = new JsonFactory((ObjectCodec)objectMapper).createParser(stream);
        ObjectNode tree = (ObjectNode)parser.getCodec().readTree(parser);
        return tree;
    }

    private void consumeParameters(EdmAction edmAction, ObjectNode node, Map<String, Parameter> parameters) throws DeserializerException {
        List parameterNames = edmAction.getParameterNames();
        if (edmAction.isBound()) {
            parameterNames = parameterNames.subList(1, parameterNames.size());
        }
        block4: for (String paramName : parameterNames) {
            EdmParameter edmParameter = edmAction.getParameter(paramName);
            Parameter parameter = new Parameter();
            parameter.setName(paramName);
            JsonNode jsonNode = node.get(paramName);
            switch (edmParameter.getType().getKind()) {
                case PRIMITIVE: 
                case DEFINITION: 
                case ENUM: {
                    if (jsonNode == null || jsonNode.isNull()) {
                        if (!edmParameter.isNullable()) {
                            throw new DeserializerException("Non-nullable parameter not present or null", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PARAMETER, new String[]{paramName});
                        }
                        if (edmParameter.isCollection()) {
                            throw new DeserializerException("Collection must not be null for parameter: " + paramName, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PARAMETER, new String[]{paramName});
                        }
                        parameter.setValue(ValueType.PRIMITIVE, null);
                        continue block4;
                    }
                    Property consumePropertyNode = this.consumePropertyNode(edmParameter.getName(), edmParameter.getType(), edmParameter.isCollection(), edmParameter.isNullable(), edmParameter.getMaxLength(), edmParameter.getPrecision(), edmParameter.getScale(), true, edmParameter.getMapping(), jsonNode);
                    parameter.setValue(consumePropertyNode.getValueType(), consumePropertyNode.getValue());
                    parameters.put(paramName, parameter);
                    node.remove(paramName);
                    continue block4;
                }
                case COMPLEX: 
                case ENTITY: {
                    throw new DeserializerException("Entity an complex parameters currently not Implemented", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
                }
            }
            throw new DeserializerException("Invalid type kind " + edmParameter.getType().getKind().toString() + " for action parameter: " + paramName, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_ACTION_PARAMETER_TYPE, new String[]{paramName});
        }
    }

    private void consumeRemainingJsonNodeFields(EdmEntityType edmEntityType, ObjectNode node, Entity entity) throws DeserializerException {
        ArrayList toRemove = new ArrayList();
        Iterator fieldsIterator = node.fields();
        while (fieldsIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldsIterator.next();
            if (((String)field.getKey()).contains("@odata.bind")) {
                Link bindingLink = this.consumeBindingLink((String)field.getKey(), (JsonNode)field.getValue(), edmEntityType);
                entity.getNavigationBindings().add(bindingLink);
                toRemove.add(field.getKey());
                continue;
            }
            if (((String)field.getKey()).contains(ODATA_CONTROL_INFORMATION_PREFIX)) {
                toRemove.add(field.getKey());
                continue;
            }
            if (!((String)field.getKey()).contains(ODATA_ANNOTATION_MARKER)) continue;
            throw new DeserializerException("Custom annotation with field name: " + (String)field.getKey() + " not supported", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
        }
        node.remove(toRemove);
    }

    private void consumeEntityProperties(EdmEntityType edmEntityType, ObjectNode node, Entity entity) throws DeserializerException {
        List propertyNames = edmEntityType.getPropertyNames();
        for (String propertyName : propertyNames) {
            JsonNode jsonNode = node.get(propertyName);
            if (jsonNode == null) continue;
            EdmProperty edmProperty = (EdmProperty)edmEntityType.getProperty(propertyName);
            if (jsonNode.isNull() && !edmProperty.isNullable()) {
                throw new DeserializerException("Property: " + propertyName + " must not be null.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PROPERTY, new String[]{propertyName});
            }
            Property property = this.consumePropertyNode(edmProperty.getName(), edmProperty.getType(), edmProperty.isCollection(), edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), edmProperty.getMapping(), jsonNode);
            entity.addProperty(property);
            node.remove(propertyName);
        }
    }

    private void consumeExpandedNavigationProperties(EdmEntityType edmEntityType, ObjectNode node, Entity entity, ExpandTreeBuilder expandBuilder) throws DeserializerException {
        List navigationPropertyNames = edmEntityType.getNavigationPropertyNames();
        for (String navigationPropertyName : navigationPropertyNames) {
            ExpandTreeBuilder childExpandBuilder;
            JsonNode jsonNode = node.get(navigationPropertyName);
            if (jsonNode == null) continue;
            EdmNavigationProperty edmNavigationProperty = edmEntityType.getNavigationProperty(navigationPropertyName);
            boolean isNullable = edmNavigationProperty.isNullable();
            if (jsonNode.isNull() && !isNullable || jsonNode.isNull() && edmNavigationProperty.isCollection()) {
                throw new DeserializerException("Property: " + navigationPropertyName + " must not be null.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PROPERTY, new String[]{navigationPropertyName});
            }
            Link link = new Link();
            link.setTitle(navigationPropertyName);
            ExpandTreeBuilder expandTreeBuilder = childExpandBuilder = expandBuilder != null ? expandBuilder.expand(edmNavigationProperty) : null;
            if (jsonNode.isArray() && edmNavigationProperty.isCollection()) {
                link.setType(Constants.ENTITY_SET_NAVIGATION_LINK_TYPE);
                EntityCollection inlineEntitySet = new EntityCollection();
                inlineEntitySet.getEntities().addAll(this.consumeEntitySetArray(edmNavigationProperty.getType(), jsonNode, childExpandBuilder));
                link.setInlineEntitySet(inlineEntitySet);
            } else if (!(jsonNode.isArray() || jsonNode.isValueNode() && !jsonNode.isNull() || edmNavigationProperty.isCollection())) {
                link.setType(Constants.ENTITY_NAVIGATION_LINK_TYPE);
                if (!jsonNode.isNull()) {
                    Entity inlineEntity = this.consumeEntityNode(edmNavigationProperty.getType(), (ObjectNode)jsonNode, childExpandBuilder);
                    link.setInlineEntity(inlineEntity);
                }
            } else {
                throw new DeserializerException("Invalid value: " + jsonNode.getNodeType() + " for expanded navigation property: " + navigationPropertyName, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_NAVIGATION_PROPERTY, new String[]{navigationPropertyName});
            }
            entity.getNavigationLinks().add(link);
            node.remove(navigationPropertyName);
        }
    }

    private Link consumeBindingLink(String key, JsonNode jsonNode, EdmEntityType edmEntityType) throws DeserializerException {
        String[] splitKey = key.split(ODATA_ANNOTATION_MARKER);
        String navigationPropertyName = splitKey[0];
        EdmNavigationProperty edmNavigationProperty = edmEntityType.getNavigationProperty(navigationPropertyName);
        if (edmNavigationProperty == null) {
            throw new DeserializerException("Invalid navigationPropertyName: " + navigationPropertyName, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.NAVIGATION_PROPERTY_NOT_FOUND, new String[]{navigationPropertyName});
        }
        Link bindingLink = new Link();
        bindingLink.setTitle(navigationPropertyName);
        if (edmNavigationProperty.isCollection()) {
            this.assertIsNullNode(key, jsonNode);
            if (!jsonNode.isArray()) {
                throw new DeserializerException("Binding annotation: " + key + " must be an array.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_ANNOTATION_TYPE, new String[]{key});
            }
            ArrayList<String> bindingLinkStrings = new ArrayList<String>();
            for (JsonNode arrayValue : jsonNode) {
                this.assertIsNullNode(key, arrayValue);
                if (!arrayValue.isTextual()) {
                    throw new DeserializerException("Binding annotation: " + key + " must have string valued array.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_ANNOTATION_TYPE, new String[]{key});
                }
                bindingLinkStrings.add(arrayValue.asText());
            }
            bindingLink.setType(Constants.ENTITY_COLLECTION_BINDING_LINK_TYPE);
            bindingLink.setBindingLinks(bindingLinkStrings);
        } else {
            this.assertIsNullNode(key, jsonNode);
            if (!jsonNode.isValueNode()) {
                throw new DeserializerException("Binding annotation: " + key + " must be a string value.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_ANNOTATION_TYPE, new String[]{key});
            }
            bindingLink.setBindingLink(jsonNode.asText());
            bindingLink.setType(Constants.ENTITY_BINDING_LINK_TYPE);
        }
        return bindingLink;
    }

    private void assertIsNullNode(String key, JsonNode jsonNode) throws DeserializerException {
        if (jsonNode.isNull()) {
            throw new DeserializerException("Annotation: " + key + "must not have a null value.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_ANNOTATION, new String[]{key});
        }
    }

    private Property consumePropertyNode(String name, EdmType type, boolean isCollection, boolean isNullable, Integer maxLength, Integer precision, Integer scale, boolean isUnicode, EdmMapping mapping, JsonNode jsonNode) throws DeserializerException {
        Property property = new Property();
        property.setName(name);
        property.setType(type.getFullQualifiedName().getFullQualifiedNameAsString());
        if (isCollection) {
            this.consumePropertyCollectionNode(name, type, isNullable, maxLength, precision, scale, isUnicode, mapping, jsonNode, property);
        } else {
            this.consumePropertySingleNode(name, type, isNullable, maxLength, precision, scale, isUnicode, mapping, jsonNode, property);
        }
        return property;
    }

    private void consumePropertySingleNode(String name, EdmType type, boolean isNullable, Integer maxLength, Integer precision, Integer scale, boolean isUnicode, EdmMapping mapping, JsonNode jsonNode, Property property) throws DeserializerException {
        switch (type.getKind()) {
            case PRIMITIVE: {
                Object value = this.readPrimitiveValue(name, type, isNullable, maxLength, precision, scale, isUnicode, mapping, jsonNode);
                property.setValue(ValueType.PRIMITIVE, value);
                break;
            }
            case DEFINITION: {
                Object value = this.readTypeDefinitionValue(name, type, isNullable, mapping, jsonNode);
                property.setValue(ValueType.PRIMITIVE, value);
                break;
            }
            case ENUM: {
                Object value = this.readEnumValue(name, type, isNullable, maxLength, precision, scale, isUnicode, mapping, jsonNode);
                property.setValue(ValueType.ENUM, value);
                break;
            }
            case COMPLEX: {
                Object value = this.readComplexNode(name, type, isNullable, jsonNode);
                property.setValue(ValueType.COMPLEX, value);
                break;
            }
            default: {
                throw new DeserializerException("Invalid Type Kind for a property found: " + type.getKind(), (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_JSON_TYPE_FOR_PROPERTY, new String[]{name});
            }
        }
    }

    private Object readComplexNode(String name, EdmType type, boolean isNullable, JsonNode jsonNode) throws DeserializerException {
        ComplexValue value = this.readComplexValue(name, type, isNullable, jsonNode);
        ArrayList toRemove = new ArrayList();
        Iterator fieldsIterator = jsonNode.fields();
        while (fieldsIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldsIterator.next();
            if (((String)field.getKey()).contains(ODATA_CONTROL_INFORMATION_PREFIX)) {
                toRemove.add(field.getKey());
                continue;
            }
            if (!((String)field.getKey()).contains(ODATA_ANNOTATION_MARKER)) continue;
            throw new DeserializerException("Custom annotation with field name: " + (String)field.getKey() + " not supported", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
        }
        if (!jsonNode.isNull()) {
            ((ObjectNode)jsonNode).remove(toRemove);
        }
        this.assertJsonNodeIsEmpty(jsonNode);
        return value;
    }

    private void consumePropertyCollectionNode(String name, EdmType type, boolean isNullable, Integer maxLength, Integer precision, Integer scale, boolean isUnicode, EdmMapping mapping, JsonNode jsonNode, Property property) throws DeserializerException {
        if (!jsonNode.isArray()) {
            throw new DeserializerException("Value for property: " + name + " must be an array but is not.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_JSON_TYPE_FOR_PROPERTY, new String[]{name});
        }
        ArrayList<Object> valueArray = new ArrayList<Object>();
        Iterator iterator = jsonNode.iterator();
        switch (type.getKind()) {
            case PRIMITIVE: {
                while (iterator.hasNext()) {
                    JsonNode arrayElement = (JsonNode)iterator.next();
                    Object value = this.readPrimitiveValue(name, type, isNullable, maxLength, precision, scale, isUnicode, mapping, arrayElement);
                    valueArray.add(value);
                }
                property.setValue(ValueType.COLLECTION_PRIMITIVE, valueArray);
                break;
            }
            case DEFINITION: {
                while (iterator.hasNext()) {
                    JsonNode arrayElement = (JsonNode)iterator.next();
                    Object value = this.readTypeDefinitionValue(name, type, isNullable, mapping, arrayElement);
                    valueArray.add(value);
                }
                property.setValue(ValueType.COLLECTION_PRIMITIVE, valueArray);
                break;
            }
            case ENUM: {
                while (iterator.hasNext()) {
                    JsonNode arrayElement = (JsonNode)iterator.next();
                    Object value = this.readEnumValue(name, type, isNullable, maxLength, precision, scale, isUnicode, mapping, arrayElement);
                    valueArray.add(value);
                }
                property.setValue(ValueType.COLLECTION_ENUM, valueArray);
                break;
            }
            case COMPLEX: {
                while (iterator.hasNext()) {
                    Object value = this.readComplexNode(name, type, isNullable, (JsonNode)iterator.next());
                    valueArray.add(value);
                }
                property.setValue(ValueType.COLLECTION_COMPLEX, valueArray);
                break;
            }
            default: {
                throw new DeserializerException("Invalid Type Kind for a property found: " + type.getKind(), (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_JSON_TYPE_FOR_PROPERTY, new String[]{name});
            }
        }
    }

    private ComplexValue readComplexValue(String name, EdmType type, boolean isNullable, JsonNode jsonNode) throws DeserializerException {
        if (this.isValidNull(name, isNullable, jsonNode)) {
            return null;
        }
        if (jsonNode.isArray() || !jsonNode.isContainerNode()) {
            throw new DeserializerException("Invalid value for property: " + name + " must not be an array or primitive value.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_JSON_TYPE_FOR_PROPERTY, new String[]{name});
        }
        ComplexValue complexValue = new ComplexValue();
        EdmComplexType edmType = (EdmComplexType)type;
        for (String propertyName : edmType.getPropertyNames()) {
            JsonNode subNode = jsonNode.get(propertyName);
            if (subNode == null) continue;
            EdmProperty edmProperty = (EdmProperty)edmType.getProperty(propertyName);
            if (subNode.isNull() && !edmProperty.isNullable()) {
                throw new DeserializerException("Property: " + propertyName + " must not be null.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PROPERTY, new String[]{propertyName});
            }
            Property property = this.consumePropertyNode(edmProperty.getName(), edmProperty.getType(), edmProperty.isCollection(), edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), edmProperty.getMapping(), subNode);
            complexValue.getValue().add(property);
            ((ObjectNode)jsonNode).remove(propertyName);
        }
        return complexValue;
    }

    private Object readTypeDefinitionValue(String name, EdmType type, boolean isNullable, EdmMapping mapping, JsonNode jsonNode) throws DeserializerException {
        this.checkForValueNode(name, jsonNode);
        if (this.isValidNull(name, isNullable, jsonNode)) {
            return null;
        }
        try {
            EdmTypeDefinition edmTypeDefinition = (EdmTypeDefinition)type;
            this.checkJsonTypeBasedOnPrimitiveType(name, edmTypeDefinition.getUnderlyingType().getName(), jsonNode);
            Class<?> javaClass = this.getJavaClassForPrimitiveType(mapping, edmTypeDefinition.getUnderlyingType());
            return edmTypeDefinition.valueOfString(jsonNode.asText(), Boolean.valueOf(isNullable), edmTypeDefinition.getMaxLength(), edmTypeDefinition.getPrecision(), edmTypeDefinition.getScale(), edmTypeDefinition.isUnicode(), javaClass);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new DeserializerException("Invalid value: " + jsonNode.asText() + " for property: " + name, (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{name});
        }
    }

    private boolean isValidNull(String name, boolean isNullable, JsonNode jsonNode) throws DeserializerException {
        if (jsonNode.isNull()) {
            if (isNullable) {
                return true;
            }
            throw new DeserializerException("Property: " + name + " must not be null.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PROPERTY, new String[]{name});
        }
        return false;
    }

    private Object readEnumValue(String name, EdmType type, boolean isNullable, Integer maxLength, Integer precision, Integer scale, boolean isUnicode, EdmMapping mapping, JsonNode jsonNode) throws DeserializerException {
        this.checkForValueNode(name, jsonNode);
        if (this.isValidNull(name, isNullable, jsonNode)) {
            return null;
        }
        try {
            EdmEnumType edmEnumType = (EdmEnumType)type;
            if (!jsonNode.isTextual()) {
                throw new DeserializerException("Invalid json type: " + jsonNode.getNodeType() + " for enum property: " + name, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{name});
            }
            Class<?> javaClass = this.getJavaClassForPrimitiveType(mapping, edmEnumType.getUnderlyingType());
            return edmEnumType.valueOfString(jsonNode.asText(), Boolean.valueOf(isNullable), maxLength, precision, scale, Boolean.valueOf(isUnicode), javaClass);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new DeserializerException("Invalid value: " + jsonNode.asText() + " for property: " + name, (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{name});
        }
    }

    private Object readPrimitiveValue(String name, EdmType type, boolean isNullable, Integer maxLength, Integer precision, Integer scale, boolean isUnicode, EdmMapping mapping, JsonNode jsonNode) throws DeserializerException {
        this.checkForValueNode(name, jsonNode);
        if (this.isValidNull(name, isNullable, jsonNode)) {
            return null;
        }
        try {
            EdmPrimitiveType edmPrimitiveType = (EdmPrimitiveType)type;
            this.checkJsonTypeBasedOnPrimitiveType(name, edmPrimitiveType.getName(), jsonNode);
            Class<?> javaClass = this.getJavaClassForPrimitiveType(mapping, edmPrimitiveType);
            return edmPrimitiveType.valueOfString(jsonNode.asText(), Boolean.valueOf(isNullable), maxLength, precision, scale, Boolean.valueOf(isUnicode), javaClass);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new DeserializerException("Invalid value: " + jsonNode.asText() + " for property: " + name, (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{name});
        }
    }

    private Class<?> getJavaClassForPrimitiveType(EdmMapping mapping, EdmPrimitiveType edmPrimitiveType) {
        return mapping == null || mapping.getMappedJavaClass() == null ? edmPrimitiveType.getDefaultType() : mapping.getMappedJavaClass();
    }

    private void checkForValueNode(String name, JsonNode jsonNode) throws DeserializerException {
        if (!jsonNode.isValueNode()) {
            throw new DeserializerException("Invalid value for property: " + name + " must not be an object or array.", (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_JSON_TYPE_FOR_PROPERTY, new String[]{name});
        }
    }

    private void assertJsonNodeIsEmpty(JsonNode node) throws DeserializerException {
        if (node.size() != 0) {
            String unknownField = (String)node.fieldNames().next();
            throw new DeserializerException("Tree should be empty but still has content left: " + unknownField, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.UNKOWN_CONTENT, new String[]{unknownField});
        }
    }

    private void checkJsonTypeBasedOnPrimitiveType(String propertyName, String edmPrimitiveTypeName, JsonNode jsonNode) throws DeserializerException {
        EdmPrimitiveTypeKind primKind;
        try {
            primKind = EdmPrimitiveTypeKind.valueOf((String)edmPrimitiveTypeName);
        }
        catch (IllegalArgumentException e) {
            throw new DeserializerException("Unknown Primitive Type: " + edmPrimitiveTypeName, (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_PRIMITIVE_TYPE, new String[]{edmPrimitiveTypeName, propertyName});
        }
        switch (primKind) {
            case Boolean: {
                if (jsonNode.isBoolean()) break;
                throw new DeserializerException("Invalid json type: " + jsonNode.getNodeType() + " for edm " + primKind + " property: " + propertyName, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{propertyName});
            }
            case Int16: 
            case Int32: 
            case Int64: 
            case Byte: 
            case SByte: 
            case Single: 
            case Double: 
            case Decimal: {
                if (jsonNode.isNumber()) break;
                throw new DeserializerException("Invalid json type: " + jsonNode.getNodeType() + " for edm " + primKind + " property: " + propertyName, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{propertyName});
            }
            case String: 
            case Binary: 
            case Date: 
            case DateTimeOffset: 
            case Duration: 
            case Guid: 
            case TimeOfDay: {
                if (jsonNode.isTextual()) break;
                throw new DeserializerException("Invalid json type: " + jsonNode.getNodeType() + " for edm " + primKind + " property: " + propertyName, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{propertyName});
            }
            default: {
                throw new DeserializerException("Unsupported Edm Primitive Type: " + primKind, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
            }
        }
    }

    public DeserializerResult property(InputStream stream, EdmProperty edmProperty) throws DeserializerException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY, true);
            JsonParser parser = new JsonFactory((ObjectCodec)objectMapper).createParser(stream);
            ObjectNode tree = (ObjectNode)parser.getCodec().readTree(parser);
            Property property = null;
            JsonNode jsonNode = tree.get("value");
            if (jsonNode != null) {
                property = this.consumePropertyNode(edmProperty.getName(), edmProperty.getType(), edmProperty.isCollection(), edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), edmProperty.getMapping(), jsonNode);
                tree.remove("value");
            } else {
                property = this.consumePropertyNode(edmProperty.getName(), edmProperty.getType(), edmProperty.isCollection(), edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), edmProperty.getMapping(), (JsonNode)tree);
            }
            return DeserializerResultImpl.with().property(property).build();
        }
        catch (JsonParseException e) {
            throw new DeserializerException("An JsonParseException occurred", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.JSON_SYNTAX_EXCEPTION, new String[0]);
        }
        catch (JsonMappingException e) {
            throw new DeserializerException("Duplicate property detected", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.DUPLICATE_PROPERTY, new String[0]);
        }
        catch (IOException e) {
            throw new DeserializerException("An IOException occurred", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
    }

    public DeserializerResult entityReferences(InputStream stream) throws DeserializerException {
        try {
            ArrayList<URI> parsedValues = new ArrayList<URI>();
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY, true);
            JsonParser parser = new JsonFactory((ObjectCodec)objectMapper).createParser(stream);
            ObjectNode tree = (ObjectNode)parser.getCodec().readTree(parser);
            String key = "@odata.id";
            JsonNode jsonNode = tree.get("value");
            if (jsonNode != null) {
                if (jsonNode.isArray()) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode;
                    Iterator it = arrayNode.iterator();
                    while (it.hasNext()) {
                        parsedValues.add(new URI(((JsonNode)it.next()).get("@odata.id").asText()));
                    }
                } else {
                    parsedValues.add(new URI(jsonNode.asText()));
                }
                tree.remove("value");
                return DeserializerResultImpl.with().entityReferences(parsedValues).build();
            }
            parsedValues.add(new URI(tree.get("@odata.id").asText()));
            return DeserializerResultImpl.with().entityReferences(parsedValues).build();
        }
        catch (JsonParseException e) {
            throw new DeserializerException("An JsonParseException occurred", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.JSON_SYNTAX_EXCEPTION, new String[0]);
        }
        catch (JsonMappingException e) {
            throw new DeserializerException("Duplicate property detected", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.DUPLICATE_PROPERTY, new String[0]);
        }
        catch (IOException e) {
            throw new DeserializerException("An IOException occurred", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        catch (URISyntaxException e) {
            throw new DeserializerException("failed to read @odata.id", (Throwable)e, (ODataTranslatedException.MessageKey)DeserializerException.MessageKeys.UNKOWN_CONTENT, new String[0]);
        }
    }
}

