/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.core.Encoder;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.core.serializer.utils.ExpandSelectHelper;

public final class ContextURLHelper {
    public static String buildSelectList(EdmStructuredType type, ExpandOption expand, SelectOption select) throws SerializerException {
        StringBuilder result = new StringBuilder();
        if (ExpandSelectHelper.hasSelect(select)) {
            ContextURLHelper.handleSelect(type, select, result);
        }
        if (ExpandSelectHelper.hasExpand(expand) && !ExpandSelectHelper.isExpandAll(expand)) {
            ContextURLHelper.handleExpand(type, expand, result);
        }
        return result.length() == 0 ? null : result.toString();
    }

    private static void handleSelect(EdmStructuredType type, SelectOption select, StringBuilder result) {
        if (ExpandSelectHelper.isAll(select)) {
            result.append('*');
        } else {
            List selectItems = select.getSelectItems();
            Set<String> selectedPropertyNames = ExpandSelectHelper.getSelectedPropertyNames(selectItems);
            for (String propertyName : type.getPropertyNames()) {
                if (!selectedPropertyNames.contains(propertyName)) continue;
                if (result.length() > 0) {
                    result.append(',');
                }
                EdmProperty edmProperty = type.getStructuralProperty(propertyName);
                Set<List<String>> selectedPaths = ExpandSelectHelper.getSelectedPaths(selectItems, propertyName);
                if (selectedPaths == null) {
                    result.append(Encoder.encode((String)propertyName));
                    continue;
                }
                List<List<String>> complexSelectedPaths = ContextURLHelper.getComplexSelectedPaths(edmProperty, selectedPaths);
                boolean first = true;
                for (List<String> path : complexSelectedPaths) {
                    if (first) {
                        first = false;
                    } else {
                        result.append(',');
                    }
                    boolean innerFirst = true;
                    for (String name : path) {
                        if (innerFirst) {
                            innerFirst = false;
                        } else {
                            result.append('/');
                        }
                        result.append(Encoder.encode((String)name));
                    }
                }
            }
        }
    }

    private static void handleExpand(EdmStructuredType type, ExpandOption expand, StringBuilder result) throws SerializerException {
        Set<String> expandedPropertyNames = ExpandSelectHelper.getExpandedPropertyNames(expand.getExpandItems());
        for (String propertyName : type.getNavigationPropertyNames()) {
            String innerSelectList;
            ExpandItem expandItem;
            if (!expandedPropertyNames.contains(propertyName) || (!ExpandSelectHelper.hasExpand((expandItem = ExpandSelectHelper.getExpandItem(expand.getExpandItems(), propertyName)).getExpandOption()) || ExpandSelectHelper.isExpandAll(expandItem.getExpandOption())) && !ExpandSelectHelper.hasSelect(expandItem.getSelectOption()) || (innerSelectList = ContextURLHelper.buildSelectList((EdmStructuredType)type.getNavigationProperty(propertyName).getType(), expandItem.getExpandOption(), expandItem.getSelectOption())) == null) continue;
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(Encoder.encode((String)propertyName)).append('(').append(innerSelectList).append(')');
        }
    }

    private static List<List<String>> getComplexSelectedPaths(EdmProperty edmProperty, Set<List<String>> selectedPaths) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        if (selectedPaths == null) {
            LinkedList<String> path = new LinkedList<String>();
            path.add(edmProperty.getName());
            result.add(path);
        } else {
            EdmComplexType type = (EdmComplexType)edmProperty.getType();
            for (String complexPropertyName : type.getPropertyNames()) {
                if (!ExpandSelectHelper.isSelected(selectedPaths, complexPropertyName)) continue;
                List<List<String>> complexSelectedPaths = ContextURLHelper.getComplexSelectedPaths((EdmProperty)type.getProperty(complexPropertyName), ExpandSelectHelper.getReducedSelectedPaths(selectedPaths, complexPropertyName));
                for (List<String> path : complexSelectedPaths) {
                    path.add(0, edmProperty.getName());
                    result.add(path);
                }
            }
        }
        return result;
    }

    public static String buildKeyPredicate(List<UriParameter> keys) throws SerializerException {
        if (keys == null || keys.isEmpty()) {
            return null;
        }
        if (keys.size() == 1) {
            return Encoder.encode((String)keys.get(0).getText());
        }
        StringBuilder result = new StringBuilder();
        for (UriParameter key : keys) {
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(Encoder.encode((String)key.getName())).append('=').append(Encoder.encode((String)key.getText()));
        }
        return result.toString();
    }
}

