/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.olingo.commons.api.format.AcceptType;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.serializer.CustomContentTypeSupport;
import org.apache.olingo.server.api.serializer.RepresentationType;
import org.apache.olingo.server.api.uri.queryoption.FormatOption;
import org.apache.olingo.server.core.ContentNegotiatorException;

public final class ContentNegotiator {
    private static final String ATOM = "atom";
    private static final String JSON = "json";
    private static final String XML = "xml";
    private static final List<ContentType> DEFAULT_SUPPORTED_CONTENT_TYPES = Collections.unmodifiableList(Arrays.asList(ContentType.JSON, ContentType.JSON_NO_METADATA, ContentType.APPLICATION_JSON, ContentType.APPLICATION_ATOM_XML, ContentType.APPLICATION_XML));

    private ContentNegotiator() {
    }

    private static List<ContentType> getDefaultSupportedContentTypes(RepresentationType type) {
        switch (type) {
            case METADATA: {
                return Collections.singletonList(ContentType.APPLICATION_XML);
            }
            case MEDIA: 
            case BINARY: {
                return Collections.singletonList(ContentType.APPLICATION_OCTET_STREAM);
            }
            case VALUE: 
            case COUNT: {
                return Collections.singletonList(ContentType.TEXT_PLAIN);
            }
            case BATCH: {
                return Collections.singletonList(ContentType.MULTIPART_MIXED);
            }
        }
        return DEFAULT_SUPPORTED_CONTENT_TYPES;
    }

    private static List<ContentType> getSupportedContentTypes(CustomContentTypeSupport customContentTypeSupport, RepresentationType representationType) throws ContentNegotiatorException {
        List result;
        List defaultSupportedContentTypes = ContentNegotiator.getDefaultSupportedContentTypes(representationType);
        List list = result = customContentTypeSupport == null ? defaultSupportedContentTypes : customContentTypeSupport.modifySupportedContentTypes(defaultSupportedContentTypes, representationType);
        if (result == null || result.isEmpty()) {
            throw new ContentNegotiatorException("No content type has been specified as supported.", ContentNegotiatorException.MessageKeys.NO_CONTENT_TYPE_SUPPORTED, new String[0]);
        }
        return result;
    }

    public static ContentType doContentNegotiation(FormatOption formatOption, ODataRequest request, CustomContentTypeSupport customContentTypeSupport, RepresentationType representationType) throws ContentNegotiatorException {
        List<ContentType> supportedContentTypes = ContentNegotiator.getSupportedContentTypes(customContentTypeSupport, representationType);
        String acceptHeaderValue = request.getHeader("Accept");
        ContentType result = null;
        if (formatOption != null && formatOption.getFormat() != null) {
            String formatString = formatOption.getFormat().trim();
            ContentType contentType = ContentNegotiator.mapContentType(formatString);
            try {
                result = ContentNegotiator.getAcceptedType(AcceptType.fromContentType((ContentType)(contentType == null ? ContentType.create((String)formatOption.getFormat()) : contentType)), supportedContentTypes);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (result == null) {
                throw new ContentNegotiatorException("Unsupported $format = " + formatString, ContentNegotiatorException.MessageKeys.UNSUPPORTED_FORMAT_OPTION, formatString);
            }
        } else if (acceptHeaderValue != null) {
            try {
                result = ContentNegotiator.getAcceptedType(AcceptType.create((String)acceptHeaderValue), supportedContentTypes);
            }
            catch (IllegalArgumentException e) {
                result = null;
            }
            if (result == null) {
                throw new ContentNegotiatorException("Unsupported or illegal Accept header value: " + acceptHeaderValue + " != " + supportedContentTypes, ContentNegotiatorException.MessageKeys.UNSUPPORTED_ACCEPT_TYPES, acceptHeaderValue);
            }
        } else {
            ContentType requestedContentType = ContentNegotiator.getDefaultSupportedContentTypes(representationType).get(0);
            result = ContentNegotiator.getAcceptedType(AcceptType.fromContentType((ContentType)requestedContentType), supportedContentTypes);
            if (result == null) {
                throw new ContentNegotiatorException("unsupported accept content type: " + requestedContentType + " != " + supportedContentTypes, ContentNegotiatorException.MessageKeys.UNSUPPORTED_CONTENT_TYPE, requestedContentType.toContentTypeString());
            }
        }
        return result;
    }

    private static ContentType mapContentType(String formatString) {
        return JSON.equalsIgnoreCase(formatString) ? ContentType.JSON : (XML.equalsIgnoreCase(formatString) ? ContentType.APPLICATION_XML : (ATOM.equalsIgnoreCase(formatString) ? ContentType.APPLICATION_ATOM_XML : null));
    }

    private static ContentType getAcceptedType(List<AcceptType> acceptedContentTypes, List<ContentType> supportedContentTypes) {
        for (AcceptType acceptedType : acceptedContentTypes) {
            Iterator<ContentType> i$ = supportedContentTypes.iterator();
            while (i$.hasNext()) {
                String ieee754compatibleValue;
                ContentType supportedContentType;
                ContentType contentType = supportedContentType = i$.next();
                String charSetValue = acceptedType.getParameter("charset");
                if (charSetValue != null) {
                    if ("utf8".equalsIgnoreCase(charSetValue) || "utf-8".equalsIgnoreCase(charSetValue)) {
                        contentType = ContentType.create((ContentType)contentType, (String)"charset", (String)"utf-8");
                    } else {
                        throw new IllegalArgumentException("charset not supported: " + acceptedType);
                    }
                }
                if ("true".equalsIgnoreCase(ieee754compatibleValue = acceptedType.getParameter("IEEE754Compatible"))) {
                    contentType = ContentType.create((ContentType)contentType, (String)"IEEE754Compatible", (String)"true");
                } else if ("false".equalsIgnoreCase(ieee754compatibleValue)) {
                    contentType = ContentType.create((ContentType)contentType, (String)"IEEE754Compatible", (String)"false");
                } else if (ieee754compatibleValue != null) {
                    throw new IllegalArgumentException("Invalid IEEE754Compatible value " + ieee754compatibleValue);
                }
                if (!acceptedType.matches(contentType)) continue;
                return contentType;
            }
        }
        return null;
    }

    public static void checkSupport(ContentType contentType, CustomContentTypeSupport customContentTypeSupport, RepresentationType representationType) throws ContentNegotiatorException {
        for (ContentType supportedContentType : ContentNegotiator.getSupportedContentTypes(customContentTypeSupport, representationType)) {
            if (!((AcceptType)AcceptType.fromContentType((ContentType)supportedContentType).get(0)).matches(contentType)) continue;
            return;
        }
        throw new ContentNegotiatorException("unsupported content type: " + contentType, ContentNegotiatorException.MessageKeys.UNSUPPORTED_CONTENT_TYPE, contentType.toContentTypeString());
    }

    public static boolean isSupported(ContentType contentType, CustomContentTypeSupport customContentTypeSupport, RepresentationType representationType) throws ContentNegotiatorException {
        for (ContentType supportedContentType : ContentNegotiator.getSupportedContentTypes(customContentTypeSupport, representationType)) {
            if (!((AcceptType)AcceptType.fromContentType((ContentType)supportedContentType).get(0)).matches(contentType)) continue;
            return true;
        }
        return false;
    }
}

