/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.debug;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.debug.DebugInformation;
import org.apache.olingo.server.api.debug.DebugSupport;
import org.apache.olingo.server.api.debug.RuntimeMeasurement;
import org.apache.olingo.server.api.uri.UriInfo;

public class ServerCoreDebugger {
    private final List<RuntimeMeasurement> runtimeInformation = new ArrayList<RuntimeMeasurement>();
    private final OData odata;
    private boolean isDebugMode = false;
    private DebugSupport debugSupport;
    private String debugFormat;

    public ServerCoreDebugger(OData odata) {
        this.odata = odata;
    }

    public void resolveDebugMode(HttpServletRequest request) {
        if (this.debugSupport != null) {
            this.debugFormat = request.getParameter("odata-debug");
            if (this.debugFormat != null) {
                this.debugSupport.init(this.odata);
                this.isDebugMode = this.debugSupport.isUserAuthorized();
            }
        }
    }

    public ODataResponse createDebugResponse(ODataRequest request, ODataResponse response, Exception exception, UriInfo uriInfo, Map<String, String> serverEnvironmentVariables) {
        if (!this.isDebugMode) {
            return response;
        }
        try {
            DebugInformation debugInfo = this.createDebugInformation(request, response, exception, uriInfo, serverEnvironmentVariables);
            return this.debugSupport.createDebugResponse(this.debugFormat, debugInfo);
        }
        catch (Exception e) {
            return this.createFailResponse();
        }
    }

    private ODataResponse createFailResponse() {
        ODataResponse odResponse = new ODataResponse();
        odResponse.setStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        odResponse.setHeader("Content-Type", ContentType.TEXT_PLAIN.toContentTypeString());
        ByteArrayInputStream content = new ByteArrayInputStream("ODataLibrary: Could not assemble debug response.".getBytes());
        odResponse.setContent((InputStream)content);
        return odResponse;
    }

    private DebugInformation createDebugInformation(ODataRequest request, ODataResponse response, Exception exception, UriInfo uriInfo, Map<String, String> serverEnvironmentVariables) {
        DebugInformation debugInfo = new DebugInformation();
        debugInfo.setRequest(request);
        debugInfo.setApplicationResponse(response);
        debugInfo.setException(exception);
        debugInfo.setServerEnvironmentVariables(serverEnvironmentVariables);
        debugInfo.setUriInfo(uriInfo);
        debugInfo.setRuntimeInformation(this.runtimeInformation);
        return debugInfo;
    }

    public int startRuntimeMeasurement(String className, String methodName) {
        if (this.isDebugMode) {
            int handleId = this.runtimeInformation.size();
            RuntimeMeasurement measurement = new RuntimeMeasurement();
            measurement.setTimeStarted(System.nanoTime());
            measurement.setClassName(className);
            measurement.setMethodName(methodName);
            this.runtimeInformation.add(measurement);
            return handleId;
        }
        return 0;
    }

    public void stopRuntimeMeasurement(int handle) {
        if (this.isDebugMode && handle < this.runtimeInformation.size()) {
            long stopTime = System.nanoTime();
            RuntimeMeasurement runtimeMeasurement = this.runtimeInformation.get(handle);
            if (runtimeMeasurement != null) {
                runtimeMeasurement.setTimeStopped(stopTime);
            }
        }
    }

    public void setDebugSupportProcessor(DebugSupport debugSupport) {
        this.debugSupport = debugSupport;
    }

    public boolean isDebugMode() {
        return this.isDebugMode;
    }
}

