/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.json;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.SerializerException;

public class ServiceDocumentJsonSerializer {
    public static final String KIND = "kind";
    public static final String FUNCTION_IMPORT = "FunctionImport";
    public static final String SINGLETON = "Singleton";
    public static final String SERVICE_DOCUMENT = "ServiceDocument";
    private final ServiceMetadata metadata;
    private final String serviceRoot;
    private final boolean isODataMetadataNone;

    public ServiceDocumentJsonSerializer(ServiceMetadata metadata, String serviceRoot, boolean isODataMetadataNone) throws SerializerException {
        if (metadata == null || metadata.getEdm() == null) {
            throw new SerializerException("Service Metadata and EDM must not be null for a service.", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.NULL_METADATA_OR_EDM, new String[0]);
        }
        this.metadata = metadata;
        this.serviceRoot = serviceRoot;
        this.isODataMetadataNone = isODataMetadataNone;
    }

    public void writeServiceDocument(JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        if (!this.isODataMetadataNone) {
            String metadataUri = (this.serviceRoot == null ? "" : (this.serviceRoot.endsWith("/") ? this.serviceRoot : this.serviceRoot + "/")) + "$metadata";
            gen.writeObjectField("@odata.context", (Object)metadataUri);
            if (this.metadata != null && this.metadata.getServiceMetadataETagSupport() != null && this.metadata.getServiceMetadataETagSupport().getMetadataETag() != null) {
                gen.writeStringField("@odata.metadataEtag", this.metadata.getServiceMetadataETagSupport().getMetadataETag());
            }
        }
        gen.writeArrayFieldStart("value");
        Edm edm = this.metadata.getEdm();
        this.writeEntitySets(gen, edm);
        this.writeFunctionImports(gen, edm);
        this.writeSingletons(gen, edm);
    }

    private void writeEntitySets(JsonGenerator gen, Edm edm) throws IOException {
        EdmEntityContainer container = edm.getEntityContainer(null);
        for (EdmEntitySet edmEntitySet : container.getEntitySets()) {
            if (!edmEntitySet.isIncludeInServiceDocument()) continue;
            gen.writeStartObject();
            gen.writeObjectField("name", (Object)edmEntitySet.getName());
            gen.writeObjectField("url", (Object)edmEntitySet.getName());
            gen.writeEndObject();
        }
    }

    private void writeFunctionImports(JsonGenerator gen, Edm edm) throws IOException {
        EdmEntityContainer container = edm.getEntityContainer(null);
        for (EdmFunctionImport edmFunctionImport : container.getFunctionImports()) {
            if (!edmFunctionImport.isIncludeInServiceDocument()) continue;
            gen.writeStartObject();
            gen.writeObjectField("name", (Object)edmFunctionImport.getName());
            gen.writeObjectField("url", (Object)edmFunctionImport.getName());
            gen.writeObjectField(KIND, (Object)FUNCTION_IMPORT);
            gen.writeEndObject();
        }
    }

    private void writeSingletons(JsonGenerator gen, Edm edm) throws IOException {
        EdmEntityContainer container = edm.getEntityContainer(null);
        for (EdmSingleton edmSingleton : container.getSingletons()) {
            gen.writeStartObject();
            gen.writeObjectField("name", (Object)edmSingleton.getName());
            gen.writeObjectField("url", (Object)edmSingleton.getName());
            gen.writeObjectField(KIND, (Object)SINGLETON);
            gen.writeEndObject();
        }
    }
}

