/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.olingo.server.core.deserializer.helper;

import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.server.core.uri.UriInfoImpl;
import org.apache.olingo.server.core.uri.UriResourceNavigationPropertyImpl;
import org.apache.olingo.server.core.uri.queryoption.ExpandItemImpl;

public abstract class ExpandTreeBuilder {
  public abstract ExpandTreeBuilder expand(EdmNavigationProperty edmNavigationProperty);

  protected ExpandItemImpl buildExpandItem(final EdmNavigationProperty edmNavigationProperty) {
    final ExpandItemImpl expandItem = new ExpandItemImpl();
    final UriInfoImpl uriInfo = new UriInfoImpl();
    final UriResourceNavigationPropertyImpl resourceNavigation = new UriResourceNavigationPropertyImpl();

    resourceNavigation.setNavigationProperty(edmNavigationProperty);
    uriInfo.addResourcePart(resourceNavigation);
    expandItem.setResourcePath(uriInfo);

    return expandItem;
  }
}