/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.xml;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.edmx.EdmxReference;
import org.apache.olingo.server.api.serializer.SerializerException;

public class ServiceDocumentXmlSerializer {
    private static final String APP = "app";
    private static final String NS_APP = "http://www.w3.org/2007/app";
    private static final String ATOM = "atom";
    private static final String NS_ATOM = "http://www.w3.org/2005/Atom";
    private static final String METADATA = "metadata";
    private static final String NS_METADATA = "http://docs.oasis-open.org/odata/ns/metadata";
    private final ServiceMetadata metadata;
    private final String serviceRoot;

    public ServiceDocumentXmlSerializer(ServiceMetadata metadata, String serviceRoot) throws SerializerException {
        if (metadata == null || metadata.getEdm() == null) {
            throw new SerializerException("Service Metadata and EDM must not be null for a service.", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.NULL_METADATA_OR_EDM, new String[0]);
        }
        this.metadata = metadata;
        this.serviceRoot = serviceRoot;
    }

    public void writeServiceDocument(XMLStreamWriter writer) throws XMLStreamException {
        String metadataUri = (this.serviceRoot == null ? "" : (this.serviceRoot.endsWith("/") ? this.serviceRoot : this.serviceRoot + "/")) + "$metadata";
        writer.writeStartDocument("UTF-8", "1.0");
        writer.writeStartElement(APP, "service", NS_APP);
        writer.writeNamespace(ATOM, NS_ATOM);
        writer.writeNamespace(APP, NS_APP);
        writer.writeNamespace(METADATA, NS_METADATA);
        writer.writeAttribute(METADATA, NS_METADATA, "context", metadataUri);
        if (this.metadata != null && this.metadata.getServiceMetadataETagSupport() != null && this.metadata.getServiceMetadataETagSupport().getMetadataETag() != null) {
            writer.writeAttribute(METADATA, NS_METADATA, "metadata-etag", this.metadata.getServiceMetadataETagSupport().getMetadataETag());
        }
        writer.writeStartElement(APP, "workspace", NS_APP);
        EdmEntityContainer container = this.metadata.getEdm().getEntityContainer();
        writer.writeStartElement(ATOM, "title", NS_ATOM);
        writer.writeCharacters(container.getFullQualifiedName().getFullQualifiedNameAsString());
        writer.writeEndElement();
        this.writeEntitySets(writer, container);
        this.writeFunctionImports(writer, container);
        this.writeSingletons(writer, container);
        this.writeServiceDocuments(writer);
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void writeServiceDocuments(XMLStreamWriter writer) throws XMLStreamException {
        for (EdmxReference reference : this.metadata.getReferences()) {
            String referenceString = reference.getUri().toASCIIString();
            this.writeElement(writer, false, "service-document", referenceString, referenceString);
        }
    }

    private void writeEntitySets(XMLStreamWriter writer, EdmEntityContainer container) throws XMLStreamException {
        for (EdmEntitySet edmEntitySet : container.getEntitySets()) {
            if (!edmEntitySet.isIncludeInServiceDocument()) continue;
            this.writeElement(writer, true, "collection", edmEntitySet.getName(), edmEntitySet.getTitle());
        }
    }

    private void writeFunctionImports(XMLStreamWriter writer, EdmEntityContainer container) throws XMLStreamException {
        for (EdmFunctionImport edmFunctionImport : container.getFunctionImports()) {
            if (!edmFunctionImport.isIncludeInServiceDocument()) continue;
            this.writeElement(writer, false, "function-import", edmFunctionImport.getName(), edmFunctionImport.getTitle());
        }
    }

    private void writeSingletons(XMLStreamWriter writer, EdmEntityContainer container) throws XMLStreamException {
        for (EdmSingleton edmSingleton : container.getSingletons()) {
            this.writeElement(writer, false, "singleton", edmSingleton.getName(), edmSingleton.getTitle());
        }
    }

    private void writeElement(XMLStreamWriter writer, boolean isApp, String kind, String name, String title) throws XMLStreamException {
        if (isApp) {
            writer.writeStartElement(APP, kind, NS_APP);
        } else {
            writer.writeStartElement(METADATA, kind, NS_METADATA);
        }
        writer.writeAttribute("href", name);
        writer.writeAttribute(METADATA, NS_METADATA, "name", name);
        writer.writeStartElement(ATOM, "title", NS_ATOM);
        if (title != null) {
            writer.writeCharacters(title);
        } else {
            writer.writeCharacters(name);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

