/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoAll;
import org.apache.olingo.server.api.uri.UriInfoBatch;
import org.apache.olingo.server.api.uri.UriInfoCrossjoin;
import org.apache.olingo.server.api.uri.UriInfoEntityId;
import org.apache.olingo.server.api.uri.UriInfoKind;
import org.apache.olingo.server.api.uri.UriInfoMetadata;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriInfoService;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.queryoption.AliasQueryOption;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.CustomQueryOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.FormatOption;
import org.apache.olingo.server.api.uri.queryoption.IdOption;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.QueryOption;
import org.apache.olingo.server.api.uri.queryoption.SearchOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.api.uri.queryoption.SkipOption;
import org.apache.olingo.server.api.uri.queryoption.SkipTokenOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOption;
import org.apache.olingo.server.api.uri.queryoption.SystemQueryOptionKind;
import org.apache.olingo.server.api.uri.queryoption.TopOption;

public class UriInfoImpl
implements UriInfo {
    private UriInfoKind kind;
    private List<String> entitySetNames = new ArrayList<String>();
    private EdmEntityType entityTypeCast;
    private UriResource lastResourcePart;
    private List<UriResource> pathParts = new ArrayList<UriResource>();
    private Map<SystemQueryOptionKind, SystemQueryOption> systemQueryOptions = new HashMap<SystemQueryOptionKind, SystemQueryOption>();
    private Map<String, AliasQueryOption> aliases = new HashMap<String, AliasQueryOption>();
    private List<CustomQueryOption> customQueryOptions = new ArrayList<CustomQueryOption>();
    private String fragment;

    public UriInfoImpl setKind(UriInfoKind kind) {
        this.kind = kind;
        return this;
    }

    public UriInfoKind getKind() {
        return this.kind;
    }

    public UriInfoAll asUriInfoAll() {
        return this;
    }

    public UriInfoBatch asUriInfoBatch() {
        return this;
    }

    public UriInfoCrossjoin asUriInfoCrossjoin() {
        return this;
    }

    public UriInfoEntityId asUriInfoEntityId() {
        return this;
    }

    public UriInfoService asUriInfoService() {
        return this;
    }

    public UriInfoMetadata asUriInfoMetadata() {
        return this;
    }

    public UriInfoResource asUriInfoResource() {
        return this;
    }

    public UriInfoImpl addEntitySetName(String entitySet) {
        this.entitySetNames.add(entitySet);
        return this;
    }

    public List<String> getEntitySetNames() {
        return Collections.unmodifiableList(this.entitySetNames);
    }

    public UriInfoImpl setEntityTypeCast(EdmEntityType type) {
        this.entityTypeCast = type;
        return this;
    }

    public EdmEntityType getEntityTypeCast() {
        return this.entityTypeCast;
    }

    public UriInfoImpl addResourcePart(UriResource uriPathInfo) {
        this.pathParts.add(uriPathInfo);
        this.lastResourcePart = uriPathInfo;
        return this;
    }

    public UriInfoImpl removeResourcePart(int index) {
        this.pathParts.remove(index);
        return this;
    }

    public UriResource getLastResourcePart() {
        return this.lastResourcePart;
    }

    public List<UriResource> getUriResourceParts() {
        return Collections.unmodifiableList(this.pathParts);
    }

    public UriInfoImpl setQueryOptions(List<QueryOption> list) {
        for (QueryOption item : list) {
            if (item instanceof SystemQueryOption) {
                this.setSystemQueryOption((SystemQueryOption)item);
                continue;
            }
            if (item instanceof AliasQueryOption) {
                this.addAlias((AliasQueryOption)item);
                continue;
            }
            if (!(item instanceof CustomQueryOption)) continue;
            this.addCustomQueryOption((CustomQueryOption)item);
        }
        return this;
    }

    public UriInfoImpl setSystemQueryOption(SystemQueryOption systemOption) {
        SystemQueryOptionKind kind = systemOption.getKind();
        if (this.systemQueryOptions.containsKey(kind)) {
            throw new ODataRuntimeException("Double System Query Option: " + systemOption.getName());
        }
        switch (kind) {
            case EXPAND: 
            case FILTER: 
            case FORMAT: 
            case ID: 
            case COUNT: 
            case ORDERBY: 
            case SEARCH: 
            case SELECT: 
            case SKIP: 
            case SKIPTOKEN: 
            case TOP: 
            case LEVELS: {
                this.systemQueryOptions.put(kind, systemOption);
                break;
            }
            default: {
                throw new ODataRuntimeException("Unsupported System Query Option: " + systemOption.getName());
            }
        }
        return this;
    }

    public ExpandOption getExpandOption() {
        return (ExpandOption)this.systemQueryOptions.get(SystemQueryOptionKind.EXPAND);
    }

    public FilterOption getFilterOption() {
        return (FilterOption)this.systemQueryOptions.get(SystemQueryOptionKind.FILTER);
    }

    public FormatOption getFormatOption() {
        return (FormatOption)this.systemQueryOptions.get(SystemQueryOptionKind.FORMAT);
    }

    public IdOption getIdOption() {
        return (IdOption)this.systemQueryOptions.get(SystemQueryOptionKind.ID);
    }

    public CountOption getCountOption() {
        return (CountOption)this.systemQueryOptions.get(SystemQueryOptionKind.COUNT);
    }

    public OrderByOption getOrderByOption() {
        return (OrderByOption)this.systemQueryOptions.get(SystemQueryOptionKind.ORDERBY);
    }

    public SearchOption getSearchOption() {
        return (SearchOption)this.systemQueryOptions.get(SystemQueryOptionKind.SEARCH);
    }

    public SelectOption getSelectOption() {
        return (SelectOption)this.systemQueryOptions.get(SystemQueryOptionKind.SELECT);
    }

    public SkipOption getSkipOption() {
        return (SkipOption)this.systemQueryOptions.get(SystemQueryOptionKind.SKIP);
    }

    public SkipTokenOption getSkipTokenOption() {
        return (SkipTokenOption)this.systemQueryOptions.get(SystemQueryOptionKind.SKIPTOKEN);
    }

    public TopOption getTopOption() {
        return (TopOption)this.systemQueryOptions.get(SystemQueryOptionKind.TOP);
    }

    public List<SystemQueryOption> getSystemQueryOptions() {
        return Collections.unmodifiableList(new ArrayList<SystemQueryOption>(this.systemQueryOptions.values()));
    }

    public UriInfoImpl addAlias(AliasQueryOption alias) {
        this.aliases.put(alias.getName(), alias);
        return this;
    }

    public String getValueForAlias(String alias) {
        AliasQueryOption aliasQueryOption = this.getAlias(alias);
        return aliasQueryOption == null ? null : aliasQueryOption.getText();
    }

    public AliasQueryOption getAlias(String key) {
        return this.aliases.get(key);
    }

    public List<AliasQueryOption> getAliases() {
        return Collections.unmodifiableList(new ArrayList<AliasQueryOption>(this.aliases.values()));
    }

    public UriInfoImpl addCustomQueryOption(CustomQueryOption item) {
        this.customQueryOptions.add(item);
        return this;
    }

    public List<CustomQueryOption> getCustomQueryOptions() {
        return Collections.unmodifiableList(this.customQueryOptions);
    }

    public UriInfoImpl setFragment(String fragment) {
        this.fragment = fragment;
        return this;
    }

    public String getFragment() {
        return this.fragment;
    }
}

