/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri;

import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.core.uri.UriResourceWithKeysImpl;

public class UriResourceFunctionImpl
extends UriResourceWithKeysImpl
implements UriResourceFunction {
    protected List<UriParameter> parameters;
    protected EdmFunction function;
    protected EdmFunctionImport functionImport;
    private boolean isParameterListFilled = false;

    public UriResourceFunctionImpl() {
        super(UriResourceKind.function);
    }

    public List<UriParameter> getParameters() {
        return this.parameters == null ? Collections.emptyList() : Collections.unmodifiableList(this.parameters);
    }

    public UriResourceFunctionImpl setParameters(List<UriParameter> parameters) {
        this.isParameterListFilled = true;
        this.parameters = parameters;
        return this;
    }

    public EdmFunction getFunction() {
        return this.function;
    }

    public UriResourceFunctionImpl setFunction(EdmFunction function) {
        this.function = function;
        return this;
    }

    public EdmFunctionImport getFunctionImport() {
        return this.functionImport;
    }

    public UriResourceFunctionImpl setFunctionImport(EdmFunctionImport edmFunctionImport, List<UriParameter> parameters) {
        this.functionImport = edmFunctionImport;
        this.setParameters(parameters);
        return this;
    }

    public EdmType getType() {
        return this.function.getReturnType().getType();
    }

    public boolean isCollection() {
        return this.keyPredicates == null && this.function.getReturnType().isCollection();
    }

    public String getSegmentValue() {
        if (this.functionImport != null) {
            return this.functionImport.getName();
        }
        if (this.function != null) {
            return this.function.getName();
        }
        return "";
    }

    public String toString() {
        return this.getSegmentValue();
    }

    public boolean isParameterListFilled() {
        return this.isParameterListFilled;
    }
}

