/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.commons.core.Decoder;
import org.apache.olingo.server.core.uri.parser.RawUri;
import org.apache.olingo.server.core.uri.parser.UriParserSyntaxException;

public class UriDecoder {
    public static RawUri decodeUri(String path, String query, String fragment, int skipSegments) throws UriParserSyntaxException {
        RawUri rawUri = new RawUri();
        rawUri.path = path;
        rawUri.queryOptionString = query;
        rawUri.fragment = fragment;
        rawUri.pathSegmentList = UriDecoder.splitPath(path, skipSegments);
        rawUri.queryOptionList = UriDecoder.splitOptions(query);
        UriDecoder.decode(rawUri);
        return rawUri;
    }

    private static void decode(RawUri rawUri) throws UriParserSyntaxException {
        rawUri.pathSegmentListDecoded = new ArrayList<String>();
        for (String segment : rawUri.pathSegmentList) {
            rawUri.pathSegmentListDecoded.add(UriDecoder.decode(segment));
        }
        rawUri.queryOptionListDecoded = new ArrayList<RawUri.QueryOption>();
        for (RawUri.QueryOption optionPair : rawUri.queryOptionList) {
            rawUri.queryOptionListDecoded.add(new RawUri.QueryOption(UriDecoder.decode(optionPair.name), UriDecoder.decode(optionPair.value)));
        }
    }

    private static List<RawUri.QueryOption> splitOptions(String queryOptionString) {
        if (queryOptionString == null) {
            return Collections.emptyList();
        }
        ArrayList<RawUri.QueryOption> queryOptionList = new ArrayList<RawUri.QueryOption>();
        for (String option : UriDecoder.splitSkipEmpty(queryOptionString, '&')) {
            List<String> pair = UriDecoder.splitFirst(option, '=');
            queryOptionList.add(new RawUri.QueryOption(pair.get(0), pair.get(1)));
        }
        return queryOptionList;
    }

    private static List<String> splitFirst(String input, char c) {
        int pos = input.indexOf(c, 0);
        if (pos >= 0) {
            return Arrays.asList(input.substring(0, pos), input.substring(pos + 1));
        }
        return Arrays.asList(input, "");
    }

    private static List<String> splitPath(String path, int skipSegments) {
        List<String> list = UriDecoder.splitSkipEmpty(path, '/');
        return skipSegments > 0 ? list.subList(skipSegments, list.size()) : list;
    }

    static List<String> splitSkipEmpty(String input, char c) {
        int end;
        if (input.isEmpty() || input.length() == 1 && input.charAt(0) == c) {
            return Collections.emptyList();
        }
        LinkedList<String> list = new LinkedList<String>();
        int start = 0;
        while ((end = input.indexOf(c, start)) >= 0) {
            if (start != end) {
                list.add(input.substring(start, end));
            }
            start = end + 1;
        }
        if (input.charAt(input.length() - 1) != c) {
            list.add(input.substring(start));
        }
        return list;
    }

    public static String decode(String encoded) throws UriParserSyntaxException {
        try {
            return Decoder.decode((String)encoded);
        }
        catch (IllegalArgumentException e) {
            throw new UriParserSyntaxException("Wrong percent encoding!", e, UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
        }
    }
}

