/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmActionImport;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmElement;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.server.api.uri.UriInfoKind;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.UriResourceRoot;
import org.apache.olingo.server.api.uri.queryoption.SelectItem;
import org.apache.olingo.server.api.uri.queryoption.expression.BinaryOperatorKind;
import org.apache.olingo.server.api.uri.queryoption.expression.MethodKind;
import org.apache.olingo.server.api.uri.queryoption.expression.UnaryOperatorKind;
import org.apache.olingo.server.core.uri.UriInfoImpl;
import org.apache.olingo.server.core.uri.UriParameterImpl;
import org.apache.olingo.server.core.uri.UriResourceActionImpl;
import org.apache.olingo.server.core.uri.UriResourceComplexPropertyImpl;
import org.apache.olingo.server.core.uri.UriResourceCountImpl;
import org.apache.olingo.server.core.uri.UriResourceEntitySetImpl;
import org.apache.olingo.server.core.uri.UriResourceFunctionImpl;
import org.apache.olingo.server.core.uri.UriResourceImpl;
import org.apache.olingo.server.core.uri.UriResourceItImpl;
import org.apache.olingo.server.core.uri.UriResourceLambdaAllImpl;
import org.apache.olingo.server.core.uri.UriResourceLambdaAnyImpl;
import org.apache.olingo.server.core.uri.UriResourceLambdaVarImpl;
import org.apache.olingo.server.core.uri.UriResourceNavigationPropertyImpl;
import org.apache.olingo.server.core.uri.UriResourcePrimitivePropertyImpl;
import org.apache.olingo.server.core.uri.UriResourceRefImpl;
import org.apache.olingo.server.core.uri.UriResourceRootImpl;
import org.apache.olingo.server.core.uri.UriResourceSingletonImpl;
import org.apache.olingo.server.core.uri.UriResourceStartingTypeFilterImpl;
import org.apache.olingo.server.core.uri.UriResourceTypedImpl;
import org.apache.olingo.server.core.uri.UriResourceValueImpl;
import org.apache.olingo.server.core.uri.UriResourceWithKeysImpl;
import org.apache.olingo.server.core.uri.antlr.UriParserBaseVisitor;
import org.apache.olingo.server.core.uri.antlr.UriParserParser;
import org.apache.olingo.server.core.uri.parser.UriContext;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.parser.UriParserSemanticException;
import org.apache.olingo.server.core.uri.parser.UriParserSyntaxException;
import org.apache.olingo.server.core.uri.queryoption.CountOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.ExpandItemImpl;
import org.apache.olingo.server.core.uri.queryoption.ExpandOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.FilterOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.LevelsOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.OrderByItemImpl;
import org.apache.olingo.server.core.uri.queryoption.OrderByOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.QueryOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.SelectItemImpl;
import org.apache.olingo.server.core.uri.queryoption.SelectOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.SkipOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.SkipTokenOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.SystemQueryOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.TopOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.AliasImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.BinaryImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.EnumerationImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.ExpressionImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.LiteralImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.MemberImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.MethodImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.TypeLiteralImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.UnaryImpl;

public class UriParseTreeVisitor
extends UriParserBaseVisitor<Object> {
    public UriContext context = null;
    public Edm edm;
    public EdmEntityContainer edmEntityContainer;

    public UriParseTreeVisitor(Edm edm, UriContext context) {
        this.edm = edm;
        this.context = context;
        this.edmEntityContainer = edm.getEntityContainer(null);
    }

    protected Object aggregateResult(Object aggregate, Object nextResult) {
        if (aggregate != null) {
            return aggregate;
        }
        return nextResult;
    }

    private FullQualifiedName getFullNameFromContext(UriParserParser.NamespaceContext vNS, String odi) {
        String namespace = vNS.getText();
        namespace = namespace.substring(0, namespace.length() - 1);
        return new FullQualifiedName(namespace, odi);
    }

    private UriContext.LambdaVariables getLambdaVar(String odi) {
        for (UriContext.LambdaVariables item : this.context.allowedLambdaVariables) {
            if (!item.name.equals(odi)) continue;
            return item;
        }
        return null;
    }

    TypeInformation getTypeInformation(UriResource lastResourcePart) {
        TypeInformation typeInformation = new TypeInformation();
        if (lastResourcePart instanceof UriResourceWithKeysImpl) {
            UriResourceWithKeysImpl lastPartWithKeys = (UriResourceWithKeysImpl)lastResourcePart;
            typeInformation.type = lastPartWithKeys.getTypeFilterOnEntry() != null ? lastPartWithKeys.getTypeFilterOnEntry() : (lastPartWithKeys.getTypeFilterOnCollection() != null ? lastPartWithKeys.getTypeFilterOnCollection() : lastPartWithKeys.getType());
            typeInformation.isCollection = lastPartWithKeys.isCollection();
        } else if (lastResourcePart instanceof UriResourceTypedImpl) {
            UriResourceTypedImpl lastPartTyped = (UriResourceTypedImpl)lastResourcePart;
            typeInformation.type = lastPartTyped.getTypeFilter() != null ? lastPartTyped.getTypeFilter() : lastPartTyped.getType();
            typeInformation.isCollection = lastPartTyped.isCollection();
        }
        return typeInformation;
    }

    public UriResourceTypedImpl readResourcePathSegment(UriParserParser.PathSegmentContext ctx) {
        UriResourceFunctionImpl pathInfoFunction;
        FullQualifiedName fullBindingTypeName;
        EdmAction action;
        EdmComplexType filterComplexType;
        UriResourceTypedImpl lastPartTyped;
        UriResourceWithKeysImpl lastPartWithKeys;
        UriResourceStartingTypeFilterImpl uriResource;
        UriResource lastResourcePart;
        TypeInformation source;
        boolean checkFirst = this.context.contextUriInfo.getLastResourcePart() == null || this.context.contextUriInfo.getLastResourcePart() instanceof UriResourceRootImpl;
        String odi = ctx.vODI.getText();
        boolean searchInContainer = true;
        if (checkFirst && ctx.vNS == null && !this.context.contextTypes.empty()) {
            EdmStructuredType str;
            EdmElement property;
            source = this.context.contextTypes.peek();
            if (source.type instanceof EdmStructuredType && (property = (str = (EdmStructuredType)source.type).getProperty(odi)) != null) {
                searchInContainer = false;
            }
        }
        if (searchInContainer) {
            List<UriResource> parts = this.context.contextUriInfo.getUriResourceParts();
            EdmEntitySet edmEntitySet = this.edmEntityContainer.getEntitySet(odi);
            if (edmEntitySet != null && (parts.isEmpty() || !(parts.get(0) instanceof UriResourcePartTyped) || parts.get(0) instanceof UriResourceRoot)) {
                this.ensureNamespaceIsNull(ctx.vNS);
                this.context.contextUriInfo.addResourcePart(new UriResourceEntitySetImpl().setEntitSet(edmEntitySet));
                return null;
            }
            EdmSingleton edmSingleton = this.edmEntityContainer.getSingleton(odi);
            if (edmSingleton != null && (parts.isEmpty() || !(parts.get(0) instanceof UriResourcePartTyped) || parts.get(0) instanceof UriResourceRoot)) {
                this.ensureNamespaceIsNull(ctx.vNS);
                this.context.contextUriInfo.addResourcePart(new UriResourceSingletonImpl().setSingleton(edmSingleton));
                return null;
            }
            EdmActionImport edmActionImport = this.edmEntityContainer.getActionImport(odi);
            if (edmActionImport != null && (parts.isEmpty() || !(parts.get(0) instanceof UriResourcePartTyped) || parts.get(0) instanceof UriResourceRoot)) {
                this.ensureNamespaceIsNull(ctx.vNS);
                this.context.contextUriInfo.addResourcePart(new UriResourceActionImpl().setActionImport(edmActionImport));
                return null;
            }
            EdmFunctionImport edmFunctionImport = this.edmEntityContainer.getFunctionImport(odi);
            if (edmFunctionImport != null && this.context.contextReadingQueryPart) {
                throw this.wrap(new UriParserSemanticException("Function Imports are not allowed in $filter or $orderby", UriParserSemanticException.MessageKeys.FUNCTION_IMPORT_NOT_ALLOWED, odi));
            }
            if (edmFunctionImport != null && (parts.isEmpty() || !(parts.get(0) instanceof UriResourcePartTyped) || parts.get(0) instanceof UriResourceRoot)) {
                if (ctx.vlNVO.isEmpty()) {
                    throw this.wrap(new UriParserSyntaxException("Function imports must have a (possibly empty) parameter list written in parentheses", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]));
                }
                this.context.contextReadingFunctionParameters = true;
                List parameters = (List)ctx.vlNVO.get(0).accept(this);
                this.context.contextReadingFunctionParameters = false;
                ctx.vlNVO.remove(0);
                UriResourceFunctionImpl uriResource2 = new UriResourceFunctionImpl().setFunctionImport(edmFunctionImport, parameters);
                ArrayList<String> names = new ArrayList<String>();
                for (UriParameter item : parameters) {
                    names.add(item.getName());
                }
                EdmFunction function = edmFunctionImport.getUnboundFunction(names);
                if (function == null) {
                    StringBuilder tmp = new StringBuilder();
                    for (String name : names) {
                        tmp.append(tmp.length() != 0 ? "," : "").append(name);
                    }
                    throw this.wrap(new UriParserSemanticException("Function of functionimport '" + edmFunctionImport.getName() + "' with parameters [" + tmp.toString() + "] not found", UriParserSemanticException.MessageKeys.FUNCTION_NOT_FOUND, edmFunctionImport.getName(), tmp.toString()));
                }
                this.ensureNamespaceIsNull(ctx.vNS);
                uriResource2.setFunction(edmFunctionImport.getUnboundFunction(names));
                this.context.contextUriInfo.addResourcePart(uriResource2);
                return null;
            }
        }
        if ((lastResourcePart = this.context.contextUriInfo.getLastResourcePart()) == null) {
            if (this.context.contextTypes.empty()) {
                if (checkFirst && ctx.vNS == null) {
                    throw this.wrap(new UriParserSemanticException("Cannot find EntitySet, Singleton, ActionImport or FunctionImport with name '" + odi + "'.", UriParserSemanticException.MessageKeys.RESOURCE_NOT_FOUND, odi));
                }
                throw this.wrap(new UriParserSemanticException("Resource part '" + odi + "' can only applied on typed resource parts", UriParserSemanticException.MessageKeys.RESOURCE_PART_ONLY_FOR_TYPED_PARTS, odi));
            }
            source = this.context.contextTypes.peek();
        } else {
            source = this.getTypeInformation(lastResourcePart);
            if (source.type == null) {
                throw this.wrap(new UriParserSemanticException("Resource part '" + odi + "' can only be applied on typed resource parts.", UriParserSemanticException.MessageKeys.RESOURCE_PART_ONLY_FOR_TYPED_PARTS, odi));
            }
        }
        if (ctx.vNS == null) {
            UriContext.LambdaVariables lVar = this.getLambdaVar(odi);
            if (lVar != null) {
                UriResourceLambdaVarImpl lambdaResource = new UriResourceLambdaVarImpl();
                lambdaResource.setVariableText(lVar.name);
                lambdaResource.setType(lVar.type);
                lambdaResource.setCollection(lVar.isCollection);
                this.context.contextUriInfo.addResourcePart(lambdaResource);
                return null;
            }
            if (!(source.type instanceof EdmStructuredType)) {
                throw this.wrap(new UriParserSemanticException("Cannot parse '" + odi + "'; previous path segment is not a structural type.", UriParserSemanticException.MessageKeys.RESOURCE_PART_MUST_BE_PRECEDED_BY_STRUCTURAL_TYPE, odi));
            }
            if ((ctx.depth() <= 2 || lastResourcePart instanceof UriResourceTypedImpl || lastResourcePart instanceof UriResourceNavigationPropertyImpl) && source.isCollection) {
                throw this.wrap(new UriParserSemanticException("Property '" + odi + "' is not allowed after collection.", UriParserSemanticException.MessageKeys.PROPERTY_AFTER_COLLECTION, odi));
            }
            EdmStructuredType structType = (EdmStructuredType)source.type;
            EdmElement property = structType.getProperty(odi);
            if (property == null) {
                throw this.wrap(new UriParserSemanticException("Property '" + odi + "' not found in type '" + structType.getFullQualifiedName().getFullQualifiedNameAsString() + "'", ctx.depth() > 2 ? UriParserSemanticException.MessageKeys.EXPRESSION_PROPERTY_NOT_IN_TYPE : UriParserSemanticException.MessageKeys.PROPERTY_NOT_IN_TYPE, structType.getFullQualifiedName().getFullQualifiedNameAsString(), odi));
            }
            if (property instanceof EdmProperty) {
                if (((EdmProperty)property).isPrimitive() || property.getType().getKind() == EdmTypeKind.ENUM || property.getType().getKind() == EdmTypeKind.DEFINITION) {
                    UriResourcePrimitivePropertyImpl simpleResource = new UriResourcePrimitivePropertyImpl().setProperty((EdmProperty)property);
                    this.context.contextUriInfo.addResourcePart(simpleResource);
                    return null;
                }
                UriResourceComplexPropertyImpl complexResource = new UriResourceComplexPropertyImpl().setProperty((EdmProperty)property);
                this.context.contextUriInfo.addResourcePart(complexResource);
                return null;
            }
            if (property instanceof EdmNavigationProperty) {
                if (this.context.contextVisitExpandResourcePath && ctx.vlNVO.size() > 0) {
                    throw this.wrap(new UriParserSemanticException("Navigation properties in expand system query options must not be followed by a key.", UriParserSemanticException.MessageKeys.KEY_NOT_ALLOWED, new String[0]));
                }
                UriResourceNavigationPropertyImpl navigationResource = new UriResourceNavigationPropertyImpl().setNavigationProperty((EdmNavigationProperty)property);
                this.context.contextUriInfo.addResourcePart(navigationResource);
                return null;
            }
            throw this.wrap(new UriParserSemanticException("Unkown type for property '" + property + "'", UriParserSemanticException.MessageKeys.UNKNOWN_PROPERTY_TYPE, property.getName()));
        }
        FullQualifiedName fullFilterName = this.getFullNameFromContext(ctx.vNS, odi);
        if (source.type instanceof EdmEntityType) {
            EdmEntityType filterEntityType = this.edm.getEntityType(fullFilterName);
            if (filterEntityType != null) {
                if (!filterEntityType.compatibleTo(source.type)) {
                    throw this.wrap(new UriParserSemanticException("Entity typefilter not compatible to previous path segment: " + fullFilterName.toString(), UriParserSemanticException.MessageKeys.INCOMPATIBLE_TYPE_FILTER, fullFilterName.toString()));
                }
                if (lastResourcePart == null) {
                    uriResource = new UriResourceStartingTypeFilterImpl().setType((EdmType)filterEntityType).setCollection(source.isCollection);
                    if (source.isCollection) {
                        uriResource.setCollectionTypeFilter((EdmType)filterEntityType);
                    } else {
                        uriResource.setEntryTypeFilter((EdmType)filterEntityType);
                    }
                    this.context.contextUriInfo.addResourcePart(uriResource);
                    return null;
                }
                if (lastResourcePart instanceof UriResourceWithKeysImpl) {
                    lastPartWithKeys = (UriResourceWithKeysImpl)lastResourcePart;
                    if (!lastPartWithKeys.isCollection()) {
                        if (lastPartWithKeys.getTypeFilterOnEntry() != null) {
                            throw this.wrap(new UriParserSemanticException("Entry typefilters are not chainable, used '" + this.getName((EdmType)filterEntityType) + "' behind '" + this.getName(lastPartWithKeys.getTypeFilterOnEntry()) + "'", UriParserSemanticException.MessageKeys.TYPE_FILTER_NOT_CHAINABLE, this.getName(lastPartWithKeys.getTypeFilterOnEntry()), this.getName((EdmType)filterEntityType)));
                        }
                        lastPartWithKeys.setEntryTypeFilter((EdmType)filterEntityType);
                        return null;
                    }
                    if (lastPartWithKeys.getTypeFilterOnCollection() != null) {
                        throw this.wrap(new UriParserSemanticException("Collection typefilters are not chainable, used '" + this.getName((EdmType)filterEntityType) + "' behind '" + this.getName(lastPartWithKeys.getTypeFilterOnCollection()) + "'", UriParserSemanticException.MessageKeys.TYPE_FILTER_NOT_CHAINABLE, this.getName(lastPartWithKeys.getTypeFilterOnCollection()), this.getName((EdmType)filterEntityType)));
                    }
                    lastPartWithKeys.setCollectionTypeFilter((EdmType)filterEntityType);
                    return null;
                }
                if (lastResourcePart instanceof UriResourceTypedImpl) {
                    lastPartTyped = (UriResourceTypedImpl)lastResourcePart;
                    if (lastPartTyped.getTypeFilter() != null) {
                        throw this.wrap(new UriParserSemanticException("Typefilters are not chainable, used '" + this.getName((EdmType)filterEntityType) + "' behind '" + this.getName(lastPartTyped.getTypeFilter()) + "'", UriParserSemanticException.MessageKeys.TYPE_FILTER_NOT_CHAINABLE, this.getName(lastPartTyped.getTypeFilter()), this.getName((EdmType)filterEntityType)));
                    }
                    lastPartTyped.setTypeFilter((EdmStructuredType)filterEntityType);
                    return null;
                }
                throw this.wrap(new UriParserSemanticException("Path segment before '" + this.getName((EdmType)filterEntityType) + "' not typed", UriParserSemanticException.MessageKeys.PREVIOUS_PART_NOT_TYPED, this.getName((EdmType)filterEntityType)));
            }
        } else if (source.type instanceof EdmComplexType && (filterComplexType = this.edm.getComplexType(fullFilterName)) != null) {
            if (!filterComplexType.compatibleTo(source.type)) {
                throw this.wrap(new UriParserSemanticException("Complex typefilter '" + this.getName(source.type) + "'not compatible type of previous path segment '" + this.getName((EdmType)filterComplexType) + "'", UriParserSemanticException.MessageKeys.INCOMPATIBLE_TYPE_FILTER, this.getName(source.type)));
            }
            if (lastResourcePart == null) {
                uriResource = new UriResourceStartingTypeFilterImpl().setType((EdmType)filterComplexType).setCollection(source.isCollection);
                if (source.isCollection) {
                    uriResource.setCollectionTypeFilter((EdmType)filterComplexType);
                } else {
                    uriResource.setEntryTypeFilter((EdmType)filterComplexType);
                }
                this.context.contextUriInfo.addResourcePart(uriResource);
                return null;
            }
            if (lastResourcePart instanceof UriResourceWithKeysImpl) {
                lastPartWithKeys = (UriResourceWithKeysImpl)lastResourcePart;
                if (!lastPartWithKeys.isCollection()) {
                    if (lastPartWithKeys.getTypeFilterOnEntry() != null) {
                        throw this.wrap(new UriParserSemanticException("Entry typefilters are not chainable, used '" + this.getName((EdmType)filterComplexType) + "' behind '" + this.getName(lastPartWithKeys.getTypeFilterOnEntry()) + "'", UriParserSemanticException.MessageKeys.TYPE_FILTER_NOT_CHAINABLE, this.getName(lastPartWithKeys.getTypeFilterOnEntry()), this.getName((EdmType)filterComplexType)));
                    }
                    lastPartWithKeys.setEntryTypeFilter((EdmType)filterComplexType);
                    return null;
                }
                if (lastPartWithKeys.getTypeFilterOnCollection() != null) {
                    throw this.wrap(new UriParserSemanticException("Collection typefilters are not chainable, used '" + this.getName((EdmType)filterComplexType) + "' behind '" + this.getName(lastPartWithKeys.getTypeFilterOnCollection()) + "'", UriParserSemanticException.MessageKeys.TYPE_FILTER_NOT_CHAINABLE, this.getName(lastPartWithKeys.getTypeFilterOnCollection()), this.getName((EdmType)filterComplexType)));
                }
                lastPartWithKeys.setCollectionTypeFilter((EdmType)filterComplexType);
                return null;
            }
            if (lastResourcePart instanceof UriResourceTypedImpl) {
                lastPartTyped = (UriResourceTypedImpl)lastResourcePart;
                if (lastPartTyped.getTypeFilter() != null) {
                    throw this.wrap(new UriParserSemanticException("Typefilters are not chainable, used '" + this.getName((EdmType)filterComplexType) + "' behind '" + this.getName(lastPartTyped.getTypeFilter()) + "'", UriParserSemanticException.MessageKeys.TYPE_FILTER_NOT_CHAINABLE, this.getName(lastPartTyped.getTypeFilter()), this.getName((EdmType)filterComplexType)));
                }
                lastPartTyped.setTypeFilter((EdmStructuredType)filterComplexType);
                return null;
            }
            throw this.wrap(new UriParserSemanticException("Path segment before '" + this.getName((EdmType)filterComplexType) + "' not typed", UriParserSemanticException.MessageKeys.PREVIOUS_PART_NOT_TYPED, this.getName((EdmType)filterComplexType)));
        }
        if ((action = this.edm.getBoundAction(fullFilterName, fullBindingTypeName = new FullQualifiedName(source.type.getNamespace(), source.type.getName()), Boolean.valueOf(source.isCollection))) != null) {
            UriResourceActionImpl pathInfoAction = new UriResourceActionImpl();
            pathInfoAction.setAction(action);
            this.context.contextUriInfo.addResourcePart(pathInfoAction);
            return null;
        }
        if (ctx.vlNVO.size() == 0) {
            throw this.wrap(new UriParserSemanticException("Unknown type for type cast " + fullFilterName.toString() + " not found", UriParserSemanticException.MessageKeys.UNKNOWN_TYPE, fullFilterName.toString()));
        }
        this.context.contextReadingFunctionParameters = true;
        List parameters = (List)ctx.vlNVO.get(0).accept(this);
        this.context.contextReadingFunctionParameters = false;
        ArrayList<String> names = new ArrayList<String>();
        for (UriParameter item : parameters) {
            names.add(item.getName());
        }
        EdmFunction function = this.edm.getBoundFunction(fullFilterName, fullBindingTypeName, Boolean.valueOf(source.isCollection), names);
        if (function != null) {
            pathInfoFunction = new UriResourceFunctionImpl().setFunction(function).setParameters(parameters);
            this.context.contextUriInfo.addResourcePart(pathInfoFunction);
            ctx.vlNVO.remove(0);
            return null;
        }
        function = this.edm.getUnboundFunction(fullFilterName, names);
        if (function != null) {
            pathInfoFunction = new UriResourceFunctionImpl().setFunction(function).setParameters(parameters);
            this.context.contextUriInfo.addResourcePart(pathInfoFunction);
            ctx.vlNVO.remove(0);
            return null;
        }
        throw this.wrap(new UriParserSemanticException("Unknown resource path segment:" + fullFilterName.toString(), UriParserSemanticException.MessageKeys.UNKNOWN_PART, fullFilterName.toString()));
    }

    private void ensureNamespaceIsNull(UriParserParser.NamespaceContext vNS) {
        if (vNS != null && this.context.contextUriInfo.getLastResourcePart() == null) {
            throw this.wrap(new UriParserSemanticException("Namespace is not allowed for EntitySets, Singeltons,  Action Imports and Function Imports. Found " + vNS.getText(), UriParserSemanticException.MessageKeys.NAMESPACE_NOT_ALLOWED_AT_FIRST_ELEMENT, vNS.getText()));
        }
    }

    private String getName(EdmType type) {
        return type.getFullQualifiedName().getFullQualifiedNameAsString();
    }

    @Override
    public Object visitAllEOF(UriParserParser.AllEOFContext ctx) {
        this.context.contextUriInfo = new UriInfoImpl().setKind(UriInfoKind.all);
        return null;
    }

    @Override
    public Object visitAllExpr(UriParserParser.AllExprContext ctx) {
        UriResourceLambdaAllImpl all = new UriResourceLambdaAllImpl();
        UriResource obj = this.context.contextUriInfo.getLastResourcePart();
        if (!(obj instanceof UriResourcePartTyped)) {
            throw this.wrap(new UriParserSemanticException("all only allowed on typed path segments", UriParserSemanticException.MessageKeys.ONLY_FOR_TYPED_PARTS, "all"));
        }
        if (obj instanceof UriResourceNavigation && !((UriResourceNavigation)obj).getKeyPredicates().isEmpty()) {
            throw this.wrap(new UriParserSemanticException("Any lamdba expression must not be following navigation properties with key predicates.", UriParserSemanticException.MessageKeys.KEY_NOT_ALLOWED, new String[0]));
        }
        UriContext.LambdaVariables var = new UriContext.LambdaVariables();
        var.name = ctx.vLV.getText();
        var.type = this.getTypeInformation((UriResource)obj).type;
        var.isCollection = false;
        all.setLamdaVariable(ctx.vLV.getText());
        this.context.allowedLambdaVariables.push(var);
        all.setExpression((ExpressionImpl)ctx.vLE.accept(this));
        this.context.allowedLambdaVariables.pop();
        return all;
    }

    @Override
    public ExpressionImpl visitAltAdd(UriParserParser.AltAddContext ctx) {
        BinaryImpl binary = new BinaryImpl();
        int tokenIndex = ctx.vO.getType();
        if (tokenIndex == 54) {
            binary.setOperator(BinaryOperatorKind.ADD);
        } else if (tokenIndex == 55) {
            binary.setOperator(BinaryOperatorKind.SUB);
        }
        binary.setLeftOperand((ExpressionImpl)ctx.vE1.accept(this));
        binary.setRightOperand((ExpressionImpl)ctx.vE2.accept(this));
        return binary;
    }

    @Override
    public Object visitAltAll(UriParserParser.AltAllContext ctx) {
        UriInfoImpl uriInfoImplpath = new UriInfoImpl().setKind(UriInfoKind.resource);
        uriInfoImplpath.addResourcePart((UriResourceImpl)super.visitAltAll(ctx));
        EdmType startType = this.removeUriResourceStartingTypeFilterImpl(uriInfoImplpath);
        MemberImpl ret = new MemberImpl();
        ret.setResourcePath((UriInfoResource)uriInfoImplpath);
        if (startType != null) {
            ret.setTypeFilter(startType);
        }
        return ret;
    }

    private EdmType removeUriResourceStartingTypeFilterImpl(UriInfoImpl uriInfoImplpath) {
        List<UriResource> segments = uriInfoImplpath.getUriResourceParts();
        if (segments.size() == 0) {
            return null;
        }
        UriResource segment = segments.get(0);
        if (segment instanceof UriResourceStartingTypeFilterImpl) {
            UriResourceStartingTypeFilterImpl startingTypeFilter = (UriResourceStartingTypeFilterImpl)segment;
            EdmType type = null;
            type = startingTypeFilter.getTypeFilterOnEntry() != null ? startingTypeFilter.getTypeFilterOnEntry() : (startingTypeFilter.getTypeFilterOnCollection() != null ? startingTypeFilter.getTypeFilterOnCollection() : startingTypeFilter.getType());
            uriInfoImplpath.removeResourcePart(0);
            return type;
        }
        return null;
    }

    @Override
    public ExpressionImpl visitAltAnd(UriParserParser.AltAndContext ctx) {
        BinaryImpl binary = new BinaryImpl();
        binary.setOperator(BinaryOperatorKind.AND);
        binary.setLeftOperand((ExpressionImpl)ctx.vE1.accept(this));
        binary.setRightOperand((ExpressionImpl)ctx.vE2.accept(this));
        return binary;
    }

    @Override
    public Object visitAltAny(UriParserParser.AltAnyContext ctx) {
        UriInfoImpl uriInfoImplpath = new UriInfoImpl().setKind(UriInfoKind.resource);
        uriInfoImplpath.addResourcePart((UriResourceImpl)super.visitAltAny(ctx));
        EdmType startType = this.removeUriResourceStartingTypeFilterImpl(uriInfoImplpath);
        MemberImpl ret = new MemberImpl();
        ret.setResourcePath((UriInfoResource)uriInfoImplpath);
        if (startType != null) {
            ret.setTypeFilter(startType);
        }
        return ret;
    }

    @Override
    public Object visitBatchEOF(UriParserParser.BatchEOFContext ctx) {
        this.context.contextUriInfo = new UriInfoImpl().setKind(UriInfoKind.batch);
        return null;
    }

    @Override
    public ExpressionImpl visitAltComparism(UriParserParser.AltComparismContext ctx) {
        BinaryImpl binary = new BinaryImpl();
        int tokenIndex = ctx.vO.getType();
        if (tokenIndex == 58) {
            binary.setOperator(BinaryOperatorKind.GT);
        } else if (tokenIndex == 59) {
            binary.setOperator(BinaryOperatorKind.GE);
        } else if (tokenIndex == 60) {
            binary.setOperator(BinaryOperatorKind.LT);
        } else if (tokenIndex == 61) {
            binary.setOperator(BinaryOperatorKind.LE);
        }
        binary.setLeftOperand((ExpressionImpl)ctx.vE1.accept(this));
        binary.setRightOperand((ExpressionImpl)ctx.vE2.accept(this));
        return binary;
    }

    @Override
    public Object visitEntityEOF(UriParserParser.EntityEOFContext ctx) {
        String odi = ctx.vODI.getText();
        FullQualifiedName fullName = this.getFullNameFromContext(ctx.vNS, odi);
        EdmEntityType type = this.edm.getEntityType(fullName);
        if (type == null) {
            throw this.wrap(new UriParserSemanticException("Expected EntityTypeName", UriParserSemanticException.MessageKeys.UNKNOWN_ENTITY_TYPE, fullName.toString()));
        }
        this.context.contextUriInfo.setEntityTypeCast(type);
        this.context.contextTypes.push(new TypeInformation((EdmType)this.context.contextUriInfo.getEntityTypeCast(), true));
        return null;
    }

    @Override
    public ExpressionImpl visitAltEquality(UriParserParser.AltEqualityContext ctx) {
        BinaryImpl binary = new BinaryImpl();
        int tokenIndex = ctx.vO.getType();
        if (tokenIndex == 63) {
            binary.setOperator(BinaryOperatorKind.EQ);
        } else {
            binary.setOperator(BinaryOperatorKind.NE);
        }
        binary.setLeftOperand((ExpressionImpl)ctx.vE1.accept(this));
        binary.setRightOperand((ExpressionImpl)ctx.vE2.accept(this));
        return binary;
    }

    @Override
    public Object visitAltHas(UriParserParser.AltHasContext ctx) {
        BinaryImpl binary = new BinaryImpl();
        binary.setOperator(BinaryOperatorKind.HAS);
        binary.setLeftOperand((ExpressionImpl)ctx.vE1.accept(this));
        binary.setRightOperand((ExpressionImpl)ctx.vE2.accept(this));
        return binary;
    }

    @Override
    public Object visitMetadataEOF(UriParserParser.MetadataEOFContext ctx) {
        this.context.contextUriInfo = new UriInfoImpl().setKind(UriInfoKind.metadata);
        return null;
    }

    @Override
    public ExpressionImpl visitAltMult(UriParserParser.AltMultContext ctx) {
        BinaryImpl binary = new BinaryImpl();
        int tokenIndex = ctx.vO.getType();
        if (tokenIndex == 50) {
            binary.setOperator(BinaryOperatorKind.MUL);
        } else if (tokenIndex == 51) {
            binary.setOperator(BinaryOperatorKind.DIV);
        } else {
            binary.setOperator(BinaryOperatorKind.MOD);
        }
        binary.setLeftOperand((ExpressionImpl)ctx.vE1.accept(this));
        binary.setRightOperand((ExpressionImpl)ctx.vE2.accept(this));
        return binary;
    }

    @Override
    public ExpressionImpl visitAltOr(UriParserParser.AltOrContext ctx) {
        BinaryImpl binary = new BinaryImpl();
        binary.setOperator(BinaryOperatorKind.OR);
        binary.setLeftOperand((ExpressionImpl)ctx.vE1.accept(this));
        binary.setRightOperand((ExpressionImpl)ctx.vE2.accept(this));
        return binary;
    }

    @Override
    public Object visitAnyExpr(UriParserParser.AnyExprContext ctx) {
        UriResourceLambdaAnyImpl any = new UriResourceLambdaAnyImpl();
        if (ctx.vLV != null) {
            UriResourceImpl lastResourcePart = (UriResourceImpl)this.context.contextUriInfo.getLastResourcePart();
            if (!(lastResourcePart instanceof UriResourcePartTyped)) {
                throw this.wrap(new UriParserSemanticException("any only allowed on typed path segments", UriParserSemanticException.MessageKeys.ONLY_FOR_TYPED_PARTS, "any"));
            }
            if (lastResourcePart instanceof UriResourceNavigation && !((UriResourceNavigation)lastResourcePart).getKeyPredicates().isEmpty()) {
                throw this.wrap(new UriParserSemanticException("Any lamdba expression must not be following navigation properties with key predicates", UriParserSemanticException.MessageKeys.KEY_NOT_ALLOWED, new String[0]));
            }
            UriContext.LambdaVariables var = new UriContext.LambdaVariables();
            var.name = ctx.vLV.getText();
            var.type = this.getTypeInformation((UriResource)lastResourcePart).type;
            var.isCollection = false;
            any.setLamdaVariable(ctx.vLV.getText());
            this.context.allowedLambdaVariables.push(var);
            any.setExpression((ExpressionImpl)ctx.vLE.accept(this));
            this.context.allowedLambdaVariables.pop();
        }
        return any;
    }

    @Override
    public Object visitBooleanNonCaseLiteral(UriParserParser.BooleanNonCaseLiteralContext ctx) {
        String text = ctx.getText().toLowerCase();
        return new LiteralImpl().setText(text.equals("false") ? "false" : "true").setType((EdmType)EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Boolean));
    }

    @Override
    public ExpressionImpl visitCastExpr(UriParserParser.CastExprContext ctx) {
        MethodImpl method = new MethodImpl();
        if (ctx.vE1 != null) {
            ExpressionImpl onExpression = (ExpressionImpl)ctx.vE1.accept(this);
            method.addParameter(onExpression);
        }
        String namespace = ctx.vNS.getText();
        namespace = namespace.substring(0, namespace.length() - 1);
        FullQualifiedName fullName = new FullQualifiedName(namespace, ctx.vODI.getText());
        EdmType type = this.getType(fullName);
        method.setMethod(MethodKind.CAST);
        method.addParameter(new TypeLiteralImpl().setType(type));
        return method;
    }

    private EdmType getType(FullQualifiedName fullName) {
        EdmPrimitiveTypeKind typeKind;
        EdmEntityType type = null;
        type = this.edm.getEntityType(fullName);
        if (type != null) {
            return type;
        }
        type = this.edm.getComplexType(fullName);
        if (type != null) {
            return type;
        }
        type = this.edm.getTypeDefinition(fullName);
        if (type != null) {
            return type;
        }
        type = this.edm.getEnumType(fullName);
        if (type != null) {
            return type;
        }
        if (fullName.getNamespace().equals("Edm") && (type = EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)(typeKind = EdmPrimitiveTypeKind.valueOf((String)fullName.getName())))) != null) {
            return type;
        }
        return null;
    }

    @Override
    public ExpressionImpl visitCeilingMethodCallExpr(UriParserParser.CeilingMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.CEILING).addParameter((ExpressionImpl)ctx.vE1.accept(this));
    }

    @Override
    public ExpressionImpl visitConcatMethodCallExpr(UriParserParser.ConcatMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.CONCAT).addParameter((ExpressionImpl)ctx.vE1.accept(this)).addParameter((ExpressionImpl)ctx.vE2.accept(this));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object visitConstSegment(UriParserParser.ConstSegmentContext ctx) {
        UriInfoImpl uriInfoResource = this.context.contextUriInfo;
        UriResource pathInfo = uriInfoResource.getLastResourcePart();
        if (ctx.vV != null) {
            if (!(pathInfo instanceof UriResourcePartTyped)) throw this.wrap(new UriParserSemanticException("$value only allowed on typed path segments", UriParserSemanticException.MessageKeys.ONLY_FOR_TYPED_PARTS, "$value"));
            if (((UriResourcePartTyped)pathInfo).isCollection()) {
                throw this.wrap(new UriParserSemanticException("$value only allowed on typed path segments", UriParserSemanticException.MessageKeys.ONLY_FOR_TYPED_PARTS, "$value"));
            }
            this.context.contextUriInfo.addResourcePart(new UriResourceValueImpl());
            return null;
        }
        if (ctx.vC != null) {
            if (!(pathInfo instanceof UriResourcePartTyped)) throw this.wrap(new UriParserSemanticException("$count only allowed on typed properties", UriParserSemanticException.MessageKeys.ONLY_FOR_TYPED_PARTS, "$count"));
            if (!((UriResourcePartTyped)pathInfo).isCollection()) throw this.wrap(new UriParserSemanticException("$count only allowed on collection properties", UriParserSemanticException.MessageKeys.ONLY_FOR_COLLECTIONS, "$count"));
            this.context.contextUriInfo.addResourcePart(new UriResourceCountImpl());
            return null;
        } else if (ctx.vR != null) {
            if (!(pathInfo instanceof UriResourcePartTyped)) throw this.wrap(new UriParserSemanticException("$ref only allowed on typed properties", UriParserSemanticException.MessageKeys.ONLY_FOR_TYPED_PROPERTIES, "$ref"));
            EdmType type = ((UriResourcePartTyped)pathInfo).getType();
            if (!(type instanceof EdmEntityType)) throw this.wrap(new UriParserSemanticException("$ref only allowed on entity types", UriParserSemanticException.MessageKeys.ONLY_FOR_ENTITY_TYPES, "$ref"));
            this.context.contextUriInfo.addResourcePart(new UriResourceRefImpl());
            return null;
        } else if (ctx.vAll != null) {
            this.context.contextUriInfo.addResourcePart((UriResourceLambdaAllImpl)ctx.vAll.accept(this));
            return null;
        } else {
            if (ctx.vAny == null) return null;
            this.context.contextUriInfo.addResourcePart((UriResourceLambdaAnyImpl)ctx.vAny.accept(this));
        }
        return null;
    }

    @Override
    public ExpressionImpl visitContainsMethodCallExpr(UriParserParser.ContainsMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.CONTAINS).addParameter((ExpressionImpl)ctx.vE1.accept(this)).addParameter((ExpressionImpl)ctx.vE2.accept(this));
    }

    @Override
    public Object visitCrossjoinEOF(UriParserParser.CrossjoinEOFContext ctx) {
        UriInfoImpl crossJoin = new UriInfoImpl().setKind(UriInfoKind.crossjoin);
        for (UriParserParser.OdataIdentifierContext obj : ctx.vlODI) {
            String odi = obj.getText();
            crossJoin.addEntitySetName(odi);
            EdmEntitySet edmEntitySet = this.edmEntityContainer.getEntitySet(odi);
            if (edmEntitySet == null) {
                throw this.wrap(new UriParserSemanticException("Expected EntityTypeName", UriParserSemanticException.MessageKeys.UNKNOWN_PART, odi));
            }
            EdmEntityType type = edmEntitySet.getEntityType();
            if (type == null) {
                throw this.wrap(new UriParserSemanticException("Expected EntityTypeName", UriParserSemanticException.MessageKeys.UNKNOWN_ENTITY_TYPE, odi));
            }
            this.context.contextTypes.push(new TypeInformation((EdmType)type, true));
        }
        this.context.contextUriInfo = crossJoin;
        return null;
    }

    @Override
    public Object visitDateMethodCallExpr(UriParserParser.DateMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.DATE).addParameter((ExpressionImpl)ctx.vE1.accept(this));
    }

    @Override
    public ExpressionImpl visitDayMethodCallExpr(UriParserParser.DayMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.DAY).addParameter((ExpressionImpl)ctx.vE1.accept(this));
    }

    @Override
    public ExpressionImpl visitGeoDistanceMethodCallExpr(UriParserParser.GeoDistanceMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.GEODISTANCE).addParameter((ExpressionImpl)ctx.vE1.accept(this)).addParameter((ExpressionImpl)ctx.vE2.accept(this));
    }

    @Override
    public Object visitEndsWithMethodCallExpr(UriParserParser.EndsWithMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.ENDSWITH).addParameter((ExpressionImpl)ctx.vE1.accept(this)).addParameter((ExpressionImpl)ctx.vE2.accept(this));
    }

    @Override
    public Object visitEnumLiteral(UriParserParser.EnumLiteralContext ctx) {
        String[] values;
        EnumerationImpl enum1 = new EnumerationImpl();
        String odi = ctx.vODI.getText();
        FullQualifiedName fullName = this.getFullNameFromContext(ctx.vNS, odi);
        EdmEnumType edmEnumType = this.edm.getEnumType(fullName);
        if (edmEnumType == null) {
            throw this.wrap(new UriParserSemanticException("Enum type '" + fullName.getFullQualifiedNameAsString() + "' not found!", UriParserSemanticException.MessageKeys.UNKNOWN_TYPE, fullName.getFullQualifiedNameAsString()));
        }
        enum1.setType(edmEnumType);
        String valueString = ctx.vValues.getText();
        valueString = valueString.substring(1, valueString.length() - 1);
        for (String item : values = valueString.split(",")) {
            enum1.addValue(item);
        }
        return enum1;
    }

    @Override
    public Object visitExpandItems(UriParserParser.ExpandItemsContext ctx) {
        ExpandOptionImpl expand = new ExpandOptionImpl();
        expand.setText(ctx.getText());
        for (UriParserParser.ExpandItemContext eI : ctx.vlEI) {
            expand.addExpandItem((ExpandItemImpl)eI.accept(this));
        }
        return expand;
    }

    @Override
    public Object visitExpandItem(UriParserParser.ExpandItemContext ctx) {
        ExpandItemImpl expandItem = null;
        if (ctx.vS != null) {
            expandItem = new ExpandItemImpl().setIsStar(true);
            if (ctx.vR != null) {
                expandItem.setIsRef(true);
            } else if (ctx.vM != null) {
                LevelsOptionImpl levels = new LevelsOptionImpl().setMax();
                levels.setText(ctx.vM.getText());
                try {
                    expandItem.setSystemQueryOption(levels);
                }
                catch (ODataRuntimeException e) {
                    throw this.wrap(new UriParserSyntaxException("Double system query option!", e, UriParserSyntaxException.MessageKeys.DOUBLE_SYSTEM_QUERY_OPTION, e.getMessage()));
                }
            } else if (ctx.vL != null) {
                LevelsOptionImpl levels = new LevelsOptionImpl();
                String text = ctx.vL.getText();
                levels.setText(text);
                levels.setValue(Integer.parseInt(text));
                try {
                    expandItem.setSystemQueryOption(levels);
                }
                catch (ODataRuntimeException e) {
                    throw this.wrap(new UriParserSyntaxException("Double system query option!", e, UriParserSyntaxException.MessageKeys.DOUBLE_SYSTEM_QUERY_OPTION, e.getMessage()));
                }
            }
        } else if (ctx.vEP != null) {
            expandItem = (ExpandItemImpl)ctx.vEP.accept(this);
            if (ctx.vEPE != null) {
                ExpandItemImpl contextExpandItemPathBU = this.context.contextExpandItemPath;
                this.context.contextExpandItemPath = expandItem;
                List list = (List)ctx.vEPE.accept(this);
                try {
                    for (SystemQueryOptionImpl option : list) {
                        expandItem.setSystemQueryOption(option);
                    }
                }
                catch (ODataRuntimeException e) {
                    throw this.wrap(new UriParserSyntaxException("Double system query option!", e, UriParserSyntaxException.MessageKeys.DOUBLE_SYSTEM_QUERY_OPTION, e.getMessage()));
                }
                this.context.contextExpandItemPath = contextExpandItemPathBU;
            }
        }
        return expandItem;
    }

    @Override
    public Object visitExpandPath(UriParserParser.ExpandPathContext ctx) {
        ExpandItemImpl expandItem = new ExpandItemImpl();
        ExpandItemImpl contextExpandItemPathBU = this.context.contextExpandItemPath;
        UriInfoImpl uriInfoResourceBU = this.context.contextUriInfo;
        this.context.contextExpandItemPath = expandItem;
        this.context.contextUriInfo = new UriInfoImpl().setKind(UriInfoKind.resource);
        this.context.contextVisitExpandResourcePath = true;
        super.visitExpandPath(ctx);
        this.context.contextVisitExpandResourcePath = false;
        EdmType startType = this.removeUriResourceStartingTypeFilterImpl(this.context.contextUriInfo);
        expandItem.setResourcePath((UriInfoResource)this.context.contextUriInfo);
        if (startType != null) {
            expandItem.setTypeFilter(startType);
        }
        this.context.contextUriInfo = uriInfoResourceBU;
        this.context.contextExpandItemPath = contextExpandItemPathBU;
        this.validate(uriInfoResourceBU.asUriInfoResource(), expandItem);
        return expandItem;
    }

    private void validate(UriInfoResource uriInfoResource, ExpandItemImpl expandItem) {
        if (uriInfoResource != null) {
            EdmElement property;
            EdmEntityType type = this.getEntityType(uriInfoResource);
            EdmEntityType name = this.getEntityType(expandItem.getResourcePath());
            if (name != null && type != null && !((property = type.getProperty(name.getName())) instanceof EdmNavigationProperty)) {
                throw this.wrap(new UriParserSemanticException("NavigationProperty '" + name.getName() + "' not found in type '" + type.getFullQualifiedName().getFullQualifiedNameAsString() + "'", UriParserSemanticException.MessageKeys.EXPRESSION_PROPERTY_NOT_IN_TYPE, name.getFullQualifiedName().getFullQualifiedNameAsString(), type.getFullQualifiedName().getFullQualifiedNameAsString()));
            }
        }
    }

    private EdmEntityType getEntityType(UriInfoResource test) {
        UriResource lastPart;
        List parts = test.getUriResourceParts();
        if (!parts.isEmpty() && (lastPart = (UriResource)parts.get(parts.size() - 1)) instanceof UriResourceEntitySet) {
            UriResourceEntitySet entitySet = (UriResourceEntitySet)lastPart;
            return entitySet.getEntityType();
        }
        return null;
    }

    @Override
    public Object visitExpandPathExtension(UriParserParser.ExpandPathExtensionContext ctx) {
        UriInfoImpl resourcePath;
        UriResourceTypedImpl lastSegment;
        ArrayList<SystemQueryOptionImpl> list = new ArrayList<SystemQueryOptionImpl>();
        EdmType targetType = null;
        boolean isColl = false;
        if (this.context.contextExpandItemPath == null) {
            lastSegment = (UriResourceTypedImpl)this.context.contextUriInfo.getLastResourcePart();
            targetType = this.getTypeInformation((UriResource)lastSegment).type;
            isColl = lastSegment.isCollection();
        } else if (this.context.contextExpandItemPath.getResourcePath() == null) {
            lastSegment = (UriResourceTypedImpl)this.context.contextUriInfo.getLastResourcePart();
            targetType = this.getTypeInformation((UriResource)lastSegment).type;
            isColl = lastSegment.isCollection();
        } else {
            UriInfoImpl info = (UriInfoImpl)this.context.contextExpandItemPath.getResourcePath();
            targetType = this.getTypeInformation((UriResource)info.getLastResourcePart()).type;
            isColl = ((UriResourcePartTyped)info.getLastResourcePart()).isCollection();
        }
        this.context.contextTypes.push(new TypeInformation(targetType, isColl));
        if (ctx.vC != null) {
            resourcePath = (UriInfoImpl)this.context.contextExpandItemPath.getResourcePath();
            resourcePath.addResourcePart(new UriResourceCountImpl());
            for (UriParserParser.ExpandCountOptionContext s : ctx.vlEOC) {
                list.add((SystemQueryOptionImpl)s.accept(this));
            }
        } else if (ctx.vR != null) {
            resourcePath = (UriInfoImpl)this.context.contextExpandItemPath.getResourcePath();
            resourcePath.addResourcePart(new UriResourceRefImpl());
            for (UriParserParser.ExpandRefOptionContext s : ctx.vlEOR) {
                list.add((SystemQueryOptionImpl)s.accept(this));
            }
        } else {
            for (UriParserParser.ExpandOptionContext s : ctx.vlEO) {
                list.add((SystemQueryOptionImpl)s.accept(this));
            }
        }
        this.context.contextTypes.pop();
        return list;
    }

    @Override
    public Object visitFilter(UriParserParser.FilterContext ctx) {
        this.context.contextReadingQueryPart = true;
        FilterOptionImpl result = new FilterOptionImpl().setExpression((ExpressionImpl)((ParseTree)ctx.children.get(2)).accept((ParseTreeVisitor)this));
        this.context.contextReadingQueryPart = false;
        return result;
    }

    @Override
    public Object visitFilterExpressionEOF(UriParserParser.FilterExpressionEOFContext ctx) {
        this.context.contextReadingQueryPart = true;
        FilterOptionImpl result = new FilterOptionImpl().setExpression((ExpressionImpl)((ParseTree)ctx.children.get(0)).accept((ParseTreeVisitor)this));
        this.context.contextReadingQueryPart = false;
        return result;
    }

    @Override
    public ExpressionImpl visitFloorMethodCallExpr(UriParserParser.FloorMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.FLOOR).addParameter((ExpressionImpl)ctx.vE1.accept(this));
    }

    @Override
    public ExpressionImpl visitFractionalsecondsMethodCallExpr(UriParserParser.FractionalsecondsMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.FRACTIONALSECONDS).addParameter((ExpressionImpl)ctx.vE1.accept(this));
    }

    @Override
    public ExpressionImpl visitGeoLengthMethodCallExpr(UriParserParser.GeoLengthMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.GEOLENGTH).addParameter((ExpressionImpl)ctx.vE1.accept(this));
    }

    @Override
    public ExpressionImpl visitHourMethodCallExpr(UriParserParser.HourMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.HOUR).addParameter((ExpressionImpl)ctx.vE1.accept(this));
    }

    @Override
    public ExpressionImpl visitIndexOfMethodCallExpr(UriParserParser.IndexOfMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.INDEXOF).addParameter((ExpressionImpl)ctx.vE1.accept(this)).addParameter((ExpressionImpl)ctx.vE2.accept(this));
    }

    @Override
    public Object visitInlinecount(UriParserParser.InlinecountContext ctx) {
        String text = ((ParseTree)ctx.children.get(2)).getText();
        return new CountOptionImpl().setValue(text.equalsIgnoreCase("true")).setText(text);
    }

    @Override
    public ExpressionImpl visitGeoIntersectsMethodCallExpr(UriParserParser.GeoIntersectsMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.GEOINTERSECTS).addParameter((ExpressionImpl)ctx.vE1.accept(this)).addParameter((ExpressionImpl)ctx.vE2.accept(this));
    }

    @Override
    public ExpressionImpl visitIsofExpr(UriParserParser.IsofExprContext ctx) {
        MethodImpl method = new MethodImpl();
        if (ctx.vE1 != null) {
            ExpressionImpl onExpression = (ExpressionImpl)ctx.vE1.accept(this);
            method.addParameter(onExpression);
        }
        String namespace = ctx.vNS.getText();
        namespace = namespace.substring(0, namespace.length() - 1);
        FullQualifiedName fullName = new FullQualifiedName(namespace, ctx.vODI.getText());
        EdmType type = this.getType(fullName);
        method.setMethod(MethodKind.ISOF);
        method.addParameter(new TypeLiteralImpl().setType(type));
        return method;
    }

    @Override
    public ExpressionImpl visitLengthMethodCallExpr(UriParserParser.LengthMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.LENGTH).addParameter((ExpressionImpl)ctx.vE1.accept(this));
    }

    @Override
    public Object visitLevels(UriParserParser.LevelsContext ctx) {
        LevelsOptionImpl levels = new LevelsOptionImpl();
        String text = ((ParseTree)ctx.children.get(2)).getText();
        if (text.equals("max")) {
            levels.setMax();
        } else {
            levels.setValue(Integer.parseInt(text));
        }
        levels.setText(text);
        return levels;
    }

    @Override
    public ExpressionImpl visitMaxDateTimeMethodCallExpr(UriParserParser.MaxDateTimeMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.MAXDATETIME);
    }

    @Override
    public Object visitMemberExpr(UriParserParser.MemberExprContext ctx) {
        UriInfoImpl uriInfoImplpath = new UriInfoImpl().setKind(UriInfoKind.resource);
        if (this.context.contextTypes.isEmpty()) {
            throw this.wrap(new UriParserSemanticException("Expression '" + ctx.getText() + "' is not allowed as key value.", UriParserSemanticException.MessageKeys.INVALID_KEY_VALUE, ctx.getText()));
        }
        TypeInformation lastTypeInfo = this.context.contextTypes.peek();
        if (ctx.vIt != null || ctx.vIts != null) {
            UriResourceItImpl pathInfoIT = new UriResourceItImpl();
            pathInfoIT.setType(lastTypeInfo.type);
            pathInfoIT.setCollection(lastTypeInfo.isCollection);
            uriInfoImplpath.addResourcePart(pathInfoIT);
        }
        if (ctx.vPs != null) {
            UriInfoImpl backupUriInfoPath = this.context.contextUriInfo;
            this.context.contextUriInfo = uriInfoImplpath;
            ctx.vPs.accept(this);
            this.context.contextUriInfo = backupUriInfoPath;
        }
        if (ctx.vALL != null) {
            uriInfoImplpath.addResourcePart((UriResourceImpl)ctx.vALL.accept(this));
        }
        if (ctx.vANY != null) {
            uriInfoImplpath.addResourcePart((UriResourceImpl)ctx.vANY.accept(this));
        }
        EdmType startType = this.removeUriResourceStartingTypeFilterImpl(uriInfoImplpath);
        MemberImpl ret = new MemberImpl();
        ret.setResourcePath((UriInfoResource)uriInfoImplpath);
        if (startType != null) {
            ret.setTypeFilter(startType);
        }
        return ret;
    }

    @Override
    public ExpressionImpl visitMinDateTimeMethodCallExpr(UriParserParser.MinDateTimeMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.MINDATETIME);
    }

    @Override
    public ExpressionImpl visitMinuteMethodCallExpr(UriParserParser.MinuteMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.MINUTE).addParameter((ExpressionImpl)ctx.vE1.accept(this));
    }

    @Override
    public ExpressionImpl visitMonthMethodCallExpr(UriParserParser.MonthMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.MONTH).addParameter((ExpressionImpl)ctx.vE1.accept(this));
    }

    @Override
    public Object visitNameValueOptList(UriParserParser.NameValueOptListContext ctx) {
        if (ctx.vVO != null) {
            String valueText = ctx.vVO.getText();
            ExpressionImpl expression = null;
            try {
                expression = (ExpressionImpl)ctx.vVO.accept(this);
            }
            catch (RuntimeException runtimeException) {
                throw this.wrap(new UriParserSemanticException("Invalid key value: " + valueText, runtimeException, UriParserSemanticException.MessageKeys.INVALID_KEY_VALUE, valueText));
            }
            UriResource uriResource = this.context.contextUriInfo.getLastResourcePart();
            if (!(uriResource instanceof UriResourcePartTyped)) {
                throw this.wrap(new UriParserSemanticException("Parameters list on untyped resource path segment not allowed", UriParserSemanticException.MessageKeys.PARAMETERS_LIST_ONLY_FOR_TYPED_PARTS, new String[0]));
            }
            if (uriResource instanceof UriResourceFunction) {
                UriResourceFunction uriResourceFunction = (UriResourceFunction)this.context.contextUriInfo.getLastResourcePart();
                EdmReturnType returnType = uriResourceFunction.getFunction().getReturnType();
                if (returnType.getType().getKind() != EdmTypeKind.ENTITY || !returnType.isCollection()) {
                    throw this.wrap(new UriParserSemanticException("No keys allowed", UriParserSemanticException.MessageKeys.KEY_NOT_ALLOWED, new String[0]));
                }
                EdmEntityType entityType = (EdmEntityType)uriResourceFunction.getFunction().getReturnType().getType();
                List lastKeyPredicates = entityType.getKeyPredicateNames();
                if (lastKeyPredicates.size() == 1) {
                    return Collections.singletonList(new UriParameterImpl().setName((String)lastKeyPredicates.get(0)).setText(valueText).setExpression(expression));
                }
                throw this.wrap(new UriParserSemanticException("Wrong number of key properties.", UriParserSemanticException.MessageKeys.WRONG_NUMBER_OF_KEY_PROPERTIES, Integer.toString(lastKeyPredicates.size()), "1"));
            }
            EdmEntityType lastType = (EdmEntityType)((UriResourcePartTyped)uriResource).getType();
            List lastKeyPredicates = lastType.getKeyPredicateNames();
            if (lastKeyPredicates.size() == 1) {
                return Collections.singletonList(new UriParameterImpl().setName((String)lastKeyPredicates.get(0)).setText(valueText).setExpression(expression));
            }
            if (!(this.context.contextUriInfo.getLastResourcePart() instanceof UriResourceNavigationPropertyImpl)) {
                throw this.wrap(new UriParserSemanticException("Wrong number of key properties.", UriParserSemanticException.MessageKeys.WRONG_NUMBER_OF_KEY_PROPERTIES, Integer.toString(lastKeyPredicates.size()), "1"));
            }
            UriResourceNavigationPropertyImpl lastNav = (UriResourceNavigationPropertyImpl)uriResource;
            EdmNavigationProperty partner = lastNav.getProperty().getPartner();
            if (partner == null) {
                throw this.wrap(new UriParserSemanticException("Wrong number of key properties.", UriParserSemanticException.MessageKeys.WRONG_NUMBER_OF_KEY_PROPERTIES, Integer.toString(lastKeyPredicates.size()), "1"));
            }
            ArrayList<UriParameterImpl> list = new ArrayList<UriParameterImpl>();
            String missedKey = null;
            for (String item : lastKeyPredicates) {
                String property = partner.getReferencingPropertyName(item);
                if (property != null) {
                    list.add(new UriParameterImpl().setName(item).setReferencedProperty(property));
                    continue;
                }
                if (missedKey == null) {
                    missedKey = item;
                    continue;
                }
                throw this.wrap(new UriParserSemanticException("Not enough referential constraints defined", UriParserSemanticException.MessageKeys.NOT_ENOUGH_REFERENTIAL_CONSTRAINTS, new String[0]));
            }
            list.add(new UriParameterImpl().setName(missedKey).setText(valueText).setExpression(expression));
            return list;
        }
        if (ctx.vNVL != null) {
            ArrayList<UriParameterImpl> list = new ArrayList<UriParameterImpl>();
            for (ParseTree parseTree : ctx.vNVL.vlNVP) {
                list.add((UriParameterImpl)parseTree.accept((ParseTreeVisitor)this));
            }
            if (this.context.contextReadingFunctionParameters) {
                return list;
            }
            UriResource last = this.context.contextUriInfo.getLastResourcePart();
            if (!(last instanceof UriResourcePartTyped)) {
                throw this.wrap(new UriParserSemanticException("Parameters list on untyped resource path segment not allowed", UriParserSemanticException.MessageKeys.PARAMETERS_LIST_ONLY_FOR_TYPED_PARTS, new String[0]));
            }
            if (last instanceof UriResourceFunction) {
                UriResourceFunction uriResourceFunction = (UriResourceFunction)this.context.contextUriInfo.getLastResourcePart();
                EdmReturnType returnType = uriResourceFunction.getFunction().getReturnType();
                if (returnType.getType().getKind() != EdmTypeKind.ENTITY || !returnType.isCollection()) {
                    throw this.wrap(new UriParserSemanticException("No keys allowed", UriParserSemanticException.MessageKeys.KEY_NOT_ALLOWED, new String[0]));
                }
                EdmEntityType entityType = (EdmEntityType)uriResourceFunction.getFunction().getReturnType().getType();
                List lastKeyPredicates = entityType.getKeyPredicateNames();
                if (lastKeyPredicates.size() == list.size()) {
                    return list;
                }
                throw this.wrap(new UriParserSemanticException("Wrong number of key properties.", UriParserSemanticException.MessageKeys.WRONG_NUMBER_OF_KEY_PROPERTIES, Integer.toString(lastKeyPredicates.size()), "1"));
            }
            EdmEntityType edmEntityType = (EdmEntityType)((UriResourcePartTyped)last).getType();
            List lastKeyPredicates = edmEntityType.getKeyPredicateNames();
            if (list.size() == lastKeyPredicates.size()) {
                return list;
            }
            if (!(this.context.contextUriInfo.getLastResourcePart() instanceof UriResourceNavigationPropertyImpl)) {
                throw this.wrap(new UriParserSemanticException("Wrong number of key properties.", UriParserSemanticException.MessageKeys.WRONG_NUMBER_OF_KEY_PROPERTIES, Integer.toString(lastKeyPredicates.size()), Integer.toString(list.size())));
            }
            UriResourceNavigationPropertyImpl lastNav = (UriResourceNavigationPropertyImpl)last;
            EdmNavigationProperty partner = lastNav.getProperty().getPartner();
            if (partner == null) {
                throw this.wrap(new UriParserSemanticException("Wrong number of key properties.", UriParserSemanticException.MessageKeys.WRONG_NUMBER_OF_KEY_PROPERTIES, Integer.toString(lastKeyPredicates.size()), Integer.toString(list.size())));
            }
            for (String key : lastKeyPredicates) {
                String property;
                boolean found = false;
                for (UriParameterImpl item : list) {
                    if (!item.getName().equals(key)) continue;
                    found = true;
                    break;
                }
                if (found || (property = partner.getReferencingPropertyName(key)) == null) continue;
                list.add(0, new UriParameterImpl().setName(key).setReferencedProperty(property));
            }
            if (list.size() == lastKeyPredicates.size()) {
                return list;
            }
            throw this.wrap(new UriParserSemanticException("Wrong number of key properties.", UriParserSemanticException.MessageKeys.WRONG_NUMBER_OF_KEY_PROPERTIES, Integer.toString(lastKeyPredicates.size()), Integer.toString(list.size())));
        }
        if (this.context.contextReadingFunctionParameters) {
            return Collections.emptyList();
        }
        UriResource last = this.context.contextUriInfo.getLastResourcePart();
        int number = last instanceof UriResourcePartTyped ? ((EdmEntityType)((UriResourcePartTyped)last).getType()).getKeyPredicateNames().size() : 0;
        throw this.wrap(new UriParserSemanticException("Wrong number of key properties.", UriParserSemanticException.MessageKeys.WRONG_NUMBER_OF_KEY_PROPERTIES, Integer.toString(number), "0"));
    }

    @Override
    public UriParameterImpl visitNameValuePair(UriParserParser.NameValuePairContext ctx) {
        UriParameterImpl uriParameter = new UriParameterImpl();
        uriParameter.setName(ctx.vODI.getText());
        if (ctx.vCOM != null) {
            String text = ctx.vCOM.getText();
            uriParameter.setText("null".equals(text) ? null : text);
            uriParameter.setExpression((ExpressionImpl)ctx.vCOM.accept(this));
        } else {
            uriParameter.setAlias("@" + ctx.vALI.getText());
        }
        return uriParameter;
    }

    @Override
    public Object visitNaninfinityLiteral(UriParserParser.NaninfinityLiteralContext ctx) {
        return new LiteralImpl().setType((EdmType)EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Decimal)).setText(ctx.getText());
    }

    @Override
    public ExpressionImpl visitNowMethodCallExpr(UriParserParser.NowMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.NOW);
    }

    @Override
    public Object visitNullruleLiteral(UriParserParser.NullruleLiteralContext ctx) {
        return new LiteralImpl().setText("null");
    }

    @Override
    public Object visitOrderBy(UriParserParser.OrderByContext ctx) {
        OrderByOptionImpl orderBy = new OrderByOptionImpl();
        for (UriParserParser.OrderByItemContext item : ((UriParserParser.OrderListContext)ctx.getChild((int)2)).vlOI) {
            OrderByItemImpl oItem = (OrderByItemImpl)item.accept(this);
            orderBy.addOrder(oItem);
        }
        return orderBy;
    }

    @Override
    public Object visitOrderByEOF(UriParserParser.OrderByEOFContext ctx) {
        this.context.contextReadingQueryPart = true;
        OrderByOptionImpl orderBy = new OrderByOptionImpl();
        for (UriParserParser.OrderByItemContext item : ((UriParserParser.OrderListContext)ctx.getChild((int)0)).vlOI) {
            OrderByItemImpl oItem = (OrderByItemImpl)item.accept(this);
            orderBy.addOrder(oItem);
        }
        this.context.contextReadingFunctionParameters = false;
        return orderBy;
    }

    @Override
    public Object visitOrderByItem(UriParserParser.OrderByItemContext ctx) {
        OrderByItemImpl oItem = new OrderByItemImpl();
        if (ctx.vD != null) {
            oItem.setDescending(true);
        }
        oItem.setExpression((ExpressionImpl)ctx.vC.accept(this));
        return oItem;
    }

    @Override
    public Object visitPathSegment(UriParserParser.PathSegmentContext ctx) {
        this.readResourcePathSegment(ctx);
        UriResourceImpl pathInfoSegment = (UriResourceImpl)this.context.contextUriInfo.getLastResourcePart();
        if (ctx.vlNVO.size() > 0) {
            if (pathInfoSegment instanceof UriResourceWithKeysImpl) {
                if (ctx.vlNVO.size() > 1) {
                    throw this.wrap(new UriParserSemanticException("More than one key predicates found", UriParserSemanticException.MessageKeys.WRONG_NUMBER_OF_KEY_PROPERTIES, "1", Integer.toString(ctx.vlNVO.size())));
                }
                List list = (List)ctx.vlNVO.get(0).accept(this);
                ((UriResourceWithKeysImpl)pathInfoSegment).setKeyPredicates(list);
            } else {
                throw this.wrap(new UriParserSemanticException("Key properties not allowed", UriParserSemanticException.MessageKeys.KEY_NOT_ALLOWED, new String[0]));
            }
        }
        return pathInfoSegment;
    }

    @Override
    public Object visitPathSegments(UriParserParser.PathSegmentsContext ctx) {
        for (UriParserParser.PathSegmentContext it : ctx.vlPS) {
            it.accept(this);
        }
        if (ctx.vCS != null) {
            ctx.vCS.accept(this);
        }
        return null;
    }

    @Override
    public Object visitPrimitiveLiteral(UriParserParser.PrimitiveLiteralContext ctx) {
        ParseTree child1 = (ParseTree)ctx.children.get(0);
        if (child1 instanceof UriParserParser.EnumLiteralContext || child1 instanceof UriParserParser.BooleanNonCaseLiteralContext || child1 instanceof UriParserParser.NullruleLiteralContext || child1 instanceof UriParserParser.NaninfinityLiteralContext || child1 instanceof UriParserParser.StringLiteralContext || child1 instanceof UriParserParser.IntLiteralContext || child1 instanceof UriParserParser.BinaryLiteralContext || child1 instanceof UriParserParser.DateLiteralContext || child1 instanceof UriParserParser.DatetimeoffsetLiteralContext || child1 instanceof UriParserParser.DurationLiteralContext || child1 instanceof UriParserParser.GuidLiteralContext || child1 instanceof UriParserParser.TimeofdayLiteralContext || child1 instanceof UriParserParser.DecimalLiteralContext || child1 instanceof UriParserParser.BinaryLiteralContext) {
            return child1.accept((ParseTreeVisitor)this);
        }
        return new LiteralImpl().setText(ctx.getText());
    }

    @Override
    public Object visitBinaryLiteral(UriParserParser.BinaryLiteralContext ctx) {
        return new LiteralImpl().setText(ctx.getText()).setType((EdmType)EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Binary));
    }

    @Override
    public Object visitStringLiteral(UriParserParser.StringLiteralContext ctx) {
        return new LiteralImpl().setText(ctx.getText()).setType((EdmType)EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.String));
    }

    @Override
    public Object visitDecimalLiteral(UriParserParser.DecimalLiteralContext ctx) {
        EdmPrimitiveType type = EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)(ctx.getText().contains("e") || ctx.getText().contains("E") ? EdmPrimitiveTypeKind.Double : EdmPrimitiveTypeKind.Decimal));
        return new LiteralImpl().setText(ctx.getText()).setType((EdmType)type);
    }

    @Override
    public Object visitIntLiteral(UriParserParser.IntLiteralContext ctx) {
        EdmPrimitiveTypeKind typeKind = null;
        try {
            long value = Long.parseLong(ctx.getText());
            typeKind = value >= -128L && value <= 127L ? EdmPrimitiveTypeKind.SByte : (value >= 0L && value <= 255L ? EdmPrimitiveTypeKind.Byte : (value >= -32768L && value <= 32767L ? EdmPrimitiveTypeKind.Int16 : (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE ? EdmPrimitiveTypeKind.Int32 : EdmPrimitiveTypeKind.Int64)));
        }
        catch (NumberFormatException e) {
            return new LiteralImpl().setText(ctx.getText()).setType((EdmType)EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Decimal));
        }
        return new LiteralImpl().setText(ctx.getText()).setType((EdmType)EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)typeKind));
    }

    @Override
    public Object visitDateLiteral(UriParserParser.DateLiteralContext ctx) {
        return new LiteralImpl().setText(ctx.getText()).setType((EdmType)EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Date));
    }

    @Override
    public Object visitDatetimeoffsetLiteral(UriParserParser.DatetimeoffsetLiteralContext ctx) {
        return new LiteralImpl().setText(ctx.getText()).setType((EdmType)EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.DateTimeOffset));
    }

    @Override
    public Object visitDurationLiteral(UriParserParser.DurationLiteralContext ctx) {
        return new LiteralImpl().setText(ctx.getText()).setType((EdmType)EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Duration));
    }

    @Override
    public Object visitGuidLiteral(UriParserParser.GuidLiteralContext ctx) {
        return new LiteralImpl().setText(ctx.getText()).setType((EdmType)EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Guid));
    }

    @Override
    public Object visitTimeofdayLiteral(UriParserParser.TimeofdayLiteralContext ctx) {
        return new LiteralImpl().setText(ctx.getText()).setType((EdmType)EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.TimeOfDay));
    }

    @Override
    public Object visitQueryOptions(UriParserParser.QueryOptionsContext ctx) {
        ArrayList<QueryOptionImpl> qpList = new ArrayList<QueryOptionImpl>();
        for (UriParserParser.QueryOptionContext entityOption : ctx.vlQO) {
            qpList.add((QueryOptionImpl)entityOption.accept(this));
        }
        return qpList;
    }

    @Override
    public Object visitRootExpr(UriParserParser.RootExprContext ctx) {
        UriResource lastResource = this.context.contextUriInfo.getLastResourcePart();
        if (!(lastResource instanceof UriResourcePartTyped)) {
            throw this.wrap(new UriParserSemanticException("Resource path not typed", UriParserSemanticException.MessageKeys.RESOURCE_PATH_NOT_TYPED, new String[0]));
        }
        UriResourcePartTyped lastType = (UriResourcePartTyped)lastResource;
        UriResourceRootImpl pathInfoRoot = new UriResourceRootImpl();
        pathInfoRoot.setCollection(lastType.isCollection());
        pathInfoRoot.setType(this.getTypeInformation((UriResource)lastType).type);
        UriInfoImpl uriInfoImplpath = new UriInfoImpl().setKind(UriInfoKind.resource);
        uriInfoImplpath.addResourcePart(pathInfoRoot);
        if (ctx.vPs != null) {
            UriInfoImpl backupUriInfoPath = this.context.contextUriInfo;
            this.context.contextUriInfo = uriInfoImplpath;
            ctx.vPs.accept(this);
            this.context.contextUriInfo = backupUriInfoPath;
        }
        return new MemberImpl().setResourcePath((UriInfoResource)uriInfoImplpath);
    }

    @Override
    public ExpressionImpl visitRoundMethodCallExpr(UriParserParser.RoundMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.ROUND).addParameter((ExpressionImpl)ctx.vE1.accept(this));
    }

    @Override
    public ExpressionImpl visitSecondMethodCallExpr(UriParserParser.SecondMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.SECOND).addParameter((ExpressionImpl)ctx.vE1.accept(this));
    }

    @Override
    public Object visitSelect(UriParserParser.SelectContext ctx) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (UriParserParser.SelectItemContext si : ctx.vlSI) {
            selectItems.add((SelectItem)si.accept(this));
        }
        return new SelectOptionImpl().setSelectItems(selectItems).setText(((ParseTree)ctx.children.get(2)).getText());
    }

    @Override
    public Object visitSelectEOF(UriParserParser.SelectEOFContext ctx) {
        this.context.contextReadingQueryPart = true;
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (UriParserParser.SelectItemContext si : ctx.vlSI) {
            selectItems.add((SelectItem)si.accept(this));
        }
        QueryOptionImpl result = new SelectOptionImpl().setSelectItems(selectItems).setText(ctx.getText());
        this.context.contextReadingQueryPart = false;
        return result;
    }

    @Override
    public Object visitSelectItem(UriParserParser.SelectItemContext ctx) {
        SelectItemImpl selectItem;
        this.context.contextSelectItem = selectItem = new SelectItemImpl();
        for (UriParserParser.SelectSegmentContext si : ctx.vlSS) {
            si.accept(this);
        }
        this.context.contextSelectItem = null;
        return selectItem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object visitSelectSegment(UriParserParser.SelectSegmentContext ctx) {
        EdmFunction function;
        EdmType prevType;
        if (ctx.vS != null) {
            if (ctx.vNS != null) {
                String namespace = ctx.vNS.getText();
                namespace = namespace.substring(0, namespace.length() - 1);
                FullQualifiedName fullName = new FullQualifiedName(namespace, "*");
                this.context.contextSelectItem.addAllOperationsInSchema(fullName);
                return null;
            } else {
                this.context.contextSelectItem.setStar(true);
            }
            return null;
        }
        String odi = ctx.vODI.getText();
        if (ctx.vNS == null) {
            EdmType prevType2 = null;
            if (this.context.contextSelectItem.getResourcePath() == null) {
                prevType2 = this.context.contextTypes.peek().type;
            } else {
                UriInfoImpl uriInfo = (UriInfoImpl)this.context.contextSelectItem.getResourcePath();
                UriResource last = uriInfo.getLastResourcePart();
                prevType2 = this.getTypeInformation((UriResource)last).type;
                if (prevType2 == null) {
                    throw this.wrap(new UriParserSemanticException("prev segment not typed", UriParserSemanticException.MessageKeys.ONLY_FOR_TYPED_PARTS, "select"));
                }
            }
            if (!(prevType2 instanceof EdmStructuredType)) {
                throw this.wrap(new UriParserSemanticException("Previous select item is not a structural type", UriParserSemanticException.MessageKeys.ONLY_FOR_STRUCTURAL_TYPES, "select"));
            }
            EdmStructuredType structType = (EdmStructuredType)prevType2;
            EdmElement element = structType.getProperty(odi);
            if (element == null) {
                throw this.wrap(new UriParserSemanticException("Previous select item has not property: " + odi, UriParserSemanticException.MessageKeys.EXPRESSION_PROPERTY_NOT_IN_TYPE, structType.getName(), odi));
            }
            if (!(element instanceof EdmProperty)) throw this.wrap(new UriParserSemanticException("Only Simple and Complex properties within select allowed", UriParserSemanticException.MessageKeys.ONLY_SIMPLE_AND_COMPLEX_PROPERTIES_IN_SELECT, new String[0]));
            EdmProperty property = (EdmProperty)element;
            if (property.isPrimitive() || property.getType().getKind() == EdmTypeKind.ENUM || property.getType().getKind() == EdmTypeKind.DEFINITION) {
                UriResourcePrimitivePropertyImpl simple = new UriResourcePrimitivePropertyImpl();
                simple.setProperty(property);
                UriInfoImpl uriInfo = (UriInfoImpl)this.context.contextSelectItem.getResourcePath();
                if (uriInfo == null) {
                    uriInfo = new UriInfoImpl().setKind(UriInfoKind.resource);
                    uriInfo.addResourcePart(simple);
                    EdmType startType = this.removeUriResourceStartingTypeFilterImpl(uriInfo);
                    if (startType != null) {
                        this.context.contextSelectItem.setTypeFilter(startType);
                    }
                    this.context.contextSelectItem.setResourcePath((UriInfoResource)uriInfo);
                    return this;
                } else {
                    uriInfo.addResourcePart(simple);
                }
                return this;
            }
            UriInfoImpl uriInfo = (UriInfoImpl)this.context.contextSelectItem.getResourcePath();
            UriResourceComplexPropertyImpl complex = new UriResourceComplexPropertyImpl();
            complex.setProperty(property);
            if (uriInfo == null) {
                uriInfo = new UriInfoImpl().setKind(UriInfoKind.resource);
                uriInfo.addResourcePart(complex);
                EdmType startType = this.removeUriResourceStartingTypeFilterImpl(uriInfo);
                if (startType != null) {
                    this.context.contextSelectItem.setTypeFilter(startType);
                }
                this.context.contextSelectItem.setResourcePath((UriInfoResource)uriInfo);
                return this;
            } else {
                uriInfo.addResourcePart(complex);
            }
            return this;
        }
        String namespace = ctx.vNS.getText();
        namespace = namespace.substring(0, namespace.length() - 1);
        FullQualifiedName fullName = new FullQualifiedName(namespace, odi);
        if (this.context.contextSelectItem.getResourcePath() == null) {
            prevType = this.context.contextTypes.peek().type;
            if (prevType instanceof EdmComplexType) {
                EdmComplexType ct = this.edm.getComplexType(fullName);
                if (ct != null && ct.compatibleTo(prevType)) {
                    UriResourceStartingTypeFilterImpl resourcePart = new UriResourceStartingTypeFilterImpl();
                    resourcePart.setCollectionTypeFilter((EdmType)ct);
                    UriInfoImpl uriInfo = new UriInfoImpl().setKind(UriInfoKind.resource);
                    uriInfo.addResourcePart(resourcePart);
                    EdmType startType = this.removeUriResourceStartingTypeFilterImpl(uriInfo);
                    if (startType != null) {
                        this.context.contextSelectItem.setTypeFilter(startType);
                    }
                    this.context.contextSelectItem.setResourcePath((UriInfoResource)uriInfo);
                    return this;
                }
            } else {
                if (!(prevType instanceof EdmEntityType)) throw this.wrap(new UriParserSemanticException("prev segment must be complex of entity type", UriParserSemanticException.MessageKeys.COMPLEX_PROPERTY_OF_ENTITY_TYPE_EXPECTED, new String[0]));
                EdmEntityType et = this.edm.getEntityType(fullName);
                if (et != null && et.compatibleTo(prevType)) {
                    UriResourceStartingTypeFilterImpl resourcePart = new UriResourceStartingTypeFilterImpl();
                    resourcePart.setCollectionTypeFilter((EdmType)et);
                    UriInfoImpl uriInfo = new UriInfoImpl().setKind(UriInfoKind.resource);
                    uriInfo.addResourcePart(resourcePart);
                    EdmType startType = this.removeUriResourceStartingTypeFilterImpl(uriInfo);
                    if (startType != null) {
                        this.context.contextSelectItem.setTypeFilter(startType);
                    }
                    this.context.contextSelectItem.setResourcePath((UriInfoResource)uriInfo);
                    return this;
                }
            }
        } else {
            UriInfoImpl uriInfo = (UriInfoImpl)this.context.contextSelectItem.getResourcePath();
            UriResource last = uriInfo.getLastResourcePart();
            if (!(last instanceof UriResourceTypedImpl)) {
                throw this.wrap(new UriParserSemanticException("prev segment typed", UriParserSemanticException.MessageKeys.ONLY_FOR_TYPED_PARTS, "select"));
            }
            EdmType prevType3 = this.getTypeInformation((UriResource)last).type;
            if (prevType3 instanceof EdmComplexType) {
                EdmComplexType ct = this.edm.getComplexType(fullName);
                if (ct != null && ct.compatibleTo(prevType3)) {
                    UriResourceStartingTypeFilterImpl resourcePart = new UriResourceStartingTypeFilterImpl();
                    resourcePart.setCollectionTypeFilter((EdmType)ct);
                    uriInfo.addResourcePart(resourcePart);
                    return this;
                }
            } else {
                if (!(prevType3 instanceof EdmEntityType)) throw this.wrap(new UriParserSemanticException("prev segment must be complex of entity type", UriParserSemanticException.MessageKeys.COMPLEX_PROPERTY_OF_ENTITY_TYPE_EXPECTED, new String[0]));
                throw this.wrap(new UriParserSemanticException("Error", UriParserSemanticException.MessageKeys.NOT_FOR_ENTITY_TYPE, new String[0]));
            }
        }
        prevType = null;
        if (this.context.contextSelectItem.getResourcePath() == null) {
            prevType = this.context.contextTypes.peek().type;
        } else {
            UriInfoImpl uriInfo = (UriInfoImpl)this.context.contextSelectItem.getResourcePath();
            UriResource last = uriInfo.getLastResourcePart();
            if (!(last instanceof UriResourceTypedImpl)) {
                throw this.wrap(new UriParserSemanticException("prev segment typed", UriParserSemanticException.MessageKeys.PREVIOUS_PART_TYPED, new String[0]));
            }
            prevType = this.getTypeInformation((UriResource)last).type;
        }
        FullQualifiedName finalTypeName = prevType.getFullQualifiedName();
        EdmAction action = this.edm.getBoundAction(fullName, finalTypeName, null);
        if (action != null) {
            UriResourceActionImpl uriAction = new UriResourceActionImpl();
            uriAction.setAction(action);
            UriInfoImpl resourcePath = (UriInfoImpl)this.context.contextSelectItem.getResourcePath();
            resourcePath.addResourcePart(uriAction);
        }
        if ((function = this.edm.getBoundFunction(fullName, finalTypeName, null, null)) == null) return null;
        UriResourceFunctionImpl uriFunction = new UriResourceFunctionImpl();
        uriFunction.setFunction(function);
        UriInfoImpl resourcePath = (UriInfoImpl)this.context.contextSelectItem.getResourcePath();
        resourcePath.addResourcePart(uriFunction);
        return null;
    }

    @Override
    public Object visitSkip(UriParserParser.SkipContext ctx) {
        String text = ((ParseTree)ctx.children.get(2)).getText();
        return new SkipOptionImpl().setValue(Integer.parseInt(text)).setText(text);
    }

    @Override
    public Object visitSkiptoken(UriParserParser.SkiptokenContext ctx) {
        String text = ((ParseTree)ctx.children.get(2)).getText();
        return new SkipTokenOptionImpl().setValue(text).setText(text);
    }

    @Override
    public ExpressionImpl visitStartsWithMethodCallExpr(UriParserParser.StartsWithMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.STARTSWITH).addParameter((ExpressionImpl)ctx.vE1.accept(this)).addParameter((ExpressionImpl)ctx.vE2.accept(this));
    }

    @Override
    public ExpressionImpl visitSubstringMethodCallExpr(UriParserParser.SubstringMethodCallExprContext ctx) {
        MethodImpl ret = new MethodImpl();
        ret.setMethod(MethodKind.SUBSTRING);
        ret.addParameter((ExpressionImpl)ctx.vE1.accept(this));
        ret.addParameter((ExpressionImpl)ctx.vE2.accept(this));
        if (ctx.vE3 != null) {
            ret.addParameter((ExpressionImpl)ctx.vE3.accept(this));
        }
        return ret;
    }

    @Override
    public ExpressionImpl visitTimeMethodCallExpr(UriParserParser.TimeMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.TIME).addParameter((ExpressionImpl)ctx.vE1.accept(this));
    }

    @Override
    public Object visitTop(UriParserParser.TopContext ctx) {
        String text = ((ParseTree)ctx.children.get(2)).getText();
        return new TopOptionImpl().setValue(Integer.parseInt(text)).setText(text);
    }

    @Override
    public ExpressionImpl visitToLowerMethodCallExpr(UriParserParser.ToLowerMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.TOLOWER).addParameter((ExpressionImpl)ctx.vE1.accept(this));
    }

    @Override
    public ExpressionImpl visitTotalOffsetMinutesMethodCallExpr(UriParserParser.TotalOffsetMinutesMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.TOTALOFFSETMINUTES).addParameter((ExpressionImpl)ctx.vE1.accept(this));
    }

    @Override
    public ExpressionImpl visitTotalsecondsMethodCallExpr(UriParserParser.TotalsecondsMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.TOTALSECONDS).addParameter((ExpressionImpl)ctx.vE1.accept(this));
    }

    @Override
    public ExpressionImpl visitToUpperMethodCallExpr(UriParserParser.ToUpperMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.TOUPPER).addParameter((ExpressionImpl)ctx.vE1.accept(this));
    }

    @Override
    public ExpressionImpl visitTrimMethodCallExpr(UriParserParser.TrimMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.TRIM).addParameter((ExpressionImpl)ctx.vE1.accept(this));
    }

    @Override
    public ExpressionImpl visitYearMethodCallExpr(UriParserParser.YearMethodCallExprContext ctx) {
        return new MethodImpl().setMethod(MethodKind.YEAR).addParameter((ExpressionImpl)ctx.vE1.accept(this));
    }

    private ParseCancellationException wrap(UriParserException uriParserException) {
        return new ParseCancellationException((Throwable)((Object)uriParserException));
    }

    @Override
    public ExpressionImpl visitAltUnary(@NotNull UriParserParser.AltUnaryContext ctx) {
        UnaryImpl unary = new UnaryImpl();
        unary.setOperator(ctx.unary().NOT() == null ? UnaryOperatorKind.MINUS : UnaryOperatorKind.NOT);
        unary.setOperand((ExpressionImpl)ctx.commonExpr().accept(this));
        return unary;
    }

    @Override
    public ExpressionImpl visitAltAlias(@NotNull UriParserParser.AltAliasContext ctx) {
        AliasImpl alias = new AliasImpl();
        alias.setParameter("@" + ctx.odataIdentifier().getChild(0).getText());
        return alias;
    }

    @Override
    public Object visitSearchSpecialToken(UriParserParser.SearchSpecialTokenContext ctx) {
        throw this.wrap(new UriParserSemanticException("System query option '$search' not implemented!", UriParserSemanticException.MessageKeys.NOT_IMPLEMENTED, "System query option '$search"));
    }

    @Override
    public Object visitArrayOrObject(UriParserParser.ArrayOrObjectContext ctx) {
        if (!this.context.contextReadingQueryPart) {
            throw this.wrap(new UriParserSemanticException("Complex parameter are not allowed in resource path", UriParserSemanticException.MessageKeys.COMPLEX_PARAMETER_IN_RESOURCE_PATH, ctx.getText()));
        }
        return new LiteralImpl().setText(ctx.getText()).setType(null);
    }

    @Override
    public Object visitExpandItemsEOF(UriParserParser.ExpandItemsEOFContext ctx) {
        this.context.contextReadingQueryPart = true;
        Object result = super.visitExpandItemsEOF(ctx);
        this.context.contextReadingQueryPart = false;
        return result;
    }

    public class TypeInformation {
        boolean isCollection;
        EdmType type;

        TypeInformation(EdmType type, boolean isCollection) {
            this.type = type;
            this.isCollection = isCollection;
        }

        public TypeInformation() {
        }
    }
}

