/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.util.Collection;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.edmx.EdmxReference;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataHandler;
import org.apache.olingo.server.api.ODataHttpHandler;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.debug.DebugResponseHelper;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.deserializer.FixedFormatDeserializer;
import org.apache.olingo.server.api.deserializer.ODataDeserializer;
import org.apache.olingo.server.api.etag.ETagHelper;
import org.apache.olingo.server.api.etag.ServiceMetadataETagSupport;
import org.apache.olingo.server.api.prefer.Preferences;
import org.apache.olingo.server.api.serializer.FixedFormatSerializer;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriHelper;
import org.apache.olingo.server.core.ODataHandlerImpl;
import org.apache.olingo.server.core.ODataHttpHandlerImpl;
import org.apache.olingo.server.core.ServiceMetadataImpl;
import org.apache.olingo.server.core.debug.DebugResponseHelperImpl;
import org.apache.olingo.server.core.debug.ServerCoreDebugger;
import org.apache.olingo.server.core.deserializer.FixedFormatDeserializerImpl;
import org.apache.olingo.server.core.deserializer.json.ODataJsonDeserializer;
import org.apache.olingo.server.core.deserializer.xml.ODataXmlDeserializer;
import org.apache.olingo.server.core.etag.ETagHelperImpl;
import org.apache.olingo.server.core.prefer.PreferencesImpl;
import org.apache.olingo.server.core.serializer.AbstractODataSerializer;
import org.apache.olingo.server.core.serializer.FixedFormatSerializerImpl;
import org.apache.olingo.server.core.serializer.json.ODataJsonSerializer;
import org.apache.olingo.server.core.serializer.xml.ODataXmlSerializer;
import org.apache.olingo.server.core.uri.UriHelperImpl;

public class ODataImpl
extends OData {
    public ODataSerializer createSerializer(ContentType contentType) throws SerializerException {
        AbstractODataSerializer serializer = null;
        if (contentType.isCompatible(ContentType.APPLICATION_JSON)) {
            String metadata = contentType.getParameter("odata.metadata");
            if (metadata == null || "minimal".equals(metadata) || "none".equals(metadata)) {
                serializer = new ODataJsonSerializer(contentType);
            }
        } else if (contentType.isCompatible(ContentType.APPLICATION_XML) || contentType.isCompatible(ContentType.APPLICATION_ATOM_XML)) {
            serializer = new ODataXmlSerializer();
        }
        if (serializer == null) {
            throw new SerializerException("Unsupported format: " + contentType.toContentTypeString(), (ODataLibraryException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_FORMAT, new String[]{contentType.toContentTypeString()});
        }
        return serializer;
    }

    public FixedFormatSerializer createFixedFormatSerializer() {
        return new FixedFormatSerializerImpl();
    }

    public ODataHttpHandler createHandler(ServiceMetadata serviceMetadata) {
        return new ODataHttpHandlerImpl(this, serviceMetadata);
    }

    public ODataHandler createRawHandler(ServiceMetadata serviceMetadata) {
        return new ODataHandlerImpl(this, serviceMetadata, new ServerCoreDebugger(this));
    }

    public ServiceMetadata createServiceMetadata(CsdlEdmProvider edmProvider, List<EdmxReference> references) {
        return this.createServiceMetadata(edmProvider, references, null);
    }

    public ServiceMetadata createServiceMetadata(CsdlEdmProvider edmProvider, List<EdmxReference> references, ServiceMetadataETagSupport serviceMetadataETagSupport) {
        return new ServiceMetadataImpl(edmProvider, references, serviceMetadataETagSupport);
    }

    public FixedFormatDeserializer createFixedFormatDeserializer() {
        return new FixedFormatDeserializerImpl();
    }

    public UriHelper createUriHelper() {
        return new UriHelperImpl();
    }

    public ODataDeserializer createDeserializer(ContentType contentType) throws DeserializerException {
        if (contentType.isCompatible(ContentType.JSON)) {
            return new ODataJsonDeserializer(contentType);
        }
        if (contentType.isCompatible(ContentType.APPLICATION_XML) || contentType.isCompatible(ContentType.APPLICATION_ATOM_XML)) {
            return new ODataXmlDeserializer();
        }
        throw new DeserializerException("Unsupported format: " + contentType.toContentTypeString(), (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNSUPPORTED_FORMAT, new String[]{contentType.toContentTypeString()});
    }

    public ODataDeserializer createDeserializer(ContentType contentType, ServiceMetadata metadata) throws DeserializerException {
        if (contentType.isCompatible(ContentType.JSON)) {
            return new ODataJsonDeserializer(contentType, metadata);
        }
        if (contentType.isCompatible(ContentType.APPLICATION_XML) || contentType.isCompatible(ContentType.APPLICATION_ATOM_XML)) {
            return new ODataXmlDeserializer(metadata);
        }
        throw new DeserializerException("Unsupported format: " + contentType.toContentTypeString(), (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNSUPPORTED_FORMAT, new String[]{contentType.toContentTypeString()});
    }

    public EdmPrimitiveType createPrimitiveTypeInstance(EdmPrimitiveTypeKind kind) {
        return EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)kind);
    }

    public ETagHelper createETagHelper() {
        return new ETagHelperImpl();
    }

    public Preferences createPreferences(Collection<String> preferHeaders) {
        return new PreferencesImpl(preferHeaders);
    }

    public DebugResponseHelper createDebugResponseHelper(String debugFormat) {
        return new DebugResponseHelperImpl(debugFormat);
    }
}

