/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.debug;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoKind;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.FilterOption;
import org.apache.olingo.server.api.uri.queryoption.OrderByItem;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.QueryOption;
import org.apache.olingo.server.api.uri.queryoption.SearchOption;
import org.apache.olingo.server.api.uri.queryoption.SelectItem;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.api.uri.queryoption.SkipOption;
import org.apache.olingo.server.api.uri.queryoption.TopOption;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;
import org.apache.olingo.server.api.uri.queryoption.search.SearchExpression;
import org.apache.olingo.server.core.debug.DebugResponseHelperImpl;
import org.apache.olingo.server.core.debug.DebugTab;
import org.apache.olingo.server.core.debug.ExpressionJsonVisitor;

public class DebugTabUri
implements DebugTab {
    private final UriInfo uriInfo;

    public DebugTabUri(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    @Override
    public String getName() {
        return "URI";
    }

    @Override
    public void appendJson(JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("kind", this.uriInfo.getKind().name());
        if (this.uriInfo.getKind() == UriInfoKind.resource) {
            gen.writeFieldName("uriResourceParts");
            this.appendURIResourceParts(gen, this.uriInfo.getUriResourceParts());
        }
        if (this.uriInfo.getFormatOption() != null) {
            gen.writeStringField("format", this.uriInfo.getFormatOption().getFormat());
        }
        if (this.uriInfo.getIdOption() != null) {
            gen.writeStringField("id", this.uriInfo.getIdOption().getValue());
        }
        if (this.uriInfo.getSkipTokenOption() != null) {
            gen.writeStringField("skiptoken", this.uriInfo.getSkipTokenOption().getValue());
        }
        this.appendCommonJsonObjects(gen, this.uriInfo.getCountOption(), this.uriInfo.getSkipOption(), this.uriInfo.getTopOption(), this.uriInfo.getFilterOption(), this.uriInfo.getOrderByOption(), this.uriInfo.getSelectOption(), this.uriInfo.getExpandOption(), this.uriInfo.getSearchOption());
        if (!this.uriInfo.getAliases().isEmpty()) {
            gen.writeFieldName("aliases");
            DebugResponseHelperImpl.appendJsonTable(gen, this.getQueryOptionsMap(this.uriInfo.getAliases()));
        }
        if (!this.uriInfo.getCustomQueryOptions().isEmpty()) {
            gen.writeFieldName("customQueryOptions");
            DebugResponseHelperImpl.appendJsonTable(gen, this.getQueryOptionsMap(this.uriInfo.getCustomQueryOptions()));
        }
        gen.writeEndObject();
    }

    private void appendCommonJsonObjects(JsonGenerator gen, CountOption countOption, SkipOption skipOption, TopOption topOption, FilterOption filterOption, OrderByOption orderByOption, SelectOption selectOption, ExpandOption expandOption, SearchOption searchOption) throws IOException {
        if (countOption != null) {
            gen.writeBooleanField("isCount", countOption.getValue());
        }
        if (skipOption != null) {
            gen.writeNumberField("skip", skipOption.getValue());
        }
        if (topOption != null) {
            gen.writeNumberField("top", topOption.getValue());
        }
        if (filterOption != null) {
            gen.writeFieldName("filter");
            this.appendExpressionJson(gen, filterOption.getExpression());
        }
        if (orderByOption != null && !orderByOption.getOrders().isEmpty()) {
            gen.writeFieldName("orderby");
            gen.writeStartObject();
            gen.writeStringField("nodeType", "orderCollection");
            gen.writeFieldName("orders");
            this.appendOrderByItemsJson(gen, orderByOption.getOrders());
            gen.writeEndObject();
        }
        if (selectOption != null && !selectOption.getSelectItems().isEmpty()) {
            gen.writeFieldName("select");
            this.appendSelectedPropertiesJson(gen, selectOption.getSelectItems());
        }
        if (expandOption != null && !expandOption.getExpandItems().isEmpty()) {
            gen.writeFieldName("expand");
            this.appendExpandedPropertiesJson(gen, expandOption.getExpandItems());
        }
        if (searchOption != null) {
            gen.writeFieldName("search");
            this.appendSearchJson(gen, searchOption.getSearchExpression());
        }
    }

    private void appendURIResourceParts(JsonGenerator gen, List<UriResource> uriResourceParts) throws IOException {
        gen.writeStartArray();
        for (UriResource resource : uriResourceParts) {
            gen.writeStartObject();
            gen.writeStringField("uriResourceKind", resource.getKind().toString());
            gen.writeStringField("segment", resource.toString());
            if (resource instanceof UriResourcePartTyped && ((UriResourcePartTyped)resource).getType() != null) {
                gen.writeStringField("type", ((UriResourcePartTyped)resource).getType().getFullQualifiedName().getFullQualifiedNameAsString());
            }
            if (resource instanceof UriResourceEntitySet) {
                this.appendParameters(gen, "keys", ((UriResourceEntitySet)resource).getKeyPredicates());
            } else if (resource instanceof UriResourceNavigation) {
                this.appendParameters(gen, "keys", ((UriResourceNavigation)resource).getKeyPredicates());
            } else if (resource instanceof UriResourceFunction) {
                this.appendParameters(gen, "parameters", ((UriResourceFunction)resource).getParameters());
                this.appendParameters(gen, "keys", ((UriResourceFunction)resource).getKeyPredicates());
            }
            gen.writeEndObject();
        }
        gen.writeEndArray();
    }

    private void appendParameters(JsonGenerator gen, String name, List<UriParameter> parameters) throws IOException {
        if (!parameters.isEmpty()) {
            LinkedHashMap<String, String> parameterMap = new LinkedHashMap<String, String>();
            for (UriParameter parameter : parameters) {
                parameterMap.put(parameter.getName(), parameter.getText() == null ? parameter.getAlias() : parameter.getText());
            }
            gen.writeFieldName(name);
            DebugResponseHelperImpl.appendJsonTable(gen, parameterMap);
        }
    }

    private void appendOrderByItemsJson(JsonGenerator gen, List<OrderByItem> orders) throws IOException {
        gen.writeStartArray();
        for (OrderByItem item : orders) {
            gen.writeStartObject();
            gen.writeStringField("nodeType", "order");
            gen.writeStringField("sortorder", item.isDescending() ? "desc" : "asc");
            gen.writeFieldName("expression");
            this.appendExpressionJson(gen, item.getExpression());
            gen.writeEndObject();
        }
        gen.writeEndArray();
    }

    private void appendExpandedPropertiesJson(JsonGenerator gen, List<ExpandItem> expandItems) throws IOException {
        gen.writeStartArray();
        for (ExpandItem item : expandItems) {
            this.appendExpandItemJson(gen, item);
        }
        gen.writeEndArray();
    }

    private void appendExpandItemJson(JsonGenerator gen, ExpandItem item) throws IOException {
        gen.writeStartObject();
        if (item.isStar()) {
            gen.writeBooleanField("star", item.isStar());
        } else if (item.getResourcePath() != null && !item.getResourcePath().getUriResourceParts().isEmpty()) {
            gen.writeFieldName("expandPath");
            gen.writeStartArray();
            for (UriResource resource : item.getResourcePath().getUriResourceParts()) {
                gen.writeStartObject();
                gen.writeStringField("propertyKind", resource.getKind().toString());
                gen.writeStringField("propertyName", resource.toString());
                gen.writeEndObject();
            }
            gen.writeEndArray();
        }
        if (item.isRef()) {
            gen.writeBooleanField("isRef", item.isRef());
        }
        if (item.getLevelsOption() != null) {
            gen.writeFieldName("levels");
            if (item.getLevelsOption().isMax()) {
                gen.writeString("max");
            } else {
                gen.writeNumber(item.getLevelsOption().getValue());
            }
        }
        this.appendCommonJsonObjects(gen, item.getCountOption(), item.getSkipOption(), item.getTopOption(), item.getFilterOption(), item.getOrderByOption(), item.getSelectOption(), item.getExpandOption(), item.getSearchOption());
        gen.writeEndObject();
    }

    private void appendExpressionJson(JsonGenerator gen, Expression expression) throws IOException {
        if (expression == null) {
            gen.writeNull();
        } else {
            try {
                JsonNode tree = (JsonNode)expression.accept((ExpressionVisitor)new ExpressionJsonVisitor());
                gen.writeTree((TreeNode)tree);
            }
            catch (ODataException e) {
                gen.writeString("Exception in Debug Expression visitor occurred: " + e.getMessage());
            }
        }
    }

    private void appendSelectedPropertiesJson(JsonGenerator gen, List<SelectItem> selectItems) throws IOException {
        gen.writeStartArray();
        for (SelectItem selectItem : selectItems) {
            gen.writeString(this.getSelectString(selectItem));
        }
        gen.writeEndArray();
    }

    private String getSelectString(SelectItem selectItem) {
        if (selectItem.isStar()) {
            if (selectItem.getAllOperationsInSchemaNameSpace() == null) {
                return "*";
            }
            return selectItem.getAllOperationsInSchemaNameSpace().getFullQualifiedNameAsString() + ".*";
        }
        StringBuilder tmp = new StringBuilder();
        for (UriResource resourcePart : selectItem.getResourcePath().getUriResourceParts()) {
            if (tmp.length() > 0) {
                tmp.append('/');
            }
            tmp.append(resourcePart.toString());
        }
        return tmp.toString();
    }

    private void appendSearchJson(JsonGenerator json, SearchExpression searchExpression) throws IOException {
        json.writeStartObject();
        if (searchExpression.isSearchTerm()) {
            json.writeStringField("nodeType", "searchTerm");
            json.writeStringField("searchTerm", searchExpression.asSearchTerm().getSearchTerm());
        } else if (searchExpression.isSearchBinary()) {
            json.writeStringField("nodeType", "binary");
            json.writeStringField("operator", searchExpression.asSearchBinary().getOperator().toString());
            json.writeFieldName("left");
            this.appendSearchJson(json, searchExpression.asSearchBinary().getLeftOperand());
            json.writeFieldName("right");
            this.appendSearchJson(json, searchExpression.asSearchBinary().getRightOperand());
        } else if (searchExpression.isSearchUnary()) {
            json.writeStringField("nodeType", "unary");
            json.writeStringField("operator", searchExpression.asSearchUnary().getOperator().toString());
            json.writeFieldName("operand");
            this.appendSearchJson(json, (SearchExpression)searchExpression.asSearchUnary().getOperand());
        }
        json.writeEndObject();
    }

    @Override
    public void appendHtml(Writer writer) throws IOException {
        JsonGenerator json;
        JsonFactory jsonFactory = new ObjectMapper().getFactory();
        if (this.uriInfo.getKind() == UriInfoKind.resource) {
            writer.append("<h2>Resource Path</h2>\n").append("<ul>\n<li class=\"json\">");
            json = jsonFactory.createGenerator(writer).useDefaultPrettyPrinter();
            this.appendURIResourceParts(json, this.uriInfo.getUriResourceParts());
            json.close();
            writer.append("\n</li>\n</ul>\n");
        } else {
            writer.append("<h2>Kind</h2>\n<p>").append(this.uriInfo.getKind().name()).append("</p>\n");
        }
        if (this.uriInfo.getSearchOption() != null) {
            writer.append("<h2>Search Option</h2>\n").append("<ul>\n<li class=\"json\">");
            json = jsonFactory.createGenerator(writer).useDefaultPrettyPrinter();
            this.appendSearchJson(json, this.uriInfo.getSearchOption().getSearchExpression());
            json.close();
            writer.append("\n</li>\n</ul>\n");
        }
        if (this.uriInfo.getFilterOption() != null) {
            writer.append("<h2>Filter Option</h2>\n").append("<ul>\n<li class=\"json\">");
            json = jsonFactory.createGenerator(writer).useDefaultPrettyPrinter();
            this.appendExpressionJson(json, this.uriInfo.getFilterOption().getExpression());
            json.close();
            writer.append("\n</li>\n</ul>\n");
        }
        if (this.uriInfo.getOrderByOption() != null) {
            writer.append("<h2>OrderBy Option</h2>\n").append("<ul>\n<li class=\"json\">");
            json = jsonFactory.createGenerator(writer).useDefaultPrettyPrinter();
            this.appendOrderByItemsJson(json, this.uriInfo.getOrderByOption().getOrders());
            json.close();
            writer.append("\n</li>\n</ul>\n");
        }
        if (this.uriInfo.getExpandOption() != null) {
            writer.append("<h2>Expand Option</h2>\n").append("<ul>\n<li class=\"json\">");
            json = jsonFactory.createGenerator(writer).useDefaultPrettyPrinter();
            this.appendExpandedPropertiesJson(json, this.uriInfo.getExpandOption().getExpandItems());
            json.close();
            writer.append("\n</li>\n</ul>\n");
        }
        if (this.uriInfo.getSelectOption() != null) {
            writer.append("<h2>Selected Properties</h2>\n").append("<ul>\n");
            for (SelectItem selectItem : this.uriInfo.getSelectOption().getSelectItems()) {
                writer.append("<li>").append(this.getSelectString(selectItem)).append("</li>\n");
            }
            writer.append("</ul>\n");
        }
        if (this.uriInfo.getCountOption() != null || this.uriInfo.getSkipOption() != null || this.uriInfo.getSkipTokenOption() != null || this.uriInfo.getTopOption() != null || this.uriInfo.getFormatOption() != null || this.uriInfo.getIdOption() != null) {
            writer.append("<h2>Unstructured System Query Options</h2>\n");
            DebugResponseHelperImpl.appendHtmlTable(writer, this.getQueryOptionsMap(Arrays.asList(this.uriInfo.getCountOption(), this.uriInfo.getSkipOption(), this.uriInfo.getSkipTokenOption(), this.uriInfo.getTopOption(), this.uriInfo.getFormatOption(), this.uriInfo.getIdOption())));
        }
        if (!this.uriInfo.getAliases().isEmpty()) {
            writer.append("<h2>Aliases</h2>\n");
            DebugResponseHelperImpl.appendHtmlTable(writer, this.getQueryOptionsMap(this.uriInfo.getAliases()));
        }
        if (!this.uriInfo.getCustomQueryOptions().isEmpty()) {
            writer.append("<h2>Custom Query Options</h2>\n");
            DebugResponseHelperImpl.appendHtmlTable(writer, this.getQueryOptionsMap(this.uriInfo.getCustomQueryOptions()));
        }
    }

    private Map<String, String> getQueryOptionsMap(List<? extends QueryOption> queryOptions) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        for (QueryOption queryOption : queryOptions) {
            if (queryOption == null) continue;
            options.put(queryOption.getName(), queryOption.getText());
        }
        return options;
    }
}

