/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Parameter;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmMapping;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.deserializer.DeserializerResult;
import org.apache.olingo.server.api.deserializer.ODataDeserializer;
import org.apache.olingo.server.core.deserializer.DeserializerResultImpl;
import org.apache.olingo.server.core.deserializer.helper.ExpandTreeBuilder;
import org.apache.olingo.server.core.deserializer.helper.ExpandTreeBuilderImpl;

public class ODataJsonDeserializer
implements ODataDeserializer {
    private static final String ODATA_ANNOTATION_MARKER = "@";
    private static final String ODATA_CONTROL_INFORMATION_PREFIX = "@odata.";
    private final boolean isIEEE754Compatible;
    private ServiceMetadata serviceMetadata;

    public ODataJsonDeserializer(ContentType contentType) {
        this.isIEEE754Compatible = this.isODataIEEE754Compatible(contentType);
    }

    public ODataJsonDeserializer(ContentType contentType, ServiceMetadata serviceMetadata) {
        this.isIEEE754Compatible = this.isODataIEEE754Compatible(contentType);
        this.serviceMetadata = serviceMetadata;
    }

    public void setMetadata(ServiceMetadata metadata) {
        this.serviceMetadata = metadata;
    }

    public DeserializerResult entityCollection(InputStream stream, EdmEntityType edmEntityType) throws DeserializerException {
        try {
            return DeserializerResultImpl.with().entityCollection(this.consumeEntityCollectionNode(edmEntityType, this.parseJsonTree(stream), null)).build();
        }
        catch (IOException e) {
            throw this.wrapParseException(e);
        }
    }

    private EntityCollection consumeEntityCollectionNode(EdmEntityType edmEntityType, ObjectNode tree, ExpandTreeBuilder expandBuilder) throws DeserializerException {
        EntityCollection entitySet = new EntityCollection();
        JsonNode jsonNode = tree.get("value");
        if (jsonNode == null) {
            throw new DeserializerException("Could not find value array.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.VALUE_ARRAY_NOT_PRESENT, new String[0]);
        }
        entitySet.getEntities().addAll(this.consumeEntitySetArray(edmEntityType, jsonNode, expandBuilder));
        tree.remove("value");
        if (tree.isObject()) {
            this.removeAnnotations(tree);
        }
        this.assertJsonNodeIsEmpty((JsonNode)tree);
        return entitySet;
    }

    private List<Entity> consumeEntitySetArray(EdmEntityType edmEntityType, JsonNode jsonNode, ExpandTreeBuilder expandBuilder) throws DeserializerException {
        if (jsonNode.isArray()) {
            ArrayList<Entity> entities = new ArrayList<Entity>();
            for (JsonNode arrayElement : jsonNode) {
                if (arrayElement.isArray() || arrayElement.isValueNode()) {
                    throw new DeserializerException("Nested Arrays and primitive values are not allowed for an entity value.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_ENTITY, new String[0]);
                }
                EdmEntityType derivedEdmEntityType = (EdmEntityType)this.getDerivedType((EdmStructuredType)edmEntityType, arrayElement);
                entities.add(this.consumeEntityNode(derivedEdmEntityType, (ObjectNode)arrayElement, expandBuilder));
            }
            return entities;
        }
        throw new DeserializerException("The content of the value tag must be an Array but is not.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.VALUE_TAG_MUST_BE_AN_ARRAY, new String[0]);
    }

    public DeserializerResult entity(InputStream stream, EdmEntityType edmEntityType) throws DeserializerException {
        try {
            ObjectNode tree = this.parseJsonTree(stream);
            ExpandTreeBuilderImpl expandBuilder = new ExpandTreeBuilderImpl();
            EdmEntityType derivedEdmEntityType = (EdmEntityType)this.getDerivedType((EdmStructuredType)edmEntityType, (JsonNode)tree);
            return DeserializerResultImpl.with().entity(this.consumeEntityNode(derivedEdmEntityType, tree, expandBuilder)).expandOption(expandBuilder.build()).build();
        }
        catch (IOException e) {
            throw this.wrapParseException(e);
        }
    }

    private Entity consumeEntityNode(EdmEntityType edmEntityType, ObjectNode tree, ExpandTreeBuilder expandBuilder) throws DeserializerException {
        Entity entity = new Entity();
        entity.setType(edmEntityType.getFullQualifiedName().getFullQualifiedNameAsString());
        this.consumeEntityProperties(edmEntityType, tree, entity);
        this.consumeExpandedNavigationProperties(edmEntityType, tree, entity, expandBuilder);
        this.consumeRemainingJsonNodeFields(edmEntityType, tree, entity);
        this.assertJsonNodeIsEmpty((JsonNode)tree);
        return entity;
    }

    public DeserializerResult actionParameters(InputStream stream, EdmAction edmAction) throws DeserializerException {
        try {
            ObjectNode tree = this.parseJsonTree(stream);
            Map<String, Parameter> parameters = this.consumeParameters(edmAction, tree);
            if (tree.isObject()) {
                this.removeAnnotations(tree);
            }
            this.assertJsonNodeIsEmpty((JsonNode)tree);
            return DeserializerResultImpl.with().actionParameters(parameters).build();
        }
        catch (IOException e) {
            throw this.wrapParseException(e);
        }
    }

    private ObjectNode parseJsonTree(InputStream stream) throws IOException, DeserializerException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY, true);
        JsonParser parser = new JsonFactory((ObjectCodec)objectMapper).createParser(stream);
        JsonNode tree = (JsonNode)parser.getCodec().readTree(parser);
        if (tree == null || !tree.isObject()) {
            throw new DeserializerException("Invalid JSON syntax.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.JSON_SYNTAX_EXCEPTION, new String[0]);
        }
        return (ObjectNode)tree;
    }

    private Map<String, Parameter> consumeParameters(EdmAction edmAction, ObjectNode node) throws DeserializerException {
        List parameterNames = edmAction.getParameterNames();
        if (edmAction.isBound()) {
            parameterNames = parameterNames.subList(1, parameterNames.size());
        }
        LinkedHashMap<String, Parameter> parameters = new LinkedHashMap<String, Parameter>();
        block3: for (String paramName : parameterNames) {
            EdmParameter edmParameter = edmAction.getParameter(paramName);
            switch (edmParameter.getType().getKind()) {
                case PRIMITIVE: 
                case DEFINITION: 
                case ENUM: 
                case COMPLEX: 
                case ENTITY: {
                    Parameter parameter = this.createParameter(node.get(paramName), paramName, edmParameter);
                    parameters.put(paramName, parameter);
                    node.remove(paramName);
                    continue block3;
                }
            }
            throw new DeserializerException("Invalid type kind " + edmParameter.getType().getKind() + " for action parameter: " + paramName, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_ACTION_PARAMETER_TYPE, new String[]{paramName});
        }
        return parameters;
    }

    private Parameter createParameter(JsonNode node, String paramName, EdmParameter edmParameter) throws DeserializerException {
        Parameter parameter = new Parameter();
        parameter.setName(paramName);
        if (node == null || node.isNull()) {
            if (!edmParameter.isNullable()) {
                throw new DeserializerException("Non-nullable parameter not present or null: " + paramName, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PARAMETER, new String[]{paramName});
            }
            if (edmParameter.isCollection()) {
                throw new DeserializerException("Collection must not be null for parameter: " + paramName, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PARAMETER, new String[]{paramName});
            }
            parameter.setValue(ValueType.PRIMITIVE, null);
        } else if (edmParameter.getType().getKind() == EdmTypeKind.ENTITY) {
            if (edmParameter.isCollection()) {
                EntityCollection entityCollection = new EntityCollection();
                entityCollection.getEntities().addAll(this.consumeEntitySetArray((EdmEntityType)edmParameter.getType(), node, null));
                parameter.setValue(ValueType.COLLECTION_ENTITY, (Object)entityCollection);
            } else {
                Entity entity = this.consumeEntityNode((EdmEntityType)edmParameter.getType(), (ObjectNode)node, null);
                parameter.setValue(ValueType.ENTITY, (Object)entity);
            }
        } else {
            Property property = this.consumePropertyNode(edmParameter.getName(), edmParameter.getType(), edmParameter.isCollection(), edmParameter.isNullable(), edmParameter.getMaxLength(), edmParameter.getPrecision(), edmParameter.getScale(), true, edmParameter.getMapping(), node);
            parameter.setValue(property.getValueType(), property.getValue());
            parameter.setType(property.getType());
        }
        return parameter;
    }

    public Parameter parameter(String content, EdmParameter parameter) throws DeserializerException {
        try {
            JsonParser parser = new JsonFactory((ObjectCodec)new ObjectMapper().configure(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY, true)).createParser(content);
            JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
            if (node == null) {
                throw new DeserializerException("Invalid JSON syntax.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.JSON_SYNTAX_EXCEPTION, new String[0]);
            }
            Parameter result = this.createParameter(node, parameter.getName(), parameter);
            if (node.isObject()) {
                this.removeAnnotations((ObjectNode)node);
                this.assertJsonNodeIsEmpty(node);
            }
            return result;
        }
        catch (IOException e) {
            throw this.wrapParseException(e);
        }
    }

    private void consumeRemainingJsonNodeFields(EdmEntityType edmEntityType, ObjectNode node, Entity entity) throws DeserializerException {
        ArrayList toRemove = new ArrayList();
        Iterator fieldsIterator = node.fields();
        while (fieldsIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldsIterator.next();
            if (!((String)field.getKey()).contains("@odata.bind")) continue;
            Link bindingLink = this.consumeBindingLink((String)field.getKey(), (JsonNode)field.getValue(), edmEntityType);
            entity.getNavigationBindings().add(bindingLink);
            toRemove.add(field.getKey());
        }
        node.remove(toRemove);
        this.removeAnnotations(node);
    }

    private void consumeEntityProperties(EdmEntityType edmEntityType, ObjectNode node, Entity entity) throws DeserializerException {
        List propertyNames = edmEntityType.getPropertyNames();
        for (String propertyName : propertyNames) {
            JsonNode jsonNode = node.get(propertyName);
            if (jsonNode == null) continue;
            EdmProperty edmProperty = (EdmProperty)edmEntityType.getProperty(propertyName);
            if (jsonNode.isNull() && !edmProperty.isNullable()) {
                throw new DeserializerException("Property: " + propertyName + " must not be null.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PROPERTY, new String[]{propertyName});
            }
            Property property = this.consumePropertyNode(edmProperty.getName(), edmProperty.getType(), edmProperty.isCollection(), edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), edmProperty.getMapping(), jsonNode);
            entity.addProperty(property);
            node.remove(propertyName);
        }
    }

    private void consumeExpandedNavigationProperties(EdmEntityType edmEntityType, ObjectNode node, Entity entity, ExpandTreeBuilder expandBuilder) throws DeserializerException {
        List navigationPropertyNames = edmEntityType.getNavigationPropertyNames();
        for (String navigationPropertyName : navigationPropertyNames) {
            JsonNode jsonNode = node.get(navigationPropertyName);
            if (jsonNode == null) continue;
            EdmNavigationProperty edmNavigationProperty = edmEntityType.getNavigationProperty(navigationPropertyName);
            this.checkNotNullOrValidNull(jsonNode, edmNavigationProperty);
            Link link = this.createLink(expandBuilder, navigationPropertyName, jsonNode, edmNavigationProperty);
            entity.getNavigationLinks().add(link);
            node.remove(navigationPropertyName);
        }
    }

    private void checkNotNullOrValidNull(JsonNode jsonNode, EdmNavigationProperty edmNavigationProperty) throws DeserializerException {
        boolean isNullable = edmNavigationProperty.isNullable();
        if (jsonNode.isNull() && !isNullable || jsonNode.isNull() && edmNavigationProperty.isCollection()) {
            throw new DeserializerException("Property: " + edmNavigationProperty.getName() + " must not be null.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PROPERTY, new String[]{edmNavigationProperty.getName()});
        }
    }

    private Link createLink(ExpandTreeBuilder expandBuilder, String navigationPropertyName, JsonNode jsonNode, EdmNavigationProperty edmNavigationProperty) throws DeserializerException {
        Link link = new Link();
        link.setTitle(navigationPropertyName);
        ExpandTreeBuilder childExpandBuilder = expandBuilder != null ? expandBuilder.expand(edmNavigationProperty) : null;
        EdmEntityType derivedEdmEntityType = (EdmEntityType)this.getDerivedType((EdmStructuredType)edmNavigationProperty.getType(), jsonNode);
        if (jsonNode.isArray() && edmNavigationProperty.isCollection()) {
            link.setType(Constants.ENTITY_SET_NAVIGATION_LINK_TYPE);
            EntityCollection inlineEntitySet = new EntityCollection();
            inlineEntitySet.getEntities().addAll(this.consumeEntitySetArray(derivedEdmEntityType, jsonNode, childExpandBuilder));
            link.setInlineEntitySet(inlineEntitySet);
        } else if (!(jsonNode.isArray() || jsonNode.isValueNode() && !jsonNode.isNull() || edmNavigationProperty.isCollection())) {
            link.setType(Constants.ENTITY_NAVIGATION_LINK_TYPE);
            if (!jsonNode.isNull()) {
                Entity inlineEntity = this.consumeEntityNode(derivedEdmEntityType, (ObjectNode)jsonNode, childExpandBuilder);
                link.setInlineEntity(inlineEntity);
            }
        } else {
            throw new DeserializerException("Invalid value: " + jsonNode.getNodeType() + " for expanded navigation property: " + navigationPropertyName, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_NAVIGATION_PROPERTY, new String[]{navigationPropertyName});
        }
        return link;
    }

    private Link consumeBindingLink(String key, JsonNode jsonNode, EdmEntityType edmEntityType) throws DeserializerException {
        String[] splitKey = key.split(ODATA_ANNOTATION_MARKER);
        String navigationPropertyName = splitKey[0];
        EdmNavigationProperty edmNavigationProperty = edmEntityType.getNavigationProperty(navigationPropertyName);
        if (edmNavigationProperty == null) {
            throw new DeserializerException("Invalid navigationPropertyName: " + navigationPropertyName, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.NAVIGATION_PROPERTY_NOT_FOUND, new String[]{navigationPropertyName});
        }
        Link bindingLink = new Link();
        bindingLink.setTitle(navigationPropertyName);
        if (edmNavigationProperty.isCollection()) {
            this.assertIsNullNode(key, jsonNode);
            if (!jsonNode.isArray()) {
                throw new DeserializerException("Binding annotation: " + key + " must be an array.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_ANNOTATION_TYPE, new String[]{key});
            }
            ArrayList<String> bindingLinkStrings = new ArrayList<String>();
            for (JsonNode arrayValue : jsonNode) {
                this.assertIsNullNode(key, arrayValue);
                if (!arrayValue.isTextual()) {
                    throw new DeserializerException("Binding annotation: " + key + " must have string valued array.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_ANNOTATION_TYPE, new String[]{key});
                }
                bindingLinkStrings.add(arrayValue.asText());
            }
            bindingLink.setType(Constants.ENTITY_COLLECTION_BINDING_LINK_TYPE);
            bindingLink.setBindingLinks(bindingLinkStrings);
        } else {
            this.assertIsNullNode(key, jsonNode);
            if (!jsonNode.isValueNode()) {
                throw new DeserializerException("Binding annotation: " + key + " must be a string value.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_ANNOTATION_TYPE, new String[]{key});
            }
            bindingLink.setBindingLink(jsonNode.asText());
            bindingLink.setType(Constants.ENTITY_BINDING_LINK_TYPE);
        }
        return bindingLink;
    }

    private void assertIsNullNode(String key, JsonNode jsonNode) throws DeserializerException {
        if (jsonNode.isNull()) {
            throw new DeserializerException("Annotation: " + key + "must not have a null value.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_ANNOTATION, new String[]{key});
        }
    }

    private Property consumePropertyNode(String name, EdmType type, boolean isCollection, boolean isNullable, Integer maxLength, Integer precision, Integer scale, boolean isUnicode, EdmMapping mapping, JsonNode jsonNode) throws DeserializerException {
        Property property = new Property();
        property.setName(name);
        property.setType(type.getFullQualifiedName().getFullQualifiedNameAsString());
        if (isCollection) {
            this.consumePropertyCollectionNode(name, type, isNullable, maxLength, precision, scale, isUnicode, mapping, jsonNode, property);
        } else {
            this.consumePropertySingleNode(name, type, isNullable, maxLength, precision, scale, isUnicode, mapping, jsonNode, property);
        }
        return property;
    }

    private void consumePropertySingleNode(String name, EdmType type, boolean isNullable, Integer maxLength, Integer precision, Integer scale, boolean isUnicode, EdmMapping mapping, JsonNode jsonNode, Property property) throws DeserializerException {
        switch (type.getKind()) {
            case PRIMITIVE: 
            case DEFINITION: 
            case ENUM: {
                Object value = this.readPrimitiveValue(name, (EdmPrimitiveType)type, isNullable, maxLength, precision, scale, isUnicode, mapping, jsonNode);
                property.setValue(type.getKind() == EdmTypeKind.ENUM ? ValueType.ENUM : ValueType.PRIMITIVE, value);
                break;
            }
            case COMPLEX: {
                EdmType derivedType = this.getDerivedType((EdmStructuredType)((EdmComplexType)type), jsonNode);
                property.setType(derivedType.getFullQualifiedName().getFullQualifiedNameAsString());
                Object value = this.readComplexNode(name, derivedType, isNullable, jsonNode);
                property.setValue(ValueType.COMPLEX, value);
                break;
            }
            default: {
                throw new DeserializerException("Invalid Type Kind for a property found: " + type.getKind(), (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_JSON_TYPE_FOR_PROPERTY, new String[]{name});
            }
        }
    }

    private Object readComplexNode(String name, EdmType type, boolean isNullable, JsonNode jsonNode) throws DeserializerException {
        ComplexValue value = this.readComplexValue(name, type, isNullable, jsonNode);
        if (jsonNode.isObject()) {
            this.removeAnnotations((ObjectNode)jsonNode);
        }
        this.assertJsonNodeIsEmpty(jsonNode);
        return value;
    }

    private void consumePropertyCollectionNode(String name, EdmType type, boolean isNullable, Integer maxLength, Integer precision, Integer scale, boolean isUnicode, EdmMapping mapping, JsonNode jsonNode, Property property) throws DeserializerException {
        if (!jsonNode.isArray()) {
            throw new DeserializerException("Value for property: " + name + " must be an array but is not.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_JSON_TYPE_FOR_PROPERTY, new String[]{name});
        }
        ArrayList<Object> valueArray = new ArrayList<Object>();
        Iterator iterator = jsonNode.iterator();
        switch (type.getKind()) {
            case PRIMITIVE: 
            case DEFINITION: 
            case ENUM: {
                while (iterator.hasNext()) {
                    JsonNode arrayElement = (JsonNode)iterator.next();
                    Object value = this.readPrimitiveValue(name, (EdmPrimitiveType)type, isNullable, maxLength, precision, scale, isUnicode, mapping, arrayElement);
                    valueArray.add(value);
                }
                property.setValue(type.getKind() == EdmTypeKind.ENUM ? ValueType.COLLECTION_ENUM : ValueType.COLLECTION_PRIMITIVE, valueArray);
                break;
            }
            case COMPLEX: {
                while (iterator.hasNext()) {
                    Object value = this.readComplexNode(name, type, isNullable, (JsonNode)iterator.next());
                    valueArray.add(value);
                }
                property.setValue(ValueType.COLLECTION_COMPLEX, valueArray);
                break;
            }
            default: {
                throw new DeserializerException("Invalid Type Kind for a property found: " + type.getKind(), (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_JSON_TYPE_FOR_PROPERTY, new String[]{name});
            }
        }
    }

    private ComplexValue readComplexValue(String name, EdmType type, boolean isNullable, JsonNode jsonNode) throws DeserializerException {
        if (this.isValidNull(name, isNullable, jsonNode)) {
            return null;
        }
        if (jsonNode.isArray() || !jsonNode.isContainerNode()) {
            throw new DeserializerException("Invalid value for property: " + name + " must not be an array or primitive value.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_JSON_TYPE_FOR_PROPERTY, new String[]{name});
        }
        ComplexValue complexValue = new ComplexValue();
        EdmComplexType edmType = (EdmComplexType)type;
        for (String propertyName : edmType.getPropertyNames()) {
            JsonNode subNode = jsonNode.get(propertyName);
            if (subNode == null) continue;
            EdmProperty edmProperty = (EdmProperty)edmType.getProperty(propertyName);
            if (subNode.isNull() && !edmProperty.isNullable()) {
                throw new DeserializerException("Property: " + propertyName + " must not be null.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PROPERTY, new String[]{propertyName});
            }
            Property property = this.consumePropertyNode(edmProperty.getName(), edmProperty.getType(), edmProperty.isCollection(), edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), edmProperty.getMapping(), subNode);
            complexValue.getValue().add(property);
            ((ObjectNode)jsonNode).remove(propertyName);
        }
        return complexValue;
    }

    private Object readPrimitiveValue(String name, EdmPrimitiveType type, boolean isNullable, Integer maxLength, Integer precision, Integer scale, boolean isUnicode, EdmMapping mapping, JsonNode jsonNode) throws DeserializerException {
        this.checkForValueNode(name, jsonNode);
        if (this.isValidNull(name, isNullable, jsonNode)) {
            return null;
        }
        this.checkJsonTypeBasedOnPrimitiveType(name, type, jsonNode);
        Class<?> javaClass = this.getJavaClassForPrimitiveType(mapping, type);
        try {
            return type.valueOfString(jsonNode.asText(), Boolean.valueOf(isNullable), maxLength, precision, scale, Boolean.valueOf(isUnicode), javaClass);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new DeserializerException("Invalid value: " + jsonNode.asText() + " for property: " + name, (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{name});
        }
    }

    private boolean isValidNull(String name, boolean isNullable, JsonNode jsonNode) throws DeserializerException {
        if (jsonNode.isNull()) {
            if (isNullable) {
                return true;
            }
            throw new DeserializerException("Property: " + name + " must not be null.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PROPERTY, new String[]{name});
        }
        return false;
    }

    private Class<?> getJavaClassForPrimitiveType(EdmMapping mapping, EdmPrimitiveType type) {
        EdmPrimitiveType edmPrimitiveType = type.getKind() == EdmTypeKind.ENUM ? ((EdmEnumType)type).getUnderlyingType() : (type.getKind() == EdmTypeKind.DEFINITION ? ((EdmTypeDefinition)type).getUnderlyingType() : type);
        return mapping == null || mapping.getMappedJavaClass() == null ? edmPrimitiveType.getDefaultType() : mapping.getMappedJavaClass();
    }

    private void checkForValueNode(String name, JsonNode jsonNode) throws DeserializerException {
        if (!jsonNode.isValueNode()) {
            throw new DeserializerException("Invalid value for property: " + name + " must not be an object or array.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_JSON_TYPE_FOR_PROPERTY, new String[]{name});
        }
    }

    private void removeAnnotations(ObjectNode tree) throws DeserializerException {
        ArrayList toRemove = new ArrayList();
        Iterator fieldsIterator = tree.fields();
        while (fieldsIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldsIterator.next();
            if (((String)field.getKey()).contains(ODATA_CONTROL_INFORMATION_PREFIX)) {
                toRemove.add(field.getKey());
                continue;
            }
            if (!((String)field.getKey()).contains(ODATA_ANNOTATION_MARKER)) continue;
            throw new DeserializerException("Custom annotation with field name: " + (String)field.getKey() + " not supported", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
        }
        tree.remove(toRemove);
    }

    private void assertJsonNodeIsEmpty(JsonNode node) throws DeserializerException {
        if (node.size() != 0) {
            String unknownField = (String)node.fieldNames().next();
            throw new DeserializerException("Tree should be empty but still has content left: " + unknownField, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_CONTENT, new String[]{unknownField});
        }
    }

    private void checkJsonTypeBasedOnPrimitiveType(String propertyName, EdmPrimitiveType edmPrimitiveType, JsonNode jsonNode) throws DeserializerException {
        boolean valid = true;
        if (edmPrimitiveType.getKind() == EdmTypeKind.DEFINITION) {
            this.checkJsonTypeBasedOnPrimitiveType(propertyName, ((EdmTypeDefinition)edmPrimitiveType).getUnderlyingType(), jsonNode);
        } else if (edmPrimitiveType.getKind() == EdmTypeKind.ENUM) {
            valid = jsonNode.isTextual();
        } else {
            EdmPrimitiveTypeKind primKind;
            String name = edmPrimitiveType.getName();
            try {
                primKind = EdmPrimitiveTypeKind.valueOf((String)name);
            }
            catch (IllegalArgumentException e) {
                throw new DeserializerException("Unknown Primitive Type: " + name, (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_PRIMITIVE_TYPE, new String[]{name, propertyName});
            }
            boolean bl = valid = this.matchTextualCase(jsonNode, primKind) || this.matchNumberCase(jsonNode, primKind) || this.matchBooleanCase(jsonNode, primKind) || this.matchIEEENumberCase(jsonNode, primKind);
        }
        if (!valid) {
            throw new DeserializerException("Invalid json type: " + jsonNode.getNodeType() + " for " + edmPrimitiveType + " property: " + propertyName, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{propertyName});
        }
    }

    private boolean matchIEEENumberCase(JsonNode node, EdmPrimitiveTypeKind primKind) {
        return (this.isIEEE754Compatible ? node.isTextual() : node.isNumber()) && (primKind == EdmPrimitiveTypeKind.Int64 || primKind == EdmPrimitiveTypeKind.Decimal);
    }

    private boolean matchBooleanCase(JsonNode node, EdmPrimitiveTypeKind primKind) {
        return node.isBoolean() && primKind == EdmPrimitiveTypeKind.Boolean;
    }

    private boolean matchNumberCase(JsonNode node, EdmPrimitiveTypeKind primKind) {
        return node.isNumber() && (primKind == EdmPrimitiveTypeKind.Int16 || primKind == EdmPrimitiveTypeKind.Int32 || primKind == EdmPrimitiveTypeKind.Byte || primKind == EdmPrimitiveTypeKind.SByte || primKind == EdmPrimitiveTypeKind.Single || primKind == EdmPrimitiveTypeKind.Double);
    }

    private boolean matchTextualCase(JsonNode node, EdmPrimitiveTypeKind primKind) {
        return node.isTextual() && (primKind == EdmPrimitiveTypeKind.String || primKind == EdmPrimitiveTypeKind.Binary || primKind == EdmPrimitiveTypeKind.Date || primKind == EdmPrimitiveTypeKind.DateTimeOffset || primKind == EdmPrimitiveTypeKind.Duration || primKind == EdmPrimitiveTypeKind.Guid || primKind == EdmPrimitiveTypeKind.TimeOfDay);
    }

    public DeserializerResult property(InputStream stream, EdmProperty edmProperty) throws DeserializerException {
        try {
            Property property;
            ObjectNode tree = this.parseJsonTree(stream);
            JsonNode jsonNode = tree.get("value");
            if (jsonNode != null) {
                property = this.consumePropertyNode(edmProperty.getName(), edmProperty.getType(), edmProperty.isCollection(), edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), edmProperty.getMapping(), jsonNode);
                tree.remove("value");
            } else {
                property = this.consumePropertyNode(edmProperty.getName(), edmProperty.getType(), edmProperty.isCollection(), edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), edmProperty.getMapping(), (JsonNode)tree);
            }
            return DeserializerResultImpl.with().property(property).build();
        }
        catch (IOException e) {
            throw this.wrapParseException(e);
        }
    }

    public DeserializerResult entityReferences(InputStream stream) throws DeserializerException {
        try {
            ArrayList<URI> parsedValues = new ArrayList<URI>();
            ObjectNode tree = this.parseJsonTree(stream);
            String key = "@odata.id";
            JsonNode jsonNode = tree.get("value");
            if (jsonNode != null) {
                if (jsonNode.isArray()) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode;
                    for (JsonNode next : arrayNode) {
                        if (!next.has("@odata.id")) continue;
                        parsedValues.add(new URI(next.get("@odata.id").asText()));
                    }
                } else {
                    throw new DeserializerException("Value must be an array", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_CONTENT, new String[0]);
                }
                tree.remove("value");
                return DeserializerResultImpl.with().entityReferences(parsedValues).build();
            }
            if (tree.get("@odata.id") == null) {
                throw new DeserializerException("Missing entity reference", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_CONTENT, new String[0]);
            }
            parsedValues.add(new URI(tree.get("@odata.id").asText()));
            return DeserializerResultImpl.with().entityReferences(parsedValues).build();
        }
        catch (IOException e) {
            throw this.wrapParseException(e);
        }
        catch (URISyntaxException e) {
            throw new DeserializerException("failed to read @odata.id", (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_CONTENT, new String[0]);
        }
    }

    private DeserializerException wrapParseException(IOException e) {
        if (e instanceof JsonParseException) {
            return new DeserializerException("A JsonParseException occurred.", (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.JSON_SYNTAX_EXCEPTION, new String[0]);
        }
        if (e instanceof JsonMappingException) {
            return new DeserializerException("Duplicate json property detected.", (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.DUPLICATE_PROPERTY, new String[0]);
        }
        return new DeserializerException("An IOException occurred.", (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.IO_EXCEPTION, new String[0]);
    }

    private boolean isODataIEEE754Compatible(ContentType contentType) {
        return contentType.getParameters().containsKey("IEEE754Compatible") && Boolean.TRUE.toString().equalsIgnoreCase(contentType.getParameter("IEEE754Compatible"));
    }

    private EdmType getDerivedType(EdmStructuredType edmType, JsonNode jsonNode) throws DeserializerException {
        String odataType;
        JsonNode odataTypeNode = jsonNode.get("@odata.type");
        if (odataTypeNode != null && !(odataType = odataTypeNode.asText()).isEmpty()) {
            if ((odataType = odataType.substring(1)).equalsIgnoreCase(edmType.getFullQualifiedName().getFullQualifiedNameAsString())) {
                return edmType;
            }
            if (this.serviceMetadata == null) {
                throw new DeserializerException("Failed to resolve Odata type " + odataType + " due to metadata is not available", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_CONTENT, new String[0]);
            }
            Object currentEdmType = null;
            currentEdmType = edmType instanceof EdmEntityType ? this.serviceMetadata.getEdm().getEntityType(new FullQualifiedName(odataType)) : this.serviceMetadata.getEdm().getComplexType(new FullQualifiedName(odataType));
            if (!this.isAssignable(edmType, (EdmStructuredType)currentEdmType)) {
                throw new DeserializerException("Odata type " + odataType + " not allowed here", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_CONTENT, new String[0]);
            }
            return currentEdmType;
        }
        return edmType;
    }

    private boolean isAssignable(EdmStructuredType edmStructuredType, EdmStructuredType edmStructuredTypeToAssign) {
        if (edmStructuredTypeToAssign == null) {
            return false;
        }
        if (edmStructuredType.getFullQualifiedName().equals((Object)edmStructuredTypeToAssign.getFullQualifiedName())) {
            return true;
        }
        return this.isAssignable(edmStructuredType, edmStructuredTypeToAssign.getBaseType());
    }
}

