/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri;

import java.util.List;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.core.Encoder;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriHelper;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.core.ODataImpl;
import org.apache.olingo.server.core.serializer.utils.ContextURLHelper;
import org.apache.olingo.server.core.uri.parser.Parser;

public class UriHelperImpl
implements UriHelper {
    public String buildContextURLSelectList(EdmStructuredType type, ExpandOption expand, SelectOption select) throws SerializerException {
        return ContextURLHelper.buildSelectList(type, expand, select);
    }

    public String buildContextURLKeyPredicate(List<UriParameter> keys) throws SerializerException {
        return ContextURLHelper.buildKeyPredicate(keys);
    }

    public String buildCanonicalURL(EdmEntitySet edmEntitySet, Entity entity) throws SerializerException {
        return edmEntitySet.getName() + '(' + this.buildKeyPredicate(edmEntitySet.getEntityType(), entity) + ')';
    }

    public String buildKeyPredicate(EdmEntityType edmEntityType, Entity entity) throws SerializerException {
        StringBuilder result = new StringBuilder();
        List keyNames = edmEntityType.getKeyPredicateNames();
        boolean first = true;
        for (String keyName : keyNames) {
            EdmProperty edmProperty;
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            if (keyNames.size() > 1) {
                result.append(Encoder.encode((String)keyName)).append('=');
            }
            if ((edmProperty = edmEntityType.getStructuralProperty(keyName)) == null) {
                throw new SerializerException("Property not found (possibly an alias): " + keyName, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.MISSING_PROPERTY, new String[]{keyName});
            }
            EdmPrimitiveType type = (EdmPrimitiveType)edmProperty.getType();
            Object propertyValue = entity.getProperty(keyName).getValue();
            try {
                String value = type.toUriLiteral(type.valueToString(propertyValue, Boolean.valueOf(edmProperty.isNullable()), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), Boolean.valueOf(edmProperty.isUnicode())));
                result.append(Encoder.encode((String)value));
            }
            catch (EdmPrimitiveTypeException e) {
                throw new SerializerException("Wrong key value!", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, new String[]{edmProperty.getName(), propertyValue.toString()});
            }
        }
        return result.toString();
    }

    public UriResourceEntitySet parseEntityId(Edm edm, String entityId, String rawServiceRoot) throws DeserializerException {
        String oDataPath = entityId;
        if (rawServiceRoot != null && entityId.startsWith(rawServiceRoot)) {
            oDataPath = entityId.substring(rawServiceRoot.length());
        }
        oDataPath = oDataPath.startsWith("/") ? oDataPath : "/" + oDataPath;
        try {
            List uriResourceParts = new Parser(edm, new ODataImpl()).parseUri(oDataPath, null, null).getUriResourceParts();
            if (uriResourceParts.size() == 1 && ((UriResource)uriResourceParts.get(0)).getKind() == UriResourceKind.entitySet) {
                UriResourceEntitySet entityUriResource = (UriResourceEntitySet)uriResourceParts.get(0);
                return entityUriResource;
            }
            throw new DeserializerException("Invalid entity binding link", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_ENTITY_BINDING_LINK, new String[]{entityId});
        }
        catch (ODataLibraryException e) {
            throw new DeserializerException("Invalid entity binding link", (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_ENTITY_BINDING_LINK, new String[]{entityId});
        }
    }
}

