/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.queryoption.expression;

import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.queryoption.expression.Binary;
import org.apache.olingo.server.api.uri.queryoption.expression.BinaryOperatorKind;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;

public class BinaryImpl
implements Binary {
    private final Expression left;
    private final BinaryOperatorKind operator;
    private final Expression right;
    private final EdmType type;

    public BinaryImpl(Expression left, BinaryOperatorKind operator, Expression right, EdmType type) {
        this.left = left;
        this.operator = operator;
        this.right = right;
        this.type = type;
    }

    public BinaryOperatorKind getOperator() {
        return this.operator;
    }

    public Expression getLeftOperand() {
        return this.left;
    }

    public Expression getRightOperand() {
        return this.right;
    }

    public EdmType getType() {
        return this.type;
    }

    public <T> T accept(ExpressionVisitor<T> visitor) throws ExpressionVisitException, ODataApplicationException {
        Object localLeft = this.left.accept(visitor);
        Object localRight = this.right.accept(visitor);
        return (T)visitor.visitBinaryOperator(this.operator, localLeft, localRight);
    }

    public String toString() {
        return "{" + this.left + " " + this.operator.name() + " " + this.right + '}';
    }
}

