/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer.xml;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.data.AbstractODataObject;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Parameter;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.commons.core.edm.primitivetype.AbstractGeospatialType;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.deserializer.DeserializerResult;
import org.apache.olingo.server.api.deserializer.ODataDeserializer;
import org.apache.olingo.server.core.deserializer.DeserializerResultImpl;

public class ODataXmlDeserializer
implements ODataDeserializer {
    private static final XMLInputFactory FACTORY = XMLInputFactory.newFactory();
    private static final QName propertiesQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "properties");
    private static final QName propertyValueQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "value");
    private static final QName contextQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "context");
    private static final QName nullQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "null");
    private static final QName inlineQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "inline");
    private static final QName entryRefQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "ref");
    private static final QName etagQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "etag");
    private static final QName countQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "count");
    private static final QName parametersQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "parameters");
    private static final QName typeQName = new QName("http://docs.oasis-open.org/odata/ns/metadata", "type");
    private ServiceMetadata serviceMetadata;

    public ODataXmlDeserializer() {
    }

    public ODataXmlDeserializer(ServiceMetadata serviceMetadata) {
        this.serviceMetadata = serviceMetadata;
    }

    public void setMetadata(ServiceMetadata metadata) {
        this.serviceMetadata = metadata;
    }

    protected XMLEventReader getReader(InputStream input) throws XMLStreamException {
        return FACTORY.createXMLEventReader(input);
    }

    private Object primitive(XMLEventReader reader, StartElement start, EdmType type, boolean isNullable, Integer maxLength, Integer precision, Integer scale, boolean isUnicode) throws XMLStreamException, EdmPrimitiveTypeException, DeserializerException {
        Object value = null;
        boolean foundEndProperty = false;
        while (reader.hasNext() && !foundEndProperty) {
            XMLEvent event = reader.nextEvent();
            if (event.isCharacters() && !event.asCharacters().isWhiteSpace()) {
                if (type instanceof AbstractGeospatialType) {
                    throw new DeserializerException("geo types support not implemented", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
                }
                EdmPrimitiveType primitiveType = (EdmPrimitiveType)type;
                String stringValue = event.asCharacters().getData();
                value = primitiveType.valueOfString(stringValue, Boolean.valueOf(isNullable), maxLength, precision, scale, Boolean.valueOf(isUnicode), primitiveType.getDefaultType());
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndProperty = true;
        }
        return value;
    }

    private Object complex(XMLEventReader reader, StartElement start, EdmComplexType edmComplex) throws XMLStreamException, EdmPrimitiveTypeException, DeserializerException {
        ComplexValue value = new ComplexValue();
        boolean foundEndProperty = false;
        while (reader.hasNext() && !foundEndProperty) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement se = event.asStartElement();
                EdmProperty p = (EdmProperty)edmComplex.getProperty(se.getName().getLocalPart());
                value.getValue().add(this.property(reader, se, p.getType(), p.isNullable(), p.getMaxLength(), p.getPrecision(), p.getScale(), p.isUnicode(), p.isCollection()));
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndProperty = true;
        }
        return value;
    }

    private void collection(Valuable valuable, XMLEventReader reader, StartElement start, EdmType edmType, boolean isNullable, Integer maxLength, Integer precision, Integer scale, boolean isUnicode) throws XMLStreamException, EdmPrimitiveTypeException, DeserializerException {
        ArrayList<Object> values = new ArrayList<Object>();
        boolean foundEndProperty = false;
        while (reader.hasNext() && !foundEndProperty) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                if (edmType instanceof EdmPrimitiveType) {
                    values.add(this.primitive(reader, event.asStartElement(), edmType, isNullable, maxLength, precision, scale, isUnicode));
                } else if (edmType instanceof EdmComplexType) {
                    values.add(this.complex(reader, event.asStartElement(), (EdmComplexType)edmType));
                }
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndProperty = true;
        }
        valuable.setValue(this.getValueType(edmType, true), values);
    }

    private Property property(XMLEventReader reader, StartElement start, EdmType edmType, boolean isNullable, Integer maxLength, Integer precision, Integer scale, boolean isUnicode, boolean isCollection) throws XMLStreamException, EdmPrimitiveTypeException, DeserializerException {
        Property property = new Property();
        if (propertyValueQName.equals(start.getName())) {
            Attribute context = start.getAttributeByName(contextQName);
            if (context != null && context.getValue() != null) {
                int pos = context.getValue().lastIndexOf(47);
                property.setName(pos == -1 ? "" : context.getValue().substring(pos + 1));
            }
        } else {
            property.setName(start.getName().getLocalPart());
        }
        EdmType resolvedType = edmType;
        Attribute attrType = start.getAttributeByName(typeQName);
        if (attrType != null && edmType instanceof EdmComplexType) {
            String type = new EdmTypeInfo.Builder().setTypeExpression(attrType.getValue()).build().internal();
            if (type.startsWith("Collection(") && type.endsWith(")")) {
                type = type.substring(11, type.length() - 1);
            }
            resolvedType = this.getDerivedType((EdmStructuredType)((EdmComplexType)edmType), type);
        }
        this.valuable((Valuable)property, reader, start, resolvedType, isNullable, maxLength, precision, scale, isUnicode, isCollection);
        return property;
    }

    private ValueType getValueType(EdmType edmType, boolean isCollection) {
        if (edmType instanceof EdmPrimitiveType) {
            if (edmType instanceof EdmEnumType) {
                return isCollection ? ValueType.COLLECTION_ENUM : ValueType.ENUM;
            }
            return isCollection ? ValueType.COLLECTION_PRIMITIVE : ValueType.PRIMITIVE;
        }
        if (edmType instanceof EdmComplexType) {
            return isCollection ? ValueType.COLLECTION_COMPLEX : ValueType.COMPLEX;
        }
        return ValueType.PRIMITIVE;
    }

    private void valuable(Valuable valuable, XMLEventReader reader, StartElement start, EdmType edmType, boolean isNullable, Integer maxLength, Integer precision, Integer scale, boolean isUnicode, boolean isCollection) throws XMLStreamException, EdmPrimitiveTypeException, DeserializerException {
        Attribute nullAttr = start.getAttributeByName(nullQName);
        if (nullAttr != null) {
            boolean foundEndProperty = false;
            while (reader.hasNext() && !foundEndProperty) {
                XMLEvent event = reader.nextEvent();
                if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
                foundEndProperty = true;
            }
            valuable.setValue(this.getValueType(edmType, false), null);
            return;
        }
        String typeName = edmType.getFullQualifiedName().getFullQualifiedNameAsString();
        valuable.setType(isCollection ? "Collection(" + typeName + ")" : typeName);
        if (isCollection) {
            this.collection(valuable, reader, start, edmType, isNullable, maxLength, precision, scale, isUnicode);
        } else if (edmType instanceof EdmPrimitiveType) {
            valuable.setValue(this.getValueType(edmType, false), this.primitive(reader, start, edmType, isNullable, maxLength, precision, scale, isUnicode));
        } else if (edmType instanceof EdmComplexType) {
            valuable.setValue(ValueType.COMPLEX, this.complex(reader, start, (EdmComplexType)edmType));
        } else if (edmType instanceof EdmEntityType) {
            valuable.setValue(ValueType.ENTITY, (Object)this.entity(reader, start, (EdmEntityType)edmType));
        }
    }

    public DeserializerResult property(InputStream input, EdmProperty edmProperty) throws DeserializerException {
        try {
            XMLEventReader reader = this.getReader(input);
            StartElement start = this.skipBeforeFirstStartElement(reader);
            Property property = this.property(reader, start, edmProperty.getType(), edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), edmProperty.isCollection());
            return DeserializerResultImpl.with().property(property).build();
        }
        catch (XMLStreamException e) {
            throw new DeserializerException(e.getMessage(), (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new DeserializerException(e.getMessage(), (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[0]);
        }
    }

    private StartElement skipBeforeFirstStartElement(XMLEventReader reader) throws XMLStreamException {
        StartElement startEvent = null;
        while (reader.hasNext() && startEvent == null) {
            XMLEvent event = reader.nextEvent();
            if (!event.isStartElement()) continue;
            startEvent = event.asStartElement();
        }
        if (startEvent == null) {
            throw new IllegalArgumentException("Cannot find any XML start element");
        }
        return startEvent;
    }

    private void common(XMLEventReader reader, StartElement start, AbstractODataObject object, String key) throws XMLStreamException {
        boolean foundEndElement = false;
        while (reader.hasNext() && !foundEndElement) {
            XMLEvent event = reader.nextEvent();
            if (event.isCharacters() && !event.asCharacters().isWhiteSpace()) {
                object.setCommonProperty(key, event.asCharacters().getData());
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndElement = true;
        }
    }

    private void inline(XMLEventReader reader, StartElement start, Link link, EdmEntityType edmEntityType) throws XMLStreamException, EdmPrimitiveTypeException, DeserializerException {
        boolean foundEndElement = false;
        EdmNavigationProperty navigationProperty = edmEntityType.getNavigationProperty(link.getTitle());
        while (reader.hasNext() && !foundEndElement) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                if (inlineQName.equals(event.asStartElement().getName())) {
                    StartElement inline = this.getStartElement(reader);
                    if (inline != null) {
                        if (Constants.QNAME_ATOM_ELEM_ENTRY.equals(inline.getName())) {
                            if (navigationProperty.isCollection()) {
                                throw new DeserializerException("Navigation Property " + link.getTitle() + " must be collection entities", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_ANNOTATION_TYPE, new String[]{link.getTitle()});
                            }
                            link.setInlineEntity(this.entity(reader, inline, navigationProperty.getType()));
                        }
                        if (Constants.QNAME_ATOM_ELEM_FEED.equals(inline.getName())) {
                            if (!navigationProperty.isCollection()) {
                                throw new DeserializerException("Navigation Property " + link.getTitle() + " must be single entity", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_ANNOTATION_TYPE, new String[]{link.getTitle()});
                            }
                            link.setInlineEntitySet(this.entitySet(reader, inline, navigationProperty.getType()));
                        }
                    }
                } else if (entryRefQName.equals(event.asStartElement().getName())) {
                    if (navigationProperty.isCollection()) {
                        throw new DeserializerException("Binding annotation: " + link.getTitle() + " must be collection of entity references", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_ANNOTATION_TYPE, new String[]{link.getTitle()});
                    }
                    link.setBindingLink(this.entityRef(reader, event.asStartElement()));
                    link.setType(Constants.ENTITY_BINDING_LINK_TYPE);
                } else if (Constants.QNAME_ATOM_ELEM_FEED.equals(event.asStartElement().getName())) {
                    if (navigationProperty.isCollection()) {
                        throw new DeserializerException("Binding annotation: " + link.getTitle() + " must be single entity references", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_ANNOTATION_TYPE, new String[]{link.getTitle()});
                    }
                    link.setBindingLinks(this.entityRefCollection(reader, event.asStartElement()));
                    link.setType(Constants.ENTITY_COLLECTION_BINDING_LINK_TYPE);
                }
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndElement = true;
        }
    }

    private List<String> entityRefCollection(XMLEventReader reader, StartElement start) throws XMLStreamException {
        boolean foundEndElement = false;
        ArrayList<String> references = new ArrayList<String>();
        while (reader.hasNext() && !foundEndElement) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement() && entryRefQName.equals(event.asStartElement().getName())) {
                references.add(this.entityRef(reader, event.asStartElement()));
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndElement = true;
        }
        return references;
    }

    private String entityRef(XMLEventReader reader, StartElement start) throws XMLStreamException {
        boolean foundEndElement = false;
        Attribute entityRefId = start.getAttributeByName(Constants.QNAME_ATOM_ATTR_ID);
        while (reader.hasNext() && !foundEndElement) {
            XMLEvent event = reader.nextEvent();
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndElement = true;
        }
        return entityRefId.getValue();
    }

    private StartElement getStartElement(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            XMLEvent innerEvent = reader.peek();
            if (innerEvent.isCharacters() && innerEvent.asCharacters().isWhiteSpace()) {
                reader.nextEvent();
                continue;
            }
            if (innerEvent.isStartElement()) {
                return innerEvent.asStartElement();
            }
            if (!innerEvent.isEndElement() || !inlineQName.equals(innerEvent.asEndElement().getName())) continue;
            return null;
        }
        return null;
    }

    private void properties(XMLEventReader reader, StartElement start, Entity entity, EdmEntityType edmEntityType) throws XMLStreamException, EdmPrimitiveTypeException, DeserializerException {
        boolean foundEndProperties = false;
        while (reader.hasNext() && !foundEndProperties) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                String propertyName = event.asStartElement().getName().getLocalPart();
                EdmProperty edmProperty = (EdmProperty)edmEntityType.getProperty(propertyName);
                if (edmProperty == null) {
                    throw new DeserializerException("Invalid Property in payload with name: " + propertyName, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_CONTENT, new String[]{propertyName});
                }
                entity.getProperties().add(this.property(reader, event.asStartElement(), edmProperty.getType(), edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), edmProperty.isCollection()));
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndProperties = true;
        }
    }

    private Entity entityRef(StartElement start) throws XMLStreamException {
        Entity entity = new Entity();
        Attribute entityRefId = start.getAttributeByName(Constants.QNAME_ATOM_ATTR_ID);
        if (entityRefId != null) {
            entity.setId(URI.create(entityRefId.getValue()));
        }
        return entity;
    }

    private Entity entity(XMLEventReader reader, StartElement start, EdmEntityType edmEntityType) throws XMLStreamException, EdmPrimitiveTypeException, DeserializerException {
        Entity entity = null;
        EdmEntityType resolvedType = edmEntityType;
        if (entryRefQName.equals(start.getName())) {
            entity = this.entityRef(start);
        } else if (Constants.QNAME_ATOM_ELEM_ENTRY.equals(start.getName())) {
            Attribute etag;
            entity = new Entity();
            Attribute xmlBase = start.getAttributeByName(Constants.QNAME_ATTR_XML_BASE);
            if (xmlBase != null) {
                entity.setBaseURI(URI.create(xmlBase.getValue()));
            }
            if ((etag = start.getAttributeByName(etagQName)) != null) {
                entity.setETag(etag.getValue());
            }
            boolean foundEndEntry = false;
            while (reader.hasNext() && !foundEndEntry) {
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement()) {
                    if (Constants.QNAME_ATOM_ELEM_ID.equals(event.asStartElement().getName())) {
                        this.common(reader, event.asStartElement(), (AbstractODataObject)entity, "id");
                    } else if (Constants.QNAME_ATOM_ELEM_CATEGORY.equals(event.asStartElement().getName())) {
                        Attribute term = event.asStartElement().getAttributeByName(QName.valueOf("term"));
                        if (term != null) {
                            String type = new EdmTypeInfo.Builder().setTypeExpression(term.getValue()).build().internal();
                            entity.setType(type);
                            resolvedType = (EdmEntityType)this.getDerivedType((EdmStructuredType)edmEntityType, type);
                        }
                    } else if (Constants.QNAME_ATOM_ELEM_LINK.equals(event.asStartElement().getName())) {
                        Attribute linktype;
                        Attribute href;
                        Attribute title;
                        Link link = new Link();
                        Attribute rel = event.asStartElement().getAttributeByName(QName.valueOf("rel"));
                        if (rel != null) {
                            link.setRel(rel.getValue());
                        }
                        if ((title = event.asStartElement().getAttributeByName(QName.valueOf("title"))) != null) {
                            link.setTitle(title.getValue());
                        }
                        if ((href = event.asStartElement().getAttributeByName(QName.valueOf("href"))) != null) {
                            link.setBindingLink(href.getValue());
                        }
                        if ((linktype = event.asStartElement().getAttributeByName(QName.valueOf("type"))) != null) {
                            link.setType(linktype.getValue());
                        }
                        if ("self".equals(link.getRel())) {
                            entity.setSelfLink(link);
                        } else if ("edit".equals(link.getRel())) {
                            entity.setEditLink(link);
                        } else if ("edit-media".equals(link.getRel())) {
                            Attribute mediaETag = event.asStartElement().getAttributeByName(etagQName);
                            if (mediaETag != null) {
                                entity.setMediaETag(mediaETag.getValue());
                            }
                        } else if (link.getRel().startsWith("http://docs.oasis-open.org/odata/ns/related/")) {
                            this.inline(reader, event.asStartElement(), link, resolvedType);
                            if (link.getInlineEntity() == null && link.getInlineEntitySet() == null) {
                                entity.getNavigationBindings().add(link);
                            } else if (link.getInlineEntitySet() != null) {
                                ArrayList<String> bindings = new ArrayList<String>();
                                List entities = link.getInlineEntitySet().getEntities();
                                for (Entity inlineEntity : entities) {
                                    if (inlineEntity.getId() == null || !inlineEntity.getProperties().isEmpty()) continue;
                                    bindings.add(inlineEntity.getId().toASCIIString());
                                }
                                if (!bindings.isEmpty()) {
                                    link.setInlineEntitySet(null);
                                    link.setBindingLinks(bindings);
                                    entity.getNavigationBindings().add(link);
                                } else {
                                    entity.getNavigationLinks().add(link);
                                }
                            } else {
                                entity.getNavigationLinks().add(link);
                            }
                        } else if (link.getRel().startsWith("http://docs.oasis-open.org/odata/ns/relatedlinks/")) {
                            entity.getAssociationLinks().add(link);
                        } else if (link.getRel().startsWith("http://docs.oasis-open.org/odata/ns/edit-media/") || link.getRel().startsWith("http://docs.oasis-open.org/odata/ns/mediaresource/")) {
                            Attribute metag = event.asStartElement().getAttributeByName(etagQName);
                            if (metag != null) {
                                link.setMediaETag(metag.getValue());
                            }
                            entity.getMediaEditLinks().add(link);
                        }
                    } else if (Constants.QNAME_ATOM_ELEM_CONTENT.equals(event.asStartElement().getName())) {
                        Attribute contenttype = event.asStartElement().getAttributeByName(QName.valueOf("type"));
                        if (contenttype == null || ContentType.APPLICATION_XML.toContentTypeString().equals(contenttype.getValue())) {
                            this.properties(reader, this.skipBeforeFirstStartElement(reader), entity, resolvedType);
                        } else {
                            entity.setMediaContentType(contenttype.getValue());
                            Attribute src = event.asStartElement().getAttributeByName(QName.valueOf("src"));
                            if (src != null) {
                                entity.setMediaContentSource(URI.create(src.getValue()));
                            }
                        }
                    } else if (propertiesQName.equals(event.asStartElement().getName())) {
                        this.properties(reader, event.asStartElement(), entity, resolvedType);
                    }
                }
                if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
                foundEndEntry = true;
            }
        }
        return entity;
    }

    public DeserializerResult entity(InputStream input, EdmEntityType edmEntityType) throws DeserializerException {
        try {
            XMLEventReader reader = this.getReader(input);
            StartElement start = this.skipBeforeFirstStartElement(reader);
            Entity entity = this.entity(reader, start, edmEntityType);
            if (entity == null) {
                throw new DeserializerException("No entity found!", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_ENTITY, new String[0]);
            }
            return DeserializerResultImpl.with().entity(entity).build();
        }
        catch (XMLStreamException e) {
            throw new DeserializerException(e.getMessage(), (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new DeserializerException(e.getMessage(), (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_ENTITY, new String[0]);
        }
    }

    private void count(XMLEventReader reader, StartElement start, EntityCollection entitySet) throws XMLStreamException {
        boolean foundEndElement = false;
        while (reader.hasNext() && !foundEndElement) {
            XMLEvent event = reader.nextEvent();
            if (event.isCharacters() && !event.asCharacters().isWhiteSpace()) {
                entitySet.setCount(Integer.valueOf(event.asCharacters().getData()));
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndElement = true;
        }
    }

    private EntityCollection entitySet(XMLEventReader reader, StartElement start, EdmEntityType edmEntityType) throws XMLStreamException, EdmPrimitiveTypeException, DeserializerException {
        if (!Constants.QNAME_ATOM_ELEM_FEED.equals(start.getName())) {
            return null;
        }
        EntityCollection entitySet = new EntityCollection();
        Attribute xmlBase = start.getAttributeByName(Constants.QNAME_ATTR_XML_BASE);
        if (xmlBase != null) {
            entitySet.setBaseURI(URI.create(xmlBase.getValue()));
        }
        boolean foundEndFeed = false;
        while (reader.hasNext() && !foundEndFeed) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                if (countQName.equals(event.asStartElement().getName())) {
                    this.count(reader, event.asStartElement(), entitySet);
                } else if (Constants.QNAME_ATOM_ELEM_ID.equals(event.asStartElement().getName())) {
                    this.common(reader, event.asStartElement(), (AbstractODataObject)entitySet, "id");
                } else if (Constants.QNAME_ATOM_ELEM_LINK.equals(event.asStartElement().getName())) {
                    Attribute rel = event.asStartElement().getAttributeByName(QName.valueOf("rel"));
                    if (rel != null) {
                        Attribute href;
                        if ("next".equals(rel.getValue()) && (href = event.asStartElement().getAttributeByName(QName.valueOf("href"))) != null) {
                            entitySet.setNext(URI.create(href.getValue()));
                        }
                        if ("http://docs.oasis-open.org/odata/ns/delta".equals(rel.getValue()) && (href = event.asStartElement().getAttributeByName(QName.valueOf("href"))) != null) {
                            entitySet.setDeltaLink(URI.create(href.getValue()));
                        }
                    }
                } else if (Constants.QNAME_ATOM_ELEM_ENTRY.equals(event.asStartElement().getName())) {
                    entitySet.getEntities().add(this.entity(reader, event.asStartElement(), edmEntityType));
                } else if (entryRefQName.equals(event.asStartElement().getName())) {
                    entitySet.getEntities().add(this.entityRef(event.asStartElement()));
                }
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndFeed = true;
        }
        return entitySet;
    }

    public DeserializerResult entityCollection(InputStream input, EdmEntityType edmEntityType) throws DeserializerException {
        try {
            XMLEventReader reader = this.getReader(input);
            StartElement start = this.skipBeforeFirstStartElement(reader);
            EntityCollection entityCollection = this.entitySet(reader, start, edmEntityType);
            if (entityCollection != null) {
                for (Entity entity : entityCollection.getEntities()) {
                    entity.setType(edmEntityType.getFullQualifiedName().getFullQualifiedNameAsString());
                }
            }
            return DeserializerResultImpl.with().entityCollection(entityCollection).build();
        }
        catch (XMLStreamException e) {
            throw new DeserializerException(e.getMessage(), (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new DeserializerException(e.getMessage(), (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[0]);
        }
    }

    public DeserializerResult entityReferences(InputStream stream) throws DeserializerException {
        try {
            XMLEventReader reader = this.getReader(stream);
            ArrayList<URI> references = new ArrayList<URI>();
            while (reader.hasNext()) {
                StartElement start;
                XMLEvent event = reader.nextEvent();
                if (!event.isStartElement() || !entryRefQName.equals((start = event.asStartElement()).getName())) continue;
                Attribute context = start.getAttributeByName(Constants.QNAME_ATOM_ATTR_ID);
                URI uri = URI.create(context.getValue());
                references.add(uri);
            }
            return DeserializerResultImpl.with().entityReferences(references).build();
        }
        catch (XMLStreamException e) {
            throw new DeserializerException(e.getMessage(), (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
    }

    public DeserializerResult actionParameters(InputStream stream, EdmAction edmAction) throws DeserializerException {
        LinkedHashMap<String, Parameter> parameters = new LinkedHashMap<String, Parameter>();
        if (edmAction.getParameterNames() == null || edmAction.getParameterNames().isEmpty() || edmAction.isBound() && edmAction.getParameterNames().size() == 1) {
            return DeserializerResultImpl.with().actionParameters(parameters).build();
        }
        try {
            XMLEventReader reader = this.getReader(stream);
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (!event.isStartElement() || !parametersQName.equals(event.asStartElement().getName())) continue;
                this.consumeParameters(edmAction, reader, event.asStartElement(), parameters);
            }
            for (String param : edmAction.getParameterNames()) {
                Parameter parameter = (Parameter)parameters.get(param);
                if (parameter != null) continue;
                EdmParameter edmParameter = edmAction.getParameter(param);
                if (!edmParameter.isNullable()) {
                    throw new DeserializerException("Non-nullable parameter not present or null: " + param, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PARAMETER, new String[]{param});
                }
                if (edmParameter.isCollection()) {
                    throw new DeserializerException("Collection must not be null for parameter: " + param, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PARAMETER, new String[]{param});
                }
                parameter = new Parameter();
                parameter.setName(param);
                parameter.setValue(ValueType.PRIMITIVE, null);
                parameters.put(param, parameter);
            }
            return DeserializerResultImpl.with().actionParameters(parameters).build();
        }
        catch (XMLStreamException e) {
            throw new DeserializerException(e.getMessage(), (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new DeserializerException(e.getMessage(), (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[0]);
        }
    }

    private void consumeParameters(EdmAction edmAction, XMLEventReader reader, StartElement start, Map<String, Parameter> parameters) throws DeserializerException, EdmPrimitiveTypeException, XMLStreamException {
        List parameterNames = edmAction.getParameterNames();
        if (edmAction.isBound()) {
            parameterNames = parameterNames.subList(1, parameterNames.size());
        }
        boolean foundEndElement = false;
        while (reader.hasNext() && !foundEndElement) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                boolean found = false;
                for (String paramName : parameterNames) {
                    if (!paramName.equals(event.asStartElement().getName().getLocalPart())) continue;
                    found = true;
                    Parameter parameter = this.createParameter(reader, event.asStartElement(), paramName, edmAction.getParameter(paramName));
                    Parameter previous = parameters.put(paramName, parameter);
                    if (previous == null) break;
                    throw new DeserializerException("Duplicate property detected", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.DUPLICATE_PROPERTY, new String[0]);
                }
                if (!found) {
                    throw new DeserializerException("failed to read " + event.asStartElement().getName().getLocalPart(), (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_CONTENT, new String[0]);
                }
            }
            if (!event.isEndElement() || !start.getName().equals(event.asEndElement().getName())) continue;
            foundEndElement = true;
        }
    }

    private Parameter createParameter(XMLEventReader reader, StartElement start, String paramName, EdmParameter edmParameter) throws DeserializerException, EdmPrimitiveTypeException, XMLStreamException {
        Parameter parameter = new Parameter();
        parameter.setName(paramName);
        switch (edmParameter.getType().getKind()) {
            case PRIMITIVE: 
            case ENUM: 
            case DEFINITION: 
            case COMPLEX: {
                Property property = this.property(reader, start, edmParameter.getType(), edmParameter.isNullable(), edmParameter.getMaxLength(), edmParameter.getPrecision(), edmParameter.getScale(), true, edmParameter.isCollection());
                parameter.setValue(property.getValueType(), property.getValue());
                break;
            }
            case ENTITY: {
                if (edmParameter.isCollection()) {
                    EntityCollection entityCollection = this.entitySet(reader, start, (EdmEntityType)edmParameter.getType());
                    parameter.setValue(ValueType.COLLECTION_ENTITY, (Object)entityCollection);
                    break;
                }
                Entity entity = this.entity(reader, start, (EdmEntityType)edmParameter.getType());
                parameter.setValue(ValueType.ENTITY, (Object)entity);
                break;
            }
            default: {
                throw new DeserializerException("Invalid type kind " + edmParameter.getType().getKind().toString() + " for action parameter: " + paramName, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_ACTION_PARAMETER_TYPE, new String[]{paramName});
            }
        }
        return parameter;
    }

    private EdmType getDerivedType(EdmStructuredType edmType, String odataType) throws DeserializerException {
        if (odataType != null && !odataType.isEmpty()) {
            if (odataType.equalsIgnoreCase(edmType.getFullQualifiedName().getFullQualifiedNameAsString())) {
                return edmType;
            }
            if (this.serviceMetadata == null) {
                throw new DeserializerException("Failed to resolve Odata type " + odataType + " due to metadata is not available", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_CONTENT, new String[0]);
            }
            Object currentEdmType = null;
            currentEdmType = edmType instanceof EdmEntityType ? this.serviceMetadata.getEdm().getEntityType(new FullQualifiedName(odataType)) : this.serviceMetadata.getEdm().getComplexType(new FullQualifiedName(odataType));
            if (!this.isAssignable(edmType, (EdmStructuredType)currentEdmType)) {
                throw new DeserializerException("Odata type " + odataType + " not allowed here", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_CONTENT, new String[0]);
            }
            return currentEdmType;
        }
        return edmType;
    }

    private boolean isAssignable(EdmStructuredType edmStructuredType, EdmStructuredType edmStructuredTypeToAssign) {
        if (edmStructuredTypeToAssign == null) {
            return false;
        }
        if (edmStructuredType.getFullQualifiedName().equals((Object)edmStructuredTypeToAssign.getFullQualifiedName())) {
            return true;
        }
        return this.isAssignable(edmStructuredType, edmStructuredTypeToAssign.getBaseType());
    }
}

