/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.olingo.commons.api.data.AbstractEntityCollection;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityIterator;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Linked;
import org.apache.olingo.commons.api.data.Operation;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.ex.ODataError;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.ComplexSerializerOptions;
import org.apache.olingo.server.api.serializer.EntityCollectionSerializerOptions;
import org.apache.olingo.server.api.serializer.EntitySerializerOptions;
import org.apache.olingo.server.api.serializer.PrimitiveSerializerOptions;
import org.apache.olingo.server.api.serializer.ReferenceCollectionSerializerOptions;
import org.apache.olingo.server.api.serializer.ReferenceSerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.api.serializer.SerializerStreamResult;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.core.ODataWritableContent;
import org.apache.olingo.server.core.serializer.AbstractODataSerializer;
import org.apache.olingo.server.core.serializer.SerializerResultImpl;
import org.apache.olingo.server.core.serializer.json.ODataErrorSerializer;
import org.apache.olingo.server.core.serializer.json.ServiceDocumentJsonSerializer;
import org.apache.olingo.server.core.serializer.utils.CircleStreamBuffer;
import org.apache.olingo.server.core.serializer.utils.ContentTypeHelper;
import org.apache.olingo.server.core.serializer.utils.ContextURLBuilder;
import org.apache.olingo.server.core.serializer.utils.ExpandSelectHelper;
import org.apache.olingo.server.core.uri.UriHelperImpl;

public class ODataJsonSerializer
extends AbstractODataSerializer {
    private final boolean isIEEE754Compatible;
    private final boolean isODataMetadataNone;
    private final boolean isODataMetadataFull;

    public ODataJsonSerializer(ContentType contentType) {
        this.isIEEE754Compatible = ContentTypeHelper.isODataIEEE754Compatible(contentType);
        this.isODataMetadataNone = ContentTypeHelper.isODataMetadataNone(contentType);
        this.isODataMetadataFull = ContentTypeHelper.isODataMetadataFull(contentType);
    }

    public SerializerResult serviceDocument(ServiceMetadata metadata, String serviceRoot) throws SerializerException {
        SerializerResult serializerResult;
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            outputStream = buffer.getOutputStream();
            JsonGenerator json = new JsonFactory().createGenerator(outputStream);
            new ServiceDocumentJsonSerializer(metadata, serviceRoot, this.isODataMetadataNone).writeServiceDocument(json);
            json.close();
            outputStream.close();
            serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (IOException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
            }
            catch (Throwable throwable) {
                this.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        this.closeCircleStreamBufferOutput(outputStream, cachedException);
        return serializerResult;
    }

    public SerializerResult metadataDocument(ServiceMetadata serviceMetadata) throws SerializerException {
        throw new SerializerException("Metadata in JSON format not supported!", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.JSON_METADATA, new String[0]);
    }

    public SerializerResult error(ODataServerError error) throws SerializerException {
        SerializerResult serializerResult;
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            outputStream = buffer.getOutputStream();
            JsonGenerator json = new JsonFactory().createGenerator(outputStream);
            new ODataErrorSerializer().writeErrorDocument(json, (ODataError)error);
            json.close();
            outputStream.close();
            serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (IOException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
            }
            catch (Throwable throwable) {
                this.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        this.closeCircleStreamBufferOutput(outputStream, cachedException);
        return serializerResult;
    }

    public SerializerResult entityCollection(ServiceMetadata metadata, EdmEntityType entityType, AbstractEntityCollection entitySet, EntityCollectionSerializerOptions options) throws SerializerException {
        SerializerResult serializerResult;
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            outputStream = buffer.getOutputStream();
            JsonGenerator json = new JsonFactory().createGenerator(outputStream);
            json.writeStartObject();
            ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
            this.writeContextURL(contextURL, json);
            this.writeMetadataETag(metadata, json);
            if (options != null && options.getCount() != null && options.getCount().getValue()) {
                this.writeInlineCount("", entitySet.getCount(), json);
            }
            this.writeOperations(entitySet.getOperations(), json);
            json.writeFieldName("value");
            if (options == null) {
                this.writeEntitySet(metadata, entityType, entitySet, null, null, false, json);
            } else {
                this.writeEntitySet(metadata, entityType, entitySet, options.getExpand(), options.getSelect(), options.getWriteOnlyReferences(), json);
            }
            this.writeNextLink(entitySet, json);
            json.close();
            outputStream.close();
            serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (IOException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
            }
            catch (Throwable throwable) {
                this.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        this.closeCircleStreamBufferOutput(outputStream, cachedException);
        return serializerResult;
    }

    public SerializerStreamResult entityCollectionStreamed(ServiceMetadata metadata, EdmEntityType entityType, EntityIterator entities, EntityCollectionSerializerOptions options) throws SerializerException {
        return ODataWritableContent.with(entities, entityType, this, metadata, options).build();
    }

    public void entityCollectionIntoStream(ServiceMetadata metadata, EdmEntityType entityType, EntityIterator entitySet, EntityCollectionSerializerOptions options, OutputStream outputStream) throws SerializerException {
        try {
            JsonGenerator json = new JsonFactory().createGenerator(outputStream);
            json.writeStartObject();
            ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
            this.writeContextURL(contextURL, json);
            this.writeMetadataETag(metadata, json);
            if (options != null && options.getCount() != null && options.getCount().getValue()) {
                this.writeInlineCount("", entitySet.getCount(), json);
            }
            json.writeFieldName("value");
            if (options == null) {
                this.writeEntitySet(metadata, entityType, (AbstractEntityCollection)entitySet, null, null, false, json);
            } else {
                this.writeEntitySet(metadata, entityType, (AbstractEntityCollection)entitySet, options.getExpand(), options.getSelect(), options.getWriteOnlyReferences(), json);
            }
            json.close();
        }
        catch (IOException e) {
            SerializerException cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
            throw cachedException;
        }
    }

    public SerializerResult entity(ServiceMetadata metadata, EdmEntityType entityType, Entity entity, EntitySerializerOptions options) throws SerializerException {
        SerializerResult serializerResult;
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            outputStream = buffer.getOutputStream();
            JsonGenerator json = new JsonFactory().createGenerator(outputStream);
            this.writeEntity(metadata, entityType, entity, contextURL, options == null ? null : options.getExpand(), options == null ? null : options.getSelect(), options == null ? false : options.getWriteOnlyReferences(), json);
            json.close();
            outputStream.close();
            serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (IOException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
            }
            catch (Throwable throwable) {
                this.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        this.closeCircleStreamBufferOutput(outputStream, cachedException);
        return serializerResult;
    }

    ContextURL checkContextURL(ContextURL contextURL) throws SerializerException {
        if (this.isODataMetadataNone) {
            return null;
        }
        if (contextURL == null) {
            throw new SerializerException("ContextURL null!", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.NO_CONTEXT_URL, new String[0]);
        }
        return contextURL;
    }

    protected void writeEntitySet(ServiceMetadata metadata, EdmEntityType entityType, AbstractEntityCollection entitySet, ExpandOption expand, SelectOption select, boolean onlyReference, JsonGenerator json) throws IOException, SerializerException {
        json.writeStartArray();
        for (Entity entity : entitySet) {
            if (onlyReference) {
                json.writeStartObject();
                json.writeStringField("@odata.id", this.getEntityId(entity));
                json.writeEndObject();
                continue;
            }
            this.writeEntity(metadata, entityType, entity, null, expand, select, false, json);
        }
        json.writeEndArray();
    }

    private String getEntityId(Entity entity) throws SerializerException {
        if (entity.getId() == null) {
            throw new SerializerException("Entity id is null.", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.MISSING_ID, new String[0]);
        }
        return entity.getId().toASCIIString();
    }

    private boolean areKeyPredicateNamesSelected(SelectOption select, EdmEntityType type) {
        if (select == null || ExpandSelectHelper.isAll(select)) {
            return true;
        }
        Set<String> selected = ExpandSelectHelper.getSelectedPropertyNames(select.getSelectItems());
        for (String key : type.getKeyPredicateNames()) {
            if (selected.contains(key)) continue;
            return false;
        }
        return true;
    }

    public void writeEntity(ServiceMetadata metadata, EdmEntityType entityType, Entity entity, ContextURL contextURL, ExpandOption expand, SelectOption select, boolean onlyReference, JsonGenerator json) throws IOException, SerializerException {
        json.writeStartObject();
        if (!this.isODataMetadataNone) {
            if (contextURL != null) {
                this.writeContextURL(contextURL, json);
                this.writeMetadataETag(metadata, json);
            }
            if (entity.getETag() != null) {
                json.writeStringField("@odata.etag", entity.getETag());
            }
            if (entityType.hasStream()) {
                if (entity.getMediaETag() != null) {
                    json.writeStringField("@odata.mediaEtag", entity.getMediaETag());
                }
                if (entity.getMediaContentType() != null) {
                    json.writeStringField("@odata.mediaContentType", entity.getMediaContentType());
                }
                if (entity.getMediaContentSource() != null) {
                    json.writeStringField("@odata.mediaReadLink", entity.getMediaContentSource().toString());
                }
                if (entity.getMediaEditLinks() != null && !entity.getMediaEditLinks().isEmpty()) {
                    json.writeStringField("@odata.mediaEditLink", ((Link)entity.getMediaEditLinks().get(0)).getHref());
                }
            }
        }
        if (onlyReference) {
            json.writeStringField("@odata.id", this.getEntityId(entity));
        } else {
            EdmEntityType resolvedType = this.resolveEntityType(metadata, entityType, entity.getType());
            if (!this.isODataMetadataNone && !resolvedType.equals(entityType) || this.isODataMetadataFull) {
                json.writeStringField("@odata.type", "#" + entity.getType());
            }
            if (!this.isODataMetadataNone && !this.areKeyPredicateNamesSelected(select, resolvedType) || this.isODataMetadataFull) {
                json.writeStringField("@odata.id", this.getEntityId(entity));
            }
            if (this.isODataMetadataFull) {
                if (entity.getSelfLink() != null) {
                    json.writeStringField("@odata.readLink", entity.getSelfLink().getHref());
                }
                if (entity.getEditLink() != null) {
                    json.writeStringField("@odata.editLink", entity.getEditLink().getHref());
                }
            }
            this.writeProperties(metadata, (EdmStructuredType)resolvedType, entity.getProperties(), select, json);
            this.writeNavigationProperties(metadata, (EdmStructuredType)resolvedType, (Linked)entity, expand, json);
            this.writeOperations(entity.getOperations(), json);
            json.writeEndObject();
        }
    }

    private void writeOperations(List<Operation> operations, JsonGenerator json) throws IOException {
        if (this.isODataMetadataFull) {
            for (Operation operation : operations) {
                json.writeObjectFieldStart(operation.getMetadataAnchor());
                json.writeStringField("title", operation.getTitle());
                json.writeStringField("target", operation.getTarget().toASCIIString());
                json.writeEndObject();
            }
        }
    }

    protected EdmEntityType resolveEntityType(ServiceMetadata metadata, EdmEntityType baseType, String derivedTypeName) throws SerializerException {
        if (derivedTypeName == null || baseType.getFullQualifiedName().getFullQualifiedNameAsString().equals(derivedTypeName)) {
            return baseType;
        }
        EdmEntityType derivedType = metadata.getEdm().getEntityType(new FullQualifiedName(derivedTypeName));
        if (derivedType == null) {
            throw new SerializerException("EntityType not found", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.UNKNOWN_TYPE, new String[]{derivedTypeName});
        }
        for (EdmEntityType type = derivedType.getBaseType(); type != null; type = type.getBaseType()) {
            if (!type.getFullQualifiedName().equals((Object)baseType.getFullQualifiedName())) continue;
            return derivedType;
        }
        throw new SerializerException("Wrong base type", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.WRONG_BASE_TYPE, new String[]{derivedTypeName, baseType.getFullQualifiedName().getFullQualifiedNameAsString()});
    }

    protected EdmComplexType resolveComplexType(ServiceMetadata metadata, EdmComplexType baseType, String derivedTypeName) throws SerializerException {
        String fullQualifiedName = baseType.getFullQualifiedName().getFullQualifiedNameAsString();
        if (derivedTypeName == null || fullQualifiedName.equals(derivedTypeName)) {
            return baseType;
        }
        EdmComplexType derivedType = metadata.getEdm().getComplexType(new FullQualifiedName(derivedTypeName));
        if (derivedType == null) {
            throw new SerializerException("Complex Type not found", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.UNKNOWN_TYPE, new String[]{derivedTypeName});
        }
        for (EdmComplexType type = derivedType.getBaseType(); type != null; type = type.getBaseType()) {
            if (!type.getFullQualifiedName().equals((Object)baseType.getFullQualifiedName())) continue;
            return derivedType;
        }
        throw new SerializerException("Wrong base type", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.WRONG_BASE_TYPE, new String[]{derivedTypeName, baseType.getFullQualifiedName().getFullQualifiedNameAsString()});
    }

    protected void writeProperties(ServiceMetadata metadata, EdmStructuredType type, List<Property> properties, SelectOption select, JsonGenerator json) throws IOException, SerializerException {
        boolean all = ExpandSelectHelper.isAll(select);
        Set<Object> selected = all ? new HashSet() : ExpandSelectHelper.getSelectedPropertyNames(select.getSelectItems());
        for (String propertyName : type.getPropertyNames()) {
            if (!all && !selected.contains(propertyName)) continue;
            EdmProperty edmProperty = type.getStructuralProperty(propertyName);
            Property property = this.findProperty(propertyName, properties);
            Set<List<String>> selectedPaths = all || edmProperty.isPrimitive() ? null : ExpandSelectHelper.getSelectedPaths(select.getSelectItems(), propertyName);
            this.writeProperty(metadata, edmProperty, property, selectedPaths, json);
        }
    }

    protected void writeNavigationProperties(ServiceMetadata metadata, EdmStructuredType type, Linked linked, ExpandOption expand, JsonGenerator json) throws SerializerException, IOException {
        block5: {
            block4: {
                if (!ExpandSelectHelper.hasExpand(expand)) break block4;
                boolean expandAll = ExpandSelectHelper.isExpandAll(expand);
                Set<Object> expanded = expandAll ? new HashSet() : ExpandSelectHelper.getExpandedPropertyNames(expand.getExpandItems());
                for (String propertyName : type.getNavigationPropertyNames()) {
                    ExpandItem innerOptions;
                    if (!expandAll && !expanded.contains(propertyName)) continue;
                    EdmNavigationProperty property = type.getNavigationProperty(propertyName);
                    Link navigationLink = linked.getNavigationLink(property.getName());
                    ExpandItem expandItem = innerOptions = expandAll ? null : ExpandSelectHelper.getExpandItem(expand.getExpandItems(), propertyName);
                    if (innerOptions != null && innerOptions.getLevelsOption() != null) {
                        throw new SerializerException("Expand option $levels is not supported.", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
                    }
                    this.writeExpandedNavigationProperty(metadata, property, navigationLink, innerOptions == null ? null : innerOptions.getExpandOption(), innerOptions == null ? null : innerOptions.getSelectOption(), innerOptions == null ? null : innerOptions.getCountOption(), innerOptions == null ? false : innerOptions.hasCountPath(), innerOptions == null ? false : innerOptions.isRef(), json);
                }
                break block5;
            }
            if (!this.isODataMetadataFull) break block5;
            for (String propertyName : type.getNavigationPropertyNames()) {
                Link associationLink;
                Link navigationLink = linked.getNavigationLink(propertyName);
                if (navigationLink != null) {
                    json.writeStringField(propertyName + "@odata.navigationLink", navigationLink.getHref());
                }
                if ((associationLink = linked.getAssociationLink(propertyName)) == null) continue;
                json.writeStringField(propertyName + "@odata.associationLink", associationLink.getHref());
            }
        }
    }

    protected void writeExpandedNavigationProperty(ServiceMetadata metadata, EdmNavigationProperty property, Link navigationLink, ExpandOption innerExpand, SelectOption innerSelect, CountOption innerCount, boolean writeOnlyCount, boolean writeOnlyRef, JsonGenerator json) throws IOException, SerializerException {
        if (property.isCollection()) {
            if (writeOnlyCount) {
                if (navigationLink == null || navigationLink.getInlineEntitySet() == null) {
                    this.writeInlineCount(property.getName(), 0, json);
                } else {
                    this.writeInlineCount(property.getName(), navigationLink.getInlineEntitySet().getCount(), json);
                }
            } else if (navigationLink == null || navigationLink.getInlineEntitySet() == null) {
                if (innerCount != null && innerCount.getValue()) {
                    this.writeInlineCount(property.getName(), 0, json);
                }
                json.writeFieldName(property.getName());
                json.writeStartArray();
                json.writeEndArray();
            } else {
                if (innerCount != null && innerCount.getValue()) {
                    this.writeInlineCount(property.getName(), navigationLink.getInlineEntitySet().getCount(), json);
                }
                json.writeFieldName(property.getName());
                this.writeEntitySet(metadata, property.getType(), (AbstractEntityCollection)navigationLink.getInlineEntitySet(), innerExpand, innerSelect, writeOnlyRef, json);
            }
        } else {
            json.writeFieldName(property.getName());
            if (navigationLink == null || navigationLink.getInlineEntity() == null) {
                json.writeNull();
            } else {
                this.writeEntity(metadata, property.getType(), navigationLink.getInlineEntity(), null, innerExpand, innerSelect, writeOnlyRef, json);
            }
        }
    }

    private boolean isStreamProperty(EdmProperty edmProperty) {
        EdmType type = edmProperty.getType();
        return edmProperty.isPrimitive() && type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Stream);
    }

    protected void writeProperty(ServiceMetadata metadata, EdmProperty edmProperty, Property property, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, SerializerException {
        boolean isStreamProperty = this.isStreamProperty(edmProperty);
        this.writePropertyType(edmProperty, json);
        if (!isStreamProperty) {
            json.writeFieldName(edmProperty.getName());
        }
        if (property == null || property.isNull()) {
            if (edmProperty.isNullable() == Boolean.FALSE.booleanValue()) {
                throw new SerializerException("Non-nullable property not present!", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.MISSING_PROPERTY, new String[]{edmProperty.getName()});
            }
            if (!isStreamProperty) {
                if (edmProperty.isCollection()) {
                    json.writeStartArray();
                    json.writeEndArray();
                } else {
                    json.writeNull();
                }
            }
        } else {
            this.writePropertyValue(metadata, edmProperty, property, selectedPaths, json);
        }
    }

    private void writePropertyType(EdmProperty edmProperty, JsonGenerator json) throws SerializerException, IOException {
        if (!this.isODataMetadataFull) {
            return;
        }
        String typeName = edmProperty.getName() + "@odata.type";
        EdmType type = edmProperty.getType();
        if (type.getKind() == EdmTypeKind.ENUM || type.getKind() == EdmTypeKind.DEFINITION) {
            if (edmProperty.isCollection()) {
                json.writeStringField(typeName, "#Collection(" + type.getFullQualifiedName().getFullQualifiedNameAsString() + ")");
            } else {
                json.writeStringField(typeName, "#" + type.getFullQualifiedName().getFullQualifiedNameAsString());
            }
        } else if (edmProperty.isPrimitive()) {
            if (edmProperty.isCollection()) {
                json.writeStringField(typeName, "#Collection(" + type.getFullQualifiedName().getName() + ")");
            } else if (type != EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Boolean) && type != EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Double) && type != EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.String)) {
                json.writeStringField(typeName, "#" + type.getFullQualifiedName().getName());
            }
        } else if (type.getKind() == EdmTypeKind.COMPLEX) {
            if (edmProperty.isCollection()) {
                json.writeStringField(typeName, "#Collection(" + type.getFullQualifiedName().getFullQualifiedNameAsString() + ")");
            }
        } else {
            throw new SerializerException("Property type not yet supported!", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{edmProperty.getName()});
        }
    }

    private void writePropertyValue(ServiceMetadata metadata, EdmProperty edmProperty, Property property, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, SerializerException {
        block8: {
            EdmType type = edmProperty.getType();
            try {
                if (edmProperty.isPrimitive() || type.getKind() == EdmTypeKind.ENUM || type.getKind() == EdmTypeKind.DEFINITION) {
                    if (edmProperty.isCollection()) {
                        this.writePrimitiveCollection((EdmPrimitiveType)type, property, edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), json);
                    } else {
                        this.writePrimitive((EdmPrimitiveType)type, property, edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), json);
                    }
                    break block8;
                }
                if (property.isComplex()) {
                    if (edmProperty.isCollection()) {
                        this.writeComplexCollection(metadata, (EdmComplexType)type, property, selectedPaths, json);
                    } else {
                        this.writeComplex(metadata, (EdmComplexType)type, property, selectedPaths, json);
                    }
                    break block8;
                }
                throw new SerializerException("Property type not yet supported!", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{edmProperty.getName()});
            }
            catch (EdmPrimitiveTypeException e) {
                throw new SerializerException("Wrong value for property!", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, new String[]{edmProperty.getName(), property.getValue().toString()});
            }
        }
    }

    private void writeComplex(ServiceMetadata metadata, EdmComplexType type, Property property, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, SerializerException {
        json.writeStartObject();
        String derivedName = property.getType();
        EdmComplexType resolvedType = this.resolveComplexType(metadata, type, derivedName);
        if (!this.isODataMetadataNone && !resolvedType.equals(type) || this.isODataMetadataFull) {
            json.writeStringField("@odata.type", "#" + property.getType());
        }
        this.writeComplexValue(metadata, resolvedType, property.asComplex().getValue(), selectedPaths, json);
        json.writeEndObject();
    }

    private void writePrimitiveCollection(EdmPrimitiveType type, Property property, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, JsonGenerator json) throws IOException, SerializerException {
        json.writeStartArray();
        block6: for (Object value : property.asCollection()) {
            switch (property.getValueType()) {
                case COLLECTION_PRIMITIVE: 
                case COLLECTION_ENUM: {
                    try {
                        this.writePrimitiveValue(property.getName(), type, value, isNullable, maxLength, precision, scale, isUnicode, json);
                        continue block6;
                    }
                    catch (EdmPrimitiveTypeException e) {
                        throw new SerializerException("Wrong value for property!", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, new String[]{property.getName(), property.getValue().toString()});
                    }
                }
                case COLLECTION_GEOSPATIAL: {
                    throw new SerializerException("Property type not yet supported!", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{property.getName()});
                }
            }
            throw new SerializerException("Property type not yet supported!", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{property.getName()});
        }
        json.writeEndArray();
    }

    private void writeComplexCollection(ServiceMetadata metadata, EdmComplexType type, Property property, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, SerializerException {
        json.writeStartArray();
        block3: for (Object value : property.asCollection()) {
            switch (property.getValueType()) {
                case COLLECTION_COMPLEX: {
                    json.writeStartObject();
                    if (this.isODataMetadataFull) {
                        json.writeStringField("@odata.type", "#" + type.getFullQualifiedName().getFullQualifiedNameAsString());
                    }
                    this.writeComplexValue(metadata, type, ((ComplexValue)value).getValue(), selectedPaths, json);
                    json.writeEndObject();
                    continue block3;
                }
            }
            throw new SerializerException("Property type not yet supported!", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{property.getName()});
        }
        json.writeEndArray();
    }

    private void writePrimitive(EdmPrimitiveType type, Property property, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, JsonGenerator json) throws EdmPrimitiveTypeException, IOException, SerializerException {
        if (property.isPrimitive()) {
            this.writePrimitiveValue(property.getName(), type, property.asPrimitive(), isNullable, maxLength, precision, scale, isUnicode, json);
        } else {
            if (property.isGeospatial()) {
                throw new SerializerException("Property type not yet supported!", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{property.getName()});
            }
            if (property.isEnum()) {
                this.writePrimitiveValue(property.getName(), type, property.asEnum(), isNullable, maxLength, precision, scale, isUnicode, json);
            } else {
                throw new SerializerException("Inconsistent property type!", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.INCONSISTENT_PROPERTY_TYPE, new String[]{property.getName()});
            }
        }
    }

    protected void writePrimitiveValue(String name, EdmPrimitiveType type, Object primitiveValue, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, JsonGenerator json) throws EdmPrimitiveTypeException, IOException {
        String value = type.valueToString(primitiveValue, isNullable, maxLength, precision, scale, isUnicode);
        if (value == null) {
            json.writeNull();
        } else if (type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Boolean)) {
            json.writeBoolean(Boolean.parseBoolean(value));
        } else if (type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Byte) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Double) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Int16) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Int32) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.SByte) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Single) || (type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Decimal) || type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Int64)) && !this.isIEEE754Compatible) {
            json.writeNumber(value);
        } else if (type == EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.Stream)) {
            if (primitiveValue instanceof Link) {
                Link stream = (Link)primitiveValue;
                if (!this.isODataMetadataNone) {
                    if (stream.getMediaETag() != null) {
                        json.writeStringField(name + "@odata.mediaEtag", stream.getMediaETag());
                    }
                    if (stream.getType() != null) {
                        json.writeStringField(name + "@odata.mediaContentType", stream.getType());
                    }
                }
                if (this.isODataMetadataFull) {
                    if (stream.getRel() != null && stream.getRel().equals("http://docs.oasis-open.org/odata/ns/mediaresource/")) {
                        json.writeStringField(name + "@odata.mediaReadLink", stream.getHref());
                    }
                    if (stream.getRel() == null || stream.getRel().equals("http://docs.oasis-open.org/odata/ns/edit-media/")) {
                        json.writeStringField(name + "@odata.mediaEditLink", stream.getHref());
                    }
                }
            }
        } else {
            json.writeString(value);
        }
    }

    protected void writeComplexValue(ServiceMetadata metadata, EdmComplexType type, List<Property> properties, Set<List<String>> selectedPaths, JsonGenerator json) throws IOException, SerializerException {
        for (String propertyName : type.getPropertyNames()) {
            Property property = this.findProperty(propertyName, properties);
            if (selectedPaths != null && !ExpandSelectHelper.isSelected(selectedPaths, propertyName)) continue;
            this.writeProperty(metadata, (EdmProperty)type.getProperty(propertyName), property, selectedPaths == null ? null : ExpandSelectHelper.getReducedSelectedPaths(selectedPaths, propertyName), json);
        }
    }

    private Property findProperty(String propertyName, List<Property> properties) {
        for (Property property : properties) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SerializerResult primitive(ServiceMetadata metadata, EdmPrimitiveType type, Property property, PrimitiveSerializerOptions options) throws SerializerException {
        SerializerResult serializerResult;
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            outputStream = buffer.getOutputStream();
            JsonGenerator json = new JsonFactory().createGenerator(outputStream);
            json.writeStartObject();
            this.writeContextURL(contextURL, json);
            this.writeMetadataETag(metadata, json);
            this.writeOperations(property.getOperations(), json);
            if (property.isNull()) {
                throw new SerializerException("Property value can not be null.", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.NULL_INPUT, new String[0]);
            }
            json.writeFieldName("value");
            this.writePrimitive(type, property, options == null ? null : options.isNullable(), options == null ? null : options.getMaxLength(), options == null ? null : options.getPrecision(), options == null ? null : options.getScale(), options == null ? null : options.isUnicode(), json);
            json.writeEndObject();
            json.close();
            outputStream.close();
            serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (IOException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
                catch (EdmPrimitiveTypeException e2) {
                    cachedException = new SerializerException("Wrong value for property!", (Throwable)e2, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, new String[]{property.getName(), property.getValue().toString()});
                    throw cachedException;
                }
            }
            catch (Throwable throwable) {
                this.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        this.closeCircleStreamBufferOutput(outputStream, cachedException);
        return serializerResult;
    }

    public SerializerResult complex(ServiceMetadata metadata, EdmComplexType type, Property property, ComplexSerializerOptions options) throws SerializerException {
        SerializerResult serializerResult;
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            outputStream = buffer.getOutputStream();
            JsonGenerator json = new JsonFactory().createGenerator(outputStream);
            json.writeStartObject();
            this.writeContextURL(contextURL, json);
            this.writeMetadataETag(metadata, json);
            EdmComplexType resolvedType = this.resolveComplexType(metadata, type, property.getType());
            if (!this.isODataMetadataNone && !resolvedType.equals(type) || this.isODataMetadataFull) {
                json.writeStringField("@odata.type", "#" + property.getType());
            }
            this.writeOperations(property.getOperations(), json);
            List values = property.isNull() ? Collections.emptyList() : property.asComplex().getValue();
            this.writeProperties(metadata, (EdmStructuredType)type, values, options == null ? null : options.getSelect(), json);
            if (!property.isNull() && property.isComplex()) {
                this.writeNavigationProperties(metadata, (EdmStructuredType)type, (Linked)property.asComplex(), options == null ? null : options.getExpand(), json);
            }
            json.writeEndObject();
            json.close();
            outputStream.close();
            serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (IOException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
            }
            catch (Throwable throwable) {
                this.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        this.closeCircleStreamBufferOutput(outputStream, cachedException);
        return serializerResult;
    }

    public SerializerResult primitiveCollection(ServiceMetadata metadata, EdmPrimitiveType type, Property property, PrimitiveSerializerOptions options) throws SerializerException {
        SerializerResult serializerResult;
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            outputStream = buffer.getOutputStream();
            JsonGenerator json = new JsonFactory().createGenerator(outputStream);
            json.writeStartObject();
            this.writeContextURL(contextURL, json);
            this.writeMetadataETag(metadata, json);
            if (this.isODataMetadataFull) {
                json.writeStringField("@odata.type", "#Collection(" + type.getFullQualifiedName().getName() + ")");
            }
            this.writeOperations(property.getOperations(), json);
            json.writeFieldName("value");
            this.writePrimitiveCollection(type, property, options == null ? null : options.isNullable(), options == null ? null : options.getMaxLength(), options == null ? null : options.getPrecision(), options == null ? null : options.getScale(), options == null ? null : options.isUnicode(), json);
            json.writeEndObject();
            json.close();
            outputStream.close();
            serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (IOException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
            }
            catch (Throwable throwable) {
                this.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        this.closeCircleStreamBufferOutput(outputStream, cachedException);
        return serializerResult;
    }

    public SerializerResult complexCollection(ServiceMetadata metadata, EdmComplexType type, Property property, ComplexSerializerOptions options) throws SerializerException {
        SerializerResult serializerResult;
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            outputStream = buffer.getOutputStream();
            JsonGenerator json = new JsonFactory().createGenerator(outputStream);
            json.writeStartObject();
            this.writeContextURL(contextURL, json);
            this.writeMetadataETag(metadata, json);
            if (this.isODataMetadataFull) {
                json.writeStringField("@odata.type", "#Collection(" + type.getFullQualifiedName().getFullQualifiedNameAsString() + ")");
            }
            this.writeOperations(property.getOperations(), json);
            json.writeFieldName("value");
            this.writeComplexCollection(metadata, type, property, null, json);
            json.writeEndObject();
            json.close();
            outputStream.close();
            serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (IOException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
            }
            catch (Throwable throwable) {
                this.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        this.closeCircleStreamBufferOutput(outputStream, cachedException);
        return serializerResult;
    }

    public SerializerResult reference(ServiceMetadata metadata, EdmEntitySet edmEntitySet, Entity entity, ReferenceSerializerOptions options) throws SerializerException {
        SerializerResult serializerResult;
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            UriHelperImpl uriHelper = new UriHelperImpl();
            outputStream = buffer.getOutputStream();
            JsonGenerator json = new JsonFactory().createGenerator(outputStream);
            json.writeStartObject();
            this.writeContextURL(contextURL, json);
            json.writeStringField("@odata.id", uriHelper.buildCanonicalURL(edmEntitySet, entity));
            json.writeEndObject();
            json.close();
            outputStream.close();
            serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (IOException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
            }
            catch (Throwable throwable) {
                this.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        this.closeCircleStreamBufferOutput(outputStream, cachedException);
        return serializerResult;
    }

    public SerializerResult referenceCollection(ServiceMetadata metadata, EdmEntitySet edmEntitySet, AbstractEntityCollection entityCollection, ReferenceCollectionSerializerOptions options) throws SerializerException {
        Iterator iterator;
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            UriHelperImpl uriHelper = new UriHelperImpl();
            outputStream = buffer.getOutputStream();
            JsonGenerator json = new JsonFactory().createGenerator(outputStream);
            json.writeStartObject();
            this.writeContextURL(contextURL, json);
            if (options != null && options.getCount() != null && options.getCount().getValue()) {
                this.writeInlineCount("", entityCollection.getCount(), json);
            }
            json.writeArrayFieldStart("value");
            for (Entity entity : entityCollection) {
                json.writeStartObject();
                json.writeStringField("@odata.id", uriHelper.buildCanonicalURL(edmEntitySet, entity));
                json.writeEndObject();
            }
            json.writeEndArray();
            this.writeNextLink(entityCollection, json);
            json.writeEndObject();
            json.close();
            outputStream.close();
            iterator = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (IOException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
            }
            catch (Throwable throwable) {
                this.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        this.closeCircleStreamBufferOutput(outputStream, cachedException);
        return iterator;
    }

    void writeContextURL(ContextURL contextURL, JsonGenerator json) throws IOException {
        if (!this.isODataMetadataNone && contextURL != null) {
            json.writeStringField("@odata.context", ContextURLBuilder.create(contextURL).toASCIIString());
        }
    }

    void writeMetadataETag(ServiceMetadata metadata, JsonGenerator json) throws IOException {
        if (!this.isODataMetadataNone && metadata != null && metadata.getServiceMetadataETagSupport() != null && metadata.getServiceMetadataETagSupport().getMetadataETag() != null) {
            json.writeStringField("@odata.metadataEtag", metadata.getServiceMetadataETagSupport().getMetadataETag());
        }
    }

    void writeInlineCount(String propertyName, Integer count, JsonGenerator json) throws IOException {
        if (count != null) {
            if (this.isIEEE754Compatible) {
                json.writeStringField(propertyName + "@odata.count", String.valueOf(count));
            } else {
                json.writeNumberField(propertyName + "@odata.count", count.intValue());
            }
        }
    }

    void writeNextLink(AbstractEntityCollection entitySet, JsonGenerator json) throws IOException {
        if (entitySet.getNext() != null) {
            json.writeStringField("@odata.nextLink", entitySet.getNext().toASCIIString());
        }
    }
}

