/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.util.Locale;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.etag.PreconditionException;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.core.AcceptHeaderContentNegotiatorException;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.ODataHandlerException;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.parser.UriParserSemanticException;
import org.apache.olingo.server.core.uri.parser.UriParserSyntaxException;
import org.apache.olingo.server.core.uri.validator.UriValidationException;

public class ODataExceptionHelper {
    private ODataExceptionHelper() {
    }

    public static ODataServerError createServerErrorObject(UriValidationException e, Locale requestedLocale) {
        ODataServerError serverError = ODataExceptionHelper.basicTranslatedError(e, requestedLocale);
        serverError.setStatusCode(HttpStatusCode.BAD_REQUEST.getStatusCode());
        return serverError;
    }

    public static ODataServerError createServerErrorObject(UriParserSemanticException e, Locale requestedLocale) {
        ODataServerError serverError = ODataExceptionHelper.basicTranslatedError(e, requestedLocale);
        if (UriParserSemanticException.MessageKeys.RESOURCE_NOT_FOUND.equals(e.getMessageKey()) || UriParserSemanticException.MessageKeys.PROPERTY_NOT_IN_TYPE.equals(e.getMessageKey())) {
            serverError.setStatusCode(HttpStatusCode.NOT_FOUND.getStatusCode());
        } else if (UriParserSemanticException.MessageKeys.NOT_IMPLEMENTED.equals(e.getMessageKey())) {
            serverError.setStatusCode(HttpStatusCode.NOT_IMPLEMENTED.getStatusCode());
        } else {
            serverError.setStatusCode(HttpStatusCode.BAD_REQUEST.getStatusCode());
        }
        return serverError;
    }

    public static ODataServerError createServerErrorObject(UriParserSyntaxException e, Locale requestedLocale) {
        ODataServerError serverError = ODataExceptionHelper.basicTranslatedError(e, requestedLocale);
        serverError.setStatusCode(UriParserSyntaxException.MessageKeys.WRONG_VALUE_FOR_SYSTEM_QUERY_OPTION_FORMAT.equals(e.getMessageKey()) ? HttpStatusCode.NOT_ACCEPTABLE.getStatusCode() : HttpStatusCode.BAD_REQUEST.getStatusCode());
        return serverError;
    }

    public static ODataServerError createServerErrorObject(UriParserException e, Locale requestedLocale) {
        ODataServerError serverError = ODataExceptionHelper.basicTranslatedError(e, requestedLocale);
        serverError.setStatusCode(HttpStatusCode.BAD_REQUEST.getStatusCode());
        return serverError;
    }

    public static ODataServerError createServerErrorObject(ContentNegotiatorException e, Locale requestedLocale) {
        ODataServerError serverError = ODataExceptionHelper.basicTranslatedError(e, requestedLocale);
        serverError.setStatusCode(HttpStatusCode.NOT_ACCEPTABLE.getStatusCode());
        return serverError;
    }

    public static ODataServerError createServerErrorObject(AcceptHeaderContentNegotiatorException e, Locale requestedLocale) {
        ODataServerError serverError = ODataExceptionHelper.basicTranslatedError(e, requestedLocale);
        serverError.setStatusCode(HttpStatusCode.BAD_REQUEST.getStatusCode());
        return serverError;
    }

    public static ODataServerError createServerErrorObject(ODataHandlerException e, Locale requestedLocale) {
        ODataServerError serverError = ODataExceptionHelper.basicTranslatedError(e, requestedLocale);
        if (ODataHandlerException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED.equals(e.getMessageKey()) || ODataHandlerException.MessageKeys.PROCESSOR_NOT_IMPLEMENTED.equals(e.getMessageKey())) {
            serverError.setStatusCode(HttpStatusCode.NOT_IMPLEMENTED.getStatusCode());
        } else if (ODataHandlerException.MessageKeys.ODATA_VERSION_NOT_SUPPORTED.equals(e.getMessageKey()) || ODataHandlerException.MessageKeys.INVALID_HTTP_METHOD.equals(e.getMessageKey()) || ODataHandlerException.MessageKeys.AMBIGUOUS_XHTTP_METHOD.equals(e.getMessageKey()) || ODataHandlerException.MessageKeys.MISSING_CONTENT_TYPE.equals(e.getMessageKey()) || ODataHandlerException.MessageKeys.INVALID_CONTENT_TYPE.equals(e.getMessageKey()) || ODataHandlerException.MessageKeys.UNSUPPORTED_CONTENT_TYPE.equals(e.getMessageKey()) || ODataHandlerException.MessageKeys.INVALID_PREFER_HEADER.equals(e.getMessageKey())) {
            serverError.setStatusCode(HttpStatusCode.BAD_REQUEST.getStatusCode());
        } else if (ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED.equals(e.getMessageKey())) {
            serverError.setStatusCode(HttpStatusCode.METHOD_NOT_ALLOWED.getStatusCode());
        }
        return serverError;
    }

    public static ODataServerError createServerErrorObject(SerializerException e, Locale requestedLocale) {
        ODataServerError serverError = ODataExceptionHelper.basicTranslatedError((ODataLibraryException)e, requestedLocale);
        serverError.setStatusCode(HttpStatusCode.BAD_REQUEST.getStatusCode());
        return serverError;
    }

    public static ODataServerError createServerErrorObject(DeserializerException e, Locale requestedLocale) {
        return ODataExceptionHelper.basicTranslatedError((ODataLibraryException)e, requestedLocale).setStatusCode(HttpStatusCode.BAD_REQUEST.getStatusCode());
    }

    public static ODataServerError createServerErrorObject(PreconditionException e, Locale requestedLocale) {
        ODataServerError serverError = ODataExceptionHelper.basicTranslatedError((ODataLibraryException)e, requestedLocale);
        if (PreconditionException.MessageKeys.MISSING_HEADER == e.getMessageKey()) {
            serverError.setStatusCode(HttpStatusCode.PRECONDITION_REQUIRED.getStatusCode());
        } else if (PreconditionException.MessageKeys.FAILED == e.getMessageKey()) {
            serverError.setStatusCode(HttpStatusCode.PRECONDITION_FAILED.getStatusCode());
        }
        return serverError;
    }

    public static ODataServerError createServerErrorObject(ODataLibraryException e, Locale requestedLocale) {
        ODataServerError serverError = ODataExceptionHelper.basicTranslatedError(e, requestedLocale);
        if (e instanceof SerializerException || e instanceof DeserializerException) {
            serverError.setStatusCode(HttpStatusCode.BAD_REQUEST.getStatusCode());
        }
        return serverError;
    }

    public static ODataServerError createServerErrorObject(ODataApplicationException e) {
        ODataServerError serverError = ODataExceptionHelper.basicServerError((Exception)e);
        serverError.setStatusCode(e.getStatusCode());
        serverError.setLocale(e.getLocale());
        serverError.setCode(e.getODataErrorCode());
        serverError.setMessage(e.getLocalizedMessage());
        return serverError;
    }

    public static ODataServerError createServerErrorObject(Exception e) {
        ODataServerError serverError = ODataExceptionHelper.basicServerError(e);
        serverError.setStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        serverError.setLocale(Locale.ENGLISH);
        return serverError;
    }

    private static ODataServerError basicServerError(Exception e) {
        ODataServerError serverError = new ODataServerError().setException(e).setMessage(e.getMessage());
        if (serverError.getMessage() == null) {
            serverError.setMessage("OData Library: An exception without message text was thrown.");
        }
        return serverError;
    }

    private static ODataServerError basicTranslatedError(ODataLibraryException e, Locale requestedLocale) {
        ODataServerError serverError = ODataExceptionHelper.basicServerError((Exception)e);
        ODataLibraryException.ODataErrorMessage translatedMessage = e.getTranslatedMessage(requestedLocale);
        serverError.setMessage(translatedMessage.getMessage());
        serverError.setLocale(translatedMessage.getLocale());
        serverError.setStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        return serverError;
    }
}

