/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.data.AbstractEntityCollection;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.EntityIterator;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Linked;
import org.apache.olingo.commons.api.data.Operation;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.ex.ODataErrorDetail;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.commons.core.edm.primitivetype.EdmString;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.ComplexSerializerOptions;
import org.apache.olingo.server.api.serializer.EntityCollectionSerializerOptions;
import org.apache.olingo.server.api.serializer.EntitySerializerOptions;
import org.apache.olingo.server.api.serializer.PrimitiveSerializerOptions;
import org.apache.olingo.server.api.serializer.ReferenceCollectionSerializerOptions;
import org.apache.olingo.server.api.serializer.ReferenceSerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerResult;
import org.apache.olingo.server.api.serializer.SerializerStreamResult;
import org.apache.olingo.server.api.uri.queryoption.CountOption;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.LevelsExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.core.ODataWritableContent;
import org.apache.olingo.server.core.serializer.AbstractODataSerializer;
import org.apache.olingo.server.core.serializer.SerializerResultImpl;
import org.apache.olingo.server.core.serializer.utils.CircleStreamBuffer;
import org.apache.olingo.server.core.serializer.utils.ContextURLBuilder;
import org.apache.olingo.server.core.serializer.utils.ExpandSelectHelper;
import org.apache.olingo.server.core.serializer.xml.MetadataDocumentXmlSerializer;
import org.apache.olingo.server.core.serializer.xml.ServiceDocumentXmlSerializer;
import org.apache.olingo.server.core.uri.UriHelperImpl;
import org.apache.olingo.server.core.uri.queryoption.ExpandOptionImpl;

public class ODataXmlSerializer
extends AbstractODataSerializer {
    private static final String ATOM = "a";
    private static final String NS_ATOM = "http://www.w3.org/2005/Atom";
    private static final String METADATA = "m";
    private static final String NS_METADATA = "http://docs.oasis-open.org/odata/ns/metadata";
    private static final String DATA = "d";
    private static final String NS_DATA = "http://docs.oasis-open.org/odata/ns/data";

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SerializerResult serviceDocument(ServiceMetadata metadata, String serviceRoot) throws SerializerException {
        SerializerResult serializerResult;
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            outputStream = buffer.getOutputStream();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream, "UTF-8");
            ServiceDocumentXmlSerializer serializer = new ServiceDocumentXmlSerializer(metadata, serviceRoot);
            serializer.writeServiceDocument(writer);
            writer.flush();
            writer.close();
            outputStream.close();
            serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (XMLStreamException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
                catch (IOException e2) {
                    cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e2, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                    throw cachedException;
                }
            }
            catch (Throwable throwable) {
                this.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        this.closeCircleStreamBufferOutput(outputStream, cachedException);
        return serializerResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SerializerResult metadataDocument(ServiceMetadata serviceMetadata) throws SerializerException {
        SerializerResult serializerResult;
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            outputStream = buffer.getOutputStream();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream, "UTF-8");
            MetadataDocumentXmlSerializer serializer = new MetadataDocumentXmlSerializer(serviceMetadata);
            serializer.writeMetadataDocument(writer);
            writer.flush();
            writer.close();
            outputStream.close();
            serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (XMLStreamException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
                catch (IOException e2) {
                    cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e2, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                    throw cachedException;
                }
            }
            catch (Throwable throwable) {
                this.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        this.closeCircleStreamBufferOutput(outputStream, cachedException);
        return serializerResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SerializerResult error(ODataServerError error) throws SerializerException {
        SerializerResult serializerResult;
        if (error == null) {
            throw new SerializerException("ODataError object MUST NOT be null!", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.NULL_INPUT, new String[0]);
        }
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            outputStream = buffer.getOutputStream();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream, "UTF-8");
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement("error");
            writer.writeDefaultNamespace(NS_METADATA);
            this.writeErrorDetails(String.valueOf(error.getCode()), error.getMessage(), error.getTarget(), writer);
            if (error.getDetails() != null && !error.getDetails().isEmpty()) {
                writer.writeStartElement("details");
                for (ODataErrorDetail inner : error.getDetails()) {
                    this.writeErrorDetails(inner.getCode(), inner.getMessage(), inner.getTarget(), writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            writer.close();
            outputStream.close();
            serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (XMLStreamException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
                catch (IOException e2) {
                    cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e2, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                    throw cachedException;
                }
            }
            catch (Throwable throwable) {
                this.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        this.closeCircleStreamBufferOutput(outputStream, cachedException);
        return serializerResult;
    }

    private void writeErrorDetails(String code, String message, String target, XMLStreamWriter writer) throws XMLStreamException {
        if (code != null) {
            writer.writeStartElement("code");
            writer.writeCharacters(code);
            writer.writeEndElement();
        }
        writer.writeStartElement("message");
        writer.writeCharacters(message);
        writer.writeEndElement();
        if (target != null) {
            writer.writeStartElement("target");
            writer.writeCharacters(target);
            writer.writeEndElement();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SerializerResult entityCollection(ServiceMetadata metadata, EdmEntityType entityType, AbstractEntityCollection entitySet, EntityCollectionSerializerOptions options) throws SerializerException {
        SerializerResult serializerResult;
        String name;
        ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
        String string = name = contextURL == null ? null : contextURL.getEntitySetOrSingletonOrType();
        if (options != null && options.getWriteOnlyReferences()) {
            ReferenceCollectionSerializerOptions rso = ReferenceCollectionSerializerOptions.with().contextURL(contextURL).build();
            return this.entityReferenceCollection(entitySet, rso);
        }
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            boolean writeOnlyRef;
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            outputStream = buffer.getOutputStream();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream, "UTF-8");
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement(ATOM, "feed", NS_ATOM);
            writer.writeNamespace(ATOM, NS_ATOM);
            writer.writeNamespace(METADATA, NS_METADATA);
            writer.writeNamespace(DATA, NS_DATA);
            writer.writeAttribute(METADATA, NS_METADATA, "context", ContextURLBuilder.create(contextURL).toASCIIString());
            this.writeMetadataETag(metadata, writer);
            this.writeOperations(entitySet.getOperations(), writer);
            if (options != null && options.getId() != null) {
                writer.writeStartElement(ATOM, "id", NS_ATOM);
                writer.writeCharacters(options.getId());
                writer.writeEndElement();
            }
            if (options != null && options.getCount() != null && options.getCount().getValue() && entitySet.getCount() != null) {
                this.writeCount(entitySet, writer);
            }
            if (entitySet.getNext() != null) {
                this.writeNextLink(entitySet, writer);
            }
            boolean bl = writeOnlyRef = options != null && options.getWriteOnlyReferences();
            if (options == null) {
                this.writeEntitySet(metadata, entityType, entitySet, null, null, null, null, writer, writeOnlyRef, name, null);
            } else {
                this.writeEntitySet(metadata, entityType, entitySet, options.getExpand(), null, options.getSelect(), options.xml10InvalidCharReplacement(), writer, writeOnlyRef, name, null);
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            writer.close();
            outputStream.close();
            serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (XMLStreamException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
                catch (IOException e2) {
                    cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e2, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                    throw cachedException;
                }
            }
            catch (Throwable throwable) {
                this.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        this.closeCircleStreamBufferOutput(outputStream, cachedException);
        return serializerResult;
    }

    public void entityCollectionIntoStream(ServiceMetadata metadata, EdmEntityType entityType, EntityIterator entitySet, EntityCollectionSerializerOptions options, OutputStream outputStream) throws SerializerException {
        ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
        String name = contextURL == null ? null : contextURL.getEntitySetOrSingletonOrType();
        try {
            boolean writeOnlyRef;
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream, "UTF-8");
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement(ATOM, "feed", NS_ATOM);
            writer.writeNamespace(ATOM, NS_ATOM);
            writer.writeNamespace(METADATA, NS_METADATA);
            writer.writeNamespace(DATA, NS_DATA);
            writer.writeAttribute(METADATA, NS_METADATA, "context", ContextURLBuilder.create(contextURL).toASCIIString());
            this.writeMetadataETag(metadata, writer);
            if (options != null && options.getId() != null) {
                writer.writeStartElement(ATOM, "id", NS_ATOM);
                writer.writeCharacters(options.getId());
                writer.writeEndElement();
            }
            if (options != null && options.getCount() != null && options.getCount().getValue() && entitySet.getCount() != null) {
                this.writeCount((AbstractEntityCollection)entitySet, writer);
            }
            if (entitySet != null && entitySet.getNext() != null) {
                this.writeNextLink((AbstractEntityCollection)entitySet, writer);
            }
            boolean bl = writeOnlyRef = options != null && options.getWriteOnlyReferences();
            if (options == null) {
                this.writeEntitySet(metadata, entityType, (AbstractEntityCollection)entitySet, null, null, null, null, writer, writeOnlyRef, name, null);
            } else {
                this.writeEntitySet(metadata, entityType, (AbstractEntityCollection)entitySet, options.getExpand(), null, options.getSelect(), options.xml10InvalidCharReplacement(), writer, writeOnlyRef, name, null);
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException e) {
            SerializerException cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
            throw cachedException;
        }
    }

    public SerializerStreamResult entityCollectionStreamed(ServiceMetadata metadata, EdmEntityType entityType, EntityIterator entities, EntityCollectionSerializerOptions options) throws SerializerException {
        return ODataWritableContent.with(entities, entityType, this, metadata, options).build();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SerializerResult entity(ServiceMetadata metadata, EdmEntityType entityType, Entity entity, EntitySerializerOptions options) throws SerializerException {
        SerializerResult serializerResult;
        String name;
        ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
        String string = name = contextURL == null ? null : contextURL.getEntitySetOrSingletonOrType();
        if (options != null && options.getWriteOnlyReferences()) {
            return this.entityReference(entity, ReferenceSerializerOptions.with().contextURL(contextURL).build());
        }
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            outputStream = buffer.getOutputStream();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream, "UTF-8");
            writer.writeStartDocument("UTF-8", "1.0");
            this.writeEntity(metadata, entityType, entity, contextURL, options == null ? null : options.getExpand(), null, options == null ? null : options.getSelect(), options == null ? null : options.xml10InvalidCharReplacement(), writer, true, false, name, null);
            writer.writeEndDocument();
            writer.flush();
            writer.close();
            outputStream.close();
            serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (XMLStreamException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
                catch (IOException e2) {
                    cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e2, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                    throw cachedException;
                }
            }
            catch (Throwable throwable) {
                this.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        this.closeCircleStreamBufferOutput(outputStream, cachedException);
        return serializerResult;
    }

    private ContextURL checkContextURL(ContextURL contextURL) throws SerializerException {
        if (contextURL == null) {
            throw new SerializerException("ContextURL null!", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.NO_CONTEXT_URL, new String[0]);
        }
        return contextURL;
    }

    private void writeMetadataETag(ServiceMetadata metadata, XMLStreamWriter writer) throws XMLStreamException {
        if (metadata != null && metadata.getServiceMetadataETagSupport() != null && metadata.getServiceMetadataETagSupport().getMetadataETag() != null) {
            writer.writeAttribute(METADATA, NS_METADATA, "metadata-etag", metadata.getServiceMetadataETagSupport().getMetadataETag());
        }
    }

    protected void writeEntitySet(ServiceMetadata metadata, EdmEntityType entityType, AbstractEntityCollection entitySet, ExpandOption expand, Integer toDepth, SelectOption select, String xml10InvalidCharReplacement, XMLStreamWriter writer, boolean writeOnlyRef, String name, Set<String> ancestors) throws XMLStreamException, SerializerException {
        for (Entity entity : entitySet) {
            this.writeEntity(metadata, entityType, entity, null, expand, toDepth, select, xml10InvalidCharReplacement, writer, false, writeOnlyRef, name, ancestors);
        }
    }

    private String getEntityId(Entity entity, EdmEntityType entityType, String name) throws SerializerException {
        if (entity.getId() == null) {
            if (entity == null || entityType == null || entityType.getKeyPredicateNames() == null || name == null) {
                throw new SerializerException("Entity id is null.", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.MISSING_ID, new String[0]);
            }
            UriHelperImpl uriHelper = new UriHelperImpl();
            entity.setId(URI.create(name + '(' + uriHelper.buildKeyPredicate(entityType, entity) + ')'));
        }
        return entity.getId().toASCIIString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeEntity(ServiceMetadata metadata, EdmEntityType entityType, Entity entity, ContextURL contextURL, ExpandOption expand, Integer toDepth, SelectOption select, String xml10InvalidCharReplacement, XMLStreamWriter writer, boolean top, boolean writeOnlyRef, String name, Set<String> ancestors) throws XMLStreamException, SerializerException {
        boolean cycle = false;
        if (expand != null) {
            if (ancestors == null) {
                ancestors = new HashSet<String>();
            }
            boolean bl = cycle = !ancestors.add(this.getEntityId(entity, entityType, name));
        }
        if (cycle || writeOnlyRef) {
            this.writeReference(entity, contextURL, writer, top);
            return;
        }
        try {
            writer.writeStartElement(ATOM, "entry", NS_ATOM);
            if (top) {
                writer.writeNamespace(ATOM, NS_ATOM);
                writer.writeNamespace(METADATA, NS_METADATA);
                writer.writeNamespace(DATA, NS_DATA);
                if (contextURL != null) {
                    writer.writeAttribute(METADATA, NS_METADATA, "context", ContextURLBuilder.create(contextURL).toASCIIString());
                    this.writeMetadataETag(metadata, writer);
                }
            }
            if (entity.getETag() != null) {
                writer.writeAttribute(METADATA, NS_METADATA, "etag", entity.getETag());
            }
            if (entity.getId() != null) {
                writer.writeStartElement(NS_ATOM, "id");
                writer.writeCharacters(entity.getId().toASCIIString());
                writer.writeEndElement();
            }
            this.writerAuthorInfo(entity.getTitle(), writer);
            if (entity.getId() != null) {
                writer.writeStartElement(NS_ATOM, "link");
                writer.writeAttribute("rel", "edit");
                writer.writeAttribute("href", entity.getId().toASCIIString());
                writer.writeEndElement();
            }
            if (entityType.hasStream()) {
                writer.writeStartElement(NS_ATOM, "content");
                writer.writeAttribute("type", entity.getMediaContentType());
                if (entity.getMediaContentSource() != null) {
                    writer.writeAttribute("src", entity.getMediaContentSource().toString());
                } else {
                    String id = entity.getId().toASCIIString();
                    writer.writeAttribute("src", (String)id + (id.endsWith("/") ? "" : "/") + "$value");
                }
                writer.writeEndElement();
            }
            for (Link link : entity.getMediaEditLinks()) {
                this.writeLink(writer, link);
            }
            EdmEntityType resolvedType = this.resolveEntityType(metadata, entityType, entity.getType());
            this.writeNavigationProperties(metadata, (EdmStructuredType)resolvedType, (Linked)entity, expand, toDepth, xml10InvalidCharReplacement, ancestors, name, writer);
            writer.writeStartElement(ATOM, "category", NS_ATOM);
            writer.writeAttribute("scheme", "http://docs.oasis-open.org/odata/ns/scheme");
            writer.writeAttribute("term", "#" + resolvedType.getFullQualifiedName().getFullQualifiedNameAsString());
            writer.writeEndElement();
            if (!entityType.hasStream()) {
                writer.writeStartElement(NS_ATOM, "content");
                writer.writeAttribute("type", "application/xml");
            }
            writer.writeStartElement(METADATA, "properties", NS_METADATA);
            this.writeProperties(metadata, (EdmStructuredType)resolvedType, entity.getProperties(), select, xml10InvalidCharReplacement, writer, (Linked)entity, expand);
            writer.writeEndElement();
            if (!entityType.hasStream()) {
                writer.writeEndElement();
            }
            this.writeOperations(entity.getOperations(), writer);
            writer.writeEndElement();
        }
        finally {
            if (!cycle && ancestors != null) {
                ancestors.remove(this.getEntityId(entity, entityType, name));
            }
        }
    }

    private void writeOperations(List<Operation> operations, XMLStreamWriter writer) throws XMLStreamException {
        for (Operation operation : operations) {
            boolean action = operation.getType() != null && operation.getType() == Operation.Type.ACTION;
            writer.writeStartElement(METADATA, action ? "action" : "function", NS_METADATA);
            writer.writeAttribute("metadata", operation.getMetadataAnchor());
            writer.writeAttribute("title", operation.getTitle());
            writer.writeAttribute("target", operation.getTarget().toASCIIString());
            writer.writeEndElement();
        }
    }

    private void writerAuthorInfo(String title, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(NS_ATOM, "title");
        if (title != null) {
            writer.writeCharacters(title);
        }
        writer.writeEndElement();
        writer.writeStartElement(NS_ATOM, "summary");
        writer.writeEndElement();
        writer.writeStartElement(NS_ATOM, "updated");
        writer.writeCharacters(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date(System.currentTimeMillis())));
        writer.writeEndElement();
        writer.writeStartElement(NS_ATOM, "author");
        writer.writeStartElement(NS_ATOM, "name");
        writer.writeEndElement();
        writer.writeEndElement();
    }

    protected EdmEntityType resolveEntityType(ServiceMetadata metadata, EdmEntityType baseType, String derivedTypeName) throws SerializerException {
        if (derivedTypeName == null || baseType.getFullQualifiedName().getFullQualifiedNameAsString().equals(derivedTypeName)) {
            return baseType;
        }
        EdmEntityType derivedType = metadata.getEdm().getEntityType(new FullQualifiedName(derivedTypeName));
        if (derivedType == null) {
            throw new SerializerException("EntityType not found", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.UNKNOWN_TYPE, new String[]{derivedTypeName});
        }
        for (EdmEntityType type = derivedType.getBaseType(); type != null; type = type.getBaseType()) {
            if (!type.getFullQualifiedName().getFullQualifiedNameAsString().equals(baseType.getFullQualifiedName().getFullQualifiedNameAsString())) continue;
            return derivedType;
        }
        throw new SerializerException("Wrong base type", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.WRONG_BASE_TYPE, new String[]{derivedTypeName, baseType.getFullQualifiedName().getFullQualifiedNameAsString()});
    }

    protected EdmComplexType resolveComplexType(ServiceMetadata metadata, EdmComplexType baseType, String derivedTypeName) throws SerializerException {
        if (derivedTypeName == null || baseType.getFullQualifiedName().getFullQualifiedNameAsString().equals(derivedTypeName)) {
            return baseType;
        }
        EdmComplexType derivedType = metadata.getEdm().getComplexType(new FullQualifiedName(derivedTypeName));
        if (derivedType == null) {
            throw new SerializerException("Complex Type not found", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.UNKNOWN_TYPE, new String[]{derivedTypeName});
        }
        for (EdmComplexType type = derivedType.getBaseType(); type != null; type = type.getBaseType()) {
            if (!type.getFullQualifiedName().getFullQualifiedNameAsString().equals(baseType.getFullQualifiedName().getFullQualifiedNameAsString())) continue;
            return derivedType;
        }
        throw new SerializerException("Wrong base type", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.WRONG_BASE_TYPE, new String[]{derivedTypeName, baseType.getFullQualifiedName().getFullQualifiedNameAsString()});
    }

    protected void writeProperties(ServiceMetadata metadata, EdmStructuredType type, List<Property> properties, SelectOption select, String xml10InvalidCharReplacement, XMLStreamWriter writer, Linked linked, ExpandOption expand) throws XMLStreamException, SerializerException {
        boolean all = ExpandSelectHelper.isAll(select);
        HashSet<String> selected = all ? new HashSet() : ExpandSelectHelper.getSelectedPropertyNames(select.getSelectItems());
        this.addKeyPropertiesToSelected(selected, type);
        Set<List<String>> expandedPaths = ExpandSelectHelper.getExpandedItemsPath(expand);
        for (String propertyName : type.getPropertyNames()) {
            if (!all && !selected.contains(propertyName)) continue;
            EdmProperty edmProperty = type.getStructuralProperty(propertyName);
            Property property = this.findProperty(propertyName, properties);
            Set<List<String>> selectedPaths = all || edmProperty.isPrimitive() ? null : ExpandSelectHelper.getSelectedPaths(select.getSelectItems(), propertyName);
            this.writeProperty(metadata, edmProperty, property, selectedPaths, xml10InvalidCharReplacement, writer, expandedPaths, linked, expand);
        }
    }

    private void addKeyPropertiesToSelected(Set<String> selected, EdmStructuredType type) {
        if (!selected.isEmpty() && type instanceof EdmEntityType) {
            List keyNames = ((EdmEntityType)type).getKeyPredicateNames();
            for (String key : keyNames) {
                if (selected.contains(key)) continue;
                selected.add(key);
            }
        }
    }

    protected void writeNavigationProperties(ServiceMetadata metadata, EdmStructuredType type, Linked linked, ExpandOption expand, Integer toDepth, String xml10InvalidCharReplacement, Set<String> ancestors, String name, XMLStreamWriter writer) throws SerializerException, XMLStreamException {
        if (toDepth != null && toDepth > 1 || toDepth == null && ExpandSelectHelper.hasExpand(expand)) {
            ExpandItem expandAll = ExpandSelectHelper.getExpandAll(expand);
            for (String propertyName : type.getNavigationPropertyNames()) {
                ExpandItem innerOptions = ExpandSelectHelper.getExpandItemBasedOnType(expand.getExpandItems(), propertyName, type, name);
                if (expandAll != null || innerOptions != null || toDepth != null) {
                    Integer levels = null;
                    EdmNavigationProperty property = type.getNavigationProperty(propertyName);
                    Link navigationLink = this.getOrCreateLink(linked, propertyName);
                    ExpandOption childExpand = null;
                    LevelsExpandOption levelsOption = null;
                    if (innerOptions != null) {
                        levelsOption = innerOptions.getLevelsOption();
                        childExpand = levelsOption == null ? innerOptions.getExpandOption() : new ExpandOptionImpl().addExpandItem(innerOptions);
                    } else if (expandAll != null) {
                        levels = 1;
                        levelsOption = expandAll.getLevelsOption();
                        childExpand = new ExpandOptionImpl().addExpandItem(expandAll);
                    }
                    if (levelsOption != null) {
                        levels = levelsOption.isMax() ? Integer.MAX_VALUE : levelsOption.getValue();
                    }
                    if (toDepth != null) {
                        levels = toDepth - 1;
                        childExpand = expand;
                    }
                    this.writeLink(writer, navigationLink, false);
                    writer.writeStartElement(METADATA, "inline", NS_METADATA);
                    this.writeExpandedNavigationProperty(metadata, property, navigationLink, childExpand, levels, innerOptions == null ? null : innerOptions.getSelectOption(), innerOptions == null ? null : innerOptions.getCountOption(), innerOptions == null ? false : innerOptions.hasCountPath(), innerOptions == null ? false : innerOptions.isRef(), xml10InvalidCharReplacement, ancestors, name, writer);
                    writer.writeEndElement();
                    writer.writeEndElement();
                    continue;
                }
                this.writeLink(writer, this.getOrCreateLink(linked, propertyName));
            }
        } else {
            for (String propertyName : type.getNavigationPropertyNames()) {
                this.writeLink(writer, this.getOrCreateLink(linked, propertyName));
            }
        }
        for (Link link : linked.getAssociationLinks()) {
            this.writeLink(writer, link);
        }
    }

    protected Link getOrCreateLink(Linked linked, String navigationPropertyName) throws XMLStreamException {
        Link link = linked.getNavigationLink(navigationPropertyName);
        if (link == null) {
            link = new Link();
            link.setRel("http://docs.oasis-open.org/odata/ns/related/" + navigationPropertyName);
            link.setType(Constants.ENTITY_SET_NAVIGATION_LINK_TYPE);
            link.setTitle(navigationPropertyName);
            EntityCollection target = new EntityCollection();
            link.setInlineEntitySet(target);
            if (linked.getId() != null) {
                link.setHref(linked.getId().toASCIIString() + "/" + navigationPropertyName);
            }
        }
        return link;
    }

    private void writeLink(XMLStreamWriter writer, Link link) throws XMLStreamException {
        this.writeLink(writer, link, true);
    }

    private void writeLink(XMLStreamWriter writer, Link link, boolean close) throws XMLStreamException {
        writer.writeStartElement(ATOM, "link", NS_ATOM);
        writer.writeAttribute("rel", link.getRel());
        if (link.getType() != null) {
            writer.writeAttribute("type", link.getType());
        }
        if (link.getTitle() != null) {
            writer.writeAttribute("title", link.getTitle());
        }
        if (link.getHref() != null) {
            writer.writeAttribute("href", link.getHref());
        }
        if (close) {
            writer.writeEndElement();
        }
    }

    protected void writeExpandedNavigationProperty(ServiceMetadata metadata, EdmNavigationProperty property, Link navigationLink, ExpandOption innerExpand, Integer toDepth, SelectOption innerSelect, CountOption coutOption, boolean writeNavigationCount, boolean writeOnlyRef, String xml10InvalidCharReplacement, Set<String> ancestors, String name, XMLStreamWriter writer) throws XMLStreamException, SerializerException {
        if (property.isCollection()) {
            if (navigationLink != null && navigationLink.getInlineEntitySet() != null) {
                writer.writeStartElement(ATOM, "feed", NS_ATOM);
                if (writeNavigationCount) {
                    this.writeCount((AbstractEntityCollection)navigationLink.getInlineEntitySet(), writer);
                } else {
                    if (coutOption != null && coutOption.getValue()) {
                        this.writeCount((AbstractEntityCollection)navigationLink.getInlineEntitySet(), writer);
                    }
                    this.writeEntitySet(metadata, property.getType(), (AbstractEntityCollection)navigationLink.getInlineEntitySet(), innerExpand, toDepth, innerSelect, xml10InvalidCharReplacement, writer, writeOnlyRef, name, ancestors);
                }
                writer.writeEndElement();
            }
        } else if (navigationLink != null && navigationLink.getInlineEntity() != null) {
            this.writeEntity(metadata, property.getType(), navigationLink.getInlineEntity(), null, innerExpand, toDepth, innerSelect, xml10InvalidCharReplacement, writer, false, writeOnlyRef, name, ancestors);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeProperty(ServiceMetadata metadata, EdmProperty edmProperty, Property property, Set<List<String>> selectedPaths, String xml10InvalidCharReplacement, XMLStreamWriter writer, Set<List<String>> expandedPaths, Linked linked, ExpandOption expand) throws XMLStreamException, SerializerException {
        writer.writeStartElement(DATA, edmProperty.getName(), NS_DATA);
        if (property == null || property.isNull()) {
            if (!edmProperty.isNullable()) throw new SerializerException("Non-nullable property not present!", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.MISSING_PROPERTY, new String[]{edmProperty.getName()});
            writer.writeAttribute(METADATA, NS_METADATA, "null", "true");
        } else {
            this.writePropertyValue(metadata, edmProperty, property, selectedPaths, xml10InvalidCharReplacement, writer, expandedPaths, linked, expand);
        }
        writer.writeEndElement();
    }

    private String collectionType(EdmType type) {
        return "#Collection(" + type.getFullQualifiedName().getFullQualifiedNameAsString() + ")";
    }

    private String complexType(ServiceMetadata metadata, EdmComplexType baseType, String definedType) throws SerializerException {
        EdmComplexType type = this.resolveComplexType(metadata, baseType, definedType);
        return type.getFullQualifiedName().getFullQualifiedNameAsString();
    }

    private String derivedComplexType(EdmComplexType baseType, String definedType) throws SerializerException {
        String base = baseType.getFullQualifiedName().getFullQualifiedNameAsString();
        if (base.equals(definedType)) {
            return null;
        }
        return definedType;
    }

    private void writePropertyValue(ServiceMetadata metadata, EdmProperty edmProperty, Property property, Set<List<String>> selectedPaths, String xml10InvalidCharReplacement, XMLStreamWriter writer, Set<List<String>> expandedPaths, Linked linked, ExpandOption expand) throws XMLStreamException, SerializerException {
        block8: {
            try {
                if (edmProperty.isPrimitive() || edmProperty.getType().getKind() == EdmTypeKind.ENUM || edmProperty.getType().getKind() == EdmTypeKind.DEFINITION) {
                    if (edmProperty.isCollection()) {
                        writer.writeAttribute(METADATA, NS_METADATA, "type", edmProperty.isPrimitive() ? "#Collection(" + edmProperty.getType().getName() + ")" : this.collectionType(edmProperty.getType()));
                        this.writePrimitiveCollection((EdmPrimitiveType)edmProperty.getType(), property, edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), xml10InvalidCharReplacement, writer);
                    } else {
                        this.writePrimitive((EdmPrimitiveType)edmProperty.getType(), property, edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), xml10InvalidCharReplacement, writer);
                    }
                    break block8;
                }
                if (property.isComplex()) {
                    if (edmProperty.isCollection()) {
                        writer.writeAttribute(METADATA, NS_METADATA, "type", this.collectionType(edmProperty.getType()));
                        this.writeComplexCollection(metadata, (EdmComplexType)edmProperty.getType(), property, selectedPaths, xml10InvalidCharReplacement, writer, expandedPaths, linked, expand);
                    } else {
                        this.writeComplex(metadata, edmProperty, property, selectedPaths, xml10InvalidCharReplacement, writer, expandedPaths, linked, expand);
                    }
                    break block8;
                }
                throw new SerializerException("Property type not yet supported!", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{edmProperty.getName()});
            }
            catch (EdmPrimitiveTypeException e) {
                throw new SerializerException("Wrong value for property!", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, new String[]{edmProperty.getName(), property.getValue().toString()});
            }
        }
    }

    private void writeComplex(ServiceMetadata metadata, EdmProperty edmProperty, Property property, Set<List<String>> selectedPaths, String xml10InvalidCharReplacement, XMLStreamWriter writer, Set<List<String>> expandedPaths, Linked linked, ExpandOption expand) throws XMLStreamException, SerializerException {
        writer.writeAttribute(METADATA, NS_METADATA, "type", "#" + this.complexType(metadata, (EdmComplexType)edmProperty.getType(), property.getType()));
        String derivedName = property.getType();
        EdmComplexType resolvedType = this.resolveComplexType(metadata, (EdmComplexType)edmProperty.getType(), derivedName);
        if (null != linked) {
            if (linked instanceof Entity) {
                linked = ((Entity)linked).getProperty(property.getName()).asComplex();
            } else if (linked instanceof ComplexValue) {
                List complexProperties = ((ComplexValue)linked).getValue();
                for (Property prop : complexProperties) {
                    if (!prop.getName().equals(property.getName())) continue;
                    linked = prop.asComplex();
                    break;
                }
            }
            expandedPaths = expandedPaths == null || expandedPaths.isEmpty() ? null : ExpandSelectHelper.getReducedExpandItemsPaths(expandedPaths, property.getName());
        }
        this.writeComplexValue(metadata, resolvedType, property.asComplex().getValue(), selectedPaths, xml10InvalidCharReplacement, writer, expandedPaths, linked, expand, property.getName());
    }

    private void writePrimitiveCollection(EdmPrimitiveType type, Property property, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, String xml10InvalidCharReplacement, XMLStreamWriter writer) throws XMLStreamException, EdmPrimitiveTypeException, SerializerException {
        for (Object value : property.asCollection()) {
            writer.writeStartElement(METADATA, "element", NS_METADATA);
            switch (property.getValueType()) {
                case COLLECTION_PRIMITIVE: 
                case COLLECTION_ENUM: {
                    this.writePrimitiveValue(type, value, isNullable, maxLength, precision, scale, isUnicode, xml10InvalidCharReplacement, writer);
                    break;
                }
                case COLLECTION_GEOSPATIAL: {
                    throw new SerializerException("Property type not yet supported!", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{property.getName()});
                }
                default: {
                    throw new SerializerException("Property type not yet supported!", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{property.getName()});
                }
            }
            writer.writeEndElement();
        }
    }

    private void writeComplexCollection(ServiceMetadata metadata, EdmComplexType type, Property property, Set<List<String>> selectedPaths, String xml10InvalidCharReplacement, XMLStreamWriter writer, Set<List<String>> expandedPaths, Linked linked, ExpandOption expand) throws XMLStreamException, SerializerException {
        EdmComplexType complexType = type;
        Set<List<String>> expandedPaths1 = expandedPaths != null && !expandedPaths.isEmpty() ? expandedPaths : ExpandSelectHelper.getExpandedItemsPath(expand);
        for (Object value : property.asCollection()) {
            String propertyType;
            expandedPaths = expandedPaths1;
            writer.writeStartElement(METADATA, "element", NS_METADATA);
            String typeName = ((ComplexValue)value).getTypeName();
            String string = propertyType = typeName != null ? typeName : property.getType();
            if (this.derivedComplexType(type, propertyType) != null) {
                writer.writeAttribute(METADATA, NS_METADATA, "type", propertyType);
            }
            complexType = typeName != null && !propertyType.equals(type.getFullQualifiedName().getFullQualifiedNameAsString()) ? metadata.getEdm().getComplexType(new FullQualifiedName(propertyType)) : type;
            switch (property.getValueType()) {
                case COLLECTION_COMPLEX: {
                    expandedPaths = expandedPaths == null || expandedPaths.isEmpty() ? null : ExpandSelectHelper.getReducedExpandItemsPaths(expandedPaths, property.getName());
                    this.writeComplexValue(metadata, complexType, ((ComplexValue)value).getValue(), selectedPaths, xml10InvalidCharReplacement, writer, expandedPaths, (Linked)((ComplexValue)value), expand, property.getName());
                    break;
                }
                default: {
                    throw new SerializerException("Property type not yet supported!", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{property.getName()});
                }
            }
            writer.writeEndElement();
        }
    }

    private void writePrimitive(EdmPrimitiveType type, Property property, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, String xml10InvalidCharReplacement, XMLStreamWriter writer) throws EdmPrimitiveTypeException, XMLStreamException, SerializerException {
        if (property.isPrimitive()) {
            if (type != EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.String)) {
                writer.writeAttribute(METADATA, NS_METADATA, "type", type.getKind() == EdmTypeKind.DEFINITION ? "#" + type.getFullQualifiedName().getFullQualifiedNameAsString() : type.getName());
            }
            this.writePrimitiveValue(type, property.asPrimitive(), isNullable, maxLength, precision, scale, isUnicode, xml10InvalidCharReplacement, writer);
        } else {
            if (property.isGeospatial()) {
                throw new SerializerException("Property type not yet supported!", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.UNSUPPORTED_PROPERTY_TYPE, new String[]{property.getName()});
            }
            if (property.isEnum()) {
                writer.writeAttribute(METADATA, NS_METADATA, "type", "#" + type.getFullQualifiedName().getFullQualifiedNameAsString());
                this.writePrimitiveValue(type, property.asEnum(), isNullable, maxLength, precision, scale, isUnicode, xml10InvalidCharReplacement, writer);
            } else {
                throw new SerializerException("Inconsistent property type!", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.INCONSISTENT_PROPERTY_TYPE, new String[]{property.getName()});
            }
        }
    }

    protected void writePrimitiveValue(EdmPrimitiveType type, Object primitiveValue, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, String xml10InvalidCharReplacement, XMLStreamWriter writer) throws EdmPrimitiveTypeException, XMLStreamException {
        String value = type.valueToString(primitiveValue, isNullable, maxLength, precision, scale, isUnicode);
        if (value == null) {
            writer.writeAttribute(METADATA, NS_METADATA, "null", "true");
        } else {
            writer.writeCharacters(ODataXmlSerializer.replaceInvalidCharacters(type, value, isUnicode, xml10InvalidCharReplacement));
        }
    }

    protected void writeComplexValue(ServiceMetadata metadata, EdmComplexType type, List<Property> properties, Set<List<String>> selectedPaths, String xml10InvalidCharReplacement, XMLStreamWriter writer, Set<List<String>> expandedPaths, Linked linked, ExpandOption expand, String complexPropName) throws XMLStreamException, SerializerException {
        if (null != expandedPaths) {
            for (List<String> paths : expandedPaths) {
                if (paths.isEmpty() || paths.size() != 1) continue;
                expandedPaths = ExpandSelectHelper.getReducedExpandItemsPaths(expandedPaths, paths.get(0));
            }
        }
        for (String propertyName : type.getPropertyNames()) {
            Property property = this.findProperty(propertyName, properties);
            if (selectedPaths != null && !ExpandSelectHelper.isSelected(selectedPaths, propertyName)) continue;
            this.writeProperty(metadata, (EdmProperty)type.getProperty(propertyName), property, selectedPaths == null ? null : ExpandSelectHelper.getReducedSelectedPaths(selectedPaths, propertyName), xml10InvalidCharReplacement, writer, expandedPaths, linked, expand);
        }
        this.writeNavigationProperties(metadata, (EdmStructuredType)type, linked, expand, null, xml10InvalidCharReplacement, null, complexPropName, writer);
    }

    private Property findProperty(String propertyName, List<Property> properties) {
        for (Property property : properties) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SerializerResult primitive(ServiceMetadata metadata, EdmPrimitiveType type, Property property, PrimitiveSerializerOptions options) throws SerializerException {
        SerializerResult serializerResult;
        ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            outputStream = buffer.getOutputStream();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream, "UTF-8");
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement(METADATA, "value", NS_METADATA);
            writer.writeNamespace(METADATA, NS_METADATA);
            if (contextURL != null) {
                writer.writeAttribute(METADATA, NS_METADATA, "context", ContextURLBuilder.create(contextURL).toASCIIString());
            }
            this.writeMetadataETag(metadata, writer);
            if (property.isNull()) {
                writer.writeAttribute(METADATA, NS_METADATA, "null", "true");
            } else {
                this.writePrimitive(type, property, options == null ? null : options.isNullable(), options == null ? null : options.getMaxLength(), options == null ? null : options.getPrecision(), options == null ? null : options.getScale(), options == null ? null : options.isUnicode(), options == null ? null : options.xml10InvalidCharReplacement(), writer);
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            writer.close();
            outputStream.close();
            serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (XMLStreamException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
                catch (EdmPrimitiveTypeException e2) {
                    cachedException = new SerializerException("Wrong value for property!", (Throwable)e2, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, new String[]{property.getName(), property.getValue().toString()});
                    throw cachedException;
                }
                catch (IOException e3) {
                    cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e3, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                    throw cachedException;
                }
            }
            catch (Throwable throwable) {
                this.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        this.closeCircleStreamBufferOutput(outputStream, cachedException);
        return serializerResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SerializerResult complex(ServiceMetadata metadata, EdmComplexType type, Property property, ComplexSerializerOptions options) throws SerializerException {
        SerializerResult serializerResult;
        ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            EdmComplexType resolvedType = null;
            resolvedType = !type.getFullQualifiedName().getFullQualifiedNameAsString().equals(property.getType()) ? (type.getBaseType() != null && type.getBaseType().getFullQualifiedName().getFullQualifiedNameAsString().equals(property.getType()) ? this.resolveComplexType(metadata, type.getBaseType(), type.getFullQualifiedName().getFullQualifiedNameAsString()) : this.resolveComplexType(metadata, type, property.getType())) : this.resolveComplexType(metadata, type, property.getType());
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            outputStream = buffer.getOutputStream();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream, "UTF-8");
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement(METADATA, "value", NS_METADATA);
            writer.writeNamespace(METADATA, NS_METADATA);
            writer.writeNamespace(DATA, NS_DATA);
            writer.writeNamespace(ATOM, NS_ATOM);
            writer.writeAttribute(METADATA, NS_METADATA, "type", "#" + resolvedType.getFullQualifiedName().getFullQualifiedNameAsString());
            writer.writeAttribute(METADATA, NS_METADATA, "context", ContextURLBuilder.create(contextURL).toASCIIString());
            this.writeMetadataETag(metadata, writer);
            if (property.isNull()) {
                writer.writeAttribute(METADATA, NS_METADATA, "null", "true");
            } else {
                List values = property.asComplex().getValue();
                this.writeProperties(metadata, (EdmStructuredType)resolvedType, values, options == null ? null : options.getSelect(), options == null ? null : options.xml10InvalidCharReplacement(), writer, (Linked)property.asComplex(), options == null ? null : options.getExpand());
            }
            writer.writeEndDocument();
            writer.flush();
            writer.close();
            outputStream.close();
            serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (XMLStreamException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
                catch (IOException e2) {
                    cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e2, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                    throw cachedException;
                }
            }
            catch (Throwable throwable) {
                this.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        this.closeCircleStreamBufferOutput(outputStream, cachedException);
        return serializerResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SerializerResult primitiveCollection(ServiceMetadata metadata, EdmPrimitiveType type, Property property, PrimitiveSerializerOptions options) throws SerializerException {
        SerializerResult serializerResult;
        ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            outputStream = buffer.getOutputStream();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream, "UTF-8");
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement(METADATA, "value", NS_METADATA);
            writer.writeNamespace(METADATA, NS_METADATA);
            if (contextURL != null) {
                writer.writeAttribute(METADATA, NS_METADATA, "context", ContextURLBuilder.create(contextURL).toASCIIString());
            }
            this.writeMetadataETag(metadata, writer);
            writer.writeAttribute(METADATA, NS_METADATA, "type", "#Collection(" + type.getName() + ")");
            this.writePrimitiveCollection(type, property, options == null ? null : options.isNullable(), options == null ? null : options.getMaxLength(), options == null ? null : options.getPrecision(), options == null ? null : options.getScale(), options == null ? null : options.isUnicode(), options == null ? null : options.xml10InvalidCharReplacement(), writer);
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            writer.close();
            outputStream.close();
            serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (XMLStreamException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
                catch (EdmPrimitiveTypeException e2) {
                    cachedException = new SerializerException("Wrong value for property!", (Throwable)e2, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.WRONG_PROPERTY_VALUE, new String[]{property.getName(), property.getValue().toString()});
                    throw cachedException;
                }
                catch (IOException e3) {
                    cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e3, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                    throw cachedException;
                }
            }
            catch (Throwable throwable) {
                this.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        this.closeCircleStreamBufferOutput(outputStream, cachedException);
        return serializerResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SerializerResult complexCollection(ServiceMetadata metadata, EdmComplexType type, Property property, ComplexSerializerOptions options) throws SerializerException {
        SerializerResult serializerResult;
        ContextURL contextURL = this.checkContextURL(options == null ? null : options.getContextURL());
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            outputStream = buffer.getOutputStream();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream, "UTF-8");
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement(METADATA, "value", NS_METADATA);
            writer.writeNamespace(METADATA, NS_METADATA);
            writer.writeNamespace(DATA, NS_DATA);
            writer.writeNamespace(ATOM, NS_ATOM);
            writer.writeAttribute(METADATA, NS_METADATA, "type", this.collectionType((EdmType)type));
            writer.writeAttribute(METADATA, NS_METADATA, "context", ContextURLBuilder.create(contextURL).toASCIIString());
            this.writeMetadataETag(metadata, writer);
            Set<List<String>> selectedPaths = null;
            if (null != options && null != options.getSelect()) {
                boolean all = ExpandSelectHelper.isAll(options.getSelect());
                selectedPaths = all || property.isPrimitive() ? null : ExpandSelectHelper.getSelectedPaths(options.getSelect().getSelectItems());
            }
            Set<List<String>> expandPaths = null;
            if (null != options && null != options.getExpand()) {
                expandPaths = ExpandSelectHelper.getExpandedItemsPath(options.getExpand());
            }
            this.writeComplexCollection(metadata, type, property, selectedPaths, options == null ? null : options.xml10InvalidCharReplacement(), writer, expandPaths, null, options == null ? null : options.getExpand());
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            writer.close();
            outputStream.close();
            serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (XMLStreamException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
                catch (IOException e2) {
                    cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e2, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                    throw cachedException;
                }
            }
            catch (Throwable throwable) {
                this.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        this.closeCircleStreamBufferOutput(outputStream, cachedException);
        return serializerResult;
    }

    public SerializerResult reference(ServiceMetadata metadata, EdmEntitySet edmEntitySet, Entity entity, ReferenceSerializerOptions options) throws SerializerException {
        return this.entityReference(entity, options);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SerializerResult entityReference(Entity entity, ReferenceSerializerOptions options) throws SerializerException {
        SerializerResult serializerResult;
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            outputStream = buffer.getOutputStream();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream, "UTF-8");
            writer.writeStartDocument("UTF-8", "1.0");
            this.writeReference(entity, options == null ? null : options.getContextURL(), writer, true);
            writer.writeEndDocument();
            writer.flush();
            writer.close();
            outputStream.close();
            serializerResult = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (XMLStreamException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
                catch (IOException e2) {
                    cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e2, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                    throw cachedException;
                }
            }
            catch (Throwable throwable) {
                this.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        this.closeCircleStreamBufferOutput(outputStream, cachedException);
        return serializerResult;
    }

    private void writeReference(Entity entity, ContextURL contextURL, XMLStreamWriter writer, boolean top) throws XMLStreamException {
        writer.writeStartElement(METADATA, "ref", NS_METADATA);
        if (top) {
            writer.writeNamespace(METADATA, NS_METADATA);
            if (contextURL != null) {
                writer.writeAttribute(METADATA, NS_METADATA, "context", ContextURLBuilder.create(contextURL).toASCIIString());
            }
        }
        writer.writeAttribute("id", entity.getId().toASCIIString());
        writer.writeEndElement();
    }

    public SerializerResult referenceCollection(ServiceMetadata metadata, EdmEntitySet edmEntitySet, AbstractEntityCollection entityCollection, ReferenceCollectionSerializerOptions options) throws SerializerException {
        return this.entityReferenceCollection(entityCollection, options);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SerializerResult entityReferenceCollection(AbstractEntityCollection entitySet, ReferenceCollectionSerializerOptions options) throws SerializerException {
        Iterator iterator;
        OutputStream outputStream = null;
        SerializerException cachedException = null;
        try {
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            outputStream = buffer.getOutputStream();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream, "UTF-8");
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement(ATOM, "feed", NS_ATOM);
            writer.writeNamespace(ATOM, NS_ATOM);
            writer.writeNamespace(METADATA, NS_METADATA);
            if (options != null && options.getContextURL() != null) {
                writer.writeAttribute(METADATA, NS_METADATA, "context", ContextURLBuilder.create(options.getContextURL()).toASCIIString());
            }
            if (options != null && options.getCount() != null && options.getCount().getValue() && entitySet.getCount() != null) {
                this.writeCount(entitySet, writer);
            }
            if (entitySet.getNext() != null) {
                this.writeNextLink(entitySet, writer);
            }
            for (Entity entity : entitySet) {
                this.writeReference(entity, options == null ? null : options.getContextURL(), writer, false);
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            writer.close();
            outputStream.close();
            iterator = SerializerResultImpl.with().content(buffer.getInputStream()).build();
        }
        catch (XMLStreamException e) {
            try {
                cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                throw cachedException;
                catch (IOException e2) {
                    cachedException = new SerializerException("An I/O exception occurred.", (Throwable)e2, (ODataLibraryException.MessageKey)SerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                    throw cachedException;
                }
            }
            catch (Throwable throwable) {
                this.closeCircleStreamBufferOutput(outputStream, cachedException);
                throw throwable;
            }
        }
        this.closeCircleStreamBufferOutput(outputStream, cachedException);
        return iterator;
    }

    private void writeCount(AbstractEntityCollection entitySet, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(METADATA, "count", NS_METADATA);
        writer.writeCharacters(String.valueOf(entitySet.getCount() == null ? 0 : entitySet.getCount()));
        writer.writeEndElement();
    }

    private void writeNextLink(AbstractEntityCollection entitySet, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(ATOM, "link", NS_ATOM);
        writer.writeAttribute("rel", "next");
        writer.writeAttribute("href", entitySet.getNext().toASCIIString());
        writer.writeEndElement();
    }

    static String replaceInvalidCharacters(EdmPrimitiveType expectedType, String value, Boolean isUniCode, String invalidCharacterReplacement) {
        if (!(expectedType instanceof EdmString) || invalidCharacterReplacement == null || isUniCode == null || !isUniCode.booleanValue()) {
            return value;
        }
        String s = value;
        StringBuilder result = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c <= ' ' && c != ' ' && c != '\n' && c != '\t' && c != '\r') {
                if (result == null) {
                    result = new StringBuilder();
                    result.append(s.substring(0, i));
                }
                result.append(invalidCharacterReplacement);
                continue;
            }
            if (result == null) continue;
            result.append(c);
        }
        if (result == null) {
            return value;
        }
        return result.toString();
    }
}

