/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmKeyPropertyRef;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.queryoption.AliasQueryOption;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.api.uri.queryoption.expression.Literal;
import org.apache.olingo.server.core.ODataImpl;
import org.apache.olingo.server.core.uri.UriParameterImpl;
import org.apache.olingo.server.core.uri.UriResourceTypedImpl;
import org.apache.olingo.server.core.uri.UriResourceWithKeysImpl;
import org.apache.olingo.server.core.uri.parser.ExpressionParser;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.parser.UriParserSemanticException;
import org.apache.olingo.server.core.uri.parser.UriParserSyntaxException;
import org.apache.olingo.server.core.uri.parser.UriTokenizer;
import org.apache.olingo.server.core.uri.queryoption.AliasQueryOptionImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.LiteralImpl;
import org.apache.olingo.server.core.uri.validator.UriValidationException;

public class ParserHelper {
    private static final OData odata = new ODataImpl();
    protected static final Map<UriTokenizer.TokenKind, EdmPrimitiveTypeKind> tokenToPrimitiveType;

    protected static void requireNext(UriTokenizer tokenizer, UriTokenizer.TokenKind required) throws UriParserException {
        if (!tokenizer.next(required)) {
            throw new UriParserSyntaxException("Expected token '" + required.toString() + "' not found.", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
        }
    }

    protected static void requireTokenEnd(UriTokenizer tokenizer) throws UriParserException {
        ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.EOF);
    }

    protected static boolean bws(UriTokenizer tokenizer) {
        return tokenizer.nextWhitespace();
    }

    protected static UriTokenizer.TokenKind next(UriTokenizer tokenizer, UriTokenizer.TokenKind ... kinds) {
        for (UriTokenizer.TokenKind kind : kinds) {
            if (!tokenizer.next(kind)) continue;
            return kind;
        }
        return null;
    }

    protected static UriTokenizer.TokenKind nextPrimitiveValue(UriTokenizer tokenizer) {
        return ParserHelper.next(tokenizer, UriTokenizer.TokenKind.NULL, UriTokenizer.TokenKind.BooleanValue, UriTokenizer.TokenKind.StringValue, UriTokenizer.TokenKind.GuidValue, UriTokenizer.TokenKind.DoubleValue, UriTokenizer.TokenKind.DecimalValue, UriTokenizer.TokenKind.DateTimeOffsetValue, UriTokenizer.TokenKind.DateValue, UriTokenizer.TokenKind.TimeOfDayValue, UriTokenizer.TokenKind.IntegerValue, UriTokenizer.TokenKind.DurationValue, UriTokenizer.TokenKind.BinaryValue, UriTokenizer.TokenKind.EnumValue, UriTokenizer.TokenKind.GeographyPoint, UriTokenizer.TokenKind.GeometryPoint, UriTokenizer.TokenKind.GeographyLineString, UriTokenizer.TokenKind.GeometryLineString, UriTokenizer.TokenKind.GeographyPolygon, UriTokenizer.TokenKind.GeometryPolygon, UriTokenizer.TokenKind.GeographyMultiPoint, UriTokenizer.TokenKind.GeometryMultiPoint, UriTokenizer.TokenKind.GeographyMultiLineString, UriTokenizer.TokenKind.GeometryMultiLineString, UriTokenizer.TokenKind.GeographyMultiPolygon, UriTokenizer.TokenKind.GeometryMultiPolygon, UriTokenizer.TokenKind.GeographyCollection, UriTokenizer.TokenKind.GeometryCollection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static List<UriParameter> parseFunctionParameters(UriTokenizer tokenizer, Edm edm, EdmType referringType, boolean withComplex, Map<String, AliasQueryOption> aliases) throws UriParserException, UriValidationException {
        ArrayList<UriParameter> parameters = new ArrayList<UriParameter>();
        HashSet<String> parameterNames = new HashSet<String>();
        ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.OPEN);
        if (tokenizer.next(UriTokenizer.TokenKind.CLOSE)) {
            return parameters;
        }
        do {
            ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.ODataIdentifier);
            String name = tokenizer.getText();
            if (parameterNames.contains(name)) {
                throw new UriParserSemanticException("Duplicated function parameter " + name, UriParserSemanticException.MessageKeys.INVALID_KEY_VALUE, name);
            }
            parameterNames.add(name);
            ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.EQ);
            if (tokenizer.next(UriTokenizer.TokenKind.COMMA) || tokenizer.next(UriTokenizer.TokenKind.CLOSE) || tokenizer.next(UriTokenizer.TokenKind.EOF)) {
                throw new UriParserSyntaxException("Parameter value expected.", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
            }
            UriParameterImpl parameter = new UriParameterImpl().setName(name);
            if (tokenizer.next(UriTokenizer.TokenKind.ParameterAliasName)) {
                String aliasName = tokenizer.getText();
                parameter.setAlias(aliasName).setExpression(aliases.containsKey(aliasName) ? aliases.get(aliasName).getValue() : null);
            } else if (tokenizer.next(UriTokenizer.TokenKind.jsonArrayOrObject)) {
                if (!withComplex) throw new UriParserSemanticException("A JSON array or object is not allowed as parameter value.", UriParserSemanticException.MessageKeys.COMPLEX_PARAMETER_IN_RESOURCE_PATH, tokenizer.getText());
                parameter.setText(tokenizer.getText());
            } else if (withComplex) {
                Expression expression = new ExpressionParser(edm, odata).parse(tokenizer, referringType, null, aliases);
                parameter.setText(expression instanceof Literal ? ("null".equals(((Literal)expression).getText()) ? null : ((Literal)expression).getText()) : null).setExpression(expression instanceof Literal ? null : expression);
            } else {
                if (ParserHelper.nextPrimitiveValue(tokenizer) == null) {
                    throw new UriParserSemanticException("Wrong parameter value.", UriParserSemanticException.MessageKeys.INVALID_KEY_VALUE, "");
                }
                String literalValue = tokenizer.getText();
                parameter.setText("null".equals(literalValue) ? null : literalValue);
            }
            parameters.add(parameter);
        } while (tokenizer.next(UriTokenizer.TokenKind.COMMA));
        ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.CLOSE);
        return parameters;
    }

    protected static void validateFunctionParameters(EdmFunction function, List<UriParameter> parameters, Edm edm, EdmType referringType, Map<String, AliasQueryOption> aliases) throws UriParserException, UriValidationException {
        for (UriParameter parameter : parameters) {
            String parameterName = parameter.getName();
            EdmParameter edmParameter = function.getParameter(parameterName);
            boolean isNullable = edmParameter.isNullable();
            if (parameter.getText() != null || parameter.getExpression() != null || isNullable) continue;
            if (parameter.getAlias() == null) {
                throw new UriValidationException("Missing non-nullable parameter " + parameterName, UriValidationException.MessageKeys.MISSING_PARAMETER, parameterName);
            }
            String valueForAlias = aliases.containsKey(parameter.getAlias()) ? ParserHelper.parseAliasValue(parameter.getAlias(), edmParameter.getType(), edmParameter.isNullable(), edmParameter.isCollection(), edm, referringType, aliases).getText() : null;
            if (valueForAlias != null) continue;
            throw new UriValidationException("Missing alias for " + parameterName, UriValidationException.MessageKeys.MISSING_ALIAS, parameter.getAlias());
        }
    }

    protected static AliasQueryOption parseAliasValue(String name, EdmType type, boolean isNullable, boolean isCollection, Edm edm, EdmType referringType, Map<String, AliasQueryOption> aliases) throws UriParserException, UriValidationException {
        EdmTypeKind kind = type == null ? null : type.getKind();
        AliasQueryOption alias = aliases.get(name);
        if (alias != null && alias.getText() != null) {
            UriTokenizer aliasTokenizer = new UriTokenizer(alias.getText());
            if (kind == null || !(isCollection || kind == EdmTypeKind.COMPLEX || kind == EdmTypeKind.ENTITY ? aliasTokenizer.next(UriTokenizer.TokenKind.jsonArrayOrObject) : ParserHelper.nextPrimitiveTypeValue(aliasTokenizer, (EdmPrimitiveType)type, isNullable)) || !aliasTokenizer.next(UriTokenizer.TokenKind.EOF)) {
                aliasTokenizer = new UriTokenizer(alias.getText());
                HashMap<String, AliasQueryOption> aliasesInner = new HashMap<String, AliasQueryOption>(aliases);
                aliasesInner.remove(name);
                Expression expression = new ExpressionParser(edm, odata).parse(aliasTokenizer, referringType, null, aliasesInner);
                EdmType expressionType = ExpressionParser.getType(expression);
                if (aliasTokenizer.next(UriTokenizer.TokenKind.EOF) && (expressionType == null || type == null || expressionType.equals(type))) {
                    ((AliasQueryOptionImpl)alias).setAliasValue(expression);
                } else {
                    throw new UriParserSemanticException("Illegal value for alias '" + alias.getName() + "'.", UriParserSemanticException.MessageKeys.UNKNOWN_PART, alias.getText());
                }
            }
        }
        return alias;
    }

    protected static List<UriParameter> parseNavigationKeyPredicate(UriTokenizer tokenizer, EdmNavigationProperty navigationProperty, Edm edm, EdmType referringType, Map<String, AliasQueryOption> aliases) throws UriParserException, UriValidationException {
        if (tokenizer.next(UriTokenizer.TokenKind.OPEN)) {
            if (navigationProperty.isCollection()) {
                return ParserHelper.parseKeyPredicate(tokenizer, navigationProperty.getType(), navigationProperty.getPartner(), edm, referringType, aliases);
            }
            throw new UriParserSemanticException("A key is not allowed on non-collection navigation properties.", UriParserSemanticException.MessageKeys.KEY_NOT_ALLOWED, new String[0]);
        }
        return null;
    }

    protected static List<UriParameter> parseKeyPredicate(UriTokenizer tokenizer, EdmEntityType edmEntityType, EdmNavigationProperty partner, Edm edm, EdmType referringType, Map<String, AliasQueryOption> aliases) throws UriParserException, UriValidationException {
        List keyPropertyRefs = edmEntityType.getKeyPropertyRefs();
        if (tokenizer.next(UriTokenizer.TokenKind.CLOSE)) {
            throw new UriParserSemanticException("Expected " + keyPropertyRefs.size() + " key predicates but got none.", UriParserSemanticException.MessageKeys.WRONG_NUMBER_OF_KEY_PROPERTIES, Integer.toString(keyPropertyRefs.size()), "0");
        }
        ArrayList<UriParameter> keys = new ArrayList<UriParameter>();
        HashMap<String, String> referencedNames = new HashMap<String, String>();
        if (partner != null) {
            for (String name : edmEntityType.getKeyPredicateNames()) {
                String referencedName = partner.getReferencingPropertyName(name);
                if (referencedName == null) continue;
                referencedNames.put(name, referencedName);
            }
        }
        if (keyPropertyRefs.size() - referencedNames.size() == 1) {
            for (EdmKeyPropertyRef candidate : keyPropertyRefs) {
                if (referencedNames.get(candidate.getName()) != null) continue;
                UriParameter simpleKey = ParserHelper.simpleKey(tokenizer, candidate, edm, referringType, aliases);
                if (simpleKey == null) break;
                keys.add(simpleKey);
                break;
            }
        }
        if (keys.isEmpty()) {
            if (tokenizer.next(UriTokenizer.TokenKind.ODataIdentifier)) {
                keys.addAll(ParserHelper.compoundKey(tokenizer, edmEntityType, edm, referringType, aliases));
            } else {
                throw new UriParserSemanticException("The key value is not valid.", UriParserSemanticException.MessageKeys.INVALID_KEY_VALUE, "");
            }
        }
        if (keys.size() < keyPropertyRefs.size() && partner != null) {
            for (String name : edmEntityType.getKeyPredicateNames()) {
                boolean found = false;
                for (UriParameter key : keys) {
                    if (!name.equals(key.getName())) continue;
                    found = true;
                    break;
                }
                if (found || referencedNames.get(name) == null) continue;
                keys.add(0, new UriParameterImpl().setName(name).setReferencedProperty((String)referencedNames.get(name)));
            }
        }
        if (keys.size() < keyPropertyRefs.size()) {
            throw new UriParserSemanticException("Expected " + keyPropertyRefs.size() + " key predicates but found " + keys.size() + ".", UriParserSemanticException.MessageKeys.WRONG_NUMBER_OF_KEY_PROPERTIES, Integer.toString(keyPropertyRefs.size()), Integer.toString(keys.size()));
        }
        return keys;
    }

    private static UriParameter simpleKey(UriTokenizer tokenizer, EdmKeyPropertyRef edmKeyPropertyRef, Edm edm, EdmType referringType, Map<String, AliasQueryOption> aliases) throws UriParserException, UriValidationException {
        EdmProperty edmProperty = edmKeyPropertyRef == null ? null : edmKeyPropertyRef.getProperty();
        if (ParserHelper.nextPrimitiveTypeValue(tokenizer, edmProperty == null ? null : (EdmPrimitiveType)edmProperty.getType(), edmProperty == null ? false : edmProperty.isNullable())) {
            String literalValue = tokenizer.getText();
            ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.CLOSE);
            return ParserHelper.createUriParameter(edmProperty, edmKeyPropertyRef.getName(), literalValue, edm, referringType, aliases);
        }
        return null;
    }

    private static List<UriParameter> compoundKey(UriTokenizer tokenizer, EdmEntityType edmEntityType, Edm edm, EdmType referringType, Map<String, AliasQueryOption> aliases) throws UriParserException, UriValidationException {
        ArrayList<UriParameter> parameters = new ArrayList<UriParameter>();
        ArrayList<String> parameterNames = new ArrayList<String>();
        ArrayList remainingKeyNames = new ArrayList(edmEntityType.getKeyPredicateNames());
        boolean hasComma = false;
        do {
            String keyPredicateName;
            if (parameterNames.contains(keyPredicateName = tokenizer.getText())) {
                throw new UriValidationException("Duplicated key property " + keyPredicateName, UriValidationException.MessageKeys.DOUBLE_KEY_PROPERTY, keyPredicateName);
            }
            if (remainingKeyNames.isEmpty()) {
                throw new UriParserSemanticException("Too many key properties.", UriParserSemanticException.MessageKeys.WRONG_NUMBER_OF_KEY_PROPERTIES, Integer.toString(parameters.size()), Integer.toString(parameters.size() + 1));
            }
            if (!remainingKeyNames.remove(keyPredicateName)) {
                throw new UriValidationException("Unknown key property " + keyPredicateName, UriValidationException.MessageKeys.INVALID_KEY_PROPERTY, keyPredicateName);
            }
            parameters.add(ParserHelper.keyValuePair(tokenizer, keyPredicateName, edmEntityType, edm, referringType, aliases));
            parameterNames.add(keyPredicateName);
            hasComma = tokenizer.next(UriTokenizer.TokenKind.COMMA);
            if (!hasComma) continue;
            ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.ODataIdentifier);
        } while (hasComma);
        ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.CLOSE);
        return parameters;
    }

    private static UriParameter keyValuePair(UriTokenizer tokenizer, String keyPredicateName, EdmEntityType edmEntityType, Edm edm, EdmType referringType, Map<String, AliasQueryOption> aliases) throws UriParserException, UriValidationException {
        EdmProperty edmProperty;
        EdmKeyPropertyRef keyPropertyRef = edmEntityType.getKeyPropertyRef(keyPredicateName);
        EdmProperty edmProperty2 = edmProperty = keyPropertyRef == null ? null : keyPropertyRef.getProperty();
        if (edmProperty == null) {
            throw new UriValidationException(keyPredicateName + " is not a valid key property name.", UriValidationException.MessageKeys.INVALID_KEY_PROPERTY, keyPredicateName);
        }
        ParserHelper.requireNext(tokenizer, UriTokenizer.TokenKind.EQ);
        if (tokenizer.next(UriTokenizer.TokenKind.COMMA) || tokenizer.next(UriTokenizer.TokenKind.CLOSE) || tokenizer.next(UriTokenizer.TokenKind.EOF)) {
            throw new UriParserSyntaxException("Key value expected.", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
        }
        if (ParserHelper.nextPrimitiveTypeValue(tokenizer, (EdmPrimitiveType)edmProperty.getType(), edmProperty.isNullable())) {
            return ParserHelper.createUriParameter(edmProperty, keyPredicateName, tokenizer.getText(), edm, referringType, aliases);
        }
        throw new UriParserSemanticException(keyPredicateName + " has not a valid  key value.", UriParserSemanticException.MessageKeys.INVALID_KEY_VALUE, keyPredicateName);
    }

    private static UriParameter createUriParameter(EdmProperty edmProperty, String parameterName, String literalValue, Edm edm, EdmType referringType, Map<String, AliasQueryOption> aliases) throws UriParserException, UriValidationException {
        AliasQueryOption alias = literalValue.startsWith("@") ? ParserHelper.getKeyAlias(literalValue, edmProperty, edm, referringType, aliases) : null;
        String value = alias == null ? literalValue : alias.getText();
        EdmPrimitiveType primitiveType = (EdmPrimitiveType)edmProperty.getType();
        try {
            if (!primitiveType.validate(primitiveType.fromUriLiteral(value), Boolean.valueOf(edmProperty.isNullable()), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), Boolean.valueOf(edmProperty.isUnicode()))) {
                throw new UriValidationException("Invalid key property", UriValidationException.MessageKeys.INVALID_KEY_PROPERTY, parameterName);
            }
        }
        catch (EdmPrimitiveTypeException e) {
            throw new UriValidationException("Invalid key property", e, UriValidationException.MessageKeys.INVALID_KEY_PROPERTY, parameterName);
        }
        return new UriParameterImpl().setName(parameterName).setText("null".equals(literalValue) ? null : literalValue).setAlias(alias == null ? null : literalValue).setExpression((Expression)(alias == null ? null : (alias.getValue() == null ? new LiteralImpl(value, (EdmType)primitiveType) : alias.getValue())));
    }

    private static AliasQueryOption getKeyAlias(String name, EdmProperty edmProperty, Edm edm, EdmType referringType, Map<String, AliasQueryOption> aliases) throws UriParserException, UriValidationException {
        if (aliases.containsKey(name)) {
            return ParserHelper.parseAliasValue(name, edmProperty.getType(), edmProperty.isNullable(), edmProperty.isCollection(), edm, referringType, aliases);
        }
        throw new UriValidationException("Alias '" + name + "' for key value not found.", UriValidationException.MessageKeys.MISSING_ALIAS, name);
    }

    private static boolean nextPrimitiveTypeValue(UriTokenizer tokenizer, EdmPrimitiveType primitiveType, boolean nullable) {
        EdmPrimitiveType type;
        EdmPrimitiveType edmPrimitiveType = type = primitiveType instanceof EdmTypeDefinition ? ((EdmTypeDefinition)primitiveType).getUnderlyingType() : primitiveType;
        if (tokenizer.next(UriTokenizer.TokenKind.ParameterAliasName)) {
            return true;
        }
        if (nullable && tokenizer.next(UriTokenizer.TokenKind.NULL)) {
            return true;
        }
        if (odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Boolean).equals(type)) {
            return tokenizer.next(UriTokenizer.TokenKind.BooleanValue);
        }
        if (odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.String).equals(type)) {
            return tokenizer.next(UriTokenizer.TokenKind.StringValue);
        }
        if (odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.SByte).equals(type) || odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Byte).equals(type) || odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Int16).equals(type) || odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Int32).equals(type) || odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Int64).equals(type)) {
            return tokenizer.next(UriTokenizer.TokenKind.IntegerValue);
        }
        if (odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Guid).equals(type)) {
            return tokenizer.next(UriTokenizer.TokenKind.GuidValue);
        }
        if (odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Decimal).equals(type)) {
            return tokenizer.next(UriTokenizer.TokenKind.DecimalValue) || tokenizer.next(UriTokenizer.TokenKind.IntegerValue);
        }
        if (odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Double).equals(type) || odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Single).equals(type)) {
            return tokenizer.next(UriTokenizer.TokenKind.DoubleValue) || tokenizer.next(UriTokenizer.TokenKind.DecimalValue) || tokenizer.next(UriTokenizer.TokenKind.IntegerValue);
        }
        if (type.getKind() == EdmTypeKind.ENUM) {
            return tokenizer.next(UriTokenizer.TokenKind.EnumValue);
        }
        for (Map.Entry<UriTokenizer.TokenKind, EdmPrimitiveTypeKind> entry : tokenToPrimitiveType.entrySet()) {
            EdmPrimitiveTypeKind kind = entry.getValue();
            if (kind != EdmPrimitiveTypeKind.Date && kind != EdmPrimitiveTypeKind.DateTimeOffset && kind != EdmPrimitiveTypeKind.TimeOfDay && kind != EdmPrimitiveTypeKind.Duration && kind != EdmPrimitiveTypeKind.Binary && !kind.isGeospatial() || !odata.createPrimitiveTypeInstance(kind).equals(type)) continue;
            return tokenizer.next(entry.getKey());
        }
        return false;
    }

    protected static List<String> getParameterNames(List<UriParameter> parameters) {
        ArrayList<String> names = new ArrayList<String>();
        for (UriParameter parameter : parameters) {
            names.add(parameter.getName());
        }
        return names;
    }

    protected static EdmStructuredType parseTypeCast(UriTokenizer tokenizer, Edm edm, EdmStructuredType referencedType) throws UriParserException {
        if (tokenizer.next(UriTokenizer.TokenKind.QualifiedName)) {
            EdmEntityType type;
            FullQualifiedName qualifiedName = new FullQualifiedName(tokenizer.getText());
            Object object = type = referencedType.getKind() == EdmTypeKind.ENTITY ? edm.getEntityType(qualifiedName) : edm.getComplexType(qualifiedName);
            if (type == null) {
                throw new UriParserSemanticException("Type '" + qualifiedName + "' not found.", UriParserSemanticException.MessageKeys.UNKNOWN_PART, qualifiedName.getFullQualifiedNameAsString());
            }
            if (!type.compatibleTo((EdmType)referencedType)) {
                throw new UriParserSemanticException("The type cast '" + qualifiedName + "' is not compatible.", UriParserSemanticException.MessageKeys.INCOMPATIBLE_TYPE_FILTER, type.getName());
            }
            return type;
        }
        return null;
    }

    protected static EdmType getTypeInformation(UriResourcePartTyped resourcePart) {
        UriResourceTypedImpl lastPartTyped;
        UriResourceWithKeysImpl lastPartWithKeys;
        EdmType type = null;
        type = resourcePart instanceof UriResourceWithKeysImpl ? ((lastPartWithKeys = (UriResourceWithKeysImpl)resourcePart).getTypeFilterOnEntry() != null ? lastPartWithKeys.getTypeFilterOnEntry() : (lastPartWithKeys.getTypeFilterOnCollection() != null ? lastPartWithKeys.getTypeFilterOnCollection() : lastPartWithKeys.getType())) : (resourcePart instanceof UriResourceTypedImpl ? ((lastPartTyped = (UriResourceTypedImpl)resourcePart).getTypeFilter() == null ? lastPartTyped.getType() : lastPartTyped.getTypeFilter()) : resourcePart.getType());
        return type;
    }

    protected static int parseNonNegativeInteger(String optionName, String optionValue, boolean zeroAllowed) throws UriParserException {
        int value;
        try {
            value = Integer.parseInt(optionValue);
        }
        catch (NumberFormatException e) {
            throw new UriParserSyntaxException("Illegal value of '" + optionName + "' option!", e, UriParserSyntaxException.MessageKeys.WRONG_VALUE_FOR_SYSTEM_QUERY_OPTION, optionName, optionValue);
        }
        if (value > 0 || value == 0 && zeroAllowed) {
            return value;
        }
        throw new UriParserSyntaxException("Illegal value of '" + optionName + "' option!", UriParserSyntaxException.MessageKeys.WRONG_VALUE_FOR_SYSTEM_QUERY_OPTION, optionName, optionValue);
    }

    protected static void validateFunctionParameterFacets(EdmFunction function, List<UriParameter> parameters, Edm edm, Map<String, AliasQueryOption> aliases) throws UriParserException, UriValidationException {
        for (UriParameter parameter : parameters) {
            EdmParameter edmParameter = function.getParameter(parameter.getName());
            EdmType type = edmParameter.getType();
            EdmTypeKind kind = type.getKind();
            if (kind != EdmTypeKind.PRIMITIVE && kind != EdmTypeKind.DEFINITION && kind != EdmTypeKind.ENUM || edmParameter.isCollection()) continue;
            EdmPrimitiveType primitiveType = (EdmPrimitiveType)type;
            String text = null;
            try {
                text = parameter.getAlias() == null ? parameter.getText() : (aliases.containsKey(parameter.getAlias()) ? ParserHelper.parseAliasValue(parameter.getAlias(), edmParameter.getType(), edmParameter.isNullable(), edmParameter.isCollection(), edm, type, aliases).getText() : null);
                primitiveType.valueOfString(primitiveType.fromUriLiteral(text), Boolean.valueOf(edmParameter.isNullable()), edmParameter.getMaxLength(), edmParameter.getPrecision(), edmParameter.getScale(), Boolean.valueOf(true), edmParameter.getMapping() == null ? primitiveType.getDefaultType() : edmParameter.getMapping().getMappedJavaClass());
            }
            catch (EdmPrimitiveTypeException e) {
                throw new UriValidationException("Invalid value '" + text + "' for parameter " + parameter.getName(), e, UriValidationException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, parameter.getName());
            }
        }
    }

    static {
        EnumMap<UriTokenizer.TokenKind, EdmPrimitiveTypeKind> temp = new EnumMap<UriTokenizer.TokenKind, EdmPrimitiveTypeKind>(UriTokenizer.TokenKind.class);
        temp.put(UriTokenizer.TokenKind.BooleanValue, EdmPrimitiveTypeKind.Boolean);
        temp.put(UriTokenizer.TokenKind.StringValue, EdmPrimitiveTypeKind.String);
        temp.put(UriTokenizer.TokenKind.IntegerValue, EdmPrimitiveTypeKind.Int64);
        temp.put(UriTokenizer.TokenKind.GuidValue, EdmPrimitiveTypeKind.Guid);
        temp.put(UriTokenizer.TokenKind.DateValue, EdmPrimitiveTypeKind.Date);
        temp.put(UriTokenizer.TokenKind.DateTimeOffsetValue, EdmPrimitiveTypeKind.DateTimeOffset);
        temp.put(UriTokenizer.TokenKind.TimeOfDayValue, EdmPrimitiveTypeKind.TimeOfDay);
        temp.put(UriTokenizer.TokenKind.DecimalValue, EdmPrimitiveTypeKind.Decimal);
        temp.put(UriTokenizer.TokenKind.DoubleValue, EdmPrimitiveTypeKind.Double);
        temp.put(UriTokenizer.TokenKind.DurationValue, EdmPrimitiveTypeKind.Duration);
        temp.put(UriTokenizer.TokenKind.BinaryValue, EdmPrimitiveTypeKind.Binary);
        temp.put(UriTokenizer.TokenKind.GeographyPoint, EdmPrimitiveTypeKind.GeographyPoint);
        temp.put(UriTokenizer.TokenKind.GeometryPoint, EdmPrimitiveTypeKind.GeometryPoint);
        temp.put(UriTokenizer.TokenKind.GeographyLineString, EdmPrimitiveTypeKind.GeographyLineString);
        temp.put(UriTokenizer.TokenKind.GeometryLineString, EdmPrimitiveTypeKind.GeometryLineString);
        temp.put(UriTokenizer.TokenKind.GeographyPolygon, EdmPrimitiveTypeKind.GeographyPolygon);
        temp.put(UriTokenizer.TokenKind.GeometryPolygon, EdmPrimitiveTypeKind.GeometryPolygon);
        temp.put(UriTokenizer.TokenKind.GeographyMultiPoint, EdmPrimitiveTypeKind.GeographyMultiPoint);
        temp.put(UriTokenizer.TokenKind.GeometryMultiPoint, EdmPrimitiveTypeKind.GeometryMultiPoint);
        temp.put(UriTokenizer.TokenKind.GeographyMultiLineString, EdmPrimitiveTypeKind.GeographyMultiLineString);
        temp.put(UriTokenizer.TokenKind.GeometryMultiLineString, EdmPrimitiveTypeKind.GeometryMultiLineString);
        temp.put(UriTokenizer.TokenKind.GeographyMultiPolygon, EdmPrimitiveTypeKind.GeographyMultiPolygon);
        temp.put(UriTokenizer.TokenKind.GeometryMultiPolygon, EdmPrimitiveTypeKind.GeometryMultiPolygon);
        temp.put(UriTokenizer.TokenKind.GeographyCollection, EdmPrimitiveTypeKind.GeographyCollection);
        temp.put(UriTokenizer.TokenKind.GeometryCollection, EdmPrimitiveTypeKind.GeometryCollection);
        tokenToPrimitiveType = Collections.unmodifiableMap(temp);
    }
}

