/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlActionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumMember;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.provider.CsdlOnDelete;
import org.apache.olingo.commons.api.edm.provider.CsdlOnDeleteAction;
import org.apache.olingo.commons.api.edm.provider.CsdlOperation;
import org.apache.olingo.commons.api.edm.provider.CsdlParameter;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlPropertyRef;
import org.apache.olingo.commons.api.edm.provider.CsdlReferentialConstraint;
import org.apache.olingo.commons.api.edm.provider.CsdlReturnType;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlSingleton;
import org.apache.olingo.commons.api.edm.provider.CsdlTerm;
import org.apache.olingo.commons.api.edm.provider.CsdlTypeDefinition;
import org.apache.olingo.server.core.SchemaBasedEdmProvider;

public class MetadataParser {
    public CsdlEdmProvider buildEdmProvider(Reader csdl) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLEventReader reader = xmlInputFactory.createXMLEventReader(csdl);
        SchemaBasedEdmProvider provider = new SchemaBasedEdmProvider();
        new ElementReader<SchemaBasedEdmProvider>(){

            @Override
            void build(XMLEventReader reader, StartElement element, SchemaBasedEdmProvider provider, String name) throws XMLStreamException {
                String version = MetadataParser.this.attr(element, "Version");
                if (version.equals("4.0")) {
                    MetadataParser.this.readDataServicesAndReference(reader, element, provider);
                }
            }
        }.read(reader, null, provider, "Edmx");
        return provider;
    }

    private void readDataServicesAndReference(XMLEventReader reader, StartElement element, SchemaBasedEdmProvider provider) throws XMLStreamException {
        new ElementReader<SchemaBasedEdmProvider>(){

            @Override
            void build(XMLEventReader reader, StartElement element, SchemaBasedEdmProvider provider, String name) throws XMLStreamException {
                if (name.equals("DataServices")) {
                    MetadataParser.this.readSchema(reader, element, provider);
                } else if (name.equals("Reference")) {
                    MetadataParser.this.readReference(reader, element, provider, "Reference");
                }
            }
        }.read(reader, element, provider, "DataServices", "Reference");
    }

    private void readReference(XMLEventReader reader, StartElement element, SchemaBasedEdmProvider provider, String name) throws XMLStreamException {
        new ElementReader<SchemaBasedEdmProvider>(){

            @Override
            void build(XMLEventReader reader, StartElement element, SchemaBasedEdmProvider t, String name) throws XMLStreamException {
            }
        }.read(reader, element, provider, name);
    }

    private void readSchema(XMLEventReader reader, StartElement element, SchemaBasedEdmProvider provider) throws XMLStreamException {
        CsdlSchema schema = new CsdlSchema();
        schema.setComplexTypes(new ArrayList());
        schema.setActions(new ArrayList());
        schema.setEntityTypes(new ArrayList());
        schema.setEnumTypes(new ArrayList());
        schema.setFunctions(new ArrayList());
        schema.setTerms(new ArrayList());
        schema.setTypeDefinitions(new ArrayList());
        new ElementReader<CsdlSchema>(){

            @Override
            void build(XMLEventReader reader, StartElement element, CsdlSchema schema, String name) throws XMLStreamException {
                schema.setNamespace(MetadataParser.this.attr(element, "Namespace"));
                schema.setAlias(MetadataParser.this.attr(element, "Alias"));
                MetadataParser.this.readSchemaContents(reader, schema);
            }
        }.read(reader, element, schema, "Schema");
        provider.addSchema(schema);
    }

    private void readSchemaContents(XMLEventReader reader, CsdlSchema schema) throws XMLStreamException {
        new ElementReader<CsdlSchema>(){

            @Override
            void build(XMLEventReader reader, StartElement element, CsdlSchema schema, String name) throws XMLStreamException {
                if (name.equals("Action")) {
                    MetadataParser.this.readAction(reader, element, schema);
                } else if (!name.equals("Annotations") && !name.equals("Annotation")) {
                    if (name.equals("ComplexType")) {
                        MetadataParser.this.readComplexType(reader, element, schema);
                    } else if (name.equals("EntityContainer")) {
                        MetadataParser.this.readEntityContainer(reader, element, schema);
                    } else if (name.equals("EntityType")) {
                        MetadataParser.this.readEntityType(reader, element, schema);
                    } else if (name.equals("EnumType")) {
                        MetadataParser.this.readEnumType(reader, element, schema);
                    } else if (name.equals("Function")) {
                        MetadataParser.this.readFunction(reader, element, schema);
                    } else if (name.equals("Term")) {
                        schema.getTerms().add(MetadataParser.this.readTerm(element));
                    } else if (name.equals("TypeDefinition")) {
                        schema.getTypeDefinitions().add(MetadataParser.this.readTypeDefinition(element));
                    }
                }
            }
        }.read(reader, null, schema, "Action", "Annotations", "Annotation", "ComplexType", "EntityContainer", "EntityType", "EnumType", "Function", "Term", "TypeDefinition");
    }

    private void readAction(XMLEventReader reader, StartElement element, CsdlSchema schema) throws XMLStreamException {
        CsdlAction action = new CsdlAction();
        action.setParameters(new ArrayList());
        action.setName(this.attr(element, "Name"));
        action.setBound(Boolean.parseBoolean(this.attr(element, "IsBound")));
        String entitySetPath = this.attr(element, "EntitySetPath");
        if (entitySetPath != null) {
            action.setEntitySetPath(entitySetPath);
        }
        this.readOperationParameters(reader, (CsdlOperation)action);
        schema.getActions().add(action);
    }

    private FullQualifiedName readType(StartElement element) {
        String type = this.attr(element, "Type");
        if (type.startsWith("Collection(") && type.endsWith(")")) {
            return new FullQualifiedName(type.substring(11, type.length() - 1));
        }
        return new FullQualifiedName(type);
    }

    private boolean isCollectionType(StartElement element) {
        String type = this.attr(element, "Type");
        return type.startsWith("Collection(") && type.endsWith(")");
    }

    private void readReturnType(StartElement element, CsdlOperation operation) {
        String srid;
        String scale;
        String precision;
        CsdlReturnType returnType = new CsdlReturnType();
        returnType.setType(this.readType(element));
        returnType.setCollection(this.isCollectionType(element));
        returnType.setNullable(Boolean.parseBoolean(this.attr(element, "Nullable")));
        String maxLength = this.attr(element, "MaxLength");
        if (maxLength != null) {
            returnType.setMaxLength(Integer.valueOf(Integer.parseInt(maxLength)));
        }
        if ((precision = this.attr(element, "Precision")) != null) {
            returnType.setPrecision(Integer.valueOf(Integer.parseInt(precision)));
        }
        if ((scale = this.attr(element, "Scale")) != null) {
            returnType.setScale(Integer.valueOf(Integer.parseInt(scale)));
        }
        if ((srid = this.attr(element, "SRID")) != null) {
            // empty if block
        }
        operation.setReturnType(returnType);
    }

    private void readParameter(StartElement element, CsdlOperation operation) {
        String srid;
        String scale;
        String precision;
        CsdlParameter parameter = new CsdlParameter();
        parameter.setName(this.attr(element, "Name"));
        parameter.setType(this.readType(element));
        parameter.setCollection(this.isCollectionType(element));
        parameter.setNullable(Boolean.parseBoolean(this.attr(element, "Nullable")));
        String maxLength = this.attr(element, "MaxLength");
        if (maxLength != null) {
            parameter.setMaxLength(Integer.valueOf(Integer.parseInt(maxLength)));
        }
        if ((precision = this.attr(element, "Precision")) != null) {
            parameter.setPrecision(Integer.valueOf(Integer.parseInt(precision)));
        }
        if ((scale = this.attr(element, "Scale")) != null) {
            parameter.setScale(Integer.valueOf(Integer.parseInt(scale)));
        }
        if ((srid = this.attr(element, "SRID")) != null) {
            // empty if block
        }
        operation.getParameters().add(parameter);
    }

    private CsdlTypeDefinition readTypeDefinition(StartElement element) {
        String srid;
        String scale;
        String precision;
        CsdlTypeDefinition td = new CsdlTypeDefinition();
        td.setName(this.attr(element, "Name"));
        td.setUnderlyingType(new FullQualifiedName(this.attr(element, "UnderlyingType")));
        td.setUnicode(Boolean.parseBoolean(this.attr(element, "Unicode")));
        String maxLength = this.attr(element, "MaxLength");
        if (maxLength != null) {
            td.setMaxLength(Integer.valueOf(Integer.parseInt(maxLength)));
        }
        if ((precision = this.attr(element, "Precision")) != null) {
            td.setPrecision(Integer.valueOf(Integer.parseInt(precision)));
        }
        if ((scale = this.attr(element, "Scale")) != null) {
            td.setScale(Integer.valueOf(Integer.parseInt(scale)));
        }
        if ((srid = this.attr(element, "SRID")) != null) {
            // empty if block
        }
        return td;
    }

    private CsdlTerm readTerm(StartElement element) {
        String srid;
        String scale;
        String precision;
        CsdlTerm term = new CsdlTerm();
        term.setName(this.attr(element, "Name"));
        term.setType(this.attr(element, "Type"));
        if (this.attr(element, "BaseTerm") != null) {
            term.setBaseTerm(this.attr(element, "BaseTerm"));
        }
        if (this.attr(element, "DefaultValue") != null) {
            term.setDefaultValue(this.attr(element, "DefaultValue"));
        }
        if (this.attr(element, "AppliesTo") != null) {
            term.setAppliesTo(Arrays.asList(this.attr(element, "AppliesTo")));
        }
        term.setNullable(Boolean.parseBoolean(this.attr(element, "Nullable")));
        String maxLength = this.attr(element, "MaxLength");
        if (maxLength != null) {
            term.setMaxLength(Integer.valueOf(Integer.parseInt(maxLength)));
        }
        if ((precision = this.attr(element, "Precision")) != null) {
            term.setPrecision(Integer.valueOf(Integer.parseInt(precision)));
        }
        if ((scale = this.attr(element, "Scale")) != null) {
            term.setScale(Integer.valueOf(Integer.parseInt(scale)));
        }
        if ((srid = this.attr(element, "SRID")) != null) {
            // empty if block
        }
        return term;
    }

    private void readFunction(XMLEventReader reader, StartElement element, CsdlSchema schema) throws XMLStreamException {
        CsdlFunction function = new CsdlFunction();
        function.setParameters(new ArrayList());
        function.setName(this.attr(element, "Name"));
        function.setBound(Boolean.parseBoolean(this.attr(element, "IsBound")));
        function.setComposable(Boolean.parseBoolean(this.attr(element, "IsComposable")));
        String entitySetPath = this.attr(element, "EntitySetPath");
        if (entitySetPath != null) {
            function.setEntitySetPath(entitySetPath);
        }
        this.readOperationParameters(reader, (CsdlOperation)function);
        schema.getFunctions().add(function);
    }

    private void readOperationParameters(XMLEventReader reader, CsdlOperation operation) throws XMLStreamException {
        new ElementReader<CsdlOperation>(){

            @Override
            void build(XMLEventReader reader, StartElement element, CsdlOperation operation, String name) throws XMLStreamException {
                if (name.equals("Parameter")) {
                    MetadataParser.this.readParameter(element, operation);
                } else if (name.equals("ReturnType")) {
                    MetadataParser.this.readReturnType(element, operation);
                }
            }
        }.read(reader, null, operation, "Parameter", "ReturnType");
    }

    private void readEnumType(XMLEventReader reader, StartElement element, CsdlSchema schema) throws XMLStreamException {
        CsdlEnumType type = new CsdlEnumType();
        type.setMembers(new ArrayList());
        type.setName(this.attr(element, "Name"));
        if (this.attr(element, "UnderlyingType") != null) {
            type.setUnderlyingType(new FullQualifiedName(this.attr(element, "UnderlyingType")));
        }
        type.setFlags(Boolean.parseBoolean(this.attr(element, "IsFlags")));
        this.readEnumMembers(reader, element, type);
        schema.getEnumTypes().add(type);
    }

    private void readEnumMembers(XMLEventReader reader, StartElement element, CsdlEnumType type) throws XMLStreamException {
        new ElementReader<CsdlEnumType>(){

            @Override
            void build(XMLEventReader reader, StartElement element, CsdlEnumType type, String name) throws XMLStreamException {
                CsdlEnumMember member = new CsdlEnumMember();
                member.setName(MetadataParser.this.attr(element, "Name"));
                member.setValue(MetadataParser.this.attr(element, "Value"));
                type.getMembers().add(member);
            }
        }.read(reader, element, type, "Member");
    }

    private void readEntityType(XMLEventReader reader, StartElement element, CsdlSchema schema) throws XMLStreamException {
        CsdlEntityType entityType = new CsdlEntityType();
        entityType.setProperties(new ArrayList());
        entityType.setNavigationProperties(new ArrayList());
        entityType.setKey(new ArrayList());
        entityType.setName(this.attr(element, "Name"));
        if (this.attr(element, "BaseType") != null) {
            entityType.setBaseType(new FullQualifiedName(this.attr(element, "BaseType")));
        }
        entityType.setAbstract(Boolean.parseBoolean(this.attr(element, "Abstract")));
        entityType.setOpenType(Boolean.parseBoolean(this.attr(element, "OpenType")));
        entityType.setHasStream(Boolean.parseBoolean(this.attr(element, "HasStream")));
        this.readEntityProperties(reader, entityType);
        schema.getEntityTypes().add(entityType);
    }

    private void readEntityProperties(XMLEventReader reader, CsdlEntityType entityType) throws XMLStreamException {
        new ElementReader<CsdlEntityType>(){

            @Override
            void build(XMLEventReader reader, StartElement element, CsdlEntityType entityType, String name) throws XMLStreamException {
                if (name.equals("Property")) {
                    entityType.getProperties().add(MetadataParser.this.readProperty(element));
                } else if (name.equals("NavigationProperty")) {
                    entityType.getNavigationProperties().add(MetadataParser.this.readNavigationProperty(reader, element));
                } else if (name.equals("Key")) {
                    MetadataParser.this.readKey(reader, element, entityType);
                }
            }
        }.read(reader, null, entityType, "Property", "NavigationProperty", "Key");
    }

    private void readKey(XMLEventReader reader, StartElement element, CsdlEntityType entityType) throws XMLStreamException {
        new ElementReader<CsdlEntityType>(){

            @Override
            void build(XMLEventReader reader, StartElement element, CsdlEntityType entityType, String name) throws XMLStreamException {
                CsdlPropertyRef ref = new CsdlPropertyRef();
                ref.setName(MetadataParser.this.attr(element, "Name"));
                ref.setAlias(MetadataParser.this.attr(element, "Alias"));
                entityType.getKey().add(ref);
            }
        }.read(reader, element, entityType, "PropertyRef");
    }

    private CsdlNavigationProperty readNavigationProperty(XMLEventReader reader, StartElement element) throws XMLStreamException {
        CsdlNavigationProperty property = new CsdlNavigationProperty();
        property.setReferentialConstraints(new ArrayList());
        property.setName(this.attr(element, "Name"));
        property.setType(this.readType(element));
        property.setCollection(this.isCollectionType(element));
        property.setNullable(Boolean.valueOf(Boolean.parseBoolean(this.attr(element, "Nullable"))));
        property.setPartner(this.attr(element, "Partner"));
        property.setContainsTarget(Boolean.parseBoolean(this.attr(element, "ContainsTarget")));
        new ElementReader<CsdlNavigationProperty>(){

            @Override
            void build(XMLEventReader reader, StartElement element, CsdlNavigationProperty property, String name) throws XMLStreamException {
                if (name.equals("ReferentialConstraint")) {
                    CsdlReferentialConstraint constraint = new CsdlReferentialConstraint();
                    constraint.setProperty(MetadataParser.this.attr(element, "Property"));
                    constraint.setReferencedProperty(MetadataParser.this.attr(element, "ReferencedProperty"));
                    property.getReferentialConstraints().add(constraint);
                } else if (name.equals("OnDelete")) {
                    property.setOnDelete(new CsdlOnDelete().setAction(CsdlOnDeleteAction.valueOf((String)MetadataParser.this.attr(element, "Action"))));
                }
            }
        }.read(reader, element, property, "ReferentialConstraint", "OnDelete");
        return property;
    }

    private String attr(StartElement element, String name) {
        Attribute attr = element.getAttributeByName(new QName(name));
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    private CsdlProperty readProperty(StartElement element) {
        String defaultValue;
        String srid;
        String scale;
        String precision;
        CsdlProperty property = new CsdlProperty();
        property.setName(this.attr(element, "Name"));
        property.setType(this.readType(element));
        property.setCollection(this.isCollectionType(element));
        property.setNullable(Boolean.parseBoolean(this.attr(element, "Nullable") == null ? "true" : this.attr(element, "Nullable")));
        property.setUnicode(Boolean.parseBoolean(this.attr(element, "Unicode")));
        String maxLength = this.attr(element, "MaxLength");
        if (maxLength != null) {
            property.setMaxLength(Integer.valueOf(Integer.parseInt(maxLength)));
        }
        if ((precision = this.attr(element, "Precision")) != null) {
            property.setPrecision(Integer.valueOf(Integer.parseInt(precision)));
        }
        if ((scale = this.attr(element, "Scale")) != null) {
            property.setScale(Integer.valueOf(Integer.parseInt(scale)));
        }
        if ((srid = this.attr(element, "SRID")) != null) {
            // empty if block
        }
        if ((defaultValue = this.attr(element, "DefaultValue")) != null) {
            property.setDefaultValue(defaultValue);
        }
        return property;
    }

    private void readEntityContainer(XMLEventReader reader, StartElement element, CsdlSchema schema) throws XMLStreamException {
        final CsdlEntityContainer container = new CsdlEntityContainer();
        container.setName(this.attr(element, "Name"));
        if (this.attr(element, "Extends") != null) {
            container.setExtendsContainer(this.attr(element, "Extends"));
        }
        container.setActionImports(new ArrayList());
        container.setFunctionImports(new ArrayList());
        container.setEntitySets(new ArrayList());
        container.setSingletons(new ArrayList());
        new ElementReader<CsdlSchema>(){

            @Override
            void build(XMLEventReader reader, StartElement element, CsdlSchema schema, String name) throws XMLStreamException {
                if (name.equals("EntitySet")) {
                    this.readEntitySet(reader, element, container);
                } else if (name.equals("Singleton")) {
                    this.readSingleton(reader, element, container);
                } else if (name.equals("ActionImport")) {
                    this.readActionImport(element, container);
                } else if (name.equals("FunctionImport")) {
                    this.readFunctionImport(element, container);
                }
            }

            private void readFunctionImport(StartElement element, CsdlEntityContainer container2) {
                CsdlFunctionImport functionImport = new CsdlFunctionImport();
                functionImport.setName(MetadataParser.this.attr(element, "Name"));
                functionImport.setFunction(new FullQualifiedName(MetadataParser.this.attr(element, "Function")));
                functionImport.setIncludeInServiceDocument(Boolean.parseBoolean(MetadataParser.this.attr(element, "IncludeInServiceDocument")));
                String entitySet = MetadataParser.this.attr(element, "EntitySet");
                if (entitySet != null) {
                    functionImport.setEntitySet(entitySet);
                }
                container2.getFunctionImports().add(functionImport);
            }

            private void readActionImport(StartElement element, CsdlEntityContainer container2) {
                CsdlActionImport actionImport = new CsdlActionImport();
                actionImport.setName(MetadataParser.this.attr(element, "Name"));
                actionImport.setAction(new FullQualifiedName(MetadataParser.this.attr(element, "Action")));
                String entitySet = MetadataParser.this.attr(element, "EntitySet");
                if (entitySet != null) {
                    actionImport.setEntitySet(entitySet);
                }
                container2.getActionImports().add(actionImport);
            }

            private void readSingleton(XMLEventReader reader, StartElement element, CsdlEntityContainer container2) throws XMLStreamException {
                CsdlSingleton singleton = new CsdlSingleton();
                singleton.setNavigationPropertyBindings(new ArrayList());
                singleton.setName(MetadataParser.this.attr(element, "Name"));
                singleton.setType(new FullQualifiedName(MetadataParser.this.attr(element, "Type")));
                singleton.setNavigationPropertyBindings(new ArrayList());
                this.readNavigationPropertyBindings(reader, element, singleton.getNavigationPropertyBindings());
                container2.getSingletons().add(singleton);
            }

            private void readEntitySet(XMLEventReader reader, StartElement element, CsdlEntityContainer container2) throws XMLStreamException {
                CsdlEntitySet entitySet = new CsdlEntitySet();
                entitySet.setName(MetadataParser.this.attr(element, "Name"));
                entitySet.setType(new FullQualifiedName(MetadataParser.this.attr(element, "EntityType")));
                entitySet.setIncludeInServiceDocument(Boolean.parseBoolean(MetadataParser.this.attr(element, "IncludeInServiceDocument")));
                entitySet.setNavigationPropertyBindings(new ArrayList());
                this.readNavigationPropertyBindings(reader, element, entitySet.getNavigationPropertyBindings());
                container2.getEntitySets().add(entitySet);
            }

            private void readNavigationPropertyBindings(XMLEventReader reader, StartElement element, List<CsdlNavigationPropertyBinding> bindings) throws XMLStreamException {
                new ElementReader<List<CsdlNavigationPropertyBinding>>(){

                    @Override
                    void build(XMLEventReader reader, StartElement element, List<CsdlNavigationPropertyBinding> bindings, String name) throws XMLStreamException {
                        CsdlNavigationPropertyBinding binding = new CsdlNavigationPropertyBinding();
                        binding.setPath(MetadataParser.this.attr(element, "Path"));
                        binding.setTarget(MetadataParser.this.attr(element, "Target"));
                        bindings.add(binding);
                    }
                }.read(reader, element, bindings, "NavigationPropertyBinding");
            }
        }.read(reader, element, schema, "EntitySet", "Singleton", "ActionImport", "FunctionImport");
        schema.setEntityContainer(container);
    }

    private void readComplexType(XMLEventReader reader, StartElement element, CsdlSchema schema) throws XMLStreamException {
        CsdlComplexType complexType = new CsdlComplexType();
        complexType.setProperties(new ArrayList());
        complexType.setNavigationProperties(new ArrayList());
        complexType.setName(this.attr(element, "Name"));
        if (this.attr(element, "BaseType") != null) {
            complexType.setBaseType(new FullQualifiedName(this.attr(element, "BaseType")));
        }
        complexType.setAbstract(Boolean.parseBoolean(this.attr(element, "Abstract")));
        complexType.setOpenType(Boolean.parseBoolean(this.attr(element, "OpenType")));
        this.readProperties(reader, complexType);
        schema.getComplexTypes().add(complexType);
    }

    private void readProperties(XMLEventReader reader, CsdlComplexType complexType) throws XMLStreamException {
        new ElementReader<CsdlComplexType>(){

            @Override
            void build(XMLEventReader reader, StartElement element, CsdlComplexType complexType, String name) throws XMLStreamException {
                if (name.equals("Property")) {
                    complexType.getProperties().add(MetadataParser.this.readProperty(element));
                } else if (name.equals("NavigationProperty")) {
                    complexType.getNavigationProperties().add(MetadataParser.this.readNavigationProperty(reader, element));
                }
            }
        }.read(reader, null, complexType, "Property", "NavigationProperty");
    }

    abstract class ElementReader<T> {
        ElementReader() {
        }

        void read(XMLEventReader reader, StartElement element, T t, String ... names) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent event = reader.peek();
                if (!(event = this.skipAnnotations(reader, event)).isStartElement() && !event.isEndElement()) {
                    reader.nextEvent();
                    continue;
                }
                boolean hit = false;
                for (int i = 0; i < names.length; ++i) {
                    EndElement e;
                    if (event.isStartElement() && (element = event.asStartElement()).getName().getLocalPart().equals(names[i])) {
                        reader.nextEvent();
                        this.build(reader, element, t, names[i]);
                        hit = true;
                    }
                    if (!event.isEndElement() || !(e = event.asEndElement()).getName().getLocalPart().equals(names[i])) continue;
                    reader.nextEvent();
                    hit = true;
                }
                if (hit) continue;
                break;
            }
        }

        private XMLEvent skipAnnotations(XMLEventReader reader, XMLEvent event) throws XMLStreamException {
            boolean skip = false;
            while (reader.hasNext()) {
                XMLEvent element;
                if (event.isStartElement() && (element = event.asStartElement()).getName().getLocalPart().equals("Annotation")) {
                    skip = true;
                }
                if (event.isEndElement() && (element = event.asEndElement()).getName().getLocalPart().equals("Annotation")) {
                    return reader.peek();
                }
                if (skip) {
                    event = reader.nextEvent();
                    continue;
                }
                return event;
            }
            return event;
        }

        abstract void build(XMLEventReader var1, StartElement var2, T var3, String var4) throws XMLStreamException;
    }
}

