/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.olingo.commons.api.ODataException;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlActionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlAliasInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotatable;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotations;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainerInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlSingleton;
import org.apache.olingo.commons.api.edm.provider.CsdlTerm;
import org.apache.olingo.commons.api.edm.provider.CsdlTypeDefinition;

public class SchemaBasedEdmProvider
implements CsdlEdmProvider {
    private final List<CsdlSchema> edmSchemas = new ArrayList<CsdlSchema>();

    public void addSchema(CsdlSchema schema) {
        this.edmSchemas.add(schema);
    }

    private CsdlSchema getSchema(String ns) {
        for (CsdlSchema s : this.edmSchemas) {
            if (!s.getNamespace().equals(ns)) continue;
            return s;
        }
        return null;
    }

    public CsdlEnumType getEnumType(FullQualifiedName fqn) throws ODataException {
        List types;
        CsdlSchema schema = this.getSchema(fqn.getNamespace());
        if (schema != null && (types = schema.getEnumTypes()) != null) {
            for (CsdlEnumType type : types) {
                if (!type.getName().equals(fqn.getName())) continue;
                return type;
            }
        }
        return null;
    }

    public CsdlTypeDefinition getTypeDefinition(FullQualifiedName fqn) throws ODataException {
        List types;
        CsdlSchema schema = this.getSchema(fqn.getNamespace());
        if (schema != null && (types = schema.getTypeDefinitions()) != null) {
            for (CsdlTypeDefinition type : types) {
                if (!type.getName().equals(fqn.getName())) continue;
                return type;
            }
        }
        return null;
    }

    public List<CsdlFunction> getFunctions(FullQualifiedName fqn) throws ODataException {
        List functions;
        ArrayList<CsdlFunction> foundFuncs = new ArrayList<CsdlFunction>();
        CsdlSchema schema = this.getSchema(fqn.getNamespace());
        if (schema != null && (functions = schema.getFunctions()) != null) {
            for (CsdlFunction func : functions) {
                if (!func.getName().equals(fqn.getName())) continue;
                foundFuncs.add(func);
            }
        }
        return foundFuncs;
    }

    public CsdlTerm getTerm(FullQualifiedName fqn) throws ODataException {
        List terms;
        CsdlSchema schema = this.getSchema(fqn.getNamespace());
        if (schema != null && (terms = schema.getTerms()) != null) {
            for (CsdlTerm term : terms) {
                if (!term.getName().equals(fqn.getName())) continue;
                return term;
            }
        }
        return null;
    }

    public CsdlEntitySet getEntitySet(FullQualifiedName fqn, String entitySetName) throws ODataException {
        CsdlEntityContainer ec;
        CsdlSchema schema = this.getSchema(fqn.getFullQualifiedNameAsString());
        if (schema != null && (ec = schema.getEntityContainer()) != null && ec.getEntitySets() != null) {
            for (CsdlEntitySet es : ec.getEntitySets()) {
                if (!es.getName().equals(entitySetName)) continue;
                return es;
            }
        }
        return null;
    }

    public CsdlSingleton getSingleton(FullQualifiedName fqn, String singletonName) throws ODataException {
        CsdlEntityContainer ec;
        CsdlSchema schema = this.getSchema(fqn.getFullQualifiedNameAsString());
        if (schema != null && (ec = schema.getEntityContainer()) != null && ec.getSingletons() != null) {
            for (CsdlSingleton es : ec.getSingletons()) {
                if (!es.getName().equals(singletonName)) continue;
                return es;
            }
        }
        return null;
    }

    public CsdlActionImport getActionImport(FullQualifiedName fqn, String actionImportName) throws ODataException {
        CsdlEntityContainer ec;
        CsdlSchema schema = this.getSchema(fqn.getFullQualifiedNameAsString());
        if (schema != null && (ec = schema.getEntityContainer()) != null && ec.getActionImports() != null) {
            for (CsdlActionImport es : ec.getActionImports()) {
                if (!es.getName().equals(actionImportName)) continue;
                return es;
            }
        }
        return null;
    }

    public CsdlFunctionImport getFunctionImport(FullQualifiedName fqn, String functionImportName) throws ODataException {
        CsdlEntityContainer ec;
        CsdlSchema schema = this.getSchema(fqn.getFullQualifiedNameAsString());
        if (schema != null && (ec = schema.getEntityContainer()) != null && ec.getFunctionImports() != null) {
            for (CsdlFunctionImport es : ec.getFunctionImports()) {
                if (!es.getName().equals(functionImportName)) continue;
                return es;
            }
        }
        return null;
    }

    public CsdlEntityContainerInfo getEntityContainerInfo(FullQualifiedName fqn) throws ODataException {
        CsdlEntityContainer ec;
        CsdlSchema schema = null;
        if (fqn == null) {
            for (CsdlSchema s : this.edmSchemas) {
                if (s.getEntityContainer() == null) continue;
                schema = s;
                break;
            }
        } else {
            schema = this.getSchema(fqn.getFullQualifiedNameAsString());
        }
        if (schema != null && (ec = schema.getEntityContainer()) != null) {
            CsdlEntityContainerInfo info = new CsdlEntityContainerInfo();
            info.setContainerName(new FullQualifiedName(schema.getNamespace()));
            if (schema.getEntityContainer().getExtendsContainer() != null) {
                info.setExtendsContainer(new FullQualifiedName(schema.getEntityContainer().getExtendsContainer()));
            }
            return info;
        }
        return null;
    }

    public List<CsdlAliasInfo> getAliasInfos() throws ODataException {
        CsdlSchema schema = null;
        for (CsdlSchema s : this.edmSchemas) {
            if (s.getEntityContainer() == null) continue;
            schema = s;
            break;
        }
        if (schema == null) {
            schema = this.edmSchemas.get(0);
        }
        CsdlAliasInfo ai = new CsdlAliasInfo();
        ai.setAlias(schema.getAlias());
        ai.setNamespace(schema.getNamespace());
        return Arrays.asList(ai);
    }

    public CsdlEntityContainer getEntityContainer() throws ODataException {
        for (CsdlSchema s : this.edmSchemas) {
            if (s.getEntityContainer() == null) continue;
            return s.getEntityContainer();
        }
        return null;
    }

    public List<CsdlSchema> getSchemas() throws ODataException {
        return new ArrayList<CsdlSchema>(this.edmSchemas);
    }

    public CsdlEntityType getEntityType(FullQualifiedName fqn) throws ODataException {
        CsdlSchema schema = this.getSchema(fqn.getNamespace());
        if (schema != null && schema.getEntityTypes() != null) {
            for (CsdlEntityType type : schema.getEntityTypes()) {
                if (!type.getName().equals(fqn.getName())) continue;
                return type;
            }
        }
        return null;
    }

    public CsdlComplexType getComplexType(FullQualifiedName fqn) throws ODataException {
        CsdlSchema schema = this.getSchema(fqn.getNamespace());
        if (schema != null && schema.getComplexTypes() != null) {
            for (CsdlComplexType type : schema.getComplexTypes()) {
                if (!type.getName().equals(fqn.getName())) continue;
                return type;
            }
        }
        return null;
    }

    public List<CsdlAction> getActions(FullQualifiedName fqn) throws ODataException {
        List types;
        ArrayList<CsdlAction> actions = new ArrayList<CsdlAction>();
        CsdlSchema schema = this.getSchema(fqn.getNamespace());
        if (schema != null && (types = schema.getActions()) != null) {
            for (CsdlAction type : types) {
                if (!type.getName().equals(fqn.getName())) continue;
                actions.add(type);
            }
        }
        return actions;
    }

    public CsdlAnnotations getAnnotationsGroup(FullQualifiedName targetName) throws ODataException {
        return null;
    }

    public CsdlAnnotatable getAnnoatatable(FullQualifiedName annotatedName) throws ODataException {
        return null;
    }
}

