/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.responses;

import java.util.Map;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.ClientServerError;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.ComplexSerializerOptions;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.PrimitiveSerializerOptions;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.ServiceRequest;
import org.apache.olingo.server.core.responses.ServiceResponse;
import org.apache.olingo.server.core.responses.ServiceResponseVisior;

public class PropertyResponse
extends ServiceResponse {
    private PrimitiveSerializerOptions primitiveOptions;
    private ComplexSerializerOptions complexOptions;
    private final ContentType responseContentType;
    private final ODataSerializer serializer;
    private final boolean collection;

    public static PropertyResponse getInstance(ServiceRequest request, ODataResponse response, EdmType edmType, ContextURL contextURL, boolean collection) throws ContentNegotiatorException, SerializerException {
        if (edmType.getKind() == EdmTypeKind.PRIMITIVE) {
            PrimitiveSerializerOptions options = request.getSerializerOptions(PrimitiveSerializerOptions.class, contextURL, false);
            ContentType type = request.getResponseContentType();
            return new PropertyResponse(request.getServiceMetaData(), request.getSerializer(), response, options, type, collection, request.getPreferences());
        }
        ComplexSerializerOptions options = request.getSerializerOptions(ComplexSerializerOptions.class, contextURL, false);
        ContentType type = request.getResponseContentType();
        return new PropertyResponse(request.getServiceMetaData(), request.getSerializer(), response, options, type, collection, request.getPreferences());
    }

    private PropertyResponse(ServiceMetadata metadata, ODataSerializer serializer, ODataResponse response, PrimitiveSerializerOptions options, ContentType contentType, boolean collection, Map<String, String> preferences) {
        super(metadata, response, preferences);
        this.serializer = serializer;
        this.primitiveOptions = options;
        this.responseContentType = contentType;
        this.collection = collection;
    }

    private PropertyResponse(ServiceMetadata metadata, ODataSerializer serializer, ODataResponse response, ComplexSerializerOptions options, ContentType contentType, boolean collection, Map<String, String> preferences) {
        super(metadata, response, preferences);
        this.serializer = serializer;
        this.complexOptions = options;
        this.responseContentType = contentType;
        this.collection = collection;
    }

    public void writeProperty(EdmType edmType, Property property) throws SerializerException {
        assert (!this.isClosed());
        if (property == null) {
            this.writeNotFound(true);
            return;
        }
        if (property.getValue() == null) {
            this.writeNoContent(true);
            return;
        }
        if (edmType.getKind() == EdmTypeKind.PRIMITIVE) {
            this.writePrimitiveProperty((EdmPrimitiveType)edmType, property);
        } else {
            this.writeComplexProperty((EdmComplexType)edmType, property);
        }
    }

    private void writeComplexProperty(EdmComplexType type, Property property) throws SerializerException {
        if (this.collection) {
            this.response.setContent(this.serializer.complexCollection(this.metadata, type, property, this.complexOptions).getContent());
        } else {
            this.response.setContent(this.serializer.complex(this.metadata, type, property, this.complexOptions).getContent());
        }
        this.writeOK(this.responseContentType.toContentTypeString());
        this.close();
    }

    private void writePrimitiveProperty(EdmPrimitiveType type, Property property) throws SerializerException {
        if (this.collection) {
            this.response.setContent(this.serializer.primitiveCollection(type, property, this.primitiveOptions).getContent());
        } else {
            this.response.setContent(this.serializer.primitive(type, property, this.primitiveOptions).getContent());
        }
        this.writeOK(this.responseContentType.toContentTypeString());
        this.close();
    }

    @Override
    public void accepts(ServiceResponseVisior visitor) throws ODataTranslatedException, ODataApplicationException {
        visitor.visit(this);
    }

    public void writePropertyUpdated() {
        this.writeNoContent(true);
    }

    public void writePropertyDeleted() {
        this.writeNoContent(true);
    }

    public void writeError(ClientServerError error) {
        try {
            this.writeContent(this.serializer.error(error).getContent(), error.getStatusCode(), true);
        }
        catch (SerializerException e) {
            this.writeServerError(true);
        }
    }

    public void writeNotModified() {
        this.response.setStatusCode(HttpStatusCode.NOT_MODIFIED.getStatusCode());
        this.close();
    }
}

