/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.requests;

import java.util.List;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.PrimitiveSerializerOptions;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.ServiceHandler;
import org.apache.olingo.server.core.requests.OperationRequest;
import org.apache.olingo.server.core.responses.EntityResponse;
import org.apache.olingo.server.core.responses.EntitySetResponse;
import org.apache.olingo.server.core.responses.PropertyResponse;

public class FunctionRequest
extends OperationRequest {
    private UriResourceFunction uriResourceFunction;

    public FunctionRequest(OData odata, ServiceMetadata serviceMetadata) {
        super(odata, serviceMetadata);
    }

    @Override
    public void execute(ServiceHandler handler, ODataResponse response) throws ODataLibraryException, ODataApplicationException {
        if (!this.allowedMethod()) {
            this.methodNotAllowed();
        }
        if (this.isReturnTypePrimitive() || this.isReturnTypeComplex()) {
            handler.invoke(this, this.getODataRequest().getMethod(), PropertyResponse.getInstance(this, response, this.getReturnType().getType(), this.getContextURL(this.odata), this.isCollection()));
        } else if (this.isCollection()) {
            handler.invoke(this, this.getODataRequest().getMethod(), EntitySetResponse.getInstance(this, this.getContextURL(this.odata), false, response));
        } else {
            handler.invoke(this, this.getODataRequest().getMethod(), EntityResponse.getInstance(this, this.getContextURL(this.odata), false, response));
        }
    }

    @Override
    public boolean allowedMethod() {
        if (this.getFunction().isComposable()) {
            return this.isGET() || this.isPATCH() || this.isDELETE() || this.isPOST() || this.isPUT();
        }
        return this.isGET();
    }

    @Override
    public <T> T getSerializerOptions(Class<T> serilizerOptions, ContextURL contextUrl, boolean references) throws ContentNegotiatorException {
        if (serilizerOptions.isAssignableFrom(PrimitiveSerializerOptions.class)) {
            return (T)PrimitiveSerializerOptions.with().contextURL(contextUrl).nullable(Boolean.valueOf(this.getReturnType().isNullable())).maxLength(this.getReturnType().getMaxLength()).precision(this.getReturnType().getPrecision()).scale(this.getReturnType().getScale()).unicode(null).build();
        }
        return super.getSerializerOptions(serilizerOptions, contextUrl, references);
    }

    public UriResourceFunction getUriResourceFunction() {
        return this.uriResourceFunction;
    }

    public void setUriResourceFunction(UriResourceFunction uriResourceFunction) {
        this.uriResourceFunction = uriResourceFunction;
    }

    @Override
    public boolean isBound() {
        return this.uriResourceFunction.getFunctionImport() != null;
    }

    public EdmFunction getFunction() {
        return this.uriResourceFunction.getFunction();
    }

    public List<UriParameter> getParameters() {
        return this.uriResourceFunction.getParameters();
    }

    @Override
    public boolean isCollection() {
        return this.getFunction().getReturnType().isCollection();
    }

    @Override
    public EdmReturnType getReturnType() {
        return this.getFunction().getReturnType();
    }

    @Override
    public boolean hasReturnType() {
        return true;
    }
}

