/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlActionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlAliasInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotations;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEdmProvider;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainerInfo;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlSingleton;
import org.apache.olingo.commons.api.edm.provider.CsdlTerm;
import org.apache.olingo.commons.api.edm.provider.CsdlTypeDefinition;
import org.apache.olingo.commons.api.edmx.EdmxReference;
import org.apache.olingo.commons.api.edmx.EdmxReferenceInclude;
import org.apache.olingo.commons.api.ex.ODataException;

public class SchemaBasedEdmProvider
implements CsdlEdmProvider {
    private final List<CsdlSchema> edmSchemas = new ArrayList<CsdlSchema>();
    private final Map<String, EdmxReference> references = new ConcurrentHashMap<String, EdmxReference>();
    private final Map<String, SchemaBasedEdmProvider> referenceSchemas = new ConcurrentHashMap<String, SchemaBasedEdmProvider>();
    private final Map<String, SchemaBasedEdmProvider> coreVocabularySchemas = new ConcurrentHashMap<String, SchemaBasedEdmProvider>();

    protected void addSchema(CsdlSchema schema) {
        this.edmSchemas.add(schema);
    }

    public List<EdmxReference> getReferences() {
        return new ArrayList<EdmxReference>(this.references.values());
    }

    protected void addReferenceSchema(String ns, SchemaBasedEdmProvider provider) {
        this.referenceSchemas.put(ns, provider);
    }

    protected void addVocabularySchema(String ns, SchemaBasedEdmProvider provider) {
        this.coreVocabularySchemas.put(ns, provider);
    }

    protected void addReference(EdmxReference reference) {
        for (EdmxReferenceInclude include : reference.getIncludes()) {
            this.references.put(include.getNamespace(), reference);
        }
    }

    CsdlSchema getVocabularySchema(String ns) {
        SchemaBasedEdmProvider provider = this.coreVocabularySchemas.get(ns);
        if (provider != null) {
            return provider.getSchema(ns, false);
        }
        return null;
    }

    CsdlSchema getSchema(String ns) {
        return this.getSchema(ns, true);
    }

    CsdlSchema getSchema(String ns, boolean checkReferences) {
        for (CsdlSchema s : this.edmSchemas) {
            if (!s.getNamespace().equals(ns)) continue;
            return s;
        }
        CsdlSchema s = null;
        if (checkReferences && (s = this.getReferenceSchema(ns)) == null) {
            s = this.getVocabularySchema(ns);
        }
        return s;
    }

    CsdlSchema getReferenceSchema(String ns) {
        if (ns == null) {
            return null;
        }
        if (this.referenceSchemas.get(ns) != null) {
            return this.referenceSchemas.get(ns).getSchema(ns);
        }
        for (SchemaBasedEdmProvider provider : this.referenceSchemas.values()) {
            CsdlSchema schema = provider.getSchema(ns);
            if (schema == null) continue;
            return schema;
        }
        return null;
    }

    public CsdlEnumType getEnumType(FullQualifiedName fqn) throws ODataException {
        List types;
        CsdlSchema schema = this.getSchema(fqn.getNamespace());
        if (schema != null && (types = schema.getEnumTypes()) != null) {
            for (CsdlEnumType type : types) {
                if (!type.getName().equals(fqn.getName())) continue;
                return type;
            }
        }
        return null;
    }

    public CsdlTypeDefinition getTypeDefinition(FullQualifiedName fqn) throws ODataException {
        List types;
        CsdlSchema schema = this.getSchema(fqn.getNamespace());
        if (schema != null && (types = schema.getTypeDefinitions()) != null) {
            for (CsdlTypeDefinition type : types) {
                if (!type.getName().equals(fqn.getName())) continue;
                return type;
            }
        }
        return null;
    }

    public List<CsdlFunction> getFunctions(FullQualifiedName fqn) throws ODataException {
        List functions;
        ArrayList<CsdlFunction> foundFuncs = new ArrayList<CsdlFunction>();
        CsdlSchema schema = this.getSchema(fqn.getNamespace());
        if (schema != null && (functions = schema.getFunctions()) != null) {
            for (CsdlFunction func : functions) {
                if (!func.getName().equals(fqn.getName())) continue;
                foundFuncs.add(func);
            }
        }
        return foundFuncs;
    }

    public CsdlTerm getTerm(FullQualifiedName fqn) throws ODataException {
        List terms;
        CsdlSchema schema = this.getSchema(fqn.getNamespace());
        if (schema != null && (terms = schema.getTerms()) != null) {
            for (CsdlTerm term : terms) {
                if (!term.getName().equals(fqn.getName())) continue;
                return term;
            }
        }
        return null;
    }

    public CsdlEntitySet getEntitySet(FullQualifiedName fqn, String entitySetName) throws ODataException {
        CsdlEntityContainer ec;
        CsdlSchema schema = this.getSchema(fqn.getNamespace());
        if (schema != null && (ec = schema.getEntityContainer()) != null && ec.getEntitySets() != null) {
            for (CsdlEntitySet es : ec.getEntitySets()) {
                if (!es.getName().equals(entitySetName)) continue;
                return es;
            }
        }
        return null;
    }

    public CsdlSingleton getSingleton(FullQualifiedName fqn, String singletonName) throws ODataException {
        CsdlEntityContainer ec;
        CsdlSchema schema = this.getSchema(fqn.getNamespace());
        if (schema != null && (ec = schema.getEntityContainer()) != null && ec.getSingletons() != null) {
            for (CsdlSingleton es : ec.getSingletons()) {
                if (!es.getName().equals(singletonName)) continue;
                return es;
            }
        }
        return null;
    }

    public CsdlActionImport getActionImport(FullQualifiedName fqn, String actionImportName) throws ODataException {
        CsdlEntityContainer ec;
        CsdlSchema schema = this.getSchema(fqn.getNamespace());
        if (schema != null && (ec = schema.getEntityContainer()) != null && ec.getActionImports() != null) {
            for (CsdlActionImport es : ec.getActionImports()) {
                if (!es.getName().equals(actionImportName)) continue;
                return es;
            }
        }
        return null;
    }

    public CsdlFunctionImport getFunctionImport(FullQualifiedName fqn, String functionImportName) throws ODataException {
        CsdlEntityContainer ec;
        CsdlSchema schema = this.getSchema(fqn.getNamespace());
        if (schema != null && (ec = schema.getEntityContainer()) != null && ec.getFunctionImports() != null) {
            for (CsdlFunctionImport es : ec.getFunctionImports()) {
                if (!es.getName().equals(functionImportName)) continue;
                return es;
            }
        }
        return null;
    }

    public CsdlEntityContainerInfo getEntityContainerInfo(FullQualifiedName fqn) throws ODataException {
        CsdlEntityContainer ec;
        CsdlSchema schema = null;
        if (fqn == null) {
            for (CsdlSchema s : this.edmSchemas) {
                if (s.getEntityContainer() == null) continue;
                schema = s;
                break;
            }
        } else {
            schema = this.getSchema(fqn.getNamespace());
        }
        if (schema != null && (ec = schema.getEntityContainer()) != null) {
            CsdlEntityContainerInfo info = new CsdlEntityContainerInfo();
            info.setContainerName(new FullQualifiedName(schema.getNamespace(), ec.getName()));
            if (schema.getEntityContainer().getExtendsContainer() != null) {
                info.setExtendsContainer(new FullQualifiedName(schema.getEntityContainer().getExtendsContainer()));
            }
            return info;
        }
        return null;
    }

    public List<CsdlAliasInfo> getAliasInfos() throws ODataException {
        CsdlAliasInfo ai;
        ArrayList<CsdlAliasInfo> list = new ArrayList<CsdlAliasInfo>();
        for (CsdlSchema s : this.edmSchemas) {
            if (s.getAlias() == null) continue;
            CsdlAliasInfo ai2 = new CsdlAliasInfo();
            ai2.setAlias(s.getAlias());
            ai2.setNamespace(s.getNamespace());
            list.add(ai2);
        }
        for (EdmxReference reference : this.references.values()) {
            for (EdmxReferenceInclude include : reference.getIncludes()) {
                if (include.getAlias() == null) continue;
                ai = new CsdlAliasInfo();
                ai.setAlias(include.getAlias());
                ai.setNamespace(include.getNamespace());
                list.add(ai);
            }
        }
        for (SchemaBasedEdmProvider p : this.coreVocabularySchemas.values()) {
            for (CsdlSchema s : p.getSchemas()) {
                if (s.getAlias() == null) continue;
                ai = new CsdlAliasInfo();
                ai.setAlias(s.getAlias());
                ai.setNamespace(s.getNamespace());
                list.add(ai);
            }
        }
        return list;
    }

    public CsdlEntityContainer getEntityContainer() throws ODataException {
        for (CsdlSchema s : this.edmSchemas) {
            if (s.getEntityContainer() == null) continue;
            return s.getEntityContainer();
        }
        return null;
    }

    public List<CsdlSchema> getSchemas() throws ODataException {
        return new ArrayList<CsdlSchema>(this.edmSchemas);
    }

    public CsdlEntityType getEntityType(FullQualifiedName fqn) throws ODataException {
        CsdlSchema schema = this.getSchema(fqn.getNamespace());
        if (schema != null && schema.getEntityTypes() != null) {
            for (CsdlEntityType type : schema.getEntityTypes()) {
                if (!type.getName().equals(fqn.getName())) continue;
                return type;
            }
        }
        return null;
    }

    public CsdlComplexType getComplexType(FullQualifiedName fqn) throws ODataException {
        CsdlSchema schema = this.getSchema(fqn.getNamespace());
        if (schema != null && schema.getComplexTypes() != null) {
            for (CsdlComplexType type : schema.getComplexTypes()) {
                if (!type.getName().equals(fqn.getName())) continue;
                return type;
            }
        }
        return null;
    }

    public List<CsdlAction> getActions(FullQualifiedName fqn) throws ODataException {
        List types;
        ArrayList<CsdlAction> actions = new ArrayList<CsdlAction>();
        CsdlSchema schema = this.getSchema(fqn.getNamespace());
        if (schema != null && (types = schema.getActions()) != null) {
            for (CsdlAction type : types) {
                if (!type.getName().equals(fqn.getName())) continue;
                actions.add(type);
            }
        }
        return actions;
    }

    public CsdlAnnotations getAnnotationsGroup(FullQualifiedName targetName, String qualifier) throws ODataException {
        CsdlSchema schema = this.getSchema(targetName.getNamespace());
        if (schema != null) {
            return schema.getAnnotationGroup(targetName.getFullQualifiedNameAsString(), qualifier);
        }
        return null;
    }
}

