/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.responses;

import java.util.HashMap;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.core.responses.ServiceResponse;
import org.apache.olingo.server.core.responses.ServiceResponseVisior;

public class ErrorResponse
extends ServiceResponse {
    private ContentType contentType;
    private ODataSerializer serializer;

    public ErrorResponse(ServiceMetadata metadata, ODataSerializer serializer, ContentType contentType, ODataResponse response) {
        super(metadata, response, new HashMap<String, String>());
        this.contentType = contentType;
        this.serializer = serializer;
    }

    @Override
    public void accepts(ServiceResponseVisior visitor) throws ODataLibraryException, ODataApplicationException {
        visitor.visit(this);
    }

    public void writeError(ODataServerError error) {
        try {
            this.writeHeader("Content-Type", this.contentType.getType());
            this.writeContent(this.serializer.error(error).getContent(), error.getStatusCode(), true);
        }
        catch (SerializerException e) {
            this.writeServerError(true);
        }
    }
}

