/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core;

import java.io.InputStream;
import org.apache.olingo.odata2.api.ODataService;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.api.batch.BatchHandler;
import org.apache.olingo.odata2.api.commons.ODataHttpMethod;
import org.apache.olingo.odata2.api.exception.ODataBadRequestException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataMethodNotAllowedException;
import org.apache.olingo.odata2.api.processor.ODataProcessor;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.processor.part.BatchProcessor;
import org.apache.olingo.odata2.api.processor.part.EntityComplexPropertyProcessor;
import org.apache.olingo.odata2.api.processor.part.EntityLinkProcessor;
import org.apache.olingo.odata2.api.processor.part.EntityLinksProcessor;
import org.apache.olingo.odata2.api.processor.part.EntityMediaProcessor;
import org.apache.olingo.odata2.api.processor.part.EntityProcessor;
import org.apache.olingo.odata2.api.processor.part.EntitySetProcessor;
import org.apache.olingo.odata2.api.processor.part.EntitySimplePropertyProcessor;
import org.apache.olingo.odata2.api.processor.part.EntitySimplePropertyValueProcessor;
import org.apache.olingo.odata2.api.processor.part.FunctionImportProcessor;
import org.apache.olingo.odata2.api.processor.part.FunctionImportValueProcessor;
import org.apache.olingo.odata2.api.processor.part.MetadataProcessor;
import org.apache.olingo.odata2.api.processor.part.ServiceDocumentProcessor;
import org.apache.olingo.odata2.api.uri.info.DeleteUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetComplexPropertyUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityLinkCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityLinkUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetLinksCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetLinksUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetFunctionImportUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetMediaResourceUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetMetadataUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetServiceDocumentUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetSimplePropertyUriInfo;
import org.apache.olingo.odata2.api.uri.info.PostUriInfo;
import org.apache.olingo.odata2.api.uri.info.PutMergePatchUriInfo;
import org.apache.olingo.odata2.core.batch.BatchHandlerImpl;
import org.apache.olingo.odata2.core.exception.ODataRuntimeException;
import org.apache.olingo.odata2.core.uri.UriInfoImpl;

public class Dispatcher {
    private final ODataService service;
    private final ODataServiceFactory serviceFactory;

    public Dispatcher(ODataServiceFactory serviceFactory, ODataService service) {
        this.service = service;
        this.serviceFactory = serviceFactory;
    }

    public ODataResponse dispatch(ODataHttpMethod method, UriInfoImpl uriInfo, InputStream content, String requestContentType, String contentType) throws ODataException {
        switch (uriInfo.getUriType()) {
            case URI0: {
                if (method == ODataHttpMethod.GET) {
                    return this.service.getServiceDocumentProcessor().readServiceDocument((GetServiceDocumentUriInfo)uriInfo, contentType);
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI1: 
            case URI6B: {
                switch (method) {
                    case GET: {
                        return this.service.getEntitySetProcessor().readEntitySet((GetEntitySetUriInfo)uriInfo, contentType);
                    }
                    case POST: {
                        return this.service.getEntitySetProcessor().createEntity((PostUriInfo)uriInfo, content, requestContentType, contentType);
                    }
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI2: {
                switch (method) {
                    case GET: {
                        return this.service.getEntityProcessor().readEntity((GetEntityUriInfo)uriInfo, contentType);
                    }
                    case PUT: {
                        return this.service.getEntityProcessor().updateEntity((PutMergePatchUriInfo)uriInfo, content, requestContentType, false, contentType);
                    }
                    case PATCH: 
                    case MERGE: {
                        return this.service.getEntityProcessor().updateEntity((PutMergePatchUriInfo)uriInfo, content, requestContentType, true, contentType);
                    }
                    case DELETE: {
                        return this.service.getEntityProcessor().deleteEntity((DeleteUriInfo)uriInfo, contentType);
                    }
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI3: {
                switch (method) {
                    case GET: {
                        return this.service.getEntityComplexPropertyProcessor().readEntityComplexProperty((GetComplexPropertyUriInfo)uriInfo, contentType);
                    }
                    case PUT: {
                        return this.service.getEntityComplexPropertyProcessor().updateEntityComplexProperty((PutMergePatchUriInfo)uriInfo, content, requestContentType, false, contentType);
                    }
                    case PATCH: 
                    case MERGE: {
                        return this.service.getEntityComplexPropertyProcessor().updateEntityComplexProperty((PutMergePatchUriInfo)uriInfo, content, requestContentType, true, contentType);
                    }
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI4: 
            case URI5: {
                switch (method) {
                    case GET: {
                        if (uriInfo.isValue()) {
                            return this.service.getEntitySimplePropertyValueProcessor().readEntitySimplePropertyValue((GetSimplePropertyUriInfo)uriInfo, contentType);
                        }
                        return this.service.getEntitySimplePropertyProcessor().readEntitySimpleProperty((GetSimplePropertyUriInfo)uriInfo, contentType);
                    }
                    case PUT: 
                    case PATCH: 
                    case MERGE: {
                        if (uriInfo.isValue()) {
                            return this.service.getEntitySimplePropertyValueProcessor().updateEntitySimplePropertyValue((PutMergePatchUriInfo)uriInfo, content, requestContentType, contentType);
                        }
                        return this.service.getEntitySimplePropertyProcessor().updateEntitySimpleProperty((PutMergePatchUriInfo)uriInfo, content, requestContentType, contentType);
                    }
                    case DELETE: {
                        if (uriInfo.isValue()) {
                            return this.service.getEntitySimplePropertyValueProcessor().deleteEntitySimplePropertyValue((DeleteUriInfo)uriInfo, contentType);
                        }
                        throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
                    }
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI6A: {
                switch (method) {
                    case GET: {
                        return this.service.getEntityProcessor().readEntity((GetEntityUriInfo)uriInfo, contentType);
                    }
                    case PUT: 
                    case PATCH: 
                    case MERGE: 
                    case DELETE: {
                        throw new ODataBadRequestException(ODataBadRequestException.NOTSUPPORTED);
                    }
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI7A: {
                switch (method) {
                    case GET: {
                        return this.service.getEntityLinkProcessor().readEntityLink((GetEntityLinkUriInfo)uriInfo, contentType);
                    }
                    case PUT: 
                    case PATCH: 
                    case MERGE: {
                        return this.service.getEntityLinkProcessor().updateEntityLink((PutMergePatchUriInfo)uriInfo, content, requestContentType, contentType);
                    }
                    case DELETE: {
                        return this.service.getEntityLinkProcessor().deleteEntityLink((DeleteUriInfo)uriInfo, contentType);
                    }
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI7B: {
                switch (method) {
                    case GET: {
                        return this.service.getEntityLinksProcessor().readEntityLinks((GetEntitySetLinksUriInfo)uriInfo, contentType);
                    }
                    case POST: {
                        return this.service.getEntityLinksProcessor().createEntityLink((PostUriInfo)uriInfo, content, requestContentType, contentType);
                    }
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI8: {
                if (method == ODataHttpMethod.GET) {
                    return this.service.getMetadataProcessor().readMetadata((GetMetadataUriInfo)uriInfo, contentType);
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI9: {
                if (method == ODataHttpMethod.POST) {
                    BatchHandlerImpl handler = new BatchHandlerImpl(this.serviceFactory, this.service);
                    return this.service.getBatchProcessor().executeBatch((BatchHandler)handler, requestContentType, content);
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI10: 
            case URI10a: 
            case URI11: 
            case URI12: 
            case URI13: {
                return this.service.getFunctionImportProcessor().executeFunctionImport((GetFunctionImportUriInfo)uriInfo, contentType);
            }
            case URI14: {
                if (uriInfo.isValue()) {
                    return this.service.getFunctionImportValueProcessor().executeFunctionImportValue((GetFunctionImportUriInfo)uriInfo, contentType);
                }
                return this.service.getFunctionImportProcessor().executeFunctionImport((GetFunctionImportUriInfo)uriInfo, contentType);
            }
            case URI15: {
                if (method == ODataHttpMethod.GET) {
                    return this.service.getEntitySetProcessor().countEntitySet((GetEntitySetCountUriInfo)uriInfo, contentType);
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI16: {
                if (method == ODataHttpMethod.GET) {
                    return this.service.getEntityProcessor().existsEntity((GetEntityCountUriInfo)uriInfo, contentType);
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI17: {
                switch (method) {
                    case GET: {
                        return this.service.getEntityMediaProcessor().readEntityMedia((GetMediaResourceUriInfo)uriInfo, contentType);
                    }
                    case PUT: {
                        return this.service.getEntityMediaProcessor().updateEntityMedia((PutMergePatchUriInfo)uriInfo, content, requestContentType, contentType);
                    }
                    case DELETE: {
                        return this.service.getEntityMediaProcessor().deleteEntityMedia((DeleteUriInfo)uriInfo, contentType);
                    }
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI50A: {
                if (method == ODataHttpMethod.GET) {
                    return this.service.getEntityLinkProcessor().existsEntityLink((GetEntityLinkCountUriInfo)uriInfo, contentType);
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
            case URI50B: {
                if (method == ODataHttpMethod.GET) {
                    return this.service.getEntityLinksProcessor().countEntityLinks((GetEntitySetLinksCountUriInfo)uriInfo, contentType);
                }
                throw new ODataMethodNotAllowedException(ODataMethodNotAllowedException.DISPATCH);
            }
        }
        throw new ODataRuntimeException("Unknown or not implemented URI type: " + (Object)((Object)uriInfo.getUriType()));
    }

    protected static Class<? extends ODataProcessor> mapUriTypeToProcessorFeature(UriInfoImpl uriInfo) {
        Class<ServiceDocumentProcessor> feature;
        switch (uriInfo.getUriType()) {
            case URI0: {
                feature = ServiceDocumentProcessor.class;
                break;
            }
            case URI1: 
            case URI6B: 
            case URI15: {
                feature = EntitySetProcessor.class;
                break;
            }
            case URI2: 
            case URI6A: 
            case URI16: {
                feature = EntityProcessor.class;
                break;
            }
            case URI3: {
                feature = EntityComplexPropertyProcessor.class;
                break;
            }
            case URI4: 
            case URI5: {
                feature = uriInfo.isValue() ? EntitySimplePropertyValueProcessor.class : EntitySimplePropertyProcessor.class;
                break;
            }
            case URI7A: 
            case URI50A: {
                feature = EntityLinkProcessor.class;
                break;
            }
            case URI7B: 
            case URI50B: {
                feature = EntityLinksProcessor.class;
                break;
            }
            case URI8: {
                feature = MetadataProcessor.class;
                break;
            }
            case URI9: {
                feature = BatchProcessor.class;
                break;
            }
            case URI10: 
            case URI10a: 
            case URI11: 
            case URI12: 
            case URI13: {
                feature = FunctionImportProcessor.class;
                break;
            }
            case URI14: {
                feature = uriInfo.isValue() ? FunctionImportValueProcessor.class : FunctionImportProcessor.class;
                break;
            }
            case URI17: {
                feature = EntityMediaProcessor.class;
                break;
            }
            default: {
                throw new ODataRuntimeException("Unknown or not implemented URI type: " + (Object)((Object)uriInfo.getUriType()));
            }
        }
        return feature;
    }
}

