/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.batch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.UUID;
import org.apache.olingo.odata2.api.client.batch.BatchChangeSetPart;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.exception.ODataRuntimeException;

public class BatchHelper {
    public static final String BINARY_ENCODING = "binary";
    public static final String DEFAULT_ENCODING = "utf-8";
    public static final String HTTP_CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static final String HTTP_CONTENT_ID = "Content-Id";
    public static final String MIME_HEADER_CONTENT_ID = "MimeHeader-ContentId";
    public static final String REQUEST_HEADER_CONTENT_ID = "RequestHeader-ContentId";
    public static final Charset DEFAULT_CHARSET = Charset.forName("utf-8");

    protected static String generateBoundary(String value) {
        return value + "_" + UUID.randomUUID().toString();
    }

    protected static byte[] getBytes(String body) {
        try {
            return body.getBytes(DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new ODataRuntimeException(e);
        }
    }

    public static Charset extractCharset(Map<String, String> headers) {
        String contentType = null;
        for (Map.Entry<String, String> s : headers.entrySet()) {
            if (!s.getKey().equalsIgnoreCase("Content-Type")) continue;
            contentType = s.getValue();
            break;
        }
        return BatchHelper.getCharset(contentType);
    }

    public static Charset extractCharset(String contentType) {
        if (contentType == null) {
            return DEFAULT_CHARSET;
        }
        return BatchHelper.getCharset(contentType);
    }

    private static Charset getCharset(String contentType) {
        String charsetString;
        ContentType ct = ContentType.parse(contentType);
        if (ct != null && (charsetString = ct.getParameters().get("charset")) != null && Charset.isSupported(charsetString)) {
            return Charset.forName(charsetString);
        }
        return DEFAULT_CHARSET;
    }

    static class Body {
        private static final int BUFFER_SIZE = 8192;
        public static final byte[] EMPTY_BYTES = new byte[0];
        private final byte[] content;

        public Body(BatchChangeSetPart response) {
            this.content = this.getBody(response);
        }

        public Body(ODataResponse response) {
            this.content = this.getBody(response);
        }

        public Body() {
            this.content = EMPTY_BYTES;
        }

        public int getLength() {
            return this.content.length;
        }

        public byte[] getContent() {
            return this.content;
        }

        public boolean isEmpty() {
            return this.content.length == 0;
        }

        private byte[] getBody(BatchChangeSetPart response) {
            if (response == null || response.getBodyAsBytes() == null) {
                return EMPTY_BYTES;
            }
            return response.getBodyAsBytes();
        }

        private byte[] getBody(ODataResponse response) {
            if (response == null) {
                return EMPTY_BYTES;
            }
            Object entity = response.getEntity();
            if (entity == null) {
                return EMPTY_BYTES;
            }
            if (entity instanceof InputStream) {
                try {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    ByteBuffer inBuffer = ByteBuffer.allocate(8192);
                    ReadableByteChannel ic = Channels.newChannel((InputStream)entity);
                    WritableByteChannel oc = Channels.newChannel(output);
                    while (ic.read(inBuffer) > 0) {
                        inBuffer.flip();
                        oc.write(inBuffer);
                        inBuffer.rewind();
                    }
                    return output.toByteArray();
                }
                catch (IOException e) {
                    throw new ODataRuntimeException("Error on reading request content");
                }
            }
            if (entity instanceof String) {
                return ((String)entity).getBytes(DEFAULT_CHARSET);
            }
            throw new ODataRuntimeException("Error on reading request content for entity type:" + entity.getClass());
        }
    }

    static class BodyBuilder {
        public static final int DEFAULT_SIZE = 8192;
        private final Charset CHARSET_ISO_8859_1 = Charset.forName("iso-8859-1");
        private ByteBuffer buffer = ByteBuffer.allocate(8192);
        private boolean isClosed = false;

        BodyBuilder() {
        }

        public byte[] getContent() {
            this.isClosed = true;
            byte[] tmp = new byte[this.buffer.position()];
            this.buffer.flip();
            this.buffer.get(tmp, 0, this.buffer.limit());
            return tmp;
        }

        public InputStream getContentAsStream() {
            return new ByteArrayInputStream(this.getContent());
        }

        public String getContentAsString(Charset charset) {
            return new String(this.getContent(), charset);
        }

        public int getLength() {
            return this.buffer.limit() > this.buffer.position() ? this.buffer.limit() : this.buffer.position();
        }

        public BodyBuilder append(String string) {
            byte[] b = string.getBytes(this.CHARSET_ISO_8859_1);
            this.put(b);
            return this;
        }

        private void put(byte[] b) {
            if (this.isClosed) {
                throw new RuntimeException("BodyBuilder is closed.");
            }
            if (this.buffer.remaining() < b.length) {
                this.buffer.flip();
                int newSize = this.buffer.limit() * 2 + b.length;
                ByteBuffer tmp = ByteBuffer.allocate(newSize);
                tmp.put(this.buffer);
                this.buffer = tmp;
            }
            this.buffer.put(b);
        }

        public BodyBuilder append(int statusCode) {
            return this.append(String.valueOf(statusCode));
        }

        public BodyBuilder append(Body body) {
            this.put(body.getContent());
            return this;
        }

        public String toString() {
            return new String(this.buffer.array(), 0, this.buffer.position());
        }
    }
}

