/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.debug;

import java.io.IOException;
import java.io.Writer;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.uri.ExpandSelectTreeNode;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.expression.BinaryExpression;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.expression.ExceptionVisitExpression;
import org.apache.olingo.odata2.api.uri.expression.ExpressionKind;
import org.apache.olingo.odata2.api.uri.expression.ExpressionParserException;
import org.apache.olingo.odata2.api.uri.expression.ExpressionVisitor;
import org.apache.olingo.odata2.api.uri.expression.FilterExpression;
import org.apache.olingo.odata2.api.uri.expression.MemberExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderByExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderExpression;
import org.apache.olingo.odata2.api.uri.expression.UnaryExpression;
import org.apache.olingo.odata2.core.debug.DebugInfo;
import org.apache.olingo.odata2.core.ep.util.JsonStreamWriter;
import org.apache.olingo.odata2.core.uri.ExpandSelectTreeCreator;
import org.apache.olingo.odata2.core.uri.ExpandSelectTreeNodeImpl;
import org.apache.olingo.odata2.core.uri.expression.JsonVisitor;

public class DebugInfoUri
implements DebugInfo {
    private final UriInfo uriInfo;
    private final FilterExpression filter;
    private final OrderByExpression orderBy;
    private final ExpandSelectTreeNodeImpl expandSelectTree;
    private final ExpressionParserException exception;

    public DebugInfoUri(UriInfo uriInfo, ExpressionParserException exception) {
        this.uriInfo = uriInfo;
        this.filter = uriInfo == null ? null : uriInfo.getFilter();
        this.orderBy = uriInfo == null ? null : uriInfo.getOrderBy();
        this.expandSelectTree = uriInfo == null ? null : this.getExpandSelect();
        this.exception = exception;
    }

    private ExpandSelectTreeNodeImpl getExpandSelect() {
        try {
            return this.uriInfo.getExpand().isEmpty() && this.uriInfo.getSelect().isEmpty() ? null : new ExpandSelectTreeCreator(this.uriInfo.getSelect(), this.uriInfo.getExpand()).create();
        }
        catch (EdmException e) {
            return null;
        }
    }

    @Override
    public String getName() {
        return "URI";
    }

    @Override
    public void appendJson(JsonStreamWriter jsonStreamWriter) throws IOException {
        jsonStreamWriter.beginObject();
        if (this.exception != null && this.exception.getFilterTree() != null) {
            jsonStreamWriter.name("error").beginObject().namedStringValue("expression", this.exception.getFilterTree().getUriLiteral()).endObject();
            if (this.filter != null || this.orderBy != null || this.expandSelectTree != null) {
                jsonStreamWriter.separator();
            }
        }
        if (this.filter != null) {
            String filterString;
            try {
                filterString = (String)this.filter.accept((ExpressionVisitor)new JsonVisitor());
            }
            catch (ExceptionVisitExpression e) {
                filterString = null;
            }
            catch (ODataApplicationException e) {
                filterString = null;
            }
            jsonStreamWriter.name("filter").unquotedValue(filterString);
            if (this.orderBy != null || this.expandSelectTree != null) {
                jsonStreamWriter.separator();
            }
        }
        if (this.orderBy != null) {
            String orderByString;
            try {
                orderByString = (String)this.orderBy.accept((ExpressionVisitor)new JsonVisitor());
            }
            catch (ExceptionVisitExpression e) {
                orderByString = null;
            }
            catch (ODataApplicationException e) {
                orderByString = null;
            }
            jsonStreamWriter.name("orderby").unquotedValue(orderByString);
            if (this.expandSelectTree != null) {
                jsonStreamWriter.separator();
            }
        }
        if (this.expandSelectTree != null) {
            jsonStreamWriter.name("expandSelect").unquotedValue(this.expandSelectTree.toJsonString());
        }
        jsonStreamWriter.endObject();
    }

    @Override
    public void appendHtml(Writer writer) throws IOException {
        if (this.exception != null && this.exception.getFilterTree() != null) {
            writer.append("<h2>Expression Information</h2>\n").append("<pre class=\"code\">").append(this.exception.getFilterTree().getUriLiteral()).append("</pre>\n");
        }
        if (this.filter != null) {
            writer.append("<h2>Filter</h2>\n").append("<ul class=\"expr\"><li>");
            this.appendExpression(this.filter.getExpression(), writer);
            writer.append("</li></ul>\n");
        }
        if (this.orderBy != null) {
            writer.append("<h2>Orderby</h2>\n").append(this.orderBy.getOrdersCount() == 1 ? "<ul" : "<ol").append(" class=\"expr\">\n");
            for (OrderExpression order : this.orderBy.getOrders()) {
                writer.append("<li>");
                this.appendExpression(order.getExpression(), writer);
                ExpressionKind kind = order.getExpression().getKind();
                if (kind == ExpressionKind.PROPERTY || kind == ExpressionKind.LITERAL) {
                    writer.append("<br />");
                }
                writer.append("<span class=\"order\">").append(order.getSortOrder().toString()).append("</span></li>\n");
            }
            writer.append(this.orderBy.getOrdersCount() == 1 ? "</ul" : "</ol").append(">\n");
        }
        if (this.expandSelectTree != null) {
            writer.append("<h2>Expand/Select</h2>\n");
            this.appendExpandSelect(this.expandSelectTree, writer);
        }
    }

    private void appendExpression(CommonExpression expression, Writer writer) throws IOException {
        ExpressionKind kind = expression.getKind();
        writer.append("<span class=\"kind\">").append(kind.toString()).append("</span> <span class=\"literal\">").append(kind == ExpressionKind.MEMBER ? ((MemberExpression)expression).getProperty().getUriLiteral() : expression.getUriLiteral()).append("</span>, type <span class=\"type\">").append(expression.getEdmType().toString()).append("</span>");
        if (kind == ExpressionKind.UNARY) {
            writer.append("<ul class=\"expr\"><li>");
            this.appendExpression(((UnaryExpression)expression).getOperand(), writer);
            writer.append("</li></ul>");
        } else if (kind == ExpressionKind.BINARY) {
            writer.append("<ol class=\"expr\"><li>");
            this.appendExpression(((BinaryExpression)expression).getLeftOperand(), writer);
            writer.append("</li><li>");
            this.appendExpression(((BinaryExpression)expression).getRightOperand(), writer);
            writer.append("</li></ol>");
        } else if (kind == ExpressionKind.METHOD) {
            MethodExpression methodExpression = (MethodExpression)expression;
            if (methodExpression.getParameterCount() > 0) {
                writer.append("<ol class=\"expr\">");
                for (CommonExpression parameter : methodExpression.getParameters()) {
                    writer.append("<li>");
                    this.appendExpression(parameter, writer);
                    writer.append("</li>");
                }
                writer.append("</ol>");
            }
        } else if (kind == ExpressionKind.MEMBER) {
            writer.append("<ul class=\"expr\"><li>");
            this.appendExpression(((MemberExpression)expression).getPath(), writer);
            writer.append("</li></ul>");
        }
    }

    private void appendExpandSelect(ExpandSelectTreeNode expandSelect, Writer writer) throws IOException {
        writer.append("<ul class=\"expand\">\n").append("<li>");
        if (expandSelect.isAll()) {
            writer.append("all properties");
        } else {
            for (EdmProperty property : expandSelect.getProperties()) {
                try {
                    writer.append("property <span class=\"prop\">").append(property.getName()).append("</span><br />");
                }
                catch (EdmException e) {}
            }
        }
        writer.append("</li>\n");
        if (!expandSelect.getLinks().isEmpty()) {
            for (String name : expandSelect.getLinks().keySet()) {
                writer.append("<li>link <span class=\"link\">").append(name).append("</span>");
                ExpandSelectTreeNode link = (ExpandSelectTreeNode)expandSelect.getLinks().get(name);
                if (link != null) {
                    writer.append('\n');
                    this.appendExpandSelect(link, writer);
                }
                writer.append("</li>\n");
            }
        }
        writer.append("</ul>\n");
    }
}

