/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;
import org.apache.olingo.odata2.core.edm.EdmDateTime;

public class EdmTime
extends AbstractSimpleType {
    private static final Pattern PATTERN = Pattern.compile("PT(?:(\\p{Digit}{1,2})H)?(?:(\\p{Digit}{1,4})M)?(?:(\\p{Digit}{1,5})(?:\\.(\\p{Digit}+?)0*)?S)?");
    private static final EdmTime instance = new EdmTime();

    public static EdmTime getInstance() {
        return instance;
    }

    public Class<?> getDefaultType() {
        return Calendar.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected <T> T internalValueOfString(String value, EdmLiteralKind literalKind, EdmFacets facets, Class<T> returnType) throws EdmSimpleTypeException {
        Calendar valueCalendar;
        if (literalKind == EdmLiteralKind.URI) {
            if (value.length() <= 6 || !value.startsWith("time'") || !value.endsWith("'")) throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(new Object[]{value}));
            valueCalendar = this.parseLiteral(value.substring(5, value.length() - 1), facets);
        } else {
            valueCalendar = this.parseLiteral(value, facets);
        }
        if (returnType.isAssignableFrom(Calendar.class)) {
            return returnType.cast(valueCalendar);
        }
        if (returnType.isAssignableFrom(Long.class)) {
            return returnType.cast(valueCalendar.getTimeInMillis());
        }
        if (!returnType.isAssignableFrom(Date.class)) throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(new Object[]{returnType}));
        return returnType.cast(valueCalendar.getTime());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Calendar parseLiteral(String literal, EdmFacets facets) throws EdmSimpleTypeException {
        Matcher matcher = PATTERN.matcher(literal);
        if (!matcher.matches() || matcher.group(1) == null && matcher.group(2) == null && matcher.group(3) == null) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(new Object[]{literal}));
        }
        Calendar dateTimeValue = Calendar.getInstance();
        dateTimeValue.clear();
        dateTimeValue.set(11, matcher.group(1) == null ? 0 : Integer.parseInt(matcher.group(1)));
        dateTimeValue.set(12, matcher.group(2) == null ? 0 : Integer.parseInt(matcher.group(2)));
        dateTimeValue.set(13, matcher.group(3) == null ? 0 : Integer.parseInt(matcher.group(3)));
        if (matcher.group(4) != null) {
            if (facets != null && facets.getPrecision() != null && facets.getPrecision() < matcher.group(4).length()) throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_FACETS_NOT_MATCHED.addContent(new Object[]{literal, facets}));
            if (matcher.group(4).length() > 3) throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(new Object[]{literal}));
            dateTimeValue.set(14, Short.parseShort(matcher.group(4) + "000".substring(0, 3 - matcher.group(4).length())));
        }
        if (dateTimeValue.get(6) != 1) throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(new Object[]{literal}));
        return dateTimeValue;
    }

    @Override
    protected <T> String internalValueToString(T value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        Calendar dateTimeValue;
        if (value instanceof Date) {
            dateTimeValue = Calendar.getInstance();
            dateTimeValue.clear();
            dateTimeValue.setTime((Date)value);
        } else if (value instanceof Calendar) {
            dateTimeValue = (Calendar)((Calendar)value).clone();
        } else if (value instanceof Long) {
            dateTimeValue = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            dateTimeValue.clear();
            dateTimeValue.setTimeInMillis((Long)value);
        } else {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(new Object[]{value.getClass()}));
        }
        StringBuilder result = new StringBuilder(15);
        result.append('P');
        result.append('T');
        result.append(dateTimeValue.get(11));
        result.append('H');
        result.append(dateTimeValue.get(12));
        result.append('M');
        result.append(dateTimeValue.get(13));
        try {
            EdmDateTime.appendMilliseconds(result, dateTimeValue.get(14), facets);
        }
        catch (IllegalArgumentException e) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_FACETS_NOT_MATCHED.addContent(new Object[]{value, facets}), (Throwable)e);
        }
        result.append('S');
        return result.toString();
    }

    @Override
    public String toUriLiteral(String literal) {
        return "time'" + literal + "'";
    }
}

