/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.producer;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.odata2.api.ODataCallback;
import org.apache.olingo.odata2.api.edm.EdmCustomizableFeedMappings;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.api.ep.callback.OnWriteEntryContent;
import org.apache.olingo.odata2.api.ep.callback.OnWriteFeedContent;
import org.apache.olingo.odata2.api.ep.callback.WriteEntryCallbackContext;
import org.apache.olingo.odata2.api.ep.callback.WriteEntryCallbackResult;
import org.apache.olingo.odata2.api.ep.callback.WriteFeedCallbackContext;
import org.apache.olingo.odata2.api.ep.callback.WriteFeedCallbackResult;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.uri.ExpandSelectTreeNode;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.commons.Encoder;
import org.apache.olingo.odata2.core.edm.EdmDateTimeOffset;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.aggregator.EntityPropertyInfo;
import org.apache.olingo.odata2.core.ep.producer.AtomFeedProducer;
import org.apache.olingo.odata2.core.ep.producer.XmlPropertyEntityProducer;

public class AtomEntryEntityProducer {
    private String etag;
    private String location;
    private final EntityProviderWriteProperties properties;

    public AtomEntryEntityProducer(EntityProviderWriteProperties properties) throws EntityProviderException {
        this.properties = properties == null ? EntityProviderWriteProperties.serviceRoot(null).build() : properties;
    }

    public void append(XMLStreamWriter writer, EntityInfoAggregator eia, Map<String, Object> data, boolean isRootElement, boolean isFeedPart) throws EntityProviderException {
        try {
            writer.writeStartElement("entry");
            if (isRootElement) {
                writer.writeDefaultNamespace("http://www.w3.org/2005/Atom");
                writer.writeNamespace("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata");
                writer.writeNamespace("d", "http://schemas.microsoft.com/ado/2007/08/dataservices");
            }
            if (!isFeedPart) {
                writer.writeAttribute("xml", "http://www.w3.org/XML/1998/namespace", "base", this.properties.getServiceRoot().toASCIIString());
            }
            if (!this.properties.isContentOnly() && !this.properties.isOmitETag()) {
                this.etag = AtomEntryEntityProducer.createETag(eia, data);
                if (this.etag != null) {
                    writer.writeAttribute("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "etag", this.etag);
                }
            }
            String selfLink = null;
            if (!this.properties.isContentOnly()) {
                selfLink = AtomEntryEntityProducer.createSelfLink(eia, data, null);
                this.appendAtomMandatoryParts(writer, eia, data, selfLink);
                this.appendAtomOptionalParts(writer, eia, data);
            }
            if (eia.getEntityType().hasStream()) {
                if (!this.properties.isContentOnly()) {
                    this.appendAtomEditLink(writer, eia, data, selfLink);
                    this.appendAtomContentLink(writer, eia, data, selfLink);
                    this.appendAtomNavigationLinks(writer, eia, data);
                } else {
                    this.appendAdditinalLinks(writer, eia, data);
                }
                this.appendCustomProperties(writer, eia, data);
                if (!this.properties.isContentOnly()) {
                    this.appendAtomContentPart(writer, eia, data, selfLink);
                }
                this.appendProperties(writer, eia, data);
            } else {
                if (!this.properties.isContentOnly()) {
                    this.appendAtomEditLink(writer, eia, data, selfLink);
                    this.appendAtomNavigationLinks(writer, eia, data);
                } else {
                    this.appendAdditinalLinks(writer, eia, data);
                }
                this.appendCustomProperties(writer, eia, data);
                writer.writeStartElement("content");
                writer.writeAttribute("type", ContentType.APPLICATION_XML.toString());
                this.appendProperties(writer, eia, data);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
        catch (EdmException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private void appendAdditinalLinks(XMLStreamWriter writer, EntityInfoAggregator eia, Map<String, Object> data) throws EntityProviderException, EdmException, URISyntaxException {
        Map links = this.properties.getAdditionalLinks();
        if (links != null && !links.isEmpty()) {
            for (Map.Entry entry : links.entrySet()) {
                boolean isFeed;
                Map navigationKeyMap = (Map)entry.getValue();
                boolean bl = isFeed = eia.getNavigationPropertyInfo((String)entry.getKey()).getMultiplicity() == EdmMultiplicity.MANY;
                if (navigationKeyMap == null || navigationKeyMap.isEmpty()) continue;
                EntityInfoAggregator targetEntityInfo = EntityInfoAggregator.create(eia.getEntitySet().getRelatedEntitySet((EdmNavigationProperty)eia.getEntityType().getProperty((String)entry.getKey())));
                this.appendAtomNavigationLink(writer, AtomEntryEntityProducer.createSelfLink(targetEntityInfo, navigationKeyMap, null), (String)entry.getKey(), isFeed, eia, data);
            }
        }
    }

    private void appendCustomProperties(XMLStreamWriter writer, EntityInfoAggregator eia, Map<String, Object> data) throws EntityProviderException {
        List<String> noneSyndicationTargetPaths = eia.getNoneSyndicationTargetPathNames();
        for (String tpName : noneSyndicationTargetPaths) {
            EntityPropertyInfo info = eia.getTargetPathInfo(tpName);
            String name = info.getName();
            XmlPropertyEntityProducer aps = new XmlPropertyEntityProducer(this.properties.isIncludeSimplePropertyType());
            aps.appendCustomProperty(writer, name, info, data.get(name));
        }
    }

    protected static String createETag(EntityInfoAggregator eia, Map<String, Object> data) throws EntityProviderException {
        try {
            String etag = null;
            Collection<EntityPropertyInfo> propertyInfos = eia.getETagPropertyInfos();
            for (EntityPropertyInfo propertyInfo : propertyInfos) {
                EdmType edmType = propertyInfo.getType();
                if (!(edmType instanceof EdmSimpleType)) continue;
                EdmSimpleType edmSimpleType = (EdmSimpleType)edmType;
                if (etag == null) {
                    etag = edmSimpleType.valueToString(data.get(propertyInfo.getName()), EdmLiteralKind.DEFAULT, propertyInfo.getFacets());
                    continue;
                }
                etag = etag + "." + edmSimpleType.valueToString(data.get(propertyInfo.getName()), EdmLiteralKind.DEFAULT, propertyInfo.getFacets());
            }
            if (etag != null) {
                etag = "W/\"" + etag + "\"";
            }
            return etag;
        }
        catch (EdmSimpleTypeException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private void appendAtomNavigationLinks(XMLStreamWriter writer, EntityInfoAggregator eia, Map<String, Object> data) throws EntityProviderException, EdmException, URISyntaxException {
        for (String name : eia.getSelectedNavigationPropertyNames()) {
            Map key;
            boolean isFeed = eia.getNavigationPropertyInfo(name).getMultiplicity() == EdmMultiplicity.MANY;
            Map links = this.properties.getAdditionalLinks();
            Map map = key = links == null ? null : (Map)links.get(name);
            if (key == null || key.isEmpty()) {
                this.appendAtomNavigationLink(writer, AtomEntryEntityProducer.createSelfLink(eia, data, name), name, isFeed, eia, data);
                continue;
            }
            EntityInfoAggregator targetEntityInfo = EntityInfoAggregator.create(eia.getEntitySet().getRelatedEntitySet((EdmNavigationProperty)eia.getEntityType().getProperty(name)));
            this.appendAtomNavigationLink(writer, AtomEntryEntityProducer.createSelfLink(targetEntityInfo, key, null), name, isFeed, eia, data);
        }
    }

    private void appendAtomNavigationLink(XMLStreamWriter writer, String target, String navigationPropertyName, boolean isFeed, EntityInfoAggregator eia, Map<String, Object> data) throws EntityProviderException, EdmException, URISyntaxException {
        try {
            writer.writeStartElement("link");
            writer.writeAttribute("href", target);
            writer.writeAttribute("rel", "http://schemas.microsoft.com/ado/2007/08/dataservices/related/" + navigationPropertyName);
            writer.writeAttribute("title", navigationPropertyName);
            if (isFeed) {
                writer.writeAttribute("type", ContentType.APPLICATION_ATOM_XML_FEED.toString());
                this.appendInlineFeed(writer, navigationPropertyName, eia, data, target);
            } else {
                writer.writeAttribute("type", ContentType.APPLICATION_ATOM_XML_ENTRY.toString());
                this.appendInlineEntry(writer, navigationPropertyName, eia, data);
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private void appendInlineFeed(XMLStreamWriter writer, String navigationPropertyName, EntityInfoAggregator eia, Map<String, Object> data, String self) throws EntityProviderException, XMLStreamException, EdmException, URISyntaxException {
        if (eia.getExpandedNavigationPropertyNames().contains(navigationPropertyName) && this.properties.getCallbacks() != null && this.properties.getCallbacks().containsKey(navigationPropertyName)) {
            writer.writeStartElement("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "inline");
            EdmNavigationProperty navProp = (EdmNavigationProperty)eia.getEntityType().getProperty(navigationPropertyName);
            WriteFeedCallbackContext context = new WriteFeedCallbackContext();
            context.setSourceEntitySet(eia.getEntitySet());
            context.setNavigationProperty(navProp);
            context.setEntryData(data);
            ExpandSelectTreeNode subNode = (ExpandSelectTreeNode)this.properties.getExpandSelectTree().getLinks().get(navigationPropertyName);
            context.setCurrentExpandSelectTreeNode(subNode);
            context.setSelfLink(new URI(self));
            ODataCallback callback = (ODataCallback)this.properties.getCallbacks().get(navigationPropertyName);
            if (callback == null) {
                throw new EntityProviderException(EntityProviderException.EXPANDNOTSUPPORTED);
            }
            WriteFeedCallbackResult result = null;
            try {
                result = ((OnWriteFeedContent)callback).retrieveFeedResult(context);
            }
            catch (ODataApplicationException e) {
                throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
            }
            ArrayList<Map<String, Object>> inlineData = result.getFeedData();
            if (inlineData == null) {
                inlineData = new ArrayList<Map<String, Object>>();
            }
            EntityProviderWriteProperties inlineProperties = result.getInlineProperties();
            EdmEntitySet inlineEntitySet = eia.getEntitySet().getRelatedEntitySet(navProp);
            AtomFeedProducer inlineFeedProducer = new AtomFeedProducer(inlineProperties);
            EntityInfoAggregator inlineEia = EntityInfoAggregator.create(inlineEntitySet, inlineProperties.getExpandSelectTree());
            inlineFeedProducer.append(writer, inlineEia, inlineData, true);
            writer.writeEndElement();
        }
    }

    private void appendInlineEntry(XMLStreamWriter writer, String navigationPropertyName, EntityInfoAggregator eia, Map<String, Object> data) throws EntityProviderException, XMLStreamException, EdmException {
        if (eia.getExpandedNavigationPropertyNames().contains(navigationPropertyName) && this.properties.getCallbacks() != null && this.properties.getCallbacks().containsKey(navigationPropertyName)) {
            writer.writeStartElement("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "inline");
            EdmNavigationProperty navProp = (EdmNavigationProperty)eia.getEntityType().getProperty(navigationPropertyName);
            WriteEntryCallbackContext context = new WriteEntryCallbackContext();
            context.setSourceEntitySet(eia.getEntitySet());
            context.setNavigationProperty(navProp);
            context.setEntryData(data);
            ExpandSelectTreeNode subNode = (ExpandSelectTreeNode)this.properties.getExpandSelectTree().getLinks().get(navigationPropertyName);
            context.setCurrentExpandSelectTreeNode(subNode);
            ODataCallback callback = (ODataCallback)this.properties.getCallbacks().get(navigationPropertyName);
            if (callback == null) {
                throw new EntityProviderException(EntityProviderException.EXPANDNOTSUPPORTED);
            }
            WriteEntryCallbackResult result = null;
            try {
                result = ((OnWriteEntryContent)callback).retrieveEntryResult(context);
            }
            catch (ODataApplicationException e) {
                throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
            }
            Map inlineData = result.getEntryData();
            if (inlineData != null && !inlineData.isEmpty()) {
                EntityProviderWriteProperties inlineProperties = result.getInlineProperties();
                EdmEntitySet inlineEntitySet = eia.getEntitySet().getRelatedEntitySet(navProp);
                AtomEntryEntityProducer inlineProducer = new AtomEntryEntityProducer(inlineProperties);
                EntityInfoAggregator inlineEia = EntityInfoAggregator.create(inlineEntitySet, inlineProperties.getExpandSelectTree());
                inlineProducer.append(writer, inlineEia, inlineData, false, false);
            }
            writer.writeEndElement();
        }
    }

    private void appendAtomEditLink(XMLStreamWriter writer, EntityInfoAggregator eia, Map<String, Object> data, String selfLink) throws EntityProviderException {
        try {
            writer.writeStartElement("link");
            writer.writeAttribute("href", selfLink);
            writer.writeAttribute("rel", "edit");
            writer.writeAttribute("title", eia.getEntityType().getName());
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
        catch (EdmException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private void appendAtomContentLink(XMLStreamWriter writer, EntityInfoAggregator eia, Map<String, Object> data, String selfLink) throws EntityProviderException, EdmException {
        try {
            String mediaResourceMimeTypeKey;
            String mediaResourceMimeType = null;
            EdmMapping entityTypeMapping = eia.getEntityType().getMapping();
            if (entityTypeMapping != null && (mediaResourceMimeTypeKey = entityTypeMapping.getMediaResourceMimeTypeKey()) != null) {
                mediaResourceMimeType = (String)data.get(mediaResourceMimeTypeKey);
            }
            if (mediaResourceMimeType == null) {
                mediaResourceMimeType = ContentType.APPLICATION_OCTET_STREAM.toString();
            }
            writer.writeStartElement("link");
            writer.writeAttribute("href", selfLink + "/$value");
            writer.writeAttribute("rel", "edit-media");
            writer.writeAttribute("type", mediaResourceMimeType);
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private void appendAtomContentPart(XMLStreamWriter writer, EntityInfoAggregator eia, Map<String, Object> data, String selfLink) throws EntityProviderException, EdmException {
        try {
            EdmMapping entityTypeMapping = eia.getEntityType().getMapping();
            String self = null;
            String mediaResourceMimeType = null;
            if (entityTypeMapping != null) {
                String mediaResourceMimeTypeKey;
                String mediaResourceSourceKey = entityTypeMapping.getMediaResourceSourceKey();
                if (mediaResourceSourceKey != null) {
                    self = (String)data.get(mediaResourceSourceKey);
                }
                if (self == null) {
                    self = selfLink + "/$value";
                }
                if ((mediaResourceMimeTypeKey = entityTypeMapping.getMediaResourceMimeTypeKey()) != null) {
                    mediaResourceMimeType = (String)data.get(mediaResourceMimeTypeKey);
                }
                if (mediaResourceMimeType == null) {
                    mediaResourceMimeType = ContentType.APPLICATION_OCTET_STREAM.toString();
                }
            } else {
                self = selfLink + "/$value";
                mediaResourceMimeType = ContentType.APPLICATION_OCTET_STREAM.toString();
            }
            writer.writeStartElement("content");
            writer.writeAttribute("type", mediaResourceMimeType);
            writer.writeAttribute("src", self);
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private void appendAtomMandatoryParts(XMLStreamWriter writer, EntityInfoAggregator eia, Map<String, Object> data, String selfLink) throws EntityProviderException {
        try {
            writer.writeStartElement("id");
            this.location = this.properties.getServiceRoot().toASCIIString() + selfLink;
            writer.writeCharacters(this.location);
            writer.writeEndElement();
            writer.writeStartElement("title");
            writer.writeAttribute("type", "text");
            EntityPropertyInfo titleInfo = eia.getTargetPathInfo("SyndicationTitle");
            if (titleInfo != null) {
                Object object;
                EdmSimpleType st = (EdmSimpleType)titleInfo.getType();
                String title = st.valueToString(object = data.get(titleInfo.getName()), EdmLiteralKind.DEFAULT, titleInfo.getFacets());
                if (title != null) {
                    writer.writeCharacters(title);
                }
            } else {
                writer.writeCharacters(eia.getEntitySetName());
            }
            writer.writeEndElement();
            writer.writeStartElement("updated");
            writer.writeCharacters(this.getUpdatedString(eia, data));
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
        catch (EdmSimpleTypeException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    String getUpdatedString(EntityInfoAggregator eia, Map<String, Object> data) throws EdmSimpleTypeException {
        Object updateDate = null;
        EdmFacets updateFacets = null;
        EntityPropertyInfo updatedInfo = eia.getTargetPathInfo("SyndicationUpdated");
        if (updatedInfo != null && (updateDate = data.get(updatedInfo.getName())) != null) {
            updateFacets = updatedInfo.getFacets();
        }
        if (updateDate == null) {
            updateDate = new Date();
        }
        String valueToString = EdmDateTimeOffset.getInstance().valueToString(updateDate, EdmLiteralKind.DEFAULT, updateFacets);
        return valueToString;
    }

    private String getTargetPathValue(EntityInfoAggregator eia, String targetPath, Map<String, Object> data) throws EntityProviderException {
        try {
            EntityPropertyInfo info = eia.getTargetPathInfo(targetPath);
            if (info != null) {
                EdmSimpleType type = (EdmSimpleType)info.getType();
                Object value = data.get(info.getName());
                return type.valueToString(value, EdmLiteralKind.DEFAULT, info.getFacets());
            }
            return null;
        }
        catch (EdmSimpleTypeException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private void appendAtomOptionalParts(XMLStreamWriter writer, EntityInfoAggregator eia, Map<String, Object> data) throws EntityProviderException {
        try {
            String authorEmail = this.getTargetPathValue(eia, "SyndicationAuthorEmail", data);
            String authorName = this.getTargetPathValue(eia, "SyndicationAuthorName", data);
            String authorUri = this.getTargetPathValue(eia, "SyndicationAuthorUri", data);
            if (authorEmail != null || authorName != null || authorUri != null) {
                writer.writeStartElement("author");
                this.appendAtomOptionalPart(writer, "name", authorName, false);
                this.appendAtomOptionalPart(writer, "email", authorEmail, false);
                this.appendAtomOptionalPart(writer, "uri", authorUri, false);
                writer.writeEndElement();
            }
            String summary = this.getTargetPathValue(eia, "SyndicationSummary", data);
            this.appendAtomOptionalPart(writer, "summary", summary, true);
            String contributorName = this.getTargetPathValue(eia, "SyndicationContributorName", data);
            String contributorEmail = this.getTargetPathValue(eia, "SyndicationContributorEmail", data);
            String contributorUri = this.getTargetPathValue(eia, "SyndicationContributorUri", data);
            if (contributorEmail != null || contributorName != null || contributorUri != null) {
                writer.writeStartElement("contributor");
                this.appendAtomOptionalPart(writer, "name", contributorName, false);
                this.appendAtomOptionalPart(writer, "email", contributorEmail, false);
                this.appendAtomOptionalPart(writer, "uri", contributorUri, false);
                writer.writeEndElement();
            }
            String rights = this.getTargetPathValue(eia, "SyndicationRights", data);
            this.appendAtomOptionalPart(writer, "rights", rights, true);
            String published = this.getTargetPathValue(eia, "SyndicationPublished", data);
            this.appendAtomOptionalPart(writer, "published", published, false);
            String term = eia.getEntityType().getNamespace() + "." + eia.getEntityType().getName();
            writer.writeStartElement("category");
            writer.writeAttribute("term", term);
            writer.writeAttribute("scheme", "http://schemas.microsoft.com/ado/2007/08/dataservices/scheme");
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
        catch (EdmException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private void appendAtomOptionalPart(XMLStreamWriter writer, String name, String value, boolean writeType) throws EntityProviderException {
        try {
            if (value != null) {
                writer.writeStartElement(name);
                if (writeType) {
                    writer.writeAttribute("type", "text");
                }
                writer.writeCharacters(value);
                writer.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    static String createSelfLink(EntityInfoAggregator eia, Map<String, Object> data, String extension) throws EntityProviderException {
        StringBuilder sb = new StringBuilder();
        if (!eia.isDefaultEntityContainer()) {
            sb.append(Encoder.encode(eia.getEntityContainerName())).append(".");
        }
        sb.append(Encoder.encode(eia.getEntitySetName()));
        sb.append("(").append(AtomEntryEntityProducer.createEntryKey(eia, data)).append(")").append(extension == null ? "" : "/" + extension);
        return sb.toString();
    }

    private static String createEntryKey(EntityInfoAggregator entityInfo, Map<String, Object> data) throws EntityProviderException {
        List<EntityPropertyInfo> keyPropertyInfos = entityInfo.getKeyPropertyInfos();
        StringBuilder keys = new StringBuilder();
        for (EntityPropertyInfo keyPropertyInfo : keyPropertyInfos) {
            if (keys.length() > 0) {
                keys.append(',');
            }
            String name = keyPropertyInfo.getName();
            if (keyPropertyInfos.size() > 1) {
                keys.append(Encoder.encode(name)).append('=');
            }
            EdmSimpleType type = (EdmSimpleType)keyPropertyInfo.getType();
            try {
                keys.append(Encoder.encode(type.valueToString(data.get(name), EdmLiteralKind.URI, keyPropertyInfo.getFacets())));
            }
            catch (EdmSimpleTypeException e) {
                throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
            }
        }
        return keys.toString();
    }

    private void appendProperties(XMLStreamWriter writer, EntityInfoAggregator eia, Map<String, Object> data) throws EntityProviderException {
        try {
            List<String> propertyNames = eia.getSelectedPropertyNames();
            if (!propertyNames.isEmpty()) {
                writer.writeStartElement("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "properties");
                for (String propertyName : propertyNames) {
                    EntityPropertyInfo propertyInfo = eia.getPropertyInfo(propertyName);
                    if (!this.isNotMappedViaCustomMapping(propertyInfo)) continue;
                    Object value = data.get(propertyName);
                    XmlPropertyEntityProducer aps = new XmlPropertyEntityProducer(this.properties.isIncludeSimplePropertyType());
                    aps.append(writer, propertyInfo.getName(), propertyInfo, value);
                }
                writer.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private boolean isNotMappedViaCustomMapping(EntityPropertyInfo propertyInfo) {
        EdmCustomizableFeedMappings customMapping = propertyInfo.getCustomMapping();
        if (customMapping != null && customMapping.isFcKeepInContent() != null) {
            return customMapping.isFcKeepInContent();
        }
        return true;
    }

    public String getETag() {
        return this.etag;
    }

    public String getLocation() {
        return this.location;
    }
}

