/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.producer;

import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.odata2.api.commons.InlineCount;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.api.ep.callback.TombstoneCallback;
import org.apache.olingo.odata2.api.ep.callback.TombstoneCallbackResult;
import org.apache.olingo.odata2.core.commons.Encoder;
import org.apache.olingo.odata2.core.edm.EdmDateTimeOffset;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.producer.AtomEntryEntityProducer;
import org.apache.olingo.odata2.core.ep.producer.TombstoneProducer;

public class AtomFeedProducer {
    private final EntityProviderWriteProperties properties;

    public AtomFeedProducer(EntityProviderWriteProperties properties) {
        this.properties = properties == null ? EntityProviderWriteProperties.serviceRoot(null).build() : properties;
    }

    public void append(XMLStreamWriter writer, EntityInfoAggregator eia, List<Map<String, Object>> data, boolean isInline) throws EntityProviderException {
        try {
            writer.writeStartElement("feed");
            TombstoneCallback callback = null;
            if (!isInline) {
                writer.writeDefaultNamespace("http://www.w3.org/2005/Atom");
                writer.writeNamespace("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata");
                writer.writeNamespace("d", "http://schemas.microsoft.com/ado/2007/08/dataservices");
                callback = this.getTombstoneCallback();
                if (callback != null) {
                    writer.writeNamespace("at", "http://purl.org/atompub/tombstones/1.0");
                }
            }
            writer.writeAttribute("xml", "http://www.w3.org/XML/1998/namespace", "base", this.properties.getServiceRoot().toASCIIString());
            this.appendAtomMandatoryParts(writer, eia);
            this.appendAtomSelfLink(writer, eia);
            if (this.properties.getInlineCountType() == InlineCount.ALLPAGES) {
                this.appendInlineCount(writer, this.properties.getInlineCount());
            }
            this.appendEntries(writer, eia, data);
            if (callback != null) {
                this.appendDeletedEntries(writer, eia, callback);
            }
            if (this.properties.getNextLink() != null) {
                this.appendNextLink(writer, this.properties.getNextLink());
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private TombstoneCallback getTombstoneCallback() {
        if (this.properties.getCallbacks() != null && this.properties.getCallbacks().containsKey("~tombstoneCallback")) {
            TombstoneCallback callback = (TombstoneCallback)this.properties.getCallbacks().get("~tombstoneCallback");
            return callback;
        }
        return null;
    }

    private void appendDeletedEntries(XMLStreamWriter writer, EntityInfoAggregator eia, TombstoneCallback callback) throws EntityProviderException {
        String deltaLink;
        TombstoneCallbackResult callbackResult = callback.getTombstoneCallbackResult();
        List tombstoneData = callbackResult.getDeletedEntriesData();
        if (tombstoneData != null) {
            TombstoneProducer tombstoneProducer = new TombstoneProducer();
            tombstoneProducer.appendTombstones(writer, eia, this.properties, tombstoneData);
        }
        if ((deltaLink = callbackResult.getDeltaLink()) != null) {
            try {
                writer.writeStartElement("link");
                writer.writeAttribute("rel", "delta");
                writer.writeAttribute("href", deltaLink);
                writer.writeEndElement();
            }
            catch (XMLStreamException e) {
                throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
            }
        }
    }

    private void appendNextLink(XMLStreamWriter writer, String nextLink) throws EntityProviderException {
        try {
            writer.writeStartElement("link");
            writer.writeAttribute("href", nextLink);
            writer.writeAttribute("rel", "next");
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private void appendEntries(XMLStreamWriter writer, EntityInfoAggregator eia, List<Map<String, Object>> data) throws EntityProviderException {
        AtomEntryEntityProducer entryProvider = new AtomEntryEntityProducer(this.properties);
        for (Map<String, Object> singleEntryData : data) {
            entryProvider.append(writer, eia, singleEntryData, false, true);
        }
    }

    private void appendInlineCount(XMLStreamWriter writer, Integer inlineCount) throws EntityProviderException {
        if (inlineCount == null || inlineCount < 0) {
            throw new EntityProviderException(EntityProviderException.INLINECOUNT_INVALID);
        }
        try {
            writer.writeStartElement("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "count");
            writer.writeCharacters(String.valueOf(inlineCount));
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private void appendAtomSelfLink(XMLStreamWriter writer, EntityInfoAggregator eia) throws EntityProviderException {
        URI self = this.properties.getSelfLink();
        String selfLink = "";
        selfLink = self == null ? this.createSelfLink(eia) : self.toASCIIString();
        try {
            writer.writeStartElement("link");
            writer.writeAttribute("href", selfLink);
            writer.writeAttribute("rel", "self");
            writer.writeAttribute("title", eia.getEntitySetName());
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private String createSelfLink(EntityInfoAggregator eia) throws EntityProviderException {
        StringBuilder sb = new StringBuilder();
        if (!eia.isDefaultEntityContainer()) {
            String entityContainerName = Encoder.encode(eia.getEntityContainerName());
            sb.append(entityContainerName).append(".");
        }
        String entitySetName = Encoder.encode(eia.getEntitySetName());
        sb.append(entitySetName);
        return sb.toString();
    }

    private void appendAtomMandatoryParts(XMLStreamWriter writer, EntityInfoAggregator eia) throws EntityProviderException {
        try {
            writer.writeStartElement("id");
            writer.writeCharacters(this.createAtomId(eia));
            writer.writeEndElement();
            writer.writeStartElement("title");
            writer.writeAttribute("type", "text");
            writer.writeCharacters(eia.getEntitySetName());
            writer.writeEndElement();
            writer.writeStartElement("updated");
            Date updateDate = null;
            EdmFacets updateFacets = null;
            updateDate = new Date();
            writer.writeCharacters(EdmDateTimeOffset.getInstance().valueToString(updateDate, EdmLiteralKind.DEFAULT, updateFacets));
            writer.writeEndElement();
            writer.writeStartElement("author");
            writer.writeStartElement("name");
            writer.writeEndElement();
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
        catch (EdmSimpleTypeException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private String createAtomId(EntityInfoAggregator eia) throws EntityProviderException {
        return this.properties.getServiceRoot() + this.createSelfLink(eia);
    }
}

